/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public abstract class PlaceTool
implements UniScreen.Tool {
    public Airship ship(UniScreen us) {
        return ((SingleShipIntent)((Object)us.intent)).getShip(us);
    }

    public int[] shipPt(Pt screenPt, UniScreen us) {
        Airship ship = this.ship(us);
        int modX = (int)Math.floor((us.screenToWorldX(screenPt.x) - ship.x) / 16.0);
        int modY = (int)Math.floor((us.screenToWorldY(screenPt.y) - ship.y) / 16.0);
        return new int[]{modX, modY};
    }

    public int[] localShipPt(Pt screenPt, UniScreen us, int w) {
        int[] xy = this.shipPt(screenPt, us);
        Airship ship = this.ship(us);
        if (ship.flipped) {
            xy[0] = ship.getWidth() - xy[0];
            xy[0] = xy[0] - w;
        }
        return xy;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        int[] sp = this.shipPt(cursor, us);
        int gridX = sp[0];
        int gridY = sp[1];
        double x = sp[0] * 16 + this.ship(us).getX();
        double y = sp[1] * 16 + this.ship(us).getY();
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        this.scaledDraw(d, x, y, gridX, gridY, us);
        d.resetTransforms();
        this.unscaledDraw(d, cursor, sm, us);
    }

    public void modified(UniScreen us) {
        ((SingleShipIntent)((Object)us.intent)).modified(us);
    }

    public abstract void scaledDraw(MyDraw var1, double var2, double var4, int var6, int var7, UniScreen var8);

    public abstract void unscaledDraw(MyDraw var1, Pt var2, ScreenMode var3, UniScreen var4);
}

