/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

public strictfp class Rect2D {
    public final double x;
    public final double y;
    public final double w;
    public final double h;

    public Rect2D(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public boolean intersects(Rect2D r2) {
        return this.x < r2.x + r2.w && r2.x < this.x + this.w && this.y < r2.y + r2.h && r2.y < this.y + this.h;
    }

    public static boolean intersects(double x1, double y1, double w1, double h1, double x2, double y2, double w2, double h2) {
        return x1 < x2 + w2 && x2 < x1 + w1 && y1 < y2 + h2 && y2 < y1 + h1;
    }

    public boolean contains(double x2, double y2, double w2, double h2) {
        return this.x <= x2 && this.y <= y2 && this.x + this.w >= x2 + w2 && this.y + this.h >= y2 + h2;
    }

    public static boolean contains(double x1, double y1, double w1, double h1, double x2, double y2) {
        return x1 < x2 && x1 + w1 > x2 && y1 < y2 && y1 + h1 > y2;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.w) ^ Double.doubleToLongBits(this.w) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.h) ^ Double.doubleToLongBits(this.h) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rect2D other = (Rect2D)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(other.w)) {
            return false;
        }
        return Double.doubleToLongBits(this.h) == Double.doubleToLongBits(other.h);
    }

    public String toString() {
        return "Rect2D{x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + '}';
    }
}

