/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.GroundTool;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceSoilTool;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;

public class RemoveGroundTool
extends GroundTool {
    public LandBlockType getBlockToRemove(LandFormation ground, int x, int y) {
        LandBlockType lbt = ground.grid[y][x];
        if (lbt.removeCost == 0) {
            return null;
        }
        for (int y2 = 0; y2 < y; ++y2) {
            if (ground.grid[y2][x] == LandBlockType.AIR) continue;
            return null;
        }
        return lbt;
    }

    @Override
    public void drawScaled(MyDraw d, UniScreen us, LandFormation ground, int cursorX, int cursorY) {
        LandBlockType lbt = this.getBlockToRemove(ground, cursorX, cursorY);
        if (lbt != null) {
            boolean allowed = us.intent instanceof SingleCombatSetupIntent || us.wm.owner((City)us.city).money >= lbt.removeCost;
            double x = ground.x + (double)(cursorX * 16);
            double y = ground.y + (double)(cursorY * 16);
            d.blit(EditPalettePanel.REMOVE, allowed ? Clr.WHITE : Clr.RED, x, y);
        }
    }

    @Override
    public void drawUnscaled(MyDraw d, UniScreen us, LandFormation ground, int cursorX, int cursorY, Pt cursor) {
        LandBlockType lbt = this.getBlockToRemove(ground, cursorX, cursorY);
        if (lbt != null) {
            boolean allowed = us.intent instanceof SingleCombatSetupIntent || us.wm.owner((City)us.city).money >= lbt.removeCost;
            d.text(allowed ? Lang._t("Remove_x", lbt.getName()) : "[ff9999]" + Lang._t("Remove_x_Sy", lbt.getName(), lbt.removeCost), AGame.FOUNT, (int)cursor.x + 16, (int)cursor.y);
        }
    }

    @Override
    public boolean click(Input in, UniScreen us, LandFormation ground, int clickX, int clickY) {
        LandBlockType lbt = this.getBlockToRemove(ground, clickX, clickY);
        if (lbt != null && (us.intent instanceof SingleCombatSetupIntent || us.wm.owner((City)us.city).money >= lbt.removeCost)) {
            ground.grid[clickY][clickX] = LandBlockType.AIR;
            ground.crop();
            PlaceSoilTool.adjustBuildingVerticals(us);
            if (us.intent instanceof DefencesIntent) {
                us.wm.owner((City)us.city).money -= lbt.removeCost;
            }
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, UniScreen us, LandFormation ground, int clickX, int clickY) {
        return false;
    }

    @Override
    public boolean mouseDown(Input in, UniScreen us, LandFormation ground, int clickX, int clickY) {
        return this.click(in, us, ground, clickX, clickY);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }
}

