/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.FBOGraphicsFactory;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LoadingScreen;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public class ResChooserScreen
implements Screen {
    private final AirshipGame g;
    private ScreenMode preferred;
    private final ArrayList<ScreenMode> modes = new ArrayList();
    private static final ArrayList<ScreenMode> STANDARD_MODES = new ArrayList();
    private boolean checkedForFBO = false;
    private boolean canCheckForFBO = false;

    public ResChooserScreen(AirshipGame g) {
        this.g = g;
    }

    private void checkForFBO() {
        try {
            if (!FBOGraphicsFactory.init()) {
                Appearance.canUseLighting = false;
                Appearance.useLighting = false;
            }
        }
        catch (Exception e) {
            this.g.reportError("Can't check for FBO", e, null, false);
            Appearance.canUseLighting = false;
            Appearance.useLighting = false;
        }
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.canCheckForFBO && !this.checkedForFBO) {
            this.checkForFBO();
            this.checkedForFBO = true;
        }
        if (this.modes.isEmpty()) {
            try {
                this.preferred = new ScreenMode(AirshipGame.PREFS.getInt("screenModeW", 800), AirshipGame.PREFS.getInt("screenModeH", 600), AirshipGame.PREFS.getBoolean("screenModeF", false));
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_prefs", new Object[0]), e, null, false);
            }
            ArrayList cands = in.modes();
            ScreenMode biggest = null;
            for (ScreenMode c : cands) {
                if (biggest != null && biggest.width * biggest.height >= c.width * c.height) continue;
                biggest = c;
            }
            if (biggest != null) {
                this.modes.add(biggest);
                if (this.preferred == null) {
                    this.preferred = biggest;
                }
            }
            for (ScreenMode c : STANDARD_MODES) {
                if (!cands.contains(c) || biggest != null && biggest.equals((Object)c)) continue;
                this.modes.add(c);
            }
            this.modes.add(new ScreenMode(1024, 768, false));
            this.modes.add(new ScreenMode(800, 600, false));
        }
        if (in.keyDown("ENTER") && this.preferred != null) {
            in.setMode(this.preferred);
            this.g.s = new LoadingScreen(this.g);
            drawState.hasClicked();
        }
        if (in.keyDown("Q")) {
            this.g.exit = true;
        }
    }

    public static String mToString(ScreenMode m) {
        return m.fullscreen ? Lang._t("resolution_format_fullscreen", m.width, m.height) : Lang._t("resolution_format", m.width, m.height);
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        Appearance.init();
        d.drawBG(AGame.CAST_IRON, sm);
        if (!this.canCheckForFBO) {
            this.canCheckForFBO = true;
            return;
        }
        int x = 10;
        int y = 10;
        d.text("[f5edb5]AIRSHIPS", AGame.HUGE_FOUNT, x, y);
        d.text("[f5edb5]" + Lang._t("a_game_by_david_stark", new Object[0]), AGame.BIG_FOUNT, x, y += 64);
        y += AGame.BIG_FOUNT.lineHeight;
        y += 12;
        x = sm.width / 2 - 100;
        for (final ScreenMode m : this.modes) {
            d.button(x, y, 200, ResChooserScreen.mToString(m), this.preferred.equals((Object)m) ? "ENTER" : null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    try {
                        AirshipGame.PREFS.putInt("screenModeW", m.width);
                        AirshipGame.PREFS.putInt("screenModeH", m.height);
                        AirshipGame.PREFS.putBoolean("screenModeF", m.fullscreen);
                        AirshipGame.PREFS.flush();
                    }
                    catch (Exception e) {
                        ResChooserScreen.this.g.reportError("Unable to save prefs", e, null, false);
                    }
                    in.setMode(m);
                    ((ResChooserScreen)ResChooserScreen.this).g.s = new LoadingScreen(ResChooserScreen.this.g);
                }
            });
            y += 27;
        }
        d.toggle(x, y += 9, 200, Lang._t("High_quality_graphics", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                Appearance.useSimpleGraphics = !Appearance.useSimpleGraphics;
            }
        }, !Appearance.useSimpleGraphics, true);
        d.tooltip(x, y, 200.0, 24.0, Lang._t("hq_gfx_tooltip", new Object[0]));
        d.button(x, y += 36, 200, Lang._t("Quit", new Object[0]), "Q", new InputRunnable(){

            @Override
            public void run(Input in) {
                ((ResChooserScreen)ResChooserScreen.this).g.exit = true;
            }
        });
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    static {
        STANDARD_MODES.add(new ScreenMode(1920, 1080, true));
        STANDARD_MODES.add(new ScreenMode(1440, 1080, true));
        STANDARD_MODES.add(new ScreenMode(1440, 900, true));
        STANDARD_MODES.add(new ScreenMode(1280, 720, true));
        STANDARD_MODES.add(new ScreenMode(1024, 768, true));
        STANDARD_MODES.add(new ScreenMode(800, 600, true));
    }
}

