/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public class ReservePanel
implements UniScreen.InfoPanel {
    public boolean visible = false;
    public boolean snapOpen = true;
    private final ScrollBar reserveScrollBar = new ScrollBar();
    private UniScreen us;
    private CoatOfArms coa;
    private final ReserveAdapter reserveAdapter = new ReserveAdapter();

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        int x;
        this.us = us;
        if (us.hideUI) {
            return;
        }
        if (this.visible) {
            this.snapOpen = false;
        }
        if (!this.visible && !this.snapOpen) {
            return;
        }
        ArrayList<Object> reserve = new ArrayList();
        this.coa = null;
        if (us.mySide != null) {
            reserve = us.mySide.reserve;
            this.coa = us.mySide.arms;
        } else if (us.wm != null) {
            Fleet fl = us.wm.getGarrison(us.city);
            if (fl != null) {
                reserve = fl.reserve;
            }
            this.coa = us.wm.owner((City)us.city).arms;
        }
        if (this.coa == null) {
            return;
        }
        if (!reserve.isEmpty() && this.snapOpen) {
            this.visible = true;
            this.snapOpen = false;
        }
        if (!this.visible) {
            return;
        }
        boolean leftSide = us.mySide != null && us.combat.sides.indexOf(us.mySide) == 0;
        int width = 190;
        int y = 43;
        int height = sm.height - y;
        int n = x = leftSide ? 0 : sm.width - width;
        if (leftSide) {
            d.drawLeftSideWindow(sm, width, y);
        } else {
            d.drawRightSideWindow(sm, sm.width - width, y);
        }
        this.reserveScrollBar.draw(d, x += 12, y += 12, width -= 24, height -= 24, reserve, this.reserveAdapter);
    }

    public void add(UniScreen us, Airship ship) {
        us.tool = us.combat != null ? new PlaceShipTool(ship, us.mySide, us.combat.sides.indexOf(us.mySide), true) : new PlaceShipTool(ship, true);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!this.visible || us.hideUI) {
            return;
        }
        boolean leftSide = us.mySide != null && us.combat.sides.indexOf(us.mySide) == 0;
        ScreenMode sm = in.mode();
        int width = 190;
        int y = 43;
        int height = sm.height - y;
        int x = leftSide ? 0 : sm.width - width;
        this.reserveScrollBar.tick(in, x += 12, y += 12, width -= 24, height -= 24);
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        boolean leftSide;
        if (us.hideUI || !this.visible) {
            return false;
        }
        boolean bl = leftSide = us.mySide != null && us.combat.sides.indexOf(us.mySide) == 0;
        return leftSide ? cursor.x <= 190.0 : cursor.x >= (double)(sm.width - 190);
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }

    private class ReserveAdapter
    implements ScrollBar.ScrollElementAdapter<Airship> {
        private ReserveAdapter() {
        }

        @Override
        public int getHeight(Airship t, MyDraw d, int availableWidth) {
            return 163 + AGame.FOUNT.lineHeight + 12;
        }

        @Override
        public void draw(final Airship ship, MyDraw d, int x, int y, int width) {
            d.drawPanel(x, y, 130, 130);
            d.rect(AGame.SKY, x + 2, y + 2, 126.0, 126.0);
            double scale = Math.min(100.0 / (double)ship.getWidth() / 16.0, 100.0 / (double)ship.getHeight() / 16.0);
            d.shift(x + 15, y + 15);
            d.scale(scale, scale);
            ship.draw(d, 100.0 / scale / 2.0 - (double)(ship.getWidth() * 16 / 2), 100.0 / scale / 2.0 - (double)(ship.getHeight() * 16 / 2), 0, true, false, true, ReservePanel.this.coa, true, null, 1.0f, 1.0f, Clr.WHITE);
            d.resetTransforms();
            d.text(ship.name, AGame.FOUNT, x, y += 133);
            d.button(x, y += AGame.FOUNT.lineHeight, 130, Lang._t("Activate", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    ReservePanel.this.add(ReservePanel.this.us, ship);
                }
            });
            d.tooltip(x, y, 130.0, 24.0, Lang._t("Move_ship_into_the_combat_area", new Object[0]));
        }
    }
}

