/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.WorldMap;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Road {
    public City src;
    public City dst;
    public boolean seaRoute;
    public ArrayList<int[]> path = new ArrayList();
    public transient ArrayList<HashMap<Road, Integer>> overlaps = new ArrayList();
    public transient int hopDist;

    public Road(City src, City dst) {
        this.src = src;
        this.dst = dst;
    }

    public Road(JSONObject o, WorldMap wm) {
        this.seaRoute = o.getBoolean("seaRoute");
        this.src = wm.empires.get((int)o.getInt((String)"srcEmpire")).cities.get(o.getInt("srcIndex"));
        this.dst = wm.empires.get((int)o.getInt((String)"dstEmpire")).cities.get(o.getInt("dstIndex"));
        JSONArray pathA = o.getJSONArray("path");
        for (int i = 0; i < pathA.length(); i += 2) {
            this.path.add(new int[]{pathA.getInt(i), pathA.getInt(i + 1)});
        }
    }

    public JSONObject toJSON(WorldMap wm) {
        JSONObject o = new JSONObject().put("seaRoute", this.seaRoute);
        Empire srcOwner = wm.owner(this.src);
        o.put("srcEmpire", wm.empires.indexOf(srcOwner));
        o.put("srcIndex", srcOwner.cities.indexOf(this.src));
        Empire dstOwner = wm.owner(this.dst);
        o.put("dstEmpire", wm.empires.indexOf(dstOwner));
        o.put("dstIndex", dstOwner.cities.indexOf(this.dst));
        JSONArray pathA = new JSONArray();
        o.put("path", pathA);
        for (int[] n : this.path) {
            pathA.put(n[0]).put(n[1]);
        }
        return o;
    }

    public String toString() {
        return this.src.name + " " + (this.seaRoute ? "~" : "-") + this.path.size() + (this.seaRoute ? "~" : "-") + "> " + this.dst.name;
    }
}

