/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public class RotatingShader {
    private static ShaderProgram lsp;
    public static boolean shaderLoadFailed;
    public static boolean shaderLocked;

    public static void lockShader(Draw d, Image[] light, float lightStrength, float ambient) {
        RotatingShader.lockShader(0, d, light, lightStrength, ambient);
    }

    public static void lockShader(int sheet, Draw d, Image[] light, float lightStrength, float ambient) {
        if (shaderLoadFailed || light == null || Appearance.useSimpleGraphics) {
            return;
        }
        if (lsp == null) {
            try {
                lsp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/rotated_litfrag.vert"), (String)AGame.getGameDirectoryPath("data/rotated_litfrag.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        lsp.bind();
        lsp.setUniform1f("strength", lightStrength);
        lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
        lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)Appearance.bumps[sheet].getTextureID());
        lsp.setUniform1i("bump", 1);
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
        lsp.setUniform1i("lightFromLeft", 2);
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
        lsp.setUniform1i("lightFromTop", 3);
        GL13.glActiveTexture((int)33988);
        GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
        lsp.setUniform1i("lightFromRight", 4);
        GL13.glActiveTexture((int)33989);
        GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
        lsp.setUniform1i("lightFromBottom", 5);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)Appearance.texes[sheet].getTextureID());
        lsp.setUniform1i("tex", 0);
        lsp.enableVertexAttribute("flipped");
        lsp.enableVertexAttribute("angle");
        lsp.enableVertexAttribute("tint");
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        shaderLocked = true;
    }

    public static void unlockShader() {
        if (shaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            lsp.unbind();
            TextureImpl.bindNone();
            shaderLocked = false;
        }
    }

    public static void draw(Img img, Draw d, double x, double y, double angle, boolean flipped, Image[] light, float lightStrength, float ambient, Clr ambientTint) {
        RotatingShader.draw(0, img, d, x, y, angle, flipped, light, lightStrength, ambient, ambientTint);
    }

    public static void draw(int sheet, Img img, Draw d, double x, double y, double angle, boolean flipped, Image[] light, float lightStrength, float ambient, Clr ambientTint) {
        if (shaderLoadFailed || Appearance.useSimpleGraphics || light == null) {
            d.blit(img, ambientTint, x, y, angle);
            return;
        }
        if (lsp == null) {
            try {
                lsp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/rotated_litfrag.vert"), (String)AGame.getGameDirectoryPath("data/rotated_litfrag.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                shaderLoadFailed = true;
                return;
            }
        }
        if (!shaderLocked) {
            lsp.bind();
            lsp.setUniform1f("strength", lightStrength);
            lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
            lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
            GL13.glActiveTexture((int)33985);
            GL11.glBindTexture((int)3553, (int)Appearance.bumps[sheet].getTextureID());
            lsp.setUniform1i("bump", 1);
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
            lsp.setUniform1i("lightFromLeft", 2);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
            lsp.setUniform1i("lightFromTop", 3);
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
            lsp.setUniform1i("lightFromRight", 4);
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
            lsp.setUniform1i("lightFromBottom", 5);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)Appearance.texes[sheet].getTextureID());
            lsp.setUniform1i("tex", 0);
            lsp.enableVertexAttribute("flipped");
            lsp.enableVertexAttribute("angle");
            lsp.enableVertexAttribute("tint");
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        int w = img.srcWidth;
        int h = img.srcHeight;
        GL20.glVertexAttrib4f((int)lsp.getAttributeID("tint"), (float)ambient, (float)ambient, (float)ambient, (float)1.0f);
        GL20.glVertexAttrib1f((int)lsp.getAttributeID("flipped"), (float)(flipped ? 1.0f : 0.0f));
        GL20.glVertexAttrib1f((int)lsp.getAttributeID("angle"), (float)((float)angle));
        if (!shaderLocked) {
            GL11.glBegin((int)7);
        }
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double w2 = (double)w * 0.5;
        double h2 = (double)h * 0.5;
        double x2 = x + w2;
        double y2 = y + h2;
        double topLeftX = x2 - w2 * cos + h2 * sin;
        double topLeftY = y2 - w2 * sin - h2 * cos;
        double bottomLeftX = x2 - w2 * cos - h2 * sin;
        double bottomLeftY = y2 - w2 * sin + h2 * cos;
        double bottomRightX = x2 + w2 * cos - h2 * sin;
        double bottomRightY = y2 + w2 * sin + h2 * cos;
        double topRightX = x2 + w2 * cos + h2 * sin;
        double topRightY = y2 + w2 * sin - h2 * cos;
        if (img.flipped) {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)topRightX, (double)topRightY);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)bottomRightX, (double)bottomRightY);
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)bottomLeftX, (double)bottomLeftY);
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)topLeftX, (double)topLeftY);
        } else {
            GL11.glTexCoord2d((double)img.srcX, (double)img.srcY);
            GL11.glVertex2d((double)topLeftX, (double)topLeftY);
            GL11.glTexCoord2d((double)img.srcX, (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)bottomLeftX, (double)bottomLeftY);
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)(img.srcY + img.srcHeight));
            GL11.glVertex2d((double)bottomRightX, (double)bottomRightY);
            GL11.glTexCoord2d((double)(img.srcX + img.srcWidth), (double)img.srcY);
            GL11.glVertex2d((double)topRightX, (double)topRightY);
        }
        if (!shaderLocked) {
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            lsp.unbind();
            TextureImpl.bindNone();
        }
    }

    static {
        shaderLoadFailed = false;
        shaderLocked = false;
    }
}

