/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class SaveDesignButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof SingleShipIntent;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Save_design", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        ShipHelperWidget shw = ShipHelperWidget.get(new File(AGame.getGameDirectory(), ((SingleShipIntent)((Object)us.intent)).type((UniScreen)us).dirName), us.g.getBestCOA(), Bonus.STANDARD_BONUSES, 0);
        us.g.s = new FileScreen(ShipEditorUtils.shipsList(((SingleShipIntent)((Object)us.intent)).type(us), shw), new SaveShipMission(us.g, us), shw, new PriceInlineInfo(shw, null));
    }

    @Override
    public String hotkey(UniScreen us) {
        return "S";
    }

    private static class SaveShipMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;

        public SaveShipMission(AirshipGame g, UniScreen us) {
            this.g = g;
            this.us = us;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.SAVE;
        }

        @Override
        public String text() {
            return Lang._t("Save_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Save", new Object[0]);
        }

        @Override
        public String initialInput() {
            return this.ship().name.replaceAll("[^a-zA-Z0-9 ]+", "");
        }

        private Airship ship() {
            return ((SingleShipIntent)((Object)this.us.intent)).getShip(this.us);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileSelected(String name) {
            this.g.s = this.us;
            File f = new File(new File(AGame.getGameDirectory(), ((SingleShipIntent)((Object)this.us.intent)).type((UniScreen)this.us).dirName), name + ".json");
            BufferedWriter w = null;
            try {
                this.ship().name = name;
                w = new BufferedWriter(new FileWriter(f));
                w.write(this.ship().toJSON(null).toString(4));
                ((SingleShipIntent)((Object)this.us.intent)).justSaved(this.us);
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_save_ship_or_building", new Object[0]), e, null, false);
            }
            finally {
                try {
                    w.close();
                }
                catch (Exception e) {}
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }
}

