/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import java.util.List;
import org.newdawn.slick.Graphics;

public class ScrollBar {
    public int offset;
    public int prevRange = 0;
    public static final int SCROLL_BAR_W = 24;
    private static final Img UP_BUTTON = new Img("spritesheet", 116, 827, 26, 25, false);
    private static final Img DOWN_BUTTON = new Img("spritesheet", 116, 853, 26, 25, false);
    private static final Img UP_BUTTON_LIT = new Img("spritesheet", 89, 827, 26, 25, false);
    private static final Img DOWN_BUTTON_LIT = new Img("spritesheet", 89, 853, 26, 25, false);
    private static final Img SCROLL_THUMB = new Img("spritesheet", 143, 827, 20, 20, false);
    private static final Img LEFT_BORDER = new Img("spritesheet", 80, 846, 2, 20, false);
    private static final Img RIGHT_BORDER = new Img("spritesheet", 83, 846, 2, 20, false);
    private static final Clr BAR_BG = Clr.fromHex((String)"4f442f");

    public void tick(Input in, int x, int y, int w, int h) {
        if (in.scrollAmount() != 0 && MyDraw.in(x, y, w, h, in.cursor())) {
            this.offset = Math.max(0, this.offset - in.scrollAmount() * AirshipGame.scrollSpeed / 60);
        }
    }

    public void draw(MyDraw d, int x, int y, final int h, final int panelH, final int range) {
        this.offset = this.prevRange != 0 && (this.offset >= this.prevRange - panelH || this.prevRange < panelH && range > panelH) ? Math.max(0, range - panelH) : Math.min(Math.max(range - panelH, 0), this.offset);
        this.prevRange = range;
        boolean upHover = range > panelH && MyDraw.in(x, y, 24, 24, d.state.cursor);
        boolean downHover = range > panelH && MyDraw.in(x, y + h - 24, 24, 24, d.state.cursor);
        boolean barHover = range > panelH && MyDraw.in(x, y + 24, 24, h - 48, d.state.cursor);
        d.blit(upHover ? UP_BUTTON_LIT : UP_BUTTON, x - 1, y - 1);
        d.hook(x, y, 24.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_DOWN}){

            public void run(Input in, Pt p, Hook.Type type) {
                ScrollBar.this.offset = Math.max(0, ScrollBar.this.offset - AirshipGame.scrollSpeed);
            }
        });
        d.rect(barHover ? MyDraw.PROGRESS_BAR_DEEP_INSIDE : BAR_BG, x + 1, y + 24, 22.0, h - 48);
        for (int y2 = y + 24; y2 < y + h - 24; y2 += ScrollBar.LEFT_BORDER.srcHeight) {
            d.blit(LEFT_BORDER, x, y2);
            d.blit(RIGHT_BORDER, x + 24 - 2, y2);
        }
        d.blit(downHover ? DOWN_BUTTON_LIT : DOWN_BUTTON, x - 1, y + h - 24);
        d.hook(x, y + h - 24, 24.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_DOWN}){

            public void run(Input in, Pt p, Hook.Type type) {
                ScrollBar.this.offset = Math.min(range, ScrollBar.this.offset + AirshipGame.scrollSpeed);
            }
        });
        if (range > panelH) {
            int thumbY = y + 24 + 1 + (h - 48 - 2 - ScrollBar.SCROLL_THUMB.srcHeight) * this.offset / (range - panelH);
            d.blit(SCROLL_THUMB, x + 2, thumbY);
            d.hook(x, y + 24, 24.0, h - 48, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    ScrollBar.this.offset = ((int)p.y - SCROLL_THUMB.srcHeight / 2) * (range - panelH) / (h - 48 - 2 - SCROLL_THUMB.srcHeight);
                }
            });
        }
    }

    public <T> void draw(MyDraw d, int x, int y, int w, int h, List<T> els, ScrollElementAdapter<T> ad) {
        int panelW = w - 24 - 12;
        int range = 0;
        for (int i = 0; i < els.size(); ++i) {
            range += ad.getHeight(els.get(i), d, panelW);
        }
        int panelH = h - 12;
        this.offset = this.prevRange != 0 && (this.offset >= this.prevRange - panelH || this.prevRange < panelH && range > panelH) ? Math.max(0, range - panelH) : Math.min(Math.max(range - panelH, 0), this.offset);
        this.prevRange = range;
        d.drawPanel(x, y, w - 24 + 4, h);
        this.draw(d, x + w - 24, y, h, panelH, range);
        int endY = y + h - 6;
        int startY = y + 6;
        y = y + 6 - this.offset;
        Graphics g = (Graphics)d.frame().nativeRenderer();
        g.setClip(x += 6, startY, panelW, endY - startY);
        for (int i = 0; i < els.size(); ++i) {
            int elH = ad.getHeight(els.get(i), d, panelW);
            if (y + elH > startY && y < endY) {
                ad.draw(els.get(i), d, x, y, panelW);
            }
            y += elH;
        }
        g.clearClip();
    }

    public static interface ScrollElementAdapter<T> {
        public int getHeight(T var1, MyDraw var2, int var3);

        public void draw(T var1, MyDraw var2, int var3, int var4, int var5);
    }
}

