/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public class Server {
    public static final int PORT = 29139;
    public static final int VERSION = 7110;
    public static final int SERVER_TICK = 64;
    private Acceptor acceptor = new Acceptor(this);
    private ArrayList<Channel> channels = new ArrayList();
    private boolean doClose = false;
    private int receiverIDCounter = 1;
    private int channelIDCounter = 1;
    private final Channel mainChannel = new Channel(this, 0, Integer.MAX_VALUE, new JSONObject().put("name", "Chat"));
    private boolean verbose;
    private File logF;
    private PrintWriter logW;

    public void log(String msg) {
        System.out.println(msg);
        System.out.flush();
        if (this.logF != null) {
            if (this.logW == null) {
                try {
                    this.logW = new PrintWriter(this.logF, "UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.logW.println(msg);
            this.logW.flush();
        }
    }

    public static void main(String[] args) {
        Server s = new Server();
        List<String> as = Arrays.asList(args);
        s.verbose = as.contains("-v");
        if (as.contains("--log")) {
            s.logF = new File(as.get(as.indexOf("--log") + 1));
        }
        s.start();
    }

    public Server() {
        this.channels.add(this.mainChannel);
    }

    public synchronized void close() {
        this.log("close() called.");
        this.doClose = true;
        this.acceptor.interrupt();
        for (Channel channel : this.channels) {
            for (Receiver r : channel.receivers) {
                r.interrupt();
            }
            channel.interrupt();
        }
    }

    public synchronized boolean doClose() {
        return this.doClose;
    }

    private int getFreeReceiverID() {
        do {
            ++this.receiverIDCounter;
        } while (!this.isFreeReceiverID(this.receiverIDCounter));
        return this.receiverIDCounter;
    }

    private boolean isFreeReceiverID(int id) {
        if (id == 0) {
            return false;
        }
        for (Channel ch : this.channels) {
            for (Receiver r : ch.receivers) {
                if (r.id != id) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized Channel getChannel(int id) {
        for (Channel ch : this.channels) {
            if (ch.id != id) continue;
            return ch;
        }
        return null;
    }

    public synchronized ArrayList<Channel> getChannels() {
        return new ArrayList<Channel>(this.channels);
    }

    public synchronized Channel createChannel(JSONObject info) {
        Channel ch = new Channel(this, this.getFreeChannelID(), 2, info);
        this.channels.add(ch);
        return ch;
    }

    public synchronized void removeChannel(Channel ch) {
        this.channels.remove(ch);
    }

    private int getFreeChannelID() {
        do {
            ++this.channelIDCounter;
        } while (!this.isFreeChannelID(this.channelIDCounter));
        return this.channelIDCounter;
    }

    private boolean isFreeChannelID(int id) {
        if (id == 0) {
            return false;
        }
        for (Channel ch : this.channels) {
            if (ch.id != id) continue;
            return false;
        }
        return true;
    }

    public void addReceiver(Socket socket) {
        try {
            Receiver r = new Receiver(this, socket, this.getFreeReceiverID());
            r.start();
        }
        catch (Exception e) {
            this.log("Failed to add receiver: " + e);
            e.printStackTrace();
        }
    }

    public void start() {
        this.log("Starting");
        this.mainChannel.start();
        this.acceptor.start();
    }

    public static class Receiver
    extends Thread {
        private Channel currentChannel;
        private final Server server;
        private final Socket socket;
        private final PrintWriter w;
        private final BufferedReader r;
        private final int id;
        private boolean flipped;

        public Receiver(Server server, Socket socket, int id) throws IOException {
            super("Receiver " + id + " for " + socket.getInetAddress().getHostAddress());
            this.server = server;
            this.socket = socket;
            this.id = id;
            this.w = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
            this.r = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        }

        private void createChannel(JSONObject info) {
            Channel ch = this.server.createChannel(info);
            this.switchChannelTo(ch);
            ch.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void switchChannelTo(Channel ch) {
            if (this.currentChannel == null) {
                Channel channel = ch;
                synchronized (channel) {
                    this.doSwitchChannel(ch);
                }
            }
            if (ch == null) {
                Channel channel = this.currentChannel;
                synchronized (channel) {
                    this.doSwitchChannel(ch);
                }
            }
            if (ch.id < this.currentChannel.id) {
                Channel channel = ch;
                synchronized (channel) {
                    Channel channel2 = this.currentChannel;
                    synchronized (channel2) {
                        this.doSwitchChannel(ch);
                    }
                }
            }
            Channel channel = this.currentChannel;
            synchronized (channel) {
                Channel channel3 = ch;
                synchronized (channel3) {
                    this.doSwitchChannel(ch);
                }
            }
        }

        private void doSwitchChannel(Channel ch) {
            if (ch != null && ch.id != 0 && ch.receivers.size() >= ch.numPlayers) {
                JSONObject reject = new JSONObject();
                reject.put("type", "reject");
                reject.put("channelID", ch.id);
                this.print(reject);
                return;
            }
            if (this.currentChannel != null) {
                this.currentChannel.receivers.remove(this);
            }
            this.currentChannel = ch;
            if (ch != null) {
                ch.receivers.add(this);
                JSONObject welcome = new JSONObject();
                welcome.put("type", "welcome");
                this.flipped = ch.receivers.size() == 1 ? false : !((Receiver)((Channel)ch).receivers.get((int)0)).flipped;
                welcome.put("flipped", this.flipped);
                welcome.put("version", 7110);
                welcome.put("channelID", ch.id);
                welcome.put("seed", ch.seed);
                welcome.put("info", ch.info);
                welcome.put("playerID", this.id);
                this.print(welcome);
            }
        }

        private void listChannels() {
            JSONObject o = new JSONObject();
            o.put("type", "channelList");
            JSONArray a = new JSONArray();
            o.put("channels", a);
            ArrayList<Channel> chs = this.server.getChannels();
            for (Channel ch : chs) {
                JSONObject info = new JSONObject().put("id", ch.id).put("info", ch.info).put("players", ch.receivers.size());
                a.put(info);
            }
            this.print(o);
        }

        public void print(JSONObject o) {
            this.print(o.toString());
        }

        public void print(String s) {
            if (this.server.verbose) {
                this.server.log(" -(" + this.socket.getInetAddress().getHostAddress() + ")-> " + s);
            }
            this.w.println(s);
            this.w.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.server.log("Running receiver " + this.id);
            this.switchChannelTo(this.server.mainChannel);
            try {
                while (!this.server.doClose()) {
                    JSONObject msg;
                    String l = this.r.readLine();
                    if (l == null) {
                        return;
                    }
                    if (this.server.verbose) {
                        this.server.log(" <-(" + this.socket.getInetAddress().getHostAddress() + ")- " + l);
                    }
                    if ((msg = new JSONObject(l)).optString("type", "-").equals("changeChannel")) {
                        Channel ch = this.server.getChannel(msg.getInt("id"));
                        if (ch == null) continue;
                        this.switchChannelTo(ch);
                        continue;
                    }
                    if (msg.optString("type", "-").equals("createChannel")) {
                        this.createChannel(msg.getJSONObject("info"));
                        continue;
                    }
                    if (msg.optString("type", "-").equals("listChannels")) {
                        this.listChannels();
                        continue;
                    }
                    this.currentChannel.addMessage(msg);
                }
            }
            catch (Exception e) {
                this.server.log("Exception in receiver: " + e);
                e.printStackTrace();
            }
            finally {
                this.switchChannelTo(null);
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    this.server.log("Exception when closing receiver socket: " + e);
                    e.printStackTrace();
                }
            }
            this.server.log("Closed receiver " + this.id);
        }
    }

    public static class Channel
    extends Thread {
        public final Server server;
        public final int id;
        public final JSONObject info;
        private int frameNumber = 0;
        private final long seed = new Random().nextLong();
        private final int numPlayers;
        private JSONArray messages = new JSONArray();
        private ArrayList<Receiver> receivers = new ArrayList();

        public synchronized void addMessage(JSONObject msg) {
            this.messages.put(msg);
        }

        public synchronized JSONArray harvestMessages() {
            JSONArray a = this.messages;
            this.messages = new JSONArray();
            return a;
        }

        public Channel(Server server, int id, int numPlayers, JSONObject info) {
            super("Channel " + id);
            this.id = id;
            this.server = server;
            this.info = info;
            this.numPlayers = numPlayers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!(this.server.doClose() || this.id != 0 && this.receivers.isEmpty())) {
                    Channel channel = this;
                    synchronized (channel) {
                        JSONArray harvestedMessages = this.harvestMessages();
                        JSONObject frame = new JSONObject();
                        frame.put("type", "frame");
                        frame.put("frameNumber", this.frameNumber);
                        frame.put("messages", harvestedMessages);
                        String frameString = frame.toString();
                        Iterator<Receiver> it = this.receivers.iterator();
                        while (it.hasNext()) {
                            try {
                                Receiver r = it.next();
                                r.print(frameString);
                            }
                            catch (Exception e) {
                                it.remove();
                            }
                        }
                        ++this.frameNumber;
                    }
                    try {
                        Thread.sleep(64L);
                    }
                    catch (Exception e) {
                        this.server.log("Channel interrupted: " + e);
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                this.server.log("Exception in channel " + this.id + ": " + e);
                e.printStackTrace();
            }
            finally {
                this.server.removeChannel(this);
            }
            this.server.log("Shut down channel " + this.id);
        }
    }

    public static class Acceptor
    extends Thread {
        public final Server server;
        private ServerSocket serverSocket;

        public Acceptor(Server server) {
            super("Acceptor");
            this.server = server;
            try {
                this.serverSocket = new ServerSocket(29139);
                this.serverSocket.setSoTimeout(1000);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                this.server.log("Running Acceptor");
                while (!this.server.doClose()) {
                    if (!this.server.doClose()) {
                        try {
                            Socket socket = this.serverSocket.accept();
                            if (socket != null) {
                                this.server.log("Accepted client from " + socket.getInetAddress().getHostAddress());
                                this.server.addReceiver(socket);
                            }
                        }
                        catch (SocketTimeoutException e) {}
                    } else {
                        Thread.sleep(10L);
                    }
                    if (this.server.mainChannel.isAlive()) continue;
                    this.server.log("Main channel is dead! Exiting!");
                    return;
                }
            }
            catch (Exception e) {
                this.server.log("Exception in acceptor: " + e);
                e.printStackTrace();
            }
            this.server.log("Acceptor shutting down...");
            try {
                this.serverSocket.close();
                this.server.log("Server socket closed.");
            }
            catch (Exception e) {
                this.server.log("Exception closing server socket: " + e);
                e.printStackTrace();
            }
        }
    }
}

