/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ResChooserScreen;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Locale;

public class SettingsScreen
implements Screen {
    public final AirshipGame g;
    private final ArrayList<ScreenMode> modes = new ArrayList();
    private final ArrayList<Locale> locales = Lang.availableLocales();
    private final MyDraw.SliderModel volumeModel = new MyDraw.SliderModel(){

        @Override
        public int min() {
            return 0;
        }

        @Override
        public int max() {
            return 10;
        }

        @Override
        public int getValue() {
            return (int)(SettingsScreen.this.g.volume * 10.0);
        }

        @Override
        public void setValue(int value) {
            SettingsScreen.this.g.volume = (double)value * 1.0 / 10.0;
        }
    };
    private final MyDraw.SliderModel musicVolumeModel = new MyDraw.SliderModel(){

        @Override
        public int min() {
            return 0;
        }

        @Override
        public int max() {
            return 10;
        }

        @Override
        public int getValue() {
            return (int)(SettingsScreen.this.g.musicVolume * 5.0);
        }

        @Override
        public void setValue(int value) {
            SettingsScreen.this.g.musicVolume = (double)value * 2.0 / 10.0;
        }
    };
    private final MyDraw.SliderModel scrollModel = new MyDraw.SliderModel(){

        @Override
        public int min() {
            return 1;
        }

        @Override
        public int max() {
            return 20;
        }

        @Override
        public int getValue() {
            AirshipGame cfr_ignored_0 = SettingsScreen.this.g;
            return AirshipGame.scrollSpeed / 2;
        }

        @Override
        public void setValue(int value) {
            AirshipGame cfr_ignored_0 = SettingsScreen.this.g;
            AirshipGame.scrollSpeed = value * 2;
        }
    };
    private static final ArrayList<ScreenMode> STANDARD_MODES = new ArrayList();

    public SettingsScreen(AirshipGame g) {
        this.g = g;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.modes.isEmpty()) {
            ArrayList cands = in.modes();
            ScreenMode biggest = null;
            for (ScreenMode c : cands) {
                if (biggest != null && biggest.width * biggest.height >= c.width * c.height) continue;
                biggest = c;
            }
            if (biggest != null) {
                this.modes.add(biggest);
            }
            for (ScreenMode c : STANDARD_MODES) {
                if (!cands.contains(c) || biggest != null && biggest.equals((Object)c)) continue;
                this.modes.add(c);
            }
            this.modes.add(new ScreenMode(1024, 768, false));
            this.modes.add(new ScreenMode(800, 600, false));
        }
        if (in.keyPressed("O") || in.keyPressed("ENTER")) {
            this.g.saveSettings();
            this.g.s = new MainMenu(this.g);
        }
        if (in.keyPressed("C") || in.keyPressed("ESCAPE")) {
            this.g.loadSettings();
            this.g.s = new MainMenu(this.g);
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.rect(AGame.SKY, 0.0, 0.0, sm.width, sm.height);
        d.drawBG(AGame.CAST_IRON, sm);
        int winW = 698;
        int winH = Math.max((SimplePref.values().length + 6) * 27, Math.max((this.locales.size() + 1) * 27, (this.modes.size() + 1) * 27)) + 24 + 12;
        int y = sm.height / 2 - winH / 2;
        int x = sm.width / 2 - winW / 2;
        int titleW = (int)d.textSize((String)Lang._t((String)"Settings", (Object[])new Object[0]), (Fount)AGame.HUGE_FOUNT).x;
        d.text("[f5edb5]" + Lang._t("Settings", new Object[0]), AGame.HUGE_FOUNT, sm.width / 2 - titleW / 2, y - AGame.HUGE_FOUNT.height);
        d.drawWindow(x, y, winW, winH);
        x += 12;
        int y2 = y += 12;
        for (final Locale l : this.locales) {
            d.toggle(x, y2, 150, l.getDisplayName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    Lang.setCurrentLocale(l);
                }
            }, Lang.currentLocale.equals(l), true);
            y2 += 27;
        }
        y2 = y;
        int x2 = x + 150 + 12;
        for (final ScreenMode m : this.modes) {
            d.toggle(x2, y2, 250, ResChooserScreen.mToString(m), "ENTER", new InputRunnable(){

                @Override
                public void run(Input in) {
                    try {
                        AirshipGame.PREFS.putInt("screenModeW", m.width);
                        AirshipGame.PREFS.putInt("screenModeH", m.height);
                        AirshipGame.PREFS.putBoolean("screenModeF", m.fullscreen);
                        AirshipGame.PREFS.flush();
                    }
                    catch (Exception e) {
                        SettingsScreen.this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
                    }
                    in.setMode(m);
                }
            }, m.equals((Object)sm), true);
            y2 += 27;
        }
        d.button(x, y + winH - 24 - 24, 100, Lang._t("OK", new Object[0]), "O", new Runnable(){

            @Override
            public void run() {
                SettingsScreen.this.g.saveSettings();
                SettingsScreen.this.g.s = new MainMenu(SettingsScreen.this.g);
            }
        });
        d.button(x + 100 + 3, y + winH - 24 - 24, 100, Lang._t("Cancel", new Object[0]), "C", new Runnable(){

            @Override
            public void run() {
                SettingsScreen.this.g.loadSettings();
                SettingsScreen.this.g.s = new MainMenu(SettingsScreen.this.g);
            }
        });
        y2 = y;
        d.text(Lang._t("Sound_Volume", new Object[0]), AGame.FOUNT, x2 += 262, y2 + 4);
        d.slider(x2 + 100, y2, 150, this.volumeModel);
        d.text(Lang._t("Music_Volume", new Object[0]), AGame.FOUNT, x2, (y2 += 27) + 4);
        d.slider(x2 + 100, y2, 150, this.musicVolumeModel);
        d.text(Lang._t("Scroll_Speed", new Object[0]), AGame.FOUNT, x2, (y2 += 27) + 4);
        d.slider(x2 + 100, y2, 150, this.scrollModel);
        d.toggle(x2, y2 += 27, 250, Lang._t("Send_back_bug_reports_automatically", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                SettingsScreen.this.g.phoneHomeWithErrors = !SettingsScreen.this.g.phoneHomeWithErrors;
            }
        }, this.g.phoneHomeWithErrors, true);
        d.tooltip(x2, y2, 250.0, 24.0, Lang._t("bug_report_info", new Object[0]));
        d.toggle(x2, y2 += 27, 250, Lang._t("High_quality_graphics", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                Appearance.useSimpleGraphics = !Appearance.useSimpleGraphics;
                Appearance.switchSpritesheet("");
            }
        }, !Appearance.useSimpleGraphics, true);
        d.tooltip(x2, y2, 250.0, 24.0, Lang._t("hq_gfx_tooltip", new Object[0]));
        d.toggle(x2, y2 += 27, 250, Lang._t("Lighting_effects", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                Appearance.useLighting = !Appearance.useLighting;
                Appearance.switchSpritesheet("");
            }
        }, Appearance.useLighting && !Appearance.useSimpleGraphics, !Appearance.useSimpleGraphics && Appearance.canUseLighting);
        y2 += 27;
        for (final SimplePref sp : SimplePref.values()) {
            d.toggle(x2, y2, 250, sp.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    sp.set(!sp.get());
                }
            }, sp.get(), true);
            d.tooltip(x2, y2, 250.0, 24.0, sp.getTooltip());
            y2 += 27;
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.MENU_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    static {
        STANDARD_MODES.add(new ScreenMode(1440, 1080, true));
        STANDARD_MODES.add(new ScreenMode(1440, 900, true));
        STANDARD_MODES.add(new ScreenMode(1024, 768, true));
        STANDARD_MODES.add(new ScreenMode(800, 600, true));
    }
}

