/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.ConstructionBackend;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;

public class ShipEditorUtils {
    public static final int MAX_COST = 20000;
    public static final int MAX_CREW = 120;

    public static String indent(String s, int amt) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < amt) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String getStats(Airship ship, int budget, Airship original) {
        int n;
        int r;
        int m;
        String costName;
        int ind = 24;
        StringBuilder sb = new StringBuilder("");
        int cost = original == null ? ship.getCost() : ship.getRefitCost(original);
        String string = costName = original == null ? Lang._t("Cost_", new Object[0]) : Lang._t("Rebuild_cost_", new Object[0]);
        if (budget > 0) {
            sb.append(cost > budget ? "[ff9999]" : "").append(ShipEditorUtils.indent(costName, ind)).append("$").append(cost).append(" / ").append(budget).append("[]");
        } else {
            sb.append(ShipEditorUtils.indent(costName, ind)).append("$").append(cost).append("[]");
        }
        if ((double)ship.getCost() > 16000.0) {
            sb.append(" [ffce6d](").append(Lang._t("max", new Object[0])).append(" ").append(20000).append(")[]\n");
        } else {
            sb.append("\n");
        }
        sb.append(ship.getSupplyRequired() > ship.getSupplyProvided() ? "[ff9999]" : "").append(ShipEditorUtils.indent(Lang._t("Supply_", new Object[0]), ind)).append(ship.getSupplyProvided()).append("/").append(ship.getSupplyRequired()).append("[]\n");
        sb.append(ShipEditorUtils.indent(Lang._t("Maintenance_", new Object[0]), ind)).append("$").append(ship.maintenanceCost());
        if (ship.type == ShipType.LANDSHIP && ship.constructionBonuses.contains((Object)Bonus.WOLFPACK) && ship.maintenanceCost() > 0 && ship.getWeight() <= 2000) {
            sb.append(" {WOLF}");
        }
        sb.append("\n");
        sb.append(ShipEditorUtils.indent(Lang._t("Weight_", new Object[0]), ind)).append(ship.getWeight()).append("[]\n");
        if (ship.type.mobile) {
            if (ship.type.onGround) {
                sb.append(ShipEditorUtils.indent(Lang._t("Max_carry_weight_", new Object[0]), ind)).append(ship.maxCarryWeight() < ship.getWeight() ? "[ff9999]" : "").append(ship.maxCarryWeight()).append("[]\n");
            } else {
                sb.append(ship.realServiceCeiling() <= 0 ? "[ff9999]" : "").append(ShipEditorUtils.indent(Lang._t("Lift_", new Object[0]), ind)).append(ship.getLift()).append("[]\n");
                sb.append(ship.realServiceCeiling() <= 0 ? "[ff9999]" : "").append(ShipEditorUtils.indent(Lang._t("Service_ceiling_", new Object[0]), ind)).append(ship.realServiceCeiling() / 7).append("m[]\n");
            }
            sb.append(ShipEditorUtils.indent(Lang._t("Speed_", new Object[0]), ind)).append((int)Math.ceil(ship.getSpeed() * 100.0)).append("[]\n");
            sb.append(ShipEditorUtils.indent(Lang._t("Turning_time_", new Object[0]), ind)).append(ship.turningCost() / 1000).append(".").append(ship.turningCost() / 100 % 10).append(" ").append(Lang._t("seconds", new Object[0])).append("[]\n");
        }
        if ((m = ship.getRequiredCrew()) > 0) {
            sb.append(ShipEditorUtils.indent(Lang._t("Min_crew_", new Object[0]), ind)).append(m).append("[]\n");
        }
        if ((r = ship.getRecommendedCrew()) > 0) {
            sb.append(ShipEditorUtils.indent(Lang._t("Recommended_crew_", new Object[0]), ind)).append(r).append("[]\n");
        }
        if ((n = ship.getQuartered(CrewType.SAILOR)) > 0 && r > 0) {
            sb.append(n < ship.getRequiredCrew() ? "[ff9999]" : "").append(ShipEditorUtils.indent(CrewType.SAILOR.getPlural() + ": ", ind)).append(n).append("[]");
            if ((double)n > 96.0) {
                sb.append(" [ffce6d](").append(Lang._t("max", new Object[0])).append(" ").append(120).append(")[]\n");
            } else {
                sb.append("\n");
            }
        }
        if ((m = ship.getRequiredGuards()) > 0) {
            sb.append(ShipEditorUtils.indent(Lang._t("Min_marines_or_guards_", new Object[0]), ind)).append(m).append("[]\n");
        }
        if ((n = ship.getQuartered(CrewType.MARINE)) > 0) {
            sb.append(ShipEditorUtils.indent(CrewType.MARINE.getPlural() + ": ", ind)).append(n).append("\n");
        }
        if ((n = ship.getQuartered(CrewType.GRENADIER)) > 0) {
            sb.append(ShipEditorUtils.indent(CrewType.GRENADIER.getPlural() + ": ", ind)).append(n).append("\n");
        }
        if ((n = ship.getQuartered(CrewType.GUARD)) > 0) {
            sb.append(ShipEditorUtils.indent(CrewType.GUARD.getPlural() + ": ", ind)).append(n).append("\n");
        }
        sb.append(ShipEditorUtils.indent(Lang._t("Coal_", new Object[0]), ind)).append(ship.getCoalCapacity()).append("[]\n");
        sb.append(ShipEditorUtils.indent(Lang._t("Ammo_", new Object[0]), ind)).append(ship.getAmmoCapacity()).append("[]\n");
        if (ship.commandPointsGenerated() == 0) {
            sb.append(Lang._t("Cannot_issue_commands", new Object[0])).append("\n");
        } else {
            sb.append(ShipEditorUtils.indent(Lang._t("Can_issue_a_command_every_", new Object[0]), ind)).append(ship.commandPointsRequired() / ship.commandPointsGenerated() * 16 / 1000).append(" ").append(Lang._t("seconds", new Object[0])).append("[]\n");
        }
        return sb.toString();
    }

    public static boolean isModuleAFixer(Airship ship, ModuleType type, EnumSet<Bonus> bonuses) {
        if (ship.modules.isEmpty()) {
            return true;
        }
        if (!ship.isPathingFullyConnected() && type == ModuleType.CORRIDOR) {
            return true;
        }
        if (!ship.type.onGround && ship.realServiceCeiling() <= 0 && type.getLift(bonuses) > 0) {
            return true;
        }
        if (ship.type.mobile && ship.getSpeed() == 0.0 && type.getPropulsion() > 0.0) {
            return true;
        }
        if (ship.getCoalCapacity() == 0 && type.getCoal() > 0 && ship.requiresCoal()) {
            return true;
        }
        if (ship.isArmed() && ship.getAmmoCapacity() == 0 && type.getAmmo() > 0) {
            return true;
        }
        if (ship.getQuartered(CrewType.SAILOR) < ship.getRequiredCrew() && type.getQuarters() > 0 && type.getQuartersType() == CrewType.SAILOR) {
            return true;
        }
        if (ship.getQuartered(CrewType.MARINE) + ship.getQuartered(CrewType.GUARD) < ship.getRequiredGuards() && type.getQuarters() > 0 && (type.getQuartersType() == CrewType.MARINE || type.getQuartersType() == CrewType.GUARD)) {
            return true;
        }
        return ship.getSupplyProvided() < ship.getSupplyRequired() && type.getSupplyProvided() > 0;
    }

    public static boolean checkForOverlaps(Airship ship, UniScreen us) {
        if (us.city != null) {
            for (Airship s : us.city.getDefences()) {
                if (s == ship || !s.overlapsWith(ship)) continue;
                return true;
            }
            Fleet gar = us.wm.getGarrison(us.city);
            if (gar != null) {
                for (Airship s : gar.actives) {
                    if (s == ship || !s.overlapsWith(ship)) continue;
                    return true;
                }
            }
            if (ship.overlapsWith(us.city.ground, false)) {
                return true;
            }
        }
        if (us.combat != null) {
            for (Combat.Side side : us.combat.sides) {
                for (Airship s : side.ships) {
                    if (s == ship || !s.overlapsWith(ship)) continue;
                    return true;
                }
            }
            if (ship.overlapsWith(us.combat.landFormations.get(0), false)) {
                return true;
            }
        }
        if (us.setupFleet != null) {
            for (Airship s : us.setupFleet) {
                if (s == ship || !s.overlapsWith(ship)) continue;
                return true;
            }
            if (ship.overlapsWith(us.setupGround, false)) {
                return true;
            }
        }
        return false;
    }

    public static ArrayList<String> shipWarnings(Airship ship) {
        ArrayList<String> ws = new ArrayList<String>();
        if (ship.commandPointsGenerated() == 0) {
            ws.add(Lang._t("Cannot_give_commands_to_" + ship.type.name(), new Object[0]));
        }
        if (!ship.type.onGround && ship.realServiceCeiling() < 112 && ship.realServiceCeiling() > 0) {
            ws.add(Lang._t("Ship_service_ceiling_low", new Object[0]));
        }
        return ws;
    }

    public static ArrayList<String> shipErrors(Airship ship, boolean checkBudget, boolean checkBonuses, int budget, EnumSet<Bonus> bonuses, Airship original, UniScreen checkForOverlaps) {
        ArrayList<String> es = new ArrayList<String>();
        if (ship.modules.isEmpty()) {
            es.add(Lang._t("edit_get_started", new Object[0]));
            return es;
        }
        if (checkForOverlaps != null && ShipEditorUtils.checkForOverlaps(ship, checkForOverlaps)) {
            es.add(Lang._t("The_" + ship.type.name() + "_cannot_be_placed_here", new Object[0]));
        }
        if (!ship.isFullyConnected()) {
            es.add(Lang._t("disconnected_" + ship.type.name(), new Object[0]));
        } else if (!ship.isPathingFullyConnected()) {
            es.add(Lang._t("inaccessible_" + ship.type.name(), new Object[0]));
        }
        if (!ship.type.onGround && ship.realServiceCeiling() <= 0) {
            es.add(Lang._t("The_ship_is_too_heavy_to_fly", new Object[0]));
        }
        if (ship.type.mobile) {
            if (ship.getSpeed() == 0.0) {
                es.add(Lang._t("The_ship_has_no_propulsion", new Object[0]));
            }
            if (ship.type.onGround && ship.getWeight() > ship.maxCarryWeight()) {
                es.add(Lang._t("The_ship_is_too_heavy", new Object[0]));
            }
        }
        if (ship.getCoalCapacity() == 0 && ship.requiresCoal()) {
            es.add(Lang._t("The_ship_has_no_coal", new Object[0]));
        }
        if (!ship.type.mobile) {
            int baseWidth = 0;
            for (int tx = 0; tx < ship.getWidth(); ++tx) {
                if (ship.tileAt(tx, ship.getHeight() - 1) == null) continue;
                ++baseWidth;
            }
            double dmg = 2.56E-4 * (double)(ship.getCollisionMass() + 5000) * 0.8 / (double)baseWidth - 1.0;
            if (dmg >= 0.3) {
                es.add(Lang._t("collapse_warning", new Object[0]));
            }
        }
        if (ship.isArmed() && ship.getAmmoCapacity() == 0) {
            es.add(Lang._t("The_" + ship.type.name() + "_has_no_ammunition", new Object[0]));
        }
        if (ship.getRequiredCrew() > 0 && ship.getQuartered(CrewType.SAILOR) == 0) {
            es.add(Lang._t("The_" + ship.type.name() + "_has_no_crew", new Object[0]));
        } else if (ship.getQuartered(CrewType.SAILOR) < ship.getRequiredCrew()) {
            es.add(Lang._t("The_" + ship.type.name() + "_has_insufficient_crew", new Object[0]));
        }
        if (ship.getRequiredGuards() > 0 && ship.getQuartered(CrewType.MARINE) + ship.getQuartered(CrewType.GUARD) == 0) {
            es.add(Lang._t("The_" + ship.type.name() + "_has_no_marines_or_guards", new Object[0]));
        } else if (ship.getQuartered(CrewType.MARINE) + ship.getQuartered(CrewType.GUARD) < ship.getRequiredGuards()) {
            es.add(Lang._t("The_" + ship.type.name() + "_has_insufficient_marines_or_guards", new Object[0]));
        }
        if (ship.getSupplyProvided() < ship.getSupplyRequired()) {
            es.add(Lang._t("The_" + ship.type.name() + "_needs_more_supply_hatches", new Object[0]));
        }
        if (checkBudget) {
            if (original == null) {
                if (ship.getCost() > budget) {
                    es.add(Lang._t("Insufficient_funds_to_build_this_" + ship.type.name(), new Object[0]));
                }
            } else if (ship.getRefitCost(original) > budget) {
                es.add(Lang._t("Insufficient_funds_to_refit_this_" + ship.type.name(), new Object[0]));
            }
        }
        if (checkBonuses) {
            block1: for (ModuleType moduleType : ModuleType.values()) {
                if (moduleType.getRequired() == null || bonuses.contains((Object)moduleType.getRequired())) continue;
                for (Module m : ship.modules) {
                    if (m.type != moduleType) continue;
                    es.add(Lang._t("x_is_not_available", moduleType.getName()));
                    continue block1;
                }
            }
            block3: for (Enum enum_ : ArmourType.values()) {
                if (((ArmourType)enum_).required == null || bonuses.contains((Object)((ArmourType)enum_).required)) continue;
                for (Tile t : ship.tiles) {
                    if (t.armour.type != enum_) continue;
                    es.add(Lang._t("x_is_not_available", ((ArmourType)enum_).getName()));
                    continue block3;
                }
            }
        }
        return es;
    }

    public static FileScreen.Backend shipsList(ShipType st, ShipHelperWidget shw) {
        File f = new File(AGame.getGameDirectory(), st.dirName);
        f.mkdirs();
        return new ConstructionBackend(f, shw);
    }
}

