/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ShipHelperWidget
implements FileScreen.HelperWidget,
Runnable {
    private final File shipDir;
    private CoatOfArms arms;
    private EnumSet<Bonus> bonuses;
    private final HashMap<String, Airship> ships = new HashMap();
    private String selection;
    private int budget;
    private final LinkedList<String> loadQueue = new LinkedList();
    private boolean doClose = false;
    public Airship original;
    private static final HashMap<String, ShipHelperWidget> forShipDir = new HashMap();

    public static ShipHelperWidget get(File shipDir, CoatOfArms arms, EnumSet<Bonus> bonuses, int budget) {
        String ap = shipDir.getAbsolutePath();
        if (forShipDir.containsKey(ap)) {
            ShipHelperWidget shw = forShipDir.get(ap);
            shw.arms = arms;
            shw.bonuses = bonuses;
            shw.budget = budget;
            return shw;
        }
        ShipHelperWidget shw = new ShipHelperWidget(shipDir, arms, bonuses, budget);
        forShipDir.put(ap, shw);
        return shw;
    }

    private ShipHelperWidget(File shipDir, CoatOfArms arms, EnumSet<Bonus> bonuses, int budget) {
        this.shipDir = shipDir;
        this.arms = arms;
        this.bonuses = bonuses;
        this.budget = budget;
        new Thread(this).start();
    }

    private Airship getShip() {
        if (this.selection == null) {
            return null;
        }
        return this.getShip(this.selection);
    }

    public Airship getShipIfAvailable(String shipName) {
        return this.ships.get(shipName);
    }

    public synchronized Airship getShip(String shipName) {
        Airship ship;
        if (!this.ships.containsKey(shipName) && !this.loadQueue.contains(shipName)) {
            this.loadQueue.add(shipName);
            this.notifyAll();
        }
        if (!((ship = this.ships.get(shipName)) == null || ship.constructionBonuses.equals(this.bonuses) && ship.currentBonuses.equals(this.bonuses))) {
            ship.constructionBonuses.clear();
            ship.constructionBonuses.addAll(this.bonuses);
            ship.currentBonuses.clear();
            ship.currentBonuses.addAll(this.bonuses);
            ship.repair();
        }
        return ship;
    }

    @Override
    public void setSelectedFile(String name) {
        this.selection = name;
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor, int x, int y, int w, int h) {
        d.drawPanel(x, y, w, h);
        Airship ship = this.getShip();
        if (ship == null) {
            return;
        }
        ship.constructionBonuses.clear();
        ship.constructionBonuses.addAll(this.bonuses);
        ship.currentBonuses.clear();
        ship.currentBonuses.addAll(this.bonuses);
        ship.repair();
        StringBuilder info = new StringBuilder(ShipEditorUtils.getStats(ship, this.budget, this.original));
        for (String s : ShipEditorUtils.shipErrors(ship, false, true, this.budget, this.bonuses, this.original, null)) {
            info.append("\n").append(s);
        }
        for (String s : ShipEditorUtils.shipWarnings(ship)) {
            info.append("\n").append(s);
        }
        String infoText = info.toString();
        h -= 12;
        d.text(ship.name, AGame.BIG_FOUNT, x += 6, y += 6);
        h -= AGame.BIG_FOUNT.height;
        Rect infoR = d.textSize(infoText, AGame.FOUNT, x, y += AGame.BIG_FOUNT.height, w -= 12);
        d.text(infoText, AGame.FOUNT, x, y, w);
        y = (int)((double)y + (infoR.height + 12.0));
        h = (int)((double)h - (infoR.height - 12.0));
        if (w < h) {
            h = w;
        } else {
            x += (w - h) / 2;
            w = h;
        }
        d.drawPanel(x, y, w, h);
        h -= 12;
        d.rect(AGame.SKY, x += 6, y += 6, w -= 12, w);
        double shipW = (double)w * 0.8 * 1.0;
        double scale = Math.min(shipW / (double)ship.getWidth() / 16.0, shipW / (double)ship.getHeight() / 16.0);
        d.shift((double)x + (double)w * 0.1, (double)y + (double)w * 0.1);
        d.scale(scale, scale);
        ship.draw(d, shipW / scale / 2.0 - (double)(ship.getWidth() * 16 / 2), shipW / scale / 2.0 - (double)(ship.getHeight() * 16 / 2), 0, false, false, true, this.arms, true, null, 1.0f, 1.0f, Clr.WHITE);
        d.resetTransforms();
        double shipX = ((double)x + (double)w * 0.1) / scale + (shipW / scale / 2.0 - (double)(ship.getWidth() * 16 / 2));
        double shipY = ((double)y + (double)w * 0.1) / scale + (shipW / scale / 2.0 - (double)(ship.getHeight() * 16 / 2));
        ship.hookModuleTooltips(d, shipX, shipY, scale);
    }

    @Override
    public synchronized void close() {
        this.doClose = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.doClose) {
            String toLoad = null;
            ShipHelperWidget shipHelperWidget = this;
            synchronized (shipHelperWidget) {
                if (!this.loadQueue.isEmpty()) {
                    toLoad = this.loadQueue.getFirst();
                }
            }
            if (toLoad != null) {
                this.loadShip(toLoad);
                continue;
            }
            try {
                shipHelperWidget = this;
                synchronized (shipHelperWidget) {
                    this.wait(100L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadShip(String shipName) {
        BufferedReader r = null;
        Airship ship = null;
        try {
            File f = new File(this.shipDir, shipName + ".json");
            r = new BufferedReader(new FileReader(f));
            ship = new Airship(new JSONObject(new JSONTokener(r)));
            ship.constructionBonuses.clear();
            ship.constructionBonuses.addAll(this.bonuses);
            ship.currentBonuses.clear();
            ship.currentBonuses.addAll(this.bonuses);
            ship.repair();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                r.close();
            }
            catch (Exception e) {}
        }
        ShipHelperWidget shipHelperWidget = this;
        synchronized (shipHelperWidget) {
            this.ships.put(shipName, ship);
            this.loadQueue.remove(shipName);
        }
    }

    @Override
    public synchronized void clearCacheFor(String name) {
        this.loadQueue.add(0, name);
    }

    public int cacheSize() {
        return this.ships.size();
    }
}

