/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.RotatingShader;
import com.zarkonnen.airships.TexGen;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WeaponAppearance;
import com.zarkonnen.airships.Wheel;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;
import java.util.Arrays;
import org.newdawn.slick.Image;

public class ShipLayers {
    public static final ArrayList<UniScreen.ShipLayer> ALL = new ArrayList<UniScreen.ShipLayer>(Arrays.asList(new DamagedBack(), new Back(), new SimpleBack(), new Barrels(), new Modules(), new DamagedModules(), new Crew(), new HPBars(), new Armour(), new Paint(), new Decals1(), new Decals2(), new Externals(), new DamagedExternals(), new TracksAndLegs()));

    static ArrayList<?> getTrackSegments(Airship ship, Module m) {
        int wi;
        ArrayList<Object> segs = new ArrayList<Object>();
        segs.add(ShipLayers.getLeftmostCurvedSegment(m.wheels.get(0), m.wheels.get(1)));
        for (wi = 0; wi < m.wheels.size() - 1; ++wi) {
            segs.add(ShipLayers.getStraightSegment(m.wheels.get(wi), m.wheels.get(wi + 1)));
            if (wi >= m.wheels.size() - 2) continue;
            segs.add(ShipLayers.getCurvedSegment(m.wheels.get(wi), m.wheels.get(wi + 1), m.wheels.get(wi + 2)));
        }
        segs.add(ShipLayers.getRightmostCurvedSegment(m.wheels.get(m.wheels.size() - 2), m.wheels.get(m.wheels.size() - 1)));
        for (wi = m.wheels.size() - 1; wi >= 1; --wi) {
            segs.add(ShipLayers.getStraightSegment(m.wheels.get(wi), m.wheels.get(wi - 1)));
            if (wi < 2) continue;
            segs.add(ShipLayers.getCurvedSegment(m.wheels.get(wi), m.wheels.get(wi - 1), m.wheels.get(wi - 2)));
        }
        for (int si = 0; si < segs.size() - 2; ++si) {
            double iSectY;
            double iSectX;
            if (!(segs.get(si) instanceof StraightSegment) || !(segs.get(si + 1) instanceof CurvedSegment) || ((CurvedSegment)segs.get((int)(si + 1))).endSegment || !(segs.get(si + 2) instanceof StraightSegment)) continue;
            StraightSegment seg1 = (StraightSegment)segs.get(si);
            StraightSegment seg2 = (StraightSegment)segs.get(si + 2);
            if (seg2.endX > seg1.endX) {
                if (!(seg1.endX > seg2.startX)) continue;
                iSectX = (seg1.endX + seg2.startX) / 2.0;
                iSectY = (seg1.endY + seg2.startY) / 2.0;
                seg1.endX = iSectX;
                seg1.endY = iSectY;
                seg2.startX = iSectX;
                seg2.startY = iSectY;
                continue;
            }
            if (!(seg2.endX > seg1.startX)) continue;
            iSectX = (seg2.endX + seg1.startX) / 2.0;
            iSectY = (seg2.endY + seg1.startY) / 2.0;
            seg2.endX = iSectX;
            seg2.endY = iSectY;
            seg1.startX = iSectX;
            seg1.startY = iSectY;
        }
        return segs;
    }

    static CurvedSegment getLeftmostCurvedSegment(Wheel w, Wheel to) {
        double wx = w.spec.xOffset * 16.0;
        double wy = w.yOffset;
        double tox = to.spec.xOffset * 16.0;
        double toy = to.yOffset;
        double wToToAngle = Direction.radiansFromTo(wx, wy, tox, toy);
        double startAngle = Direction.normalizeRadians(wToToAngle + 1.5707963267948966);
        return new CurvedSegment(w, startAngle, startAngle + Math.PI, true);
    }

    static CurvedSegment getCurvedSegment(Wheel from, Wheel w, Wheel to) {
        double fromx = from.spec.xOffset * 16.0;
        double fromy = from.yOffset;
        double wx = w.spec.xOffset * 16.0;
        double wy = w.yOffset;
        double tox = to.spec.xOffset * 16.0;
        double toy = to.yOffset;
        double fromToWAngle = Direction.radiansFromTo(fromx, fromy, wx, wy);
        double wToToAngle = Direction.radiansFromTo(wx, wy, tox, toy);
        double startAngle = Direction.normalizeRadians(fromToWAngle + 4.71238898038469);
        double endAngle = Direction.normalizeRadians(wToToAngle + 4.71238898038469);
        return new CurvedSegment(w, startAngle, endAngle, false);
    }

    static CurvedSegment getRightmostCurvedSegment(Wheel from, Wheel w) {
        double fromx = from.spec.xOffset * 16.0;
        double fromy = from.yOffset;
        double wx = w.spec.xOffset * 16.0;
        double wy = w.yOffset;
        double fromToWAngle = Direction.radiansFromTo(fromx, fromy, wx, wy);
        double startAngle = Direction.normalizeRadians(fromToWAngle + 4.71238898038469);
        return new CurvedSegment(w, startAngle, startAngle + Math.PI, true);
    }

    static StraightSegment getStraightSegment(Wheel from, Wheel to) {
        double fromx = from.spec.xOffset * 16.0;
        double fromy = from.yOffset;
        double tox = to.spec.xOffset * 16.0;
        double toy = to.yOffset;
        double fromToToAngle = Direction.radiansFromTo(fromx, fromy, tox, toy);
        double startAngle = fromToToAngle + 4.71238898038469;
        double endAngle = fromToToAngle + 4.71238898038469;
        return new StraightSegment(fromx + Math.cos(startAngle) * from.spec.radius, fromy + Math.sin(startAngle) * from.spec.radius, tox + Math.cos(endAngle) * to.spec.radius, toy + Math.sin(endAngle) * to.spec.radius);
    }

    public static final class TracksAndLegs
    implements UniScreen.ShipLayer {
        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            RotatingShader.lockShader(4, d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            for (Module m : ship.modules) {
                double mx = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16);
                double my = y + (double)(m.y * 16) + (double)(m.type.getH() * 16);
                if (m.hp <= 0) continue;
                for (Wheel w : m.wheels) {
                    RotatingShader.draw(4, w.spec.wheel, d, mx + w.spec.xOffset * 16.0 - (double)(w.spec.wheel.srcWidth / 2), my + w.yOffset - (double)(w.spec.wheel.srcHeight / 2), w.phase, false, light, lightStrength, ambient, ambientClr);
                }
                if (!m.wheels.isEmpty()) {
                    Wheel.Spec ws = m.wheels.get((int)0).spec;
                    double segmentStride = ws.segmentStride;
                    double strideRadians = segmentStride / m.wheels.get((int)0).spec.radius;
                    ArrayList<?> segs = ShipLayers.getTrackSegments(ship, m);
                    for (int pass = 0; pass < 2; ++pass) {
                        double value = m.wheels.get((int)0).phase * segmentStride / strideRadians;
                        if (value < 0.0) {
                            value += Math.ceil(-value / segmentStride / 2.0) * segmentStride * 2.0;
                        }
                        boolean flipAlt = (value %= segmentStride * 2.0) >= segmentStride;
                        value %= segmentStride;
                        boolean second = pass == 1;
                        boolean alternation = second ^ flipAlt;
                        for (Object seg : segs) {
                            if (seg instanceof StraightSegment) {
                                StraightSegment ss = (StraightSegment)seg;
                                double dist = Math.sqrt((ss.startX - ss.endX) * (ss.startX - ss.endX) + (ss.startY - ss.endY) * (ss.startY - ss.endY));
                                double angle = Direction.radiansFromTo(ss.startX, ss.startY, ss.endX, ss.endY);
                                while (value < dist) {
                                    boolean bl = alternation = !alternation;
                                    if (!alternation) {
                                        Img lnk = second ? ws.upperLink : ws.lowerLink;
                                        RotatingShader.draw(4, lnk, d, mx + ss.startX + (ss.endX - ss.startX) * value / dist - (double)(lnk.srcWidth / 2), my + ss.startY + (ss.endY - ss.startY) * value / dist - (double)(lnk.srcHeight / 2), angle + Math.PI, false, light, lightStrength, ambient, ambientClr);
                                    }
                                    value += segmentStride;
                                }
                                value -= dist;
                            }
                            if (!(seg instanceof CurvedSegment)) continue;
                            CurvedSegment cs = (CurvedSegment)seg;
                            if (cs.startAngle >= cs.endAngle) continue;
                            Wheel w = cs.w;
                            for (value = cs.startAngle + value * strideRadians / segmentStride; value < cs.endAngle; value += strideRadians) {
                                boolean bl = alternation = !alternation;
                                if (alternation) continue;
                                Img lnk = second ? ws.upperLink : ws.lowerLink;
                                RotatingShader.draw(4, lnk, d, mx + w.spec.xOffset * 16.0 + Math.cos(value) * w.spec.radius - (double)(lnk.srcWidth / 2), my + w.yOffset + Math.sin(value) * w.spec.radius - (double)(lnk.srcHeight / 2), value + 4.71238898038469, false, light, lightStrength, ambient, ambientClr);
                            }
                            value = (value - cs.endAngle) * segmentStride / strideRadians;
                        }
                    }
                }
                for (Leg l : m.legs) {
                    double hipX;
                    double d2 = hipX = ship.flipped ? mx + ((double)m.type.getW() - l.spec.xOffset) * 16.0 : mx + l.spec.xOffset * 16.0;
                    if (l.spec.upperLeg != null) {
                        RotatingShader.draw(4, l.spec.upperLeg, d, hipX - (double)(l.spec.upperLeg.srcWidth / 2), my + l.spec.yOffset * 16.0 - (double)(l.spec.upperLeg.srcHeight / 2), l.upperRotation, false, light, lightStrength, ambient, ambientClr);
                        RotatingShader.draw(4, l.spec.lowerLeg, d, hipX + Math.cos(l.upperRotation) * l.spec.limbLength - (double)(l.spec.lowerLeg.srcWidth / 2), my + l.spec.yOffset * 16.0 + Math.sin(l.upperRotation) * l.spec.limbLength - (double)(l.spec.lowerLeg.srcHeight / 2), l.lowerRotation, false, light, lightStrength, ambient, ambientClr);
                        RotatingShader.draw(4, l.spec.foot, d, hipX + (Math.cos(l.upperRotation) + Math.cos(l.lowerRotation)) * l.spec.limbLength - (double)(l.spec.foot.srcWidth / 2), my + l.spec.yOffset * 16.0 + (Math.sin(l.upperRotation) + Math.sin(l.lowerRotation)) * l.spec.limbLength - (double)(l.spec.foot.srcHeight / 2), 1.5707963267948966, false, light, lightStrength, ambient, ambientClr);
                        continue;
                    }
                    d.shift(mx + l.spec.xOffset * 16.0, my + l.spec.yOffset * 16.0);
                    d.rotate(l.upperRotation * 180.0 / Math.PI);
                    d.rect(Clr.RED, -l.spec.limbLength / 8.0, -l.spec.limbLength / 8.0, l.spec.limbLength, l.spec.limbLength / 4.0);
                    d.rotate(-l.upperRotation * 180.0 / Math.PI);
                    d.shift(Math.cos(l.upperRotation) * l.spec.limbLength, Math.sin(l.upperRotation) * l.spec.limbLength);
                    d.rotate(l.lowerRotation * 180.0 / Math.PI);
                    d.rect(Clr.RED, -l.spec.limbLength / 8.0, -l.spec.limbLength / 8.0, l.spec.limbLength, l.spec.limbLength / 4.0);
                    d.rotate(-l.lowerRotation * 180.0 / Math.PI);
                    d.shift(-Math.cos(l.upperRotation) * l.spec.limbLength, -Math.sin(l.upperRotation) * l.spec.limbLength);
                    d.shift(-mx - l.spec.xOffset * 16.0, -my - l.spec.yOffset * 16.0);
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            RotatingShader.unlockShader();
        }
    }

    static class StraightSegment {
        double startX;
        double startY;
        double endX;
        double endY;

        public StraightSegment(double startX, double startY, double endX, double endY) {
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
        }
    }

    static class CurvedSegment {
        Wheel w;
        double startAngle;
        double endAngle;
        boolean endSegment;

        public CurvedSegment(Wheel w, double startAngle, double endAngle, boolean endSegment) {
            this.w = w;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
            this.endSegment = endSegment;
        }
    }

    public static class DamagedExternals
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            Appearance.lockShader(3, d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            Module m;
            int mi;
            if (!outside) {
                return;
            }
            int msz = ship.modules.size();
            for (mi = 0; mi < msz; ++mi) {
                m = ship.modules.get(mi);
                if (m.hp > 0 || m.type.getExternalDrawPriority()) continue;
                m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, light, lightStrength, ambient);
            }
            for (mi = 0; mi < msz; ++mi) {
                m = ship.modules.get(mi);
                if (m.hp > 0 || !m.type.getExternalDrawPriority()) continue;
                m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, light, lightStrength, ambient);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class Externals
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            Appearance.lockShader(d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            Module m;
            int mi;
            if (!outside) {
                return;
            }
            int msz = ship.modules.size();
            for (mi = 0; mi < msz; ++mi) {
                m = ship.modules.get(mi);
                if (m.hp <= 0 || m.type.getExternalDrawPriority()) continue;
                m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, light, lightStrength, ambient);
            }
            for (mi = 0; mi < msz; ++mi) {
                m = ship.modules.get(mi);
                if (m.hp <= 0 || !m.type.getExternalDrawPriority()) continue;
                m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, light, lightStrength, ambient);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class Decals2
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            if (!outside) {
                return;
            }
            Clr ambientTint = new Clr((int)(255.0f * ambient), (int)(255.0f * ambient), (int)(255.0f * ambient));
            if (showDecals) {
                int dsz = ship.decals.size();
                for (int di = 0; di < dsz; ++di) {
                    Decal dec = ship.decals.get(di);
                    if (!dec.enabled) continue;
                    dec.type.drawNonShader(d, x + (double)(ship.gridXToWorldX(dec.x, dec.type.w) * 16), y + (double)(dec.y * 16), ms, ship.flipped, coa, ship.name, ambientTint);
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class Decals1
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            Appearance.lockShader(d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            if (!outside) {
                return;
            }
            if (showDecals) {
                int dsz = ship.decals.size();
                for (int di = 0; di < dsz; ++di) {
                    Decal dec = ship.decals.get(di);
                    if (!dec.enabled) continue;
                    dec.type.draw(d, x + (double)(ship.gridXToWorldX(dec.x, dec.type.w) * 16), y + (double)(dec.y * 16), ms, ship.flipped, coa, ship.name, light, lightStrength, ambient);
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class Paint
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            if (!outside) {
                return;
            }
            if (light != null) {
                return;
            }
            int tsz = ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = ship.tiles.get(ti);
                if (t.armour.paint == null || t.armour.type == ArmourType.NONE) continue;
                d.rect(t.armour.paint.paintTint, x + (double)(ship.gridXToWorldX(t.x, 1) * 16), y + (double)(t.y * 16), 16.0, 16.0);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class Armour
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            Appearance.lockBevelledShader(d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            if (!outside) {
                return;
            }
            int tsz = ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = ship.tiles.get(ti);
                if (t.armour.type == ArmourType.NONE) continue;
                int[][] patch9 = new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}};
                if (t.armour.hp == 0) {
                    for (int dy = -1; dy < 2; ++dy) {
                        for (int dx = -1; dx < 2; ++dx) {
                            if (!t.adjacent[dy + 1][dx + 1] || ship.tileAt((int)(t.x + dx), (int)(t.y + dy)).armour.hp != 0) continue;
                            patch9[dy + 1][dx + 1] = 0;
                        }
                    }
                }
                t.armour.getApp().drawBevelled(d, x + (double)(ship.gridXToWorldX(t.x, 1) * 16), y + (double)(t.y * 16), 16.0, 16.0, ms, null, ship.flipped, light, lightStrength, ambient, t.adjacent[0][1] ? 0 : 1, t.adjacent[2][1] ? 0 : 1, t.adjacent[1][0] ? 0 : 1, t.adjacent[1][2] ? 0 : 1, patch9, t.armour.paint == null ? null : t.armour.paint.nicePaintTint);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockBevelledShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class HPBars
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            if (!outside && showHPBarsAndDoors) {
                int msz = ship.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    double barY;
                    double barX;
                    Module m = ship.modules.get(mi);
                    if (displayStatusIcons && m.hp < m.getMaxHP() / 2 && m.hp > 0) {
                        barX = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16);
                        double barW = m.type.getW() * 16;
                        barY = y + (double)((m.y + m.type.getH()) * 16);
                        d.rect(Airship.HP_BG, barX + 1.0, barY - 5.0, barW - 2.0, 4.0);
                        Clr c = Clr.LIGHT_GREY;
                        if (m.hp < m.getMaxHP() / 2) {
                            c = Clr.ORANGE;
                        }
                        if (m.hp < m.getMaxHP() / 4) {
                            c = Clr.RED;
                        }
                        d.rect(c, barX + 2.0 + (barW - 4.0) * (double)m.getMaxRepairToHP() / (double)m.getMaxHP() - 2.0, barY - 4.0, 1.0, 2.0);
                        d.rect(c, barX + 2.0, barY - 4.0, (barW - 4.0) * (double)m.hp / (double)m.getMaxHP(), 2.0);
                    }
                    barX = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16) + 2.0;
                    double barH = m.type.getH() * 16 - 8;
                    barY = y + (double)(m.y * 16) + 2.0;
                    double barW = 3.0;
                    if (displayStatusIcons && m.type.getCoal() > 0) {
                        d.rect(Airship.COAL_BG, barX, barY, barW, barH);
                        d.rect(Airship.COAL_FG, barX, barY + barH - barH * (double)m.getResource(Resource.COAL) / (double)m.type.getCoal(), barW, barH * (double)m.getResource(Resource.COAL) / (double)m.type.getCoal());
                    }
                    if (displayStatusIcons && m.type.getWater() > 0) {
                        d.rect(Airship.WATER_BG, barX, barY, barW, barH);
                        d.rect(Airship.WATER_FG, barX, barY + barH - barH * (double)m.getResource(Resource.WATER) / (double)m.type.getWater(), barW, barH * (double)m.getResource(Resource.WATER) / (double)m.type.getWater());
                    }
                    if (displayStatusIcons && m.type.getRepair() > 0) {
                        d.rect(Airship.REPAIR_BG, barX, barY, barW, barH);
                        d.rect(Airship.REPAIR_FG, barX, barY + barH - barH * (double)m.getResource(Resource.REPAIR) / (double)m.type.getRepair(), barW, barH * (double)m.getResource(Resource.REPAIR) / (double)m.type.getRepair());
                    }
                    if (!displayStatusIcons || m.type.getAmmo() <= 0) continue;
                    d.rect(Airship.AMMO_BG, barX, barY, barW, barH);
                    d.rect(Airship.AMMO_FG, barX, barY + barH - barH * (double)m.getResource(Resource.AMMO) / (double)m.type.getAmmo(), barW, barH * (double)m.getResource(Resource.AMMO) / (double)m.type.getAmmo());
                }
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class Crew
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            if (scale < 1.0) {
                Appearance.lockShader(d, light, lightStrength, ambient);
            } else {
                RotatingShader.lockShader(d, light, lightStrength, ambient);
            }
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            if (outside && scale < 0.75) {
                return;
            }
            Clr ambientTint = new Clr((int)(ambient * 255.0f), (int)(ambient * 255.0f), (int)(ambient * 255.0f));
            int csz = ship.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman c = ship.crew.get(ci);
                if (scale < 1.0) {
                    c.simpleDraw(d, x + (double)(ship.gridXToWorldX(c.currentTile.x, 1) * 16), y + (double)(c.currentTile.y * 16), ms, light, lightStrength, ambient);
                    continue;
                }
                c.draw(d, x + (double)(ship.gridXToWorldX(c.currentTile.x, 1) * 16), y + (double)(c.currentTile.y * 16), ms, light, lightStrength, ambient, ambientTint);
            }
            int bsz = ship.boarders.size();
            for (int bi = 0; bi < bsz; ++bi) {
                Crewman b = ship.boarders.get(bi);
                if (scale < 1.0) {
                    b.simpleDraw(d, x + (double)(ship.gridXToWorldX(b.currentTile.x, 1) * 16), y + (double)(b.currentTile.y * 16), ms, light, lightStrength, ambient);
                    continue;
                }
                b.draw(d, x + (double)(ship.gridXToWorldX(b.currentTile.x, 1) * 16), y + (double)(b.currentTile.y * 16), ms, light, lightStrength, ambient, ambientTint);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            if (scale < 1.0) {
                Appearance.unlockShader(light != null);
            } else {
                RotatingShader.unlockShader();
            }
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class DamagedModules
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            Appearance.lockShader(3, d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            if (outside && scale <= 0.75) {
                return;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (!displayStatusIcons || m.hp > 0) continue;
                m.type.draw(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, light, lightStrength, ambient);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class Modules
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            Appearance.lockShader(d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            if (outside && scale <= 0.75) {
                return;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (displayStatusIcons && m.hp <= 0) continue;
                m.type.draw(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, light, lightStrength, ambient);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class Barrels
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            RotatingShader.lockShader(d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            int msz = ship.modules.size();
            Clr ambientTint = new Clr((int)(ambient * 255.0f), (int)(ambient * 255.0f), (int)(ambient * 255.0f));
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                WeaponAppearance wa = m.type.weaponAppearance();
                if (wa == null) continue;
                Img barrel = ship.flipped ? wa.flippedbarrel : wa.barrel;
                Pt offset = ship.flipped ? wa.flippedBarrelOffset : wa.barrelOffset;
                double angle = ship.flipped != m.type.isFlipped() ? m.weaponAngle + Math.PI : m.weaponAngle;
                double recoilX = Math.cos(m.weaponAngle) * m.recoil;
                double recoilY = Math.sin(m.weaponAngle) * m.recoil;
                if (barrel == null || m.hp <= 0) continue;
                double bx = x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16) + offset.x - recoilX;
                double by = y + (double)(m.y * 16) + offset.y - recoilY;
                RotatingShader.draw(barrel, d, bx, by, angle, ship.flipped, light, lightStrength, ambient, ambientTint);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            RotatingShader.unlockShader();
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class SimpleBack
    implements UniScreen.ShipLayer {
        Clr bgOutside = TexGen.DARK_WOOD_GRAIN;

        @Override
        public boolean doDraw(double scale) {
            return true;
        }

        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            int alpha = Math.min(255, (int)((2.5 - scale) * 255.0));
            this.bgOutside = new Clr((int)((float)TexGen.WOOD_GRAIN.r * ambient), (int)((float)TexGen.WOOD_GRAIN.g * ambient), (int)((float)TexGen.WOOD_GRAIN.b * ambient), alpha);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            if (outside) {
                if (scale > 2.5) {
                    return;
                }
            } else {
                return;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (m.type.isExternal()) continue;
                d.rect(this.bgOutside, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.type.getW() * 16, m.type.getH() * 16);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
        }
    }

    public static class Back
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            Appearance.lockShader(d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            float armourBackFalloff;
            boolean externalsOnly = outside && scale <= 1.5;
            float f = armourBackFalloff = outside ? 0.1f : 0.25f;
            if (!outside) {
                int msz = ship.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    Module m = ship.modules.get(mi);
                    if (m.hp <= 0) continue;
                    m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, light, lightStrength, ambient);
                }
            }
            if (externalsOnly) {
                return;
            }
            int tsz = ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = ship.tiles.get(ti);
                if (t.armour.type == ArmourType.NONE) continue;
                if (outside) {
                    t.armour.type.damagedApps.get(0).draw(d, x + (double)(ship.gridXToWorldX(t.x, 1) * 16), y + (double)(t.y * 16), ms, Airship.ARMOUR_BACK, ship.flipped, light, lightStrength * armourBackFalloff, ambient);
                    continue;
                }
                t.armour.getApp().draw(d, x + (double)(ship.gridXToWorldX(t.x, 1) * 16), y + (double)(t.y * 16), ms, Airship.ARMOUR_BACK, ship.flipped, light, lightStrength * armourBackFalloff, ambient);
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                WeaponAppearance wa = m.type.weaponAppearance();
                if (wa == null || wa.back == null) continue;
                m.type.drawBack(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, Airship.ARMOUR_BACK, ship.flipped, m.variant);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }

    public static class DamagedBack
    implements UniScreen.ShipLayer {
        @Override
        public void lockShader(MyDraw d, double scale, Image[] light, float lightStrength, float ambient) {
            Appearance.lockShader(3, d, light, lightStrength, ambient);
        }

        @Override
        public void draw(Airship ship, MyDraw d, boolean outside, double scale, double x, double y, int ms, boolean displayStatusIcons, boolean showDecals, CoatOfArms coa, boolean showHPBarsAndDoors, Image[] light, float lightStrength, float ambient, Clr ambientClr) {
            ship.showingOutside = outside;
            if (outside) {
                return;
            }
            int msz = ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = ship.modules.get(mi);
                if (m.hp > 0) continue;
                m.type.drawExternal(d, x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16), y + (double)(m.y * 16), m.time + m.animOffset, ship.flipped, m.variant, light, lightStrength, ambient);
            }
        }

        @Override
        public void unlockShader(Image[] light, double scale) {
            Appearance.unlockShader(light != null);
        }

        @Override
        public boolean doDraw(double scale) {
            return true;
        }
    }
}

