/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.EditorAttractIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public class ShipProfilePanel
implements UniScreen.InfoPanel {
    static final Clr OVERLAY = new Clr(0, 0, 0, 200);
    static final ModuleType[] INTERESTING = new ModuleType[]{ModuleType.LARGE_KEEL, ModuleType.TARGETING_COMPUTER, ModuleType.TELESCOPE};

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        if (us.followShip == null) {
            return;
        }
        Airship ship = us.followShip;
        CoatOfArms coa = CoatEditor.getMyStrategicArms();
        if (us.combat != null && us.combat.sideOf(ship) != null) {
            coa = us.combat.sideOf((Airship)ship).arms;
        }
        if (us.intent instanceof EditorAttractIntent) {
            EditorAttractIntent eai = (EditorAttractIntent)us.intent;
            coa = eai.coa;
            if (eai.typeToAdd < ModuleType.values().length) {
                return;
            }
        }
        int coaScale = 4;
        int x = 10;
        int y = sm.height - 10 - 41 * coaScale;
        d.rect(OVERLAY, 0.0, y - 12, sm.width, sm.height);
        coa.layout.drawShield(coa, d, x, y, coaScale, Clr.WHITE);
        d.text(ship.name, AGame.HUGE_FOUNT, x += 39 * coaScale + 12, y);
        y += AGame.HUGE_FOUNT.height;
        int in = 20;
        ArrayList<String> stats = new ArrayList<String>();
        stats.add(ShipEditorUtils.indent(Lang._t("Cost_", new Object[0]), in) + ship.getCost());
        stats.add(ShipEditorUtils.indent(Lang._t("Weight_", new Object[0]), in) + ship.getWeight());
        stats.add(ShipEditorUtils.indent(Lang._t("Speed_", new Object[0]), in) + (int)(ship.getSpeed() * 100.0));
        stats.add(ShipEditorUtils.indent(Lang._t("Service_ceiling_", new Object[0]), in) + ship.realServiceCeiling() / 8);
        for (CrewType crewType : CrewType.values()) {
            if (ship.getQuartered(crewType) <= 0) continue;
            stats.add(ShipEditorUtils.indent(crewType.getPlural() + ": ", in) + ship.getQuartered(crewType));
        }
        for (ModuleType mt : ModuleCategory.WEAPONS.getContents()) {
            int n = 0;
            for (Module m : ship.modules) {
                if (m.type != mt) continue;
                ++n;
            }
            if (n <= 0) continue;
            stats.add(ShipEditorUtils.indent(mt.getName() + ": ", in) + n);
        }
        for (Enum enum_ : INTERESTING) {
            boolean has = false;
            for (Module m : ship.modules) {
                if (m.type != enum_) continue;
                has = true;
                break;
            }
            if (!has) continue;
            stats.add(((ModuleType)enum_).getName());
        }
        int y2 = y;
        int x2 = x;
        for (String string : stats) {
            d.text(string, AGame.FOUNT, x2, y2);
            if ((y2 += AGame.FOUNT.lineHeight) + AGame.FOUNT.lineHeight <= sm.height - 10) continue;
            y2 = y;
            x2 += AGame.FOUNT.displayWidth * 30;
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

