/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MessageDialog;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Utils;

public class ShipSpyButton
extends UniScreen.ShipButton {
    public final Spy.ShipSpyAction action;

    public ShipSpyButton(Spy.ShipSpyAction action) {
        this.action = action;
    }

    public int successChance(Airship ship, UniScreen us, StrategicScreen ss) {
        return this.action.successChance(ship, ss.w.player.getSpyFor(us.city), ss.w.player, us.city, ss.w.map);
    }

    public int cost(Airship ship, UniScreen us, StrategicScreen ss) {
        return this.action.cost(ship, ss.w.player.getSpyFor(us.city), ss.w.player, us.city, ss.w.map);
    }

    @Override
    public boolean enabled(Airship ship, Combat.Side side, UniScreen us) {
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        return this.successChance(ship, us, ss) > 0 && this.cost(ship, us, ss) <= ss.w.player.money;
    }

    @Override
    public void click(Input in, Airship ship, Combat.Side side, UniScreen us) {
        boolean abjectFailure;
        int chance;
        final StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        ss.w.player.money -= this.cost(ship, us, ss);
        int roll = AGame.ANIM_R.nextInt(100);
        boolean success = roll < (chance = this.successChance(ship, us, ss));
        boolean bl = abjectFailure = roll * 2 < chance;
        if (success) {
            Utils.Pair<String, String> myYourText = this.action.success(ship, ss.w.player.getSpyFor(us.city), us.city, ss.w.map);
            us.confirmDialog = new MessageDialog((String)myYourText.a){

                @Override
                public void ok(UniScreen us) {
                    us.city.alertAmount += 15000;
                    us.confirmDialog = null;
                }
            };
        } else {
            Utils.Pair<String, String> myYourText = this.action.failure(ship, ss.w.player.getSpyFor(us.city), us.city, ss.w.map);
            if (abjectFailure) {
                ss.w.player.spies.remove(ss.w.player.getSpyFor(us.city));
                us.confirmDialog = new MessageDialog((String)myYourText.a + " " + Lang._t("Your_spy_has_been_captured", new Object[0])){

                    @Override
                    public void ok(UniScreen us) {
                        us.city.alertAmount += 30000;
                        us.g.s = ss;
                    }
                };
            } else {
                us.confirmDialog = new MessageDialog((String)myYourText.a){

                    @Override
                    public void ok(UniScreen us) {
                        us.confirmDialog = null;
                    }
                };
            }
        }
    }

    @Override
    public boolean visible(Airship ship, Combat.Side side, UniScreen us) {
        if (!(us.intent instanceof EspionageIntent)) {
            return false;
        }
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        Spy spy = ss.w.player.getSpyFor(us.city);
        if (spy == null) {
            return false;
        }
        return this.action.available(ship, spy, us.city, ss.w.map);
    }

    @Override
    public String text(Airship ship, Combat.Side side, UniScreen us) {
        StrategicScreen ss = ((EspionageIntent)us.intent).ss;
        return this.action.getName() + " ($" + this.cost(ship, us, ss) + ", " + this.successChance(ship, us, ss) + "%)";
    }
}

