/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CampaignCombatIntent;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MultiplayerCombatIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.SingleCombatIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class ShipWarningsChrome
implements UniScreen.ShipChrome {
    private final Img DEFEATED = new Img("spritesheet", 144, 416, 16, 16, false);
    private final Img UNDER_COMMAND = new Img("spritesheet", 32, 384, 16, 16, false);
    private final Img COAL = new Img("spritesheet", 192, 416, 16, 16, false);
    private final Img WATER = new Img("spritesheet", 160, 416, 16, 16, false);
    private final Img AMMO = new Img("spritesheet", 176, 416, 16, 16, false);
    private final Img REPAIR = new Img("spritesheet", 48, 416, 16, 16, false);
    private final Img READY = new Img("spritesheet", 112, 512, 16, 16, false);

    @Override
    public void draw(MyDraw d, Pt cursor, Airship ship, Combat.Side side, int x, int y, int w, int h, ScreenMode sm, UniScreen us) {
        if (us.hideUI) {
            return;
        }
        if (!(us.intent instanceof SingleCombatIntent || us.intent instanceof MultiplayerCombatIntent || us.intent instanceof CampaignCombatIntent)) {
            return;
        }
        y -= 20;
        if (ship.readyForCommand() && (side == null || side == us.mySide)) {
            d.borderedBlit(this.READY, Clr.GREEN, Clr.WHITE, x, y);
            d.tooltip(x, y, 16.0, 16.0, Lang._t("Ready_for_command", new Object[0]));
            x += 20;
        }
        if (!ship.canShoot() || ship.crew.isEmpty()) {
            d.borderedBlit(this.DEFEATED, Clr.RED, Clr.WHITE, x, y);
            d.tooltip(x, y, 16.0, 16.0, Lang._t("Defeated", new Object[0]));
            x += 20;
        }
        if (side == null || side == us.mySide) {
            if (ship.commandPointsGenerated() <= 0) {
                d.borderedBlit(this.UNDER_COMMAND, Clr.RED, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("Not_under_command", new Object[0]));
                x += 20;
            }
            int cc = ship.getCoalCapacity();
            int ct = ship.getTotalResource(Resource.COAL);
            if (cc > 0 && ct == 0) {
                d.borderedBlit(this.COAL, Clr.RED, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("Out_of_COAL", new Object[0]));
                x += 20;
            } else if (cc > 0 && (double)ct < (double)cc * 0.2) {
                d.borderedBlit(this.COAL, Clr.ORANGE, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("x_y_COAL_left", ct, cc));
                x += 20;
            } else if (cc > 0 && (double)ct < (double)cc * 0.4) {
                d.borderedBlit(this.COAL, Clr.YELLOW, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("x_y_COAL_left", ct, cc));
                x += 20;
            }
            int wc = ship.getWaterCapacity();
            int wt = ship.getTotalResource(Resource.WATER);
            if (wc > 0 && wt == 0) {
                d.borderedBlit(this.WATER, Clr.RED, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("Out_of_WATER", new Object[0]));
                x += 20;
            } else if (wc > 0 && (double)wt < (double)wc * 0.2) {
                d.borderedBlit(this.WATER, Clr.ORANGE, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("x_y_WATER_left", wt, wc));
                x += 20;
            } else if (wc > 0 && (double)wt < (double)wc * 0.4) {
                d.borderedBlit(this.WATER, Clr.YELLOW, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("x_y_WATER_left", wt, wc));
                x += 20;
            }
            int rc = ship.getRepairCapacity();
            int rt = ship.getTotalResource(Resource.REPAIR);
            if (rc > 0 && rt == 0) {
                d.borderedBlit(this.REPAIR, Clr.RED, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("Out_of_REPAIR", new Object[0]));
                x += 20;
            } else if (rc > 0 && (double)rt < (double)rc * 0.2) {
                d.borderedBlit(this.REPAIR, Clr.ORANGE, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("x_y_REPAIR_left", rt, rc));
                x += 20;
            } else if (rc > 0 && (double)rt < (double)rc * 0.4) {
                d.borderedBlit(this.REPAIR, Clr.YELLOW, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("x_y_REPAIR_left", rt, rc));
                x += 20;
            }
            int ac = ship.getAmmoCapacity();
            int at = ship.getTotalResource(Resource.AMMO);
            if (ac > 0 && at == 0) {
                d.borderedBlit(this.AMMO, Clr.RED, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("Out_of_AMMO", new Object[0]));
                x += 20;
            } else if (ac > 0 && (double)at < (double)ac * 0.2) {
                d.borderedBlit(this.AMMO, Clr.ORANGE, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("x_y_AMMO_left", at, ac));
                x += 20;
            } else if (ac > 0 && (double)at < (double)ac * 0.4) {
                d.borderedBlit(this.AMMO, Clr.YELLOW, Clr.WHITE, x, y);
                d.tooltip(x, y, 16.0, 16.0, Lang._t("x_y_AMMO_left", at, ac));
                x += 20;
            }
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean textInputOccurring(UniScreen us) {
        return false;
    }
}

