/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Img;

public strictfp class Shot {
    public Airship target;
    public double tX;
    public double tY;
    public double sX;
    public double sY;
    public int time;
    public int travelTime;
    public boolean internal;
    public boolean vsBoarders;
    public int crewDamage;
    public Crewman shooter;
    public Airship sourceShip;
    public Module weapon;
    public transient boolean done;

    public Shot(Airship target, double tX, double tY, Airship source, double sX, double sY, Module weapon) {
        this.target = target;
        this.tX = tX;
        this.tY = tY;
        this.sourceShip = source;
        this.sX = sX;
        this.sY = sY;
        this.weapon = weapon;
        double dist = Math.sqrt((tX - sX) * (tX - sX) + (tY - sY) * (tY - sY));
        this.travelTime = (int)(dist / weapon.type.getShotSpeed());
    }

    public Shot(Airship target, double tX, double tY, Crewman shooter, double sX, double sY, int crewDamage, boolean vsBoarders) {
        this.target = target;
        this.tX = tX;
        this.tY = tY;
        this.shooter = shooter;
        this.sX = sX;
        this.sY = sY;
        this.crewDamage = crewDamage;
        this.vsBoarders = vsBoarders;
        double dist = Math.sqrt((tX - sX) * (tX - sX) + (tY - sY) * (tY - sY));
        this.travelTime = (int)(dist / 0.7);
    }

    public boolean tick(int ms, Combat c) {
        Particle p;
        if (this.weapon != null && this.weapon.type.weaponAppearance().shotEmitter != null && (p = this.weapon.type.weaponAppearance().shotEmitter.emit(this.sX + (this.tX - this.sX) * (double)this.time / (double)this.travelTime, this.sY + (this.tY - this.sY) * (double)this.time / (double)this.travelTime, ms)) != null) {
            c.particles.add(p);
        }
        if (this.weapon != null && this.weapon.type.weaponAppearance().exhaust != null && (p = this.weapon.type.weaponAppearance().exhaust.emit(this.sX + (this.tX - this.sX) * (double)this.time / (double)this.travelTime, this.sY + (this.tY - this.sY) * (double)this.time / (double)this.travelTime, Math.atan2(this.tY - this.sY, this.tX - this.sX), ms)) != null) {
            c.particles.add(p);
        }
        this.time += ms;
        if (this.time >= this.travelTime) {
            boolean hit = this.target.hit(this, c);
            if (this.weapon != null) {
                int i;
                if (hit) {
                    int dmg = this.weapon.type.getBlastDmg(this.sourceShip.currentBonuses) + this.weapon.type.getPenDmg();
                    c.play("hit" + AGame.ANIM_R.nextInt(4), (int)this.tX, (int)this.tY, (double)dmg / 20.0);
                    c.boringTicks = 0;
                }
                int parts = Math.min(10, this.weapon.type.getBlastDmg(this.sourceShip.currentBonuses) / 2 + (hit ? this.weapon.type.getPenDmg() / 3 : 0));
                for (i = 0; i < parts * 2; ++i) {
                    c.particles.add(new Particle(Particle.Type.SMALL_SOOT, this.tX, this.tY));
                    c.particles.add(new Particle(Particle.Type.LARGE_SOOT, this.tX, this.tY));
                }
                for (i = 0; i < parts; ++i) {
                    c.particles.add(new Particle(Particle.Type.IMPACT, this.tX, this.tY));
                }
                if (this.weapon.type.getHitSound() != null) {
                    c.play(this.weapon.type.getHitSound(), (int)this.tX, (int)this.tY, 1.0);
                }
            }
            this.done = true;
            return true;
        }
        return false;
    }

    public void draw(Draw d) {
        if (this.weapon != null) {
            Img img = this.weapon.type.weaponAppearance().shot;
            d.blit(img, this.sX + (this.tX - this.sX) * (double)this.time / (double)this.travelTime - (double)(img.srcWidth / 2), this.sY + (this.tY - this.sY) * (double)this.time / (double)this.travelTime - (double)(img.srcHeight / 2), Math.atan2(this.tY - this.sY, this.tX - this.sX));
        }
    }

    public int getPenDmg() {
        return this.weapon == null ? 0 : this.weapon.type.getPenDmg();
    }

    public int getBlastDmg() {
        return this.weapon == null ? 0 : this.weapon.type.getBlastDmg(this.sourceShip.currentBonuses);
    }

    public int getCrewDmg() {
        return this.crewDamage;
    }

    public boolean harmsCrew() {
        return this.weapon != null || !this.vsBoarders;
    }

    public boolean harmsBoarders() {
        return this.weapon != null || this.vsBoarders;
    }
}

