/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.Trail;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

public class ShotVisualLayer
implements UniScreen.VisualLayer {
    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.combat == null) {
            return;
        }
        Graphics g = (Graphics)d.frame().nativeRenderer();
        float ambient = us.getTimeOfDay().ambient;
        g.setColor(new Color(255, 255, 255, (int)(10.0f + 40.0f * ambient)));
        for (Trail t : us.combat.trails) {
            double trailHeight;
            double trailWidth;
            double trailTop;
            double shotX = t.shot.sX + (t.shot.tX - t.shot.sX) * (double)t.shot.time / (double)t.shot.travelTime;
            double shotY = t.shot.sY + (t.shot.tY - t.shot.sY) * (double)t.shot.time / (double)t.shot.travelTime;
            double trailLeft = Math.min(shotX, t.shot.sX);
            if (!Rect2D.intersects(cropX, cropY, cropW, cropH, trailLeft, trailTop = Math.min(shotY, t.shot.sY), trailWidth = Math.max(shotX, t.shot.sX) - trailLeft, trailHeight = Math.max(shotY, t.shot.sY) - trailTop)) continue;
            g.setLineWidth((float)(t.baseWidth * (1.0 - (double)t.age * 1.0 / 500.0)));
            g.drawLine((float)t.shot.sX, (float)t.shot.sY, (float)shotX, (float)shotY);
        }
        g.setLineWidth(1.0f);
        for (Shot shot : us.combat.shots) {
            shot.draw(d);
        }
    }
}

