/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;

public class SkyVisualLayer
implements UniScreen.VisualLayer {
    public static final Clr BLUEPRINT = Clr.fromHex((String)"0e61a7");
    public static final Img BLUEPRINT_IMG = new Img("blueprint", 0, 0, 512, 512, false);
    public static final Clr GRID = new Clr(255, 255, 255, 23);

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        block10: {
            block9: {
                if (!us.intent.drawAsBlueprint()) break block9;
                d.rect(BLUEPRINT, cropX, cropY, cropW, cropH);
                int xStart = 0;
                while ((double)xStart > cropX) {
                    xStart -= 256;
                }
                int yStart = 0;
                while ((double)yStart > cropY) {
                    yStart -= 256;
                }
                int y = yStart;
                while ((double)y < cropY + cropH) {
                    int x = xStart;
                    while ((double)x < cropX + cropW) {
                        d.blit(BLUEPRINT_IMG, x, y);
                        x += 256;
                    }
                    y += 256;
                }
                if (!(us.intent instanceof SingleShipIntent)) break block10;
                double w = 1.5 / us.zoom;
                Airship ship = ((SingleShipIntent)((Object)us.intent)).getShip(us);
                for (double xs = (double)ship.getX() - w / 2.0; xs > cropX; xs -= 16.0) {
                }
                for (double ys = (double)ship.getY() - w / 2.0; ys > cropY; ys -= 16.0) {
                }
                for (double x = xs; x < cropX + cropW; x += 16.0) {
                    d.rect(GRID, x, cropY, w, cropH);
                }
                for (double y2 = ys; y2 < cropY + cropH; y2 += 16.0) {
                    d.rect(GRID, cropX, y2, cropW, w);
                }
                break block10;
            }
            TimeOfDay tod = us.getTimeOfDay();
            int y = 512;
            int h = tod.skyColorBandHeight;
            for (int i = 0; i < tod.skyColors.length - 1; ++i) {
                d.rect(tod.skyColors[i], cropX, y - h, cropW, h + 2);
                y -= h;
                h *= 2;
            }
        }
    }
}

