/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.util.Utils;
import org.json.JSONObject;

public class Spy {
    public static final int HIRE_COST = 100;
    public static final int MAINTENANCE_COST = 5;
    public static final int INFILTRATION_TIME = 10000;
    public static final int ALERT_FAILURE_MULT = 2;
    public static final int SUCCESS_ALERT = 15000;
    public static final int CAPTURE_ALERT = 30000;
    public City location;
    public int infiltrationTimeout;

    public Spy(City location) {
        this.location = location;
        this.infiltrationTimeout = 10000;
    }

    public Spy(JSONObject o) {
        this.infiltrationTimeout = o.getInt("infiltrationTimeout");
    }

    public void finish(JSONObject o, WorldMap wm) {
        this.location = wm.empires.get((int)o.getInt((String)"locationEmpire")).cities.get(o.getInt("location"));
    }

    public JSONObject toJSON(WorldMap wm) {
        Empire cityOwner = wm.owner(this.location);
        JSONObject o = new JSONObject();
        o.put("infiltrationTimeout", this.infiltrationTimeout);
        o.put("locationEmpire", wm.empires.indexOf(cityOwner));
        o.put("location", cityOwner.cities.indexOf(this.location));
        return o;
    }

    public void tick(int ms, Empire owner, WorldMap map) {
        this.infiltrationTimeout -= ms;
        if (this.infiltrationTimeout < 0) {
            this.infiltrationTimeout = 0;
        }
    }

    public static enum ShipSpyAction {
        DESTROY{

            @Override
            public boolean available(Airship ship, Spy spy, City city, WorldMap wm) {
                return true;
            }

            @Override
            public int baseFailureRate(Airship ship, Spy spy, City city, WorldMap wm) {
                return Math.min(90, 50 + ship.getCost() / 15);
            }

            @Override
            public int baseCost(Airship ship, Spy spy, City city, WorldMap wm) {
                return 100 + ship.getCost() / 10 * 20;
            }

            @Override
            public Utils.Pair<String, String> success(Airship ship, Spy spy, City city, WorldMap wm) {
                Empire owner = wm.owner(city);
                owner.remove(ship, wm);
                return Utils.p((Object)Lang._t("spy_ship_DESTROY_success_spy", ship.name), (Object)Lang._t("spy_ship_DESTROY_success_victim", ship.name, city.name));
            }

            @Override
            public Utils.Pair<String, String> failure(Airship ship, Spy spy, City city, WorldMap wm) {
                return Utils.p((Object)Lang._t("spy_ship_DESTROY_failure_spy", ship.name), (Object)Lang._t("spy_ship_DESTROY_failure_victim", ship.name, city.name));
            }
        }
        ,
        BRIBE{

            @Override
            public boolean available(Airship ship, Spy spy, City city, WorldMap wm) {
                return ship.type.mobile && this.fleeCity(ship, spy, city, wm) != null;
            }

            @Override
            public int baseFailureRate(Airship ship, Spy spy, City city, WorldMap wm) {
                int rate = 70 + ship.getCost() / 30;
                Fleet garrison = wm.getGarrison(city);
                if (garrison == null) {
                    throw new RuntimeException("Checking failure rate for bribing in garrison-free city.");
                }
                if (garrison.actives.size() + garrison.reserve.size() <= 1) {
                    rate -= 20;
                }
                return Math.min(100, rate);
            }

            @Override
            public int baseCost(Airship ship, Spy spy, City city, WorldMap wm) {
                return 50 + ship.getCost() / 10 * 80;
            }

            private City fleeCity(Airship ship, Spy spy, City city, WorldMap wm) {
                Empire spyOwner = wm.owner(spy);
                if (spyOwner == null) {
                    return null;
                }
                if (ship.type.onGround) {
                    City fleeCity = null;
                    int minDist = 0;
                    for (City c : spyOwner.cities) {
                        if (!wm.connected(c, city)) continue;
                        int distSq = (c.x - city.x) * (c.x - city.x) * (c.y - city.y) * (c.y - city.y);
                        if (fleeCity != null && minDist <= distSq) continue;
                        fleeCity = c;
                        minDist = distSq;
                    }
                    return fleeCity;
                }
                City fleeCity = null;
                int minDist = 0;
                for (City c : spyOwner.cities) {
                    int distSq = (c.x - city.x) * (c.x - city.x) * (c.y - city.y) * (c.y - city.y);
                    if (fleeCity != null && minDist <= distSq) continue;
                    fleeCity = c;
                    minDist = distSq;
                }
                return fleeCity;
            }

            @Override
            public Utils.Pair<String, String> success(Airship ship, Spy spy, City city, WorldMap wm) {
                Empire oldOwner = wm.owner(city);
                oldOwner.remove(ship, wm);
                Empire newOwner = wm.owner(spy);
                Fleet newFleet = null;
                for (Fleet fl : newOwner.fleets) {
                    if (fl.sx != (double)city.x || fl.sy != (double)city.y || fl.progress != 0.0) continue;
                    newFleet = fl;
                    break;
                }
                if (newFleet == null) {
                    newFleet = new Fleet(city);
                    newOwner.fleets.add(newFleet);
                }
                newFleet.actives.add(ship);
                newFleet.travelTo(this.fleeCity(ship, spy, city, wm), wm);
                return Utils.p((Object)Lang._t("spy_ship_BRIBE_success_spy", ship.name), (Object)Lang._t("spy_ship_BRIBE_success_victim", ship.name, newOwner.name));
            }

            @Override
            public Utils.Pair<String, String> failure(Airship ship, Spy spy, City city, WorldMap wm) {
                return Utils.p((Object)Lang._t("spy_ship_BRIBE_failure_spy", ship.name), (Object)Lang._t("spy_ship_BRIBE_failure_victim", ship.name, city.name));
            }
        };


        public abstract boolean available(Airship var1, Spy var2, City var3, WorldMap var4);

        public abstract int baseFailureRate(Airship var1, Spy var2, City var3, WorldMap var4);

        public abstract int baseCost(Airship var1, Spy var2, City var3, WorldMap var4);

        public abstract Utils.Pair<String, String> success(Airship var1, Spy var2, City var3, WorldMap var4);

        public abstract Utils.Pair<String, String> failure(Airship var1, Spy var2, City var3, WorldMap var4);

        public int successChance(Airship ship, Spy spy, Empire empire, City city, WorldMap wm) {
            int failure = this.baseFailureRate(ship, spy, city, wm) + wm.owner((City)city).policeLevel.spyReduction;
            if (city.alertAmount > 0) {
                failure *= 2;
            }
            int success = Math.max(0, 100 - failure);
            return Math.min(100, empire.hasBonus(Bonus.MASTER_SPIES) ? success * 3 / 2 : success);
        }

        public int cost(Airship ship, Spy spy, Empire empire, City city, WorldMap wm) {
            int cost = this.baseCost(ship, spy, city, wm);
            return empire.hasBonus(Bonus.MASTER_SPIES) ? cost / 2 : cost;
        }

        public String getName() {
            return Lang._t("spy_ship_" + this.name(), new Object[0]);
        }
    }

    public static enum CitySpyAction {
        SABOTAGE_PRODUCTION{

            @Override
            public boolean available(Spy spy, City city, WorldMap wm) {
                return city.constructing != null && city.constructionProgress > 0;
            }

            @Override
            public int baseFailureRate(Spy spy, City city, WorldMap wm) {
                return 75;
            }

            @Override
            public int baseCost(Spy spy, City city, WorldMap wm) {
                return 400;
            }

            @Override
            public Utils.Pair<String, String> success(Spy spy, City city, WorldMap wm) {
                city.constructionProgress /= 2;
                return Utils.p((Object)Lang._t("spy_city_SABOTAGE_PRODUCTION_success_spy", city.constructing.name), (Object)Lang._t("spy_city_SABOTAGE_PRODUCTION_success_victim", city.name, city.constructing.name));
            }

            @Override
            public Utils.Pair<String, String> failure(Spy spy, City city, WorldMap wm) {
                return Utils.p((Object)Lang._t("spy_city_SABOTAGE_PRODUCTION_failure_spy", new Object[0]), (Object)Lang._t("spy_city_SABOTAGE_PRODUCTION_failure_victim", city.name, city.constructing.name));
            }
        }
        ,
        INCITE_REVOLT{

            @Override
            public boolean available(Spy spy, City city, WorldMap wm) {
                Empire owner = wm.owner(city);
                return owner.cities.size() > 1 && !owner.name.equals(city.name);
            }

            @Override
            public int baseFailureRate(Spy spy, City city, WorldMap wm) {
                int rate = 95;
                if (wm.getGarrison(city) == null) {
                    rate -= 15;
                }
                if (city.takeoverMethod != null) {
                    rate -= 15;
                }
                return rate;
            }

            @Override
            public int baseCost(Spy spy, City city, WorldMap wm) {
                return 1000;
            }

            @Override
            public Utils.Pair<String, String> success(Spy spy, City city, WorldMap wm) {
                Empire owner = wm.owner(spy);
                wm.dirty = true;
                if (owner.hasBonus(Bonus.REVOLUTION)) {
                    Empire oldEmp = wm.owner(city);
                    Fleet garrison = wm.getGarrison(city);
                    oldEmp.cities.remove(city);
                    owner.cities.add(city);
                    if (garrison != null) {
                        oldEmp.fleets.remove(garrison);
                        owner.fleets.add(garrison);
                        garrison.broadcastDestroyed(wm);
                    }
                    city.takeoverAmount = 0;
                    city.takeoverMethod = null;
                    city.takeoverNeeded = false;
                    city.addMessage(City.MessageType.REVOLT, Lang._t("The_citizens_of_x_revolt", city.name));
                    return Utils.p((Object)Lang._t("spy_city_INCITE_REVOLT_success_join_spy", city.name), (Object)Lang._t("spy_city_INCITE_REVOLT_success_join_victim", city.name, owner.name));
                }
                Empire newEmp = new Empire(city.name, CoatOfArms.getRandom(), Bonus.NO_BONUS, 100, Empire.Personality.POLICE, 1.0, TakeoverMethod.GENTLE);
                wm.empires.add(newEmp);
                Empire oldEmp = wm.owner(city);
                Fleet garrison = wm.getGarrison(city);
                oldEmp.cities.remove(city);
                newEmp.cities.add(city);
                if (garrison != null) {
                    oldEmp.fleets.remove(garrison);
                    newEmp.fleets.add(garrison);
                    garrison.broadcastDestroyed(wm);
                }
                city.takeoverAmount = 0;
                city.takeoverMethod = null;
                city.takeoverNeeded = false;
                city.addMessage(City.MessageType.REVOLT, Lang._t("The_citizens_of_x_revolt", city.name));
                return Utils.p((Object)Lang._t("spy_city_INCITE_REVOLT_success_spy", city.name), (Object)Lang._t("spy_city_INCITE_REVOLT_success_victim", city.name));
            }

            @Override
            public Utils.Pair<String, String> failure(Spy spy, City city, WorldMap wm) {
                return Utils.p((Object)Lang._t("spy_city_INCITE_REVOLT_failure_spy", new Object[0]), (Object)Lang._t("spy_city_INCITE_REVOLT_failure_victim", city.name));
            }
        };


        public abstract boolean available(Spy var1, City var2, WorldMap var3);

        public abstract int baseFailureRate(Spy var1, City var2, WorldMap var3);

        public abstract int baseCost(Spy var1, City var2, WorldMap var3);

        public abstract Utils.Pair<String, String> success(Spy var1, City var2, WorldMap var3);

        public abstract Utils.Pair<String, String> failure(Spy var1, City var2, WorldMap var3);

        public int successChance(Spy spy, Empire empire, City city, WorldMap wm) {
            int failure = this.baseFailureRate(spy, city, wm) + wm.owner((City)city).policeLevel.spyReduction;
            if (city.alertAmount > 0) {
                failure *= 2;
            }
            int success = Math.max(0, 100 - failure);
            return Math.min(100, empire.hasBonus(Bonus.MASTER_SPIES) ? success * 3 / 2 : success);
        }

        public int cost(Spy spy, Empire empire, City city, WorldMap wm) {
            int cost = this.baseCost(spy, city, wm);
            return empire.hasBonus(Bonus.MASTER_SPIES) ? cost / 2 : cost;
        }

        public String getName() {
            return Lang._t("spy_city_" + this.name(), new Object[0]);
        }
    }
}

