/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CampaignCombatIntent;
import com.zarkonnen.airships.CampaignCombatSetupIntent;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.SingleCombatIntent;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public class StartCombatButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof SingleCombatSetupIntent || us.intent instanceof CampaignCombatSetupIntent;
    }

    @Override
    public boolean enabled(UniScreen us) {
        if (us.intent instanceof SingleCombatSetupIntent) {
            return !us.combat.sides.get((int)0).ships.isEmpty() && !us.combat.sides.get((int)1).ships.isEmpty();
        }
        return true;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Start", new Object[0]);
    }

    @Override
    public boolean gold(UniScreen us) {
        return true;
    }

    @Override
    public void click(Input in, UniScreen us) {
        Combat.Side playerSide = null;
        Combat.Side computerSide = null;
        if (us.intent instanceof SingleCombatSetupIntent) {
            us.intent = new SingleCombatIntent();
            playerSide = us.combat.sides.get(0);
            computerSide = us.combat.sides.get(1);
        }
        if (us.intent instanceof CampaignCombatSetupIntent) {
            CampaignCombatSetupIntent ccsi = (CampaignCombatSetupIntent)us.intent;
            us.intent = new CampaignCombatIntent(ccsi.ss, ccsi.ci);
            playerSide = us.combat.sides.get(ccsi.ci.playerCombatSideIndex);
            computerSide = us.combat.otherSide(playerSide);
        }
        computerSide.usingAI = true;
        int shipI = 1;
        for (Airship as : computerSide.ships) {
            as.ai = new TacticalAI(as, us.combat, computerSide, playerSide);
            as.networkID = "ai." + shipI++;
        }
        for (Airship as : computerSide.reserve) {
            as.ai = new TacticalAI(as, us.combat, computerSide, playerSide);
            as.networkID = "ai." + shipI++;
        }
        shipI = 1;
        for (Airship as : playerSide.ships) {
            as.networkID = "p." + shipI++;
        }
        for (Airship as : playerSide.reserve) {
            as.networkID = "p." + shipI++;
        }
        us.tool = UniScreen.NAVIGATE;
    }

    @Override
    public String hotkey(UniScreen us) {
        return "S";
    }
}

