/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.DesignFromDefencesIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public class StartDesignFromDefencesButton
extends UniScreen.Button {
    public ShipType type;

    public StartDesignFromDefencesButton(ShipType type) {
        this.type = type;
    }

    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof DefencesIntent;
    }

    @Override
    public boolean enabled(UniScreen us) {
        return us.city.constructing == null;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Design_" + this.type.name(), new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        Airship editShip = new Airship(this.type);
        editShip.constructionBonuses = us.wm.owner(us.city).bonuses();
        editShip.currentBonuses = us.wm.owner(us.city).bonuses();
        editShip.x = 100.0;
        if (!this.type.mobile) {
            us.city.addDefence(editShip);
        } else {
            Empire owner = us.wm.owner(us.city);
            boolean added = false;
            for (Fleet f : owner.fleets) {
                if (f.location != us.city) continue;
                f.actives.add(editShip);
                added = true;
                break;
            }
            if (!added) {
                Fleet f = new Fleet(us.city);
                f.actives.add(editShip);
                owner.fleets.add(f);
            }
        }
        us.intent = new DesignFromDefencesIntent((DefencesIntent)us.intent, editShip);
    }
}

