/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import java.nio.ByteBuffer;
import net.puppygames.steam.AppID;
import net.puppygames.steam.BeginAuthSessionResult;
import net.puppygames.steam.Steam;

public class SteamBackend {
    public static final int APP_ID = 342560;
    public static final boolean SWITCHED_ON = System.getProperty("steam", "false").equals("true");
    private static boolean authed = false;
    private static ByteBuffer authTicket;
    private static final char[] hexArray;
    private static String nick;

    public static void tick() {
        if (SteamBackend.isEnabled()) {
            Steam.tick();
            if (!authed) {
                authed = true;
                authTicket = ByteBuffer.allocateDirect(2048);
                Steam.getUser().getAuthSessionTicket(authTicket);
                BeginAuthSessionResult basr = Steam.getUser().beginAuthSession(authTicket, Steam.getUser().getSteamID());
                switch (basr) {
                    case InvalidTicket: 
                    case InvalidVersion: 
                    case ExpiredTicket: 
                    case DuplicateRequest: 
                    case GameMismatch: {
                        System.exit(777);
                    }
                }
                System.err.println(basr);
                System.err.println(Steam.getUser().isUserLicensedForApp(Steam.getUser().getSteamID(), new AppID(342560)));
                Steam.tick();
            }
        }
    }

    public static String getAuthTicketHex() {
        byte[] array = new byte[authTicket.limit()];
        authTicket.get(array);
        authTicket.rewind();
        return SteamBackend.bytesToHex(array);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean isEnabled() {
        return SWITCHED_ON && Steam.isCreated() && Steam.isSteamRunning();
    }

    public static String getSteamNickname() {
        if (nick == null) {
            nick = Steam.getFriends().getFriendPersonaName(Steam.getUser().getSteamID());
        }
        return nick;
    }

    public static String getSteamNickDisplayName() {
        return SteamBackend.getSteamNickname().replace("[", "(").replace("]", ")").replace("{", "(").replace("}", ")");
    }

    public static long getUserID() {
        return Steam.getUser().getSteamID().getSteamID();
    }

    public static boolean _achieve(String name) {
        try {
            if (!Steam.getUserStats().isAchieved(name)) {
                Steam.getUserStats().setAchievement(name);
                Steam.getUserStats().storeStats();
                return true;
            }
        }
        catch (Exception e) {
            AirshipGame.instance.reportError("Can't achieve " + name, e, "", false, true);
            return true;
        }
        return false;
    }

    public static boolean _unAchieve(String name) {
        try {
            if (Steam.getUserStats().isAchieved(name)) {
                Steam.getUserStats().clearAchievement(name);
                Steam.getUserStats().storeStats();
                return true;
            }
        }
        catch (Exception e) {
            AirshipGame.instance.reportError("Can't achieve " + name, e, "", false, true);
            return true;
        }
        return false;
    }

    public static boolean _isAchieved(String name) {
        try {
            return Steam.getUserStats().isAchieved(name);
        }
        catch (Exception e) {
            AirshipGame.instance.reportError("Fetch isAchieved of " + name, e, "", false, true);
            return false;
        }
    }

    static {
        if (SWITCHED_ON) {
            Steam.init((int)342560);
        }
        hexArray = "0123456789ABCDEF".toCharArray();
    }
}

