/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.ConstructionAffinity;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.WorldMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import org.json.JSONObject;
import org.json.JSONTokener;

public class StrategicAI {
    public static final ArrayList<Airship> SHIP_DESIGNS = new ArrayList();
    public static final ArrayList<Airship> BUILDING_DESIGNS = new ArrayList();
    public static final int NUM_TARGETS = 2;

    public static ArrayList<Airship> available(ArrayList<Airship> ships, Empire e, int minCost, int budget, boolean considerAffinity) {
        ArrayList<Airship> av = new ArrayList<Airship>();
        for (Airship a : ships) {
            a.constructionBonuses = e.bonuses();
            if (considerAffinity && !e.constructionAffinity.accept(e, a)) continue;
            if (!considerAffinity || e.constructionAffinity != ConstructionAffinity.SMALL_SHIPS || a.type == ShipType.BUILDING) {
                if (a.getCost() < minCost || a.getCost() > budget || !a.isBuildable(e.bonuses())) continue;
                av.add(a);
                continue;
            }
            if (!a.isBuildable(e.bonuses()) || a.getCost() > budget) continue;
            av.add(a);
        }
        if (av.isEmpty()) {
            for (Airship a : ships) {
                a.constructionBonuses = e.bonuses();
                if (!a.isBuildable(e.bonuses()) || a.getCost() > budget) continue;
                av.add(a);
            }
        }
        return av;
    }

    public static void tick(CampaignWorld w, WorldMap m, Empire e) {
        e.messages.clear();
        ArrayList<City> targets = StrategicAI.targets(w, m, e);
        ArrayList<City> cs = new ArrayList<City>(m.cities());
        Collections.shuffle(cs, AGame.ANIM_R);
        for (City c : cs) {
            Spy s;
            if (e.cities.contains(c)) continue;
            if (targets.contains(c)) {
                s = e.getSpyFor(c);
                if (s != null) continue;
                e.spies.add(new Spy(c));
                continue;
            }
            s = e.getSpyFor(c);
            if (s == null) continue;
            e.spies.remove(s);
        }
        boolean hasUndefendedCities = false;
        for (City c : e.cities) {
            hasUndefendedCities |= c.getDefences().isEmpty();
        }
        for (City c : e.cities) {
            StrategicAI.tick(w, m, e, c, hasUndefendedCities);
        }
        int fsz = e.fleets.size();
        for (int fi = 0; fi < fsz; ++fi) {
            Fleet f = e.fleets.get(fi);
            if (!StrategicAI.tick(w, m, e, f, targets)) continue;
            e.fleets.remove(fi);
            --fi;
            --fsz;
            f.broadcastDestroyed(m);
        }
        for (City c : targets) {
            StrategicAI.espionage(w, m, e, c);
        }
    }

    static void espionage(CampaignWorld w, WorldMap m, Empire e, City target) {
        Spy spy = e.getSpyFor(target);
        if (spy == null || spy.infiltrationTimeout > 0) {
            return;
        }
        if (AGame.ANIM_R.nextDouble() < 0.1 && target.alertAmount <= 0 && Spy.CitySpyAction.INCITE_REVOLT.available(spy, target, m) && Spy.CitySpyAction.INCITE_REVOLT.cost(spy, e, target, m) <= e.money && Spy.CitySpyAction.INCITE_REVOLT.successChance(spy, e, target, m) >= 30) {
            StrategicAI.doSpyAction(Spy.CitySpyAction.INCITE_REVOLT, spy, w, m, e, target);
            return;
        }
        boolean invading = false;
        for (Fleet fl : e.fleets) {
            if (fl.destination != target) continue;
            invading = true;
            break;
        }
        if (invading || AGame.ANIM_R.nextDouble() < 0.001) {
            for (Airship ship : target.getDefences()) {
                if (!(AGame.ANIM_R.nextDouble() < 0.25) || !Spy.ShipSpyAction.DESTROY.available(ship, spy, target, m) || Spy.ShipSpyAction.DESTROY.cost(ship, spy, e, target, m) > e.money || Spy.ShipSpyAction.DESTROY.successChance(ship, spy, e, target, m) <= 30) continue;
                StrategicAI.doSpyAction(Spy.ShipSpyAction.DESTROY, ship, spy, w, m, e, target);
                return;
            }
        }
        if (AGame.ANIM_R.nextDouble() < 0.001 && target.alertAmount <= 0 && Spy.CitySpyAction.SABOTAGE_PRODUCTION.available(spy, target, m) && Spy.CitySpyAction.SABOTAGE_PRODUCTION.cost(spy, e, target, m) <= e.money && target.constructionProgress > 100) {
            StrategicAI.doSpyAction(Spy.CitySpyAction.SABOTAGE_PRODUCTION, spy, w, m, e, target);
        }
    }

    static void doSpyAction(Spy.CitySpyAction a, Spy spy, CampaignWorld w, WorldMap m, Empire e, City target) {
        boolean abjectFailure;
        int chance;
        ++e.spyActionsDone;
        Empire victim = m.owner(target);
        e.money -= a.cost(spy, e, target, m);
        int roll = AGame.ANIM_R.nextInt(100);
        boolean success = roll < (chance = a.successChance(spy, e, target, m));
        boolean bl = abjectFailure = roll < chance * 2;
        if (success) {
            victim.messages.add(new Empire.Message(Empire.MessageType.SPY_ACTION, target, (String)a.success((Spy)spy, (City)target, (WorldMap)m).b));
            target.alertAmount += 15000;
        } else {
            String msg = (String)a.failure((Spy)spy, (City)target, (WorldMap)m).b;
            if (abjectFailure) {
                e.spies.remove(spy);
                target.alertAmount += 30000;
                victim.messages.add(new Empire.Message(Empire.MessageType.SPY_CAUGHT, target, msg));
            }
        }
    }

    static void doSpyAction(Spy.ShipSpyAction a, Airship ship, Spy spy, CampaignWorld w, WorldMap m, Empire e, City target) {
        boolean abjectFailure;
        int chance;
        ++e.spyActionsDone;
        Empire victim = m.owner(target);
        e.money -= a.cost(ship, spy, e, target, m);
        int roll = AGame.ANIM_R.nextInt(100);
        boolean success = roll < (chance = a.successChance(ship, spy, e, target, m));
        boolean bl = abjectFailure = roll * 2 < chance;
        if (success) {
            victim.messages.add(new Empire.Message(Empire.MessageType.SPY_ACTION, target, (String)a.success((Airship)ship, (Spy)spy, (City)target, (WorldMap)m).b));
        } else {
            String msg = (String)a.failure((Airship)ship, (Spy)spy, (City)target, (WorldMap)m).b;
            if (abjectFailure) {
                e.spies.remove(spy);
                victim.messages.add(new Empire.Message(Empire.MessageType.SPY_CAUGHT, target, msg));
                target.alertAmount += 30000;
            }
        }
    }

    static void tick(CampaignWorld w, WorldMap m, Empire e, City c, boolean hasUndefendedCities) {
        if (c.takeoverNeeded) {
            c.takeoverMethod = e.takeoverMethod;
            c.takeoverNeeded = false;
        }
        if (e.incomeBalance() <= 0) {
            return;
        }
        int budget = Math.max(c.income / 4, e.incomeBalance());
        if (c.constructionTarget != null && c.constructionTarget.getCost() > budget * 90) {
            c.constructionTarget = null;
        }
        if (c.constructionTarget == null) {
            boolean doBuilding;
            int localValue = 0;
            for (Airship b : c.getDefences()) {
                localValue += b.getCost();
            }
            Fleet gar = m.getGarrison(c);
            if (gar != null) {
                for (Airship s : gar.actives) {
                    localValue += s.getCost();
                }
                for (Airship s : gar.reserve) {
                    localValue += s.getCost();
                }
            }
            int minCost = c.getDefences().isEmpty() ? 0 : localValue / 3 * 2;
            int maxCost = c.getDefences().isEmpty() ? budget * 15 : Math.min(budget * 90, Math.max(minCost * 3, budget * 50));
            boolean bl = doBuilding = c.getDefences().isEmpty() ? true : w.r.nextBoolean();
            if (doBuilding) {
                ArrayList<Airship> bs = StrategicAI.available(BUILDING_DESIGNS, e, minCost, maxCost, true);
                if (bs.isEmpty()) {
                    bs = StrategicAI.available(BUILDING_DESIGNS, e, 0, 100000, false);
                }
                if (!bs.isEmpty()) {
                    Collections.shuffle(bs, w.r);
                    Airship b = bs.get(0).clone();
                    if (StrategicAI.positionDefense(b, c, m)) {
                        c.constructionTarget = b;
                    } else {
                        doBuilding = false;
                    }
                }
            }
            if (!doBuilding) {
                ArrayList<Airship> as = StrategicAI.available(SHIP_DESIGNS, e, minCost, maxCost, true);
                boolean tooManyLandships = false;
                if (gar != null) {
                    for (Airship ship : gar.reserve) {
                        if (ship.type != ShipType.LANDSHIP) continue;
                        tooManyLandships = true;
                        break;
                    }
                }
                if (tooManyLandships) {
                    Iterator<Airship> it = as.iterator();
                    while (it.hasNext()) {
                        if (it.next().type != ShipType.LANDSHIP) continue;
                        it.remove();
                    }
                }
                if (as.isEmpty()) {
                    as = StrategicAI.available(SHIP_DESIGNS, e, 0, 100000, false);
                }
                if (!as.isEmpty()) {
                    Collections.shuffle(as, w.r);
                    c.constructionTarget = as.get(0).clone();
                    c.constructionTarget.setFlipped(true);
                    c.constructionTarget.flipTo = true;
                    c.constructionTarget.initLegs(c.ground, c.floaters, c.shipList(m));
                }
            }
        }
        if (c.constructionTarget != null && c.constructing == null && c.constructionTarget.getCost() <= e.money && (!hasUndefendedCities || c.getDefences().isEmpty())) {
            c.constructing = c.constructionTarget;
            c.constructionCost = c.constructionTarget.getCost();
            e.money -= c.constructionTarget.getCost();
            c.constructionTarget = null;
            c.constructing.name = c.constructing.type.mobile ? AGame.getAIShipName() : AGame.getBuildingName();
            c.constructing.initLegs(c.ground, c.floaters, c.shipList(m));
        }
    }

    static ArrayList<City> targets(CampaignWorld w, WorldMap m, Empire e) {
        ArrayList<City> adj = new ArrayList<City>();
        ArrayList seaAdj = new ArrayList();
        ArrayList<City> nonAdj = new ArrayList<City>();
        for (City c : m.cities()) {
            if (e.cities.contains(c)) continue;
            ArrayList<City> l = nonAdj;
            for (City c2 : e.cities) {
                if (m.connected(c, c2)) {
                    l = seaAdj;
                }
                if (!m.connectedByLand(c, c2)) continue;
                l = adj;
                break;
            }
            switch (e.personality) {
                case CONQUEROR: {
                    l.add(c);
                    break;
                }
                case POLICE: {
                    if (m.owner((City)c).personality != Empire.Personality.CONQUEROR) break;
                    l.add(c);
                }
            }
        }
        Collections.sort(adj, new DistCmp(e));
        Collections.sort(seaAdj, new DistCmp(e));
        Collections.sort(nonAdj, new DistCmp(e));
        adj.addAll(seaAdj);
        adj.addAll(nonAdj);
        while (adj.size() > 2) {
            adj.remove(adj.size() - 1);
        }
        return adj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean tick(CampaignWorld w, WorldMap m, Empire e, Fleet f, ArrayList<City> targets) {
        if (f.fleeDestinationNeeded) {
            double bestDist = 0.0;
            City best = null;
            for (City c : e.cities) {
                if (!f.canTravelTo(c, m, e)) continue;
                double d = ((double)c.x - f.realX()) * ((double)c.x - f.realX()) + ((double)c.y - f.realY()) * ((double)c.y - f.realY());
                if (best != null && !(d < bestDist)) continue;
                best = c;
                bestDist = d;
            }
            if (best == null) return true;
            f.travelTo(best, m);
            f.fleeDestinationNeeded = false;
            return false;
        } else {
            if (f.location != null && w.map.owner(f.location) == e) {
                for (Airship toScrap : new ArrayList<Airship>(f.actives)) {
                    if (toScrap.isArmed()) continue;
                    f.actives.remove(toScrap);
                    e.money += toScrap.getCost() / 8;
                }
                for (Airship toScrap : new ArrayList<Airship>(f.reserve)) {
                    if (toScrap.isArmed()) continue;
                    f.reserve.remove(toScrap);
                    e.money += toScrap.getCost() / 8;
                }
                if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                    return true;
                }
            }
            boolean beingInvaded = false;
            if (f.location != null) {
                for (Empire enemy : m.empires) {
                    if (enemy == e) continue;
                    for (Fleet fl : e.fleets) {
                        if (fl.destination != f.location) continue;
                        return false;
                    }
                }
            }
            if (beingInvaded) return false;
            if (f.location == null) return false;
            if (f.location.getDefences().isEmpty()) return false;
            if (e.warConsiderDelay > 0) return false;
            int attackValue = 0;
            for (Airship s : f.actives) {
                attackValue += s.getCost();
            }
            for (Airship s : f.reserve) {
                attackValue += s.getCost();
            }
            double bestDist = 0.0;
            City best = null;
            for (City c : targets) {
                Spy spy = e.getSpyFor(c);
                if (spy == null || spy.infiltrationTimeout > 0) continue;
                Empire victim = m.owner(c);
                int defenceValue = 100;
                for (Airship b : c.getDefences()) {
                    defenceValue = (int)((double)defenceValue + (double)b.getCost() * 0.6);
                }
                for (Fleet df : victim.fleets) {
                    if (df.location != c) continue;
                    for (Airship s : df.actives) {
                        defenceValue += s.getCost();
                    }
                    for (Airship s : df.reserve) {
                        defenceValue += s.getCost();
                    }
                }
                if (c.constructing != null) {
                    defenceValue = (int)((double)defenceValue + (double)c.constructing.getCost() * (c.constructing.type == ShipType.BUILDING ? 0.6 : 1.0));
                }
                if ((double)defenceValue > (double)attackValue * e.aggressiveness) continue;
                double d = ((double)c.x - f.realX()) * ((double)c.x - f.realX()) + ((double)c.y - f.realY()) * ((double)c.y - f.realY());
                if (best != null && !(d < bestDist)) continue;
                best = c;
                bestDist = d;
            }
            if (best != null && f.canTravelTo(best, m, e)) {
                f.travelTo(best, m);
                e.warConsiderDelay = 10000 + AGame.ANIM_R.nextInt(40000);
                return false;
            }
            Fleet mergeTarget = null;
            int closest = 0;
            for (Fleet cand : e.fleets) {
                if (cand.location == null || cand == f) continue;
                int dist = (f.location.x - cand.location.x) * (f.location.x - cand.location.x) + (f.location.y - cand.location.y) * (f.location.y - cand.location.y);
                if (mergeTarget != null && dist >= closest) continue;
                mergeTarget = cand;
                closest = dist;
            }
            if (mergeTarget != null) {
                f.travelTo(mergeTarget.location, m);
            } else {
                boolean atFront = false;
                for (City t : targets) {
                    if (!m.connectedByLand(f.location, t)) continue;
                    atFront = true;
                    break;
                }
                if (!atFront) {
                    City front = null;
                    for (City c : e.cities) {
                        if (!m.connected(f.location, c)) continue;
                        for (City t : targets) {
                            if (!m.connectedByLand(c, t)) continue;
                            front = c;
                        }
                    }
                    if (front != null) {
                        f.travelTo(front, m);
                        return false;
                    }
                }
            }
            ArrayList<Airship> airships = new ArrayList<Airship>();
            attackValue = 0;
            for (Airship ship : f.actives) {
                if (ship.type != ShipType.AIRSHIP) continue;
                airships.add(ship);
                attackValue += ship.getCost();
            }
            for (Airship ship : f.reserve) {
                if (ship.type != ShipType.AIRSHIP) continue;
                airships.add(ship);
                attackValue += ship.getCost();
            }
            if (attackValue == 0) return false;
            if (airships.size() == f.actives.size() + f.reserve.size()) {
                return false;
            }
            bestDist = 0.0;
            best = null;
            for (City c : targets) {
                Spy spy = e.getSpyFor(c);
                if (spy == null || spy.infiltrationTimeout > 0) continue;
                Empire victim = m.owner(c);
                int defenceValue = 100;
                for (Airship b : c.getDefences()) {
                    defenceValue = (int)((double)defenceValue + (double)b.getCost() * 0.6);
                }
                for (Fleet df : victim.fleets) {
                    if (df.location != c) continue;
                    for (Airship s : df.actives) {
                        defenceValue += s.getCost();
                    }
                    for (Airship s : df.reserve) {
                        defenceValue += s.getCost();
                    }
                }
                if (c.constructing != null) {
                    defenceValue = (int)((double)defenceValue + (double)c.constructing.getCost() * (c.constructing.type == ShipType.BUILDING ? 0.6 : 1.0));
                }
                if ((double)defenceValue > (double)attackValue * e.aggressiveness) continue;
                double d = ((double)c.x - f.realX()) * ((double)c.x - f.realX()) + ((double)c.y - f.realY()) * ((double)c.y - f.realY());
                if (best != null && !(d < bestDist)) continue;
                best = c;
                bestDist = d;
            }
            if (best == null) return false;
            Fleet f2 = new Fleet(f);
            e.fleets.add(f);
            f.actives.removeAll(airships);
            f.reserve.removeAll(airships);
            f2.actives.retainAll(airships);
            f2.reserve.retainAll(airships);
            f2.travelTo(best, m);
        }
        return false;
    }

    public static void setup(WorldMap m, Empire e, Random r, boolean guaranteeOneShip, boolean addShips) {
        int cost = 0;
        for (City c : e.cities) {
            cost += StrategicAI.setup(m, e, c, r, guaranteeOneShip, addShips);
        }
        e.money -= cost;
    }

    static int setup(WorldMap m, Empire e, City c, Random r, boolean guaranteeShip, boolean addMoreShips) {
        ArrayList<Airship> bs;
        int budget = e.money / e.cities.size();
        ArrayList<Airship> as = StrategicAI.available(SHIP_DESIGNS, e, 0, budget, true);
        if (as.isEmpty()) {
            as = StrategicAI.available(SHIP_DESIGNS, e, 0, budget, false);
        }
        if (guaranteeShip && !as.isEmpty()) {
            Collections.sort(as, new MostExpensiveCmp());
            Collections.shuffle(as.subList(0, Math.min(as.size(), 2)), r);
            Airship def = as.get(0).clone();
            def.repair();
            def.setFlipped(true);
            def.name = Airship.getRandomName(ShipType.AIRSHIP);
            e.addShipAt(def, c);
            budget -= def.getCost();
            def.initLegs(c.ground, c.floaters, c.shipList(m));
        }
        for (int i = 0; i < 20 && !(bs = StrategicAI.available(BUILDING_DESIGNS, e, 0, budget, true)).isEmpty(); ++i) {
            Collections.sort(bs, new MostExpensiveCmp());
            Collections.shuffle(bs.subList(0, Math.min(bs.size(), 2)), r);
            Airship def = bs.get(0).clone();
            def.repair();
            def.name = AGame.getBuildingName();
            if (StrategicAI.positionDefense(def, c, m)) {
                c.addDefence(def);
                budget -= def.getCost();
            }
            if (!addMoreShips || !r.nextBoolean()) continue;
            as = StrategicAI.available(SHIP_DESIGNS, e, 0, budget, true);
            if (as.isEmpty()) break;
            Collections.sort(as, new MostExpensiveCmp());
            Collections.shuffle(as.subList(0, Math.min(as.size(), 2)), r);
            def = as.get(0).clone();
            def.repair();
            def.setFlipped(true);
            def.name = Airship.getRandomName(ShipType.AIRSHIP);
            e.addShipAt(def, c);
            def.initLegs(c.ground, c.floaters, c.shipList(m));
            budget -= def.getCost();
        }
        return e.money / e.cities.size() - budget;
    }

    static boolean positionDefense(Airship building, City c, WorldMap wm) {
        int startX;
        int x = startX = 112;
        while ((double)x < 1600.0 - building.getBBWidth()) {
            int y = c.ground.getVerticalPosition(building, x, false);
            if (c.ground.isFullySupported(building, x) && c.canPlace(building, x, y, 32, wm.getGarrison(c))) {
                building.setX(x);
                building.setY(y + 1);
                return true;
            }
            x += 32;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        for (ShipType st : ShipType.values()) {
            File shipDir = new File(new File(AGame.getStaticGameDirectory(), "data"), st.dirName);
            for (File f : shipDir.listFiles()) {
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(f));
                    (st.mobile ? SHIP_DESIGNS : BUILDING_DESIGNS).add(new Airship(new JSONObject(new JSONTokener(r))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        r.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private static class MostExpensiveCmp
    implements Comparator<Airship> {
        private MostExpensiveCmp() {
        }

        @Override
        public int compare(Airship o1, Airship o2) {
            return o2.getCost() - o1.getCost();
        }
    }

    static class DistCmp
    implements Comparator<City> {
        public final Empire e;

        public DistCmp(Empire e) {
            this.e = e;
        }

        public int distSq(City c) {
            int d = 0x3FFFFFFD;
            for (City c2 : this.e.cities) {
                d = Math.min(d, (c.x - c2.x) * (c.x - c2.x) + (c.y - c2.y) * (c.y - c2.y));
            }
            return d;
        }

        @Override
        public int compare(City o1, City o2) {
            return this.distSq(o1) - this.distSq(o2);
        }
    }
}

