/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AffordableFilter;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.CampaignCombatSetupIntent;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.DateInfo;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.DesignFromStrategicIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.JSONFileBackend;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LightHaloLayer;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Perlin;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.RefitFromStrategicIntent;
import com.zarkonnen.airships.Road;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SecretPoliceLevel;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.TexGen;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.ImageBuffer;

public class StrategicScreen
implements Screen {
    public static final Clr ROT = Clr.fromHex((String)"74595233");
    public static final Clr PARCHMENT = Clr.fromHex((String)"e7e0a9");
    public static final Clr PARCHMENT_OVER = Clr.fromHex((String)"e7e0a966");
    public static final Clr INK_TINT = Clr.fromHex((String)"745952").mix(0.3, PARCHMENT);
    public static final Clr INK = Clr.fromHex((String)"7d673e");
    public static final Clr DARK_INK = Clr.fromHex((String)"7d673e");
    public static final Clr DARKER_INK = Clr.fromHex((String)"7d673e");
    public static final Clr RED_INK = Clr.fromHex((String)"7d673e").mix(0.7, Clr.RED);
    public static final Clr DARK_RED_INK = Clr.fromHex((String)"7d673e").mix(0.25, Clr.RED);
    public static final String DARK_RED_INK_TINT = DARK_RED_INK.toString();
    public static final Clr DARK_GREEN_INK = Clr.fromHex((String)"7d673e").mix(0.15, Clr.GREEN);
    public static final String DARK_GREEN_INK_TINT = DARK_GREEN_INK.toString();
    public static final int MAP_TILE_SIZE = 256;
    private final Img[] mountains = new Img[5];
    private final Img[] trees = new Img[6];
    private final Img[] swamps = new Img[4];
    private final Img[] sea_creatures = new Img[7];
    private final Img[] cities = new Img[10];
    private final Img[] mountains_bg = new Img[5];
    private final Img[] trees_bg = new Img[6];
    private final Img[] sea_creatures_bg = new Img[7];
    private final Img[] cities_bg = new Img[10];
    private final Appearance airfleet = new Appearance(10, 30, 2, 2);
    private final Appearance airfleetOutline = new Appearance(12, 30, 2, 2);
    private final Appearance landfleet = new Appearance(14, 30, 2, 2);
    private final Appearance landfleetOutline = new Appearance(16, 30, 2, 2);
    private final Appearance mixedfleet = new Appearance(18, 30, 2, 2);
    private final Appearance mixedfleetOutline = new Appearance(20, 30, 2, 2);
    private final Appearance convoy = new Appearance(22, 30, 2, 2);
    private final Appearance convoyOutline = new Appearance(24, 30, 2, 2);
    private final Appearance escortedConvoy = new Appearance(26, 30, 2, 2);
    private final Appearance escortedConvoyOutline = new Appearance(28, 30, 2, 2);
    private final Img fight = new Img("spritesheet", 64, 512, 16, 16, false);
    private final Img shipLoss = new Img("spritesheet", 80, 512, 16, 16, false);
    private final Appearance victoryUnderlay = new Appearance().frame(0, 32, 2, 2);
    private final Appearance defeatOverlay = new Appearance().frame(2, 32, 2, 2);
    private int endGameCounter = 0;
    public boolean debug = AGame.isDebug();
    public AirshipGame g;
    public CampaignWorld w;
    private Image[][] mapTiles;
    private City hoverCity;
    private City nextHoverCity;
    public City menuCity;
    private Fleet hoverFleet;
    private Fleet nextHoverFleet;
    private Fleet selectedFleet;
    private boolean showEmpireDetails = false;
    private ArrayList<Airship> fleetSelection = new ArrayList();
    private final ScrollBar fleetScrollBar = new ScrollBar();
    private boolean menu;
    private CampaignWorld.Speed lastSpeed = CampaignWorld.Speed.NORMAL;
    private Airship askForScrap = null;
    private City highlitTravelConnection;
    private int highlitTravelConnectionTime = 10;
    private static final BackdropType[] STAINS = new BackdropType[]{new BackdropType(new Img("stains", 10, 11, 279, 167, false), false), new BackdropType(new Img("stains", 324, 0, 205, 202, false), false), new BackdropType(new Img("stains", 0, 200, 318, 321, false), false), new BackdropType(new Img("stains", 337, 220, 292, 290, false), false), new BackdropType(new Img("stains", 60, 577, 96, 99, false), false), new BackdropType(new Img("stains", 255, 594, 102, 88, false), false), new BackdropType(new Img("stains", 465, 528, 224, 215, false), false), new BackdropType(new Img("stains", 22, 697, 204, 209, false), false), new BackdropType(new Img("stains", 797, 192, 124, 114, false), false)};
    private static final BackdropType[] BACKDROPS = new BackdropType[]{new BackdropType(new Img("p_dove.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_wyrm.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_report.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_spy.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("p_listing.jpg", 0, 0, 843, 1024, false), true), new BackdropType(new Img("notes.jpg", 114, 4, 292, 73, false), true), new BackdropType(new Img("notes.jpg", 396, 4, 153, 73, false), true), new BackdropType(new Img("notes.jpg", 530, 2, 152, 70, false), true), new BackdropType(new Img("notes.jpg", 86, 79, 215, 59, false), true), new BackdropType(new Img("notes.jpg", 425, 79, 121, 61, false), true), new BackdropType(new Img("notes.jpg", 540, 82, 116, 54, false), true), new BackdropType(new Img("notes.jpg", 329, 149, 116, 54, false), true), new BackdropType(new Img("notes.jpg", 438, 150, 116, 54, false), true), new BackdropType(new Img("notes.jpg", 118, 151, 225, 54, false), true), new BackdropType(new Img("notes.jpg", 80, 223, 225, 54, false), true), new BackdropType(new Img("notes.jpg", 280, 221, 225, 54, false), true), new BackdropType(new Img("notes.jpg", 250, 291, 265, 57, false), true), new BackdropType(new Img("notes.jpg", 127, 352, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 429, 350, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 124, 412, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 100, 663, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 112, 728, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 101, 796, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 382, 805, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 384, 724, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 394, 667, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 115, 469, 288, 96, false), true), new BackdropType(new Img("notes.jpg", 371, 488, 288, 57, false), true), new BackdropType(new Img("notes.jpg", 507, 571, 155, 41, false), true), new BackdropType(new Img("notes.jpg", 104, 286, 155, 41, false), true), new BackdropType(new Img("notes.jpg", 561, 408, 155, 83, false), true), new BackdropType(new Img("notes.jpg", 411, 404, 155, 83, false), true), new BackdropType(new Img("notes.jpg", 123, 575, 177, 83, false), true), new BackdropType(new Img("notes.jpg", 339, 575, 177, 83, false), true)};
    private final ArrayList<Backdrop> backdrops = new ArrayList();
    public CampaignWorld.CombatOutcomeType combatOutcome;
    int time = 0;
    int scrollX = 0;
    int scrollY = 0;
    public static final Image MAP_BG = LightHaloLayer.loadImage("map_bg.jpg");
    private final FleetElementAdapter fea = new FleetElementAdapter();
    public static final Clr MAP_SHADOW = new Clr(0, 0, 0, 30);

    public StrategicScreen(AirshipGame g, CampaignWorld w) {
        int i;
        this.g = g;
        this.w = w;
        for (i = 0; i < 5; ++i) {
            this.mountains[i] = new Img("spritesheet", i * 16, 464, 16, 16, false);
            this.mountains_bg[i] = new Img("spritesheet", i * 16, 432, 16, 16, false);
        }
        for (i = 0; i < 6; ++i) {
            this.trees[i] = new Img("spritesheet", 80 + i * 16, 464, 16, 16, false);
            this.trees_bg[i] = new Img("spritesheet", 80 + i * 16, 432, 16, 16, false);
        }
        for (i = 0; i < 4; ++i) {
            this.swamps[i] = new Img("spritesheet", 192 + i * 16, 464, 16, 16, false);
        }
        for (i = 0; i < 7; ++i) {
            this.sea_creatures[i] = new Img("spritesheet", 256 + i * 16, 464, 16, 16, false);
            this.sea_creatures_bg[i] = new Img("spritesheet", 256 + i * 16, 432, 16, 16, false);
        }
        for (i = 0; i < 10; ++i) {
            this.cities[i] = new Img("spritesheet", i * 16, 480, 16, 16, false);
            this.cities_bg[i] = new Img("spritesheet", i * 16, 448, 16, 16, false);
        }
        if (this.menuCity == null && w != null) {
            this.menuCity = w.player.cities.get(0);
        }
        this.updateBackgrounds();
    }

    private void updateBackgrounds() {
        if (this.w == null) {
            return;
        }
        this.backdrops.clear();
        int nBackdrops = this.w.map.empires.size() / 4 + 5;
        ArrayList<BackdropType> stains = new ArrayList<BackdropType>(Arrays.asList(STAINS));
        Collections.shuffle(stains, AGame.ANIM_R);
        ArrayList<BackdropType> backs = new ArrayList<BackdropType>(Arrays.asList(BACKDROPS));
        Collections.shuffle(backs, AGame.ANIM_R);
        ArrayList<BackdropType> cands = new ArrayList<BackdropType>();
        cands.addAll(stains.subList(0, Math.min(nBackdrops / 2, stains.size())));
        cands.addAll(backs);
        block6: for (int i = 0; i < nBackdrops; ++i) {
            switch (AGame.ANIM_R.nextInt(4)) {
                case 0: {
                    this.backdrops.add(new Backdrop((BackdropType)cands.get(i), -300 + AGame.ANIM_R.nextInt(this.w.map.water[0].length + 400 - ((BackdropType)cands.get((int)i)).img.srcWidth), -300 + AGame.ANIM_R.nextInt(200), -0.2 + 0.4 * AGame.ANIM_R.nextDouble()));
                    continue block6;
                }
                case 1: {
                    this.backdrops.add(new Backdrop((BackdropType)cands.get(i), -300 + AGame.ANIM_R.nextInt(200), -300 + AGame.ANIM_R.nextInt(this.w.map.water.length + 600 - ((BackdropType)cands.get((int)i)).img.srcHeight), -0.2 + 0.4 * AGame.ANIM_R.nextDouble()));
                    continue block6;
                }
                case 2: {
                    this.backdrops.add(new Backdrop((BackdropType)cands.get(i), this.w.map.water[0].length - 200 + AGame.ANIM_R.nextInt(300), -300 + AGame.ANIM_R.nextInt(this.w.map.water.length + 600 - ((BackdropType)cands.get((int)i)).img.srcHeight), -0.2 + 0.4 * AGame.ANIM_R.nextDouble()));
                    continue block6;
                }
                case 3: {
                    this.backdrops.add(new Backdrop((BackdropType)cands.get(i), -300 + AGame.ANIM_R.nextInt(this.w.map.water[0].length + 600 - ((BackdropType)cands.get((int)i)).img.srcWidth), this.w.map.water.length - 200 + AGame.ANIM_R.nextInt(300), -0.2 + 0.4 * AGame.ANIM_R.nextDouble()));
                }
            }
        }
    }

    public void postCombat() {
        this.combatOutcome = this.w.postCombat();
    }

    public boolean modalUp() {
        for (City c : this.w.player.cities) {
            if (!c.takeoverNeeded) continue;
            return true;
        }
        for (Fleet fl : this.w.player.fleets) {
            if (!fl.fleeDestinationNeeded) continue;
            if (this.selectedFleet == null) {
                this.selectedFleet = fl;
                this.fleetSelection = new ArrayList<Airship>(fl.actives);
                this.fleetSelection.addAll(fl.reserve);
            }
            return true;
        }
        return false;
    }

    private void doScrap() {
        this.w.player.scrap(this.askForScrap, this.w.map);
        this.askForScrap = null;
        if (this.selectedFleet != null && this.selectedFleet.actives.isEmpty() && this.selectedFleet.reserve.isEmpty()) {
            this.selectedFleet = null;
        }
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        ScreenMode sm;
        if (this.time == 0) {
            sm = in.mode();
            this.scrollX = -this.w.player.cities.get((int)0).x + sm.width / 2;
            this.scrollY = -this.w.player.cities.get((int)0).y + sm.height / 2;
        }
        if (this.w.combatInfo != null) {
            UniScreen us = new UniScreen(this.g, new CampaignCombatSetupIntent(this, this.w.combatInfo));
            us.combat = this.w.combatInfo.combat;
            us.mySide = this.w.combatInfo.combat.sides.get(this.w.combatInfo.playerCombatSideIndex);
            this.g.s = us;
            return;
        }
        this.time += ms;
        if (this.highlitTravelConnectionTime++ > 2) {
            this.highlitTravelConnection = null;
        }
        sm = in.mode();
        if (this.selectedFleet != null) {
            this.fleetScrollBar.tick(in, sm.width - 190 + 12, 55, 166, sm.height - 23 - 24);
        }
        if (this.w.victory() || this.w.defeat()) {
            this.endGameCounter += ms;
            if (click != null && drawState.canClick() && this.endGameCounter > 300) {
                drawState.hasClicked();
                this.g.s = new MainMenu(this.g);
            }
            return;
        }
        if (this.combatOutcome != null) {
            if (click != null) {
                this.combatOutcome = null;
            }
            return;
        }
        if (this.askForScrap != null) {
            if (in.keyPressed("ENTER") && drawState.canClick()) {
                this.doScrap();
                drawState.hasClicked();
            }
            if (in.keyPressed("ESCAPE") && drawState.canClick()) {
                this.askForScrap = null;
                drawState.hasClicked();
            }
            return;
        }
        if (this.selectedFleet == null || !this.selectedFleet.fleeDestinationNeeded) {
            for (Fleet fl : this.w.player.fleets) {
                if (!fl.fleeDestinationNeeded) continue;
                this.selectedFleet = fl;
                this.fleetSelection = new ArrayList<Airship>(fl.actives);
                this.fleetSelection.addAll(fl.reserve);
                this.menuCity = null;
            }
        }
        if (this.selectedFleet != null && !this.w.player.fleets.contains(this.selectedFleet)) {
            Fleet oldF = this.selectedFleet;
            this.selectedFleet = null;
            for (Fleet fl : this.w.player.fleets) {
                if (!fl.containsAny(oldF)) continue;
                this.selectedFleet = fl;
                ArrayList<Airship> both = new ArrayList<Airship>(fl.actives);
                both.addAll(fl.reserve);
                this.fleetSelection.retainAll(both);
                break;
            }
        }
        if (in.keyDown("UP") || cursor.y < 2.0) {
            this.scrollY += AirshipGame.scrollSpeed;
        }
        if (in.keyDown("DOWN") || cursor.y > (double)(in.mode().height - 2)) {
            this.scrollY -= AirshipGame.scrollSpeed;
        }
        if (in.keyDown("LEFT") || cursor.x < 2.0) {
            this.scrollX += AirshipGame.scrollSpeed;
        }
        if (in.keyDown("RIGHT") || cursor.x > (double)(in.mode().width - 2)) {
            this.scrollX -= AirshipGame.scrollSpeed;
        }
        if (this.scrollX < sm.width - this.w.map.water[0].length - 300) {
            this.scrollX = sm.width - this.w.map.water[0].length - 300;
        }
        if (this.scrollX > 300) {
            this.scrollX = 300;
        }
        if (this.scrollY < sm.height - this.w.map.water.length - 300) {
            this.scrollY = sm.height - this.w.map.water.length - 300;
        }
        if (this.scrollY > 300) {
            this.scrollY = 300;
        }
        if (!this.menu && in.keyPressed("M") && drawState.canClick()) {
            this.menu = true;
            drawState.hasClicked();
        }
        if (!this.menu && !this.showEmpireDetails && in.keyPressed("ESCAPE") && drawState.canClick()) {
            this.menu = true;
            drawState.hasClicked();
        }
        if (this.menu && drawState.canClick()) {
            if (in.keyPressed("Q")) {
                this.g.s = new MainMenu(this.g);
                drawState.hasClicked();
                return;
            }
            if (in.keyPressed("O")) {
                drawState.hasClicked();
                this.open(false);
                return;
            }
            if (in.keyPressed("S")) {
                drawState.hasClicked();
                this.save();
                return;
            }
            if (in.keyPressed("B") || in.keyPressed("ESCAPE")) {
                this.menu = false;
                drawState.hasClicked();
            }
        }
        if (!this.menu && !this.w.player.messages.isEmpty()) {
            if (in.keyPressed("ENTER") || in.keyPressed("ESCAPE")) {
                this.w.player.messages.remove(this.w.player.messages.size() - 1);
            }
            return;
        }
        if (!this.menu && in.keyPressed("SPACE") && drawState.canClick()) {
            if (this.w.speed == CampaignWorld.Speed.STOP) {
                this.w.speed = this.lastSpeed;
                if (this.w.speed == CampaignWorld.Speed.STOP) {
                    this.w.speed = CampaignWorld.Speed.NORMAL;
                }
            } else {
                this.lastSpeed = this.w.speed;
                this.w.speed = CampaignWorld.Speed.STOP;
            }
            drawState.hasClicked();
        }
        if (!this.menu && this.selectedFleet != null && in.keyPressed("C") && drawState.canClick()) {
            this.selectedFleet = null;
            drawState.hasClicked();
        }
        if (!this.menu && !this.showEmpireDetails && in.keyPressed("E")) {
            this.showEmpireDetails = true;
        }
        if (!this.menu && this.showEmpireDetails && (in.keyPressed("ESCAPE") || in.keyPressed("ENTER"))) {
            this.showEmpireDetails = false;
        }
        if (!this.menu && this.menuCity != null) {
            if (this.w.player.cities.contains(this.menuCity) && this.menuCity.canBuild()) {
                if (in.keyPressed("C") && drawState.canClick() && this.menuCity.constructing == null) {
                    drawState.hasClicked();
                    this.createShip(ShipType.AIRSHIP);
                }
                if (in.keyPressed("B") && drawState.canClick() && this.menuCity.constructing == null) {
                    drawState.hasClicked();
                    this.buildSavedShip(ShipType.AIRSHIP);
                }
                if (in.keyPressed("A") && drawState.canClick() && this.menuCity.constructing == null) {
                    drawState.hasClicked();
                    this.createShip(ShipType.LANDSHIP);
                }
                if (in.keyPressed("L") && drawState.canClick() && this.menuCity.constructing == null) {
                    drawState.hasClicked();
                    this.buildSavedShip(ShipType.LANDSHIP);
                }
                if (in.keyPressed("C") && drawState.canClick() && this.menuCity.constructing != null) {
                    drawState.hasClicked();
                    this.cancelShip();
                }
                if (in.keyPressed("D") && drawState.canClick()) {
                    drawState.hasClicked();
                    this.defenses();
                }
            } else {
                Spy spy = this.w.player.getSpyFor(this.menuCity);
                if (in.keyPressed("S") && drawState.canClick()) {
                    if (spy == null) {
                        if (this.w.player.money >= 100) {
                            this.w.player.spies.add(new Spy(this.menuCity));
                            this.w.player.money -= 100;
                            this.menuCity = null;
                        }
                    } else {
                        this.w.player.spies.remove(spy);
                        this.menuCity = null;
                    }
                }
                if (in.keyPressed("V") && drawState.canClick() && spy != null) {
                    UniScreen us = new UniScreen(this.g, new EspionageIntent(this));
                    us.wm = this.w.map;
                    us.city = this.menuCity;
                    this.g.s = us;
                    this.menuCity = null;
                    return;
                }
            }
        }
        if (!(this.menu || this.modalUp() || this.showEmpireDetails)) {
            this.w.tick(ms);
        }
        this.hoverCity = this.nextHoverCity;
        this.nextHoverCity = null;
        this.hoverFleet = this.nextHoverFleet;
        this.nextHoverFleet = null;
    }

    private void renderMapTiles() {
        Perlin p = new Perlin(AGame.ANIM_R);
        this.mapTiles = new Image[this.w.map.water.length / 256][this.w.map.water[0].length / 256];
        for (int ty = 0; ty < this.w.map.water.length / 256; ++ty) {
            for (int tx = 0; tx < this.w.map.water[0].length / 256; ++tx) {
                this.renderMapTile(tx, ty, p);
            }
        }
    }

    private void renderMapTile(int tx, int ty, Perlin p) {
        HashMap<Integer, Empire> idToOwner = new HashMap<Integer, Empire>();
        for (Empire e : this.w.map.empires) {
            for (City c : e.cities) {
                idToOwner.put(c.id, e);
            }
        }
        ImageBuffer ib = new ImageBuffer(256, 256);
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256; ++x) {
                Empire owner;
                int my = ty * 256 + y;
                int mx = tx * 256 + x;
                boolean water = false;
                boolean land = false;
                int penW = (int)(1.9 + 1.8 * p.pnoise((double)mx * 0.05, (double)my * 0.05, 0.0));
                for (int dy = -1; dy <= penW; ++dy) {
                    for (int dx = -1; dx <= penW; ++dx) {
                        try {
                            water |= this.w.map.water[my + dy][mx + dx];
                            land |= !this.w.map.water[my + dy][mx + dx];
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                boolean edge = mx <= penW + 2 || mx >= this.w.map.water[0].length - penW - 2 || my <= penW + 2 || my >= this.w.map.water.length - penW - 2;
                Color c = MAP_BG.getColor(tx % 4 * 256 + x, ty % 4 * 256 + y);
                if (this.w.map.cityOwnership[my][mx] != -1 && (owner = (Empire)idToOwner.get(this.w.map.cityOwnership[my][mx])) != null) {
                    CoatOfArms.Tincture t0 = owner.getMainTincture();
                    if (this.w.map.border[my][mx]) {
                        if (idToOwner.get(this.w.map.borderingCityID[my][mx]) == owner) {
                            c = new Color(t0.tint.r / 6 + c.getRed() * 4 / 6 + StrategicScreen.INK_TINT.r / 6, t0.tint.g / 6 + c.getGreen() * 4 / 6 + StrategicScreen.INK_TINT.g / 6, t0.tint.b / 6 + c.getBlue() * 4 / 6 + StrategicScreen.INK_TINT.b / 6);
                        }
                    } else {
                        c = new Color(t0.tint.r / 6 + c.getRed() * 5 / 6, t0.tint.g / 6 + c.getGreen() * 5 / 6, t0.tint.b / 6 + c.getBlue() * 5 / 6);
                    }
                }
                if (!this.w.map.seaRouteBorder[my][mx] && (this.w.map.roadMap[my][mx] || edge || land && water || (10000 + mx * 4 - my * 3 + penW * 4) / 7 % 5 == 0 && this.w.map.water[my][mx])) {
                    ib.setRGBA(x, y, StrategicScreen.INK_TINT.r * c.getRed() / 256, StrategicScreen.INK_TINT.g * c.getGreen() / 256, StrategicScreen.INK_TINT.b * c.getBlue() / 256, 255);
                } else {
                    ib.setRGBA(x, y, c.getRed(), c.getGreen(), c.getBlue(), 255);
                }
                if (mx != 0 && my != 0 && mx != this.w.map.water[0].length - 1 && my != this.w.map.water.length - 1 || !(p.pnoise((double)mx * 0.02, (double)my * 0.02, 5.0) > 0.0)) continue;
                ib.setRGBA(x, y, 0, 0, 0, 0);
            }
        }
        this.mapTiles[ty][tx] = ib.getImage();
    }

    private void renderFleetList(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int width = 190;
        int y = 43;
        int x = sm.width - width;
        d.drawRightSideWindow(sm, x, y);
        int height = sm.height - y - 24;
        d.hook(x += 12, y += 12, width -= 24, height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN}){

            public void run(Input in, Pt p, Hook.Type type) {
            }
        });
        this.fleetScrollBar.draw(d, x, y, width, height, this.selectedFleet.getAllShips(), this.fea);
    }

    private void refitShip(City c, Airship original) {
        UniScreen us = new UniScreen(this.g, new RefitFromStrategicIntent(this, original, c));
        us.standaloneEditShip = original.clone();
        this.g.s = us;
    }

    private void doIntercept(Fleet target) {
        if (this.fleetSelection.containsAll(this.selectedFleet.actives) && this.fleetSelection.containsAll(this.selectedFleet.reserve)) {
            if (this.selectedFleet.doIntercept(target, this.w.map)) {
                this.selectedFleet.broadcastChangedDirection(this.w.map);
            }
        } else {
            Fleet f = new Fleet(this.selectedFleet);
            f.actives.retainAll(this.fleetSelection);
            f.reserve.retainAll(this.fleetSelection);
            if (f.doIntercept(target, this.w.map)) {
                this.w.player.fleets.add(f);
                this.selectedFleet.actives.removeAll(this.fleetSelection);
                this.selectedFleet.reserve.removeAll(this.fleetSelection);
                if (this.selectedFleet.actives.isEmpty() && this.selectedFleet.reserve.isEmpty()) {
                    this.w.player.fleets.remove(this.selectedFleet);
                    this.selectedFleet.broadcastDestroyed(this.w.map);
                } else if (this.selectedFleet.location != null && this.w.map.owner(this.selectedFleet.location) == this.w.player) {
                    this.selectedFleet.location.layoutGarrison(this.selectedFleet);
                }
                this.selectedFleet = f;
                this.selectedFleet.broadcastChangedDirection(this.w.map);
            }
        }
    }

    private boolean canTravelTo(City destination) {
        if (this.selectedFleet == null || this.fleetSelection.isEmpty()) {
            return false;
        }
        boolean selectionCanFly = true;
        for (Airship ship : this.fleetSelection) {
            if (!ship.type.onGround) continue;
            selectionCanFly = false;
            break;
        }
        if (selectionCanFly) {
            return true;
        }
        return this.selectedFleet.canTravelTo(destination, this.w.map, this.w.player);
    }

    private void travelTo(City destination) {
        if (this.selectedFleet == null || this.fleetSelection.isEmpty()) {
            return;
        }
        boolean selectionCanFly = true;
        for (Airship ship : this.fleetSelection) {
            if (!ship.type.onGround) continue;
            selectionCanFly = false;
            break;
        }
        for (Fleet f : this.w.player.fleets) {
            if (selectionCanFly != f.canFly() || f == this.selectedFleet || f.destination != destination || f.realX() != this.selectedFleet.realX() || f.realY() != this.selectedFleet.realY()) continue;
            f.reserve.addAll(this.fleetSelection);
            this.selectedFleet.actives.removeAll(this.fleetSelection);
            this.selectedFleet.reserve.removeAll(this.fleetSelection);
            if (this.selectedFleet.actives.isEmpty() && this.selectedFleet.reserve.isEmpty()) {
                this.w.player.fleets.remove(this.selectedFleet);
                this.selectedFleet.broadcastDestroyed(this.w.map);
            }
            this.selectedFleet = f;
            return;
        }
        if (this.fleetSelection.containsAll(this.selectedFleet.actives) && this.fleetSelection.containsAll(this.selectedFleet.reserve) && this.selectedFleet.canTravelTo(destination, this.w.map, this.w.player)) {
            this.selectedFleet.travelTo(destination, this.w.map);
            this.selectedFleet.fleeDestinationNeeded = false;
        } else {
            Fleet f = new Fleet(this.selectedFleet);
            f.actives.retainAll(this.fleetSelection);
            f.reserve.retainAll(this.fleetSelection);
            if (!f.canTravelTo(destination, this.w.map, this.w.player)) {
                return;
            }
            this.w.player.fleets.add(f);
            this.selectedFleet.actives.removeAll(this.fleetSelection);
            this.selectedFleet.reserve.removeAll(this.fleetSelection);
            if (this.selectedFleet.actives.isEmpty() && this.selectedFleet.reserve.isEmpty()) {
                this.w.player.fleets.remove(this.selectedFleet);
                this.selectedFleet.broadcastDestroyed(this.w.map);
            } else if (this.selectedFleet.location != null && this.w.map.owner(this.selectedFleet.location) == this.w.player) {
                this.selectedFleet.location.layoutGarrison(this.selectedFleet);
            }
            this.selectedFleet = f;
            f.travelTo(destination, this.w.map);
        }
        this.selectedFleet = null;
    }

    private void renderMenu(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int width = 174;
        int height = 129;
        int x = sm.width / 2 - width / 2;
        int y = sm.height / 2 - height / 2;
        d.drawShadowedWindow(x, y, width, height);
        d.button(x += 12, y += 12, width -= 24, Lang._t("Save", new Object[0]), "S", new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.save();
            }
        });
        d.button(x, y += 27, width, Lang._t("Open", new Object[0]), "O", new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.open(false);
            }
        });
        d.button(x, y += 27, width, Lang._t("Quit", new Object[0]), "Q", new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.g.s = new MainMenu(StrategicScreen.this.g);
            }
        });
        d.button(x, y += 27, width, Lang._t("Back_to_game", new Object[0]), "B", new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.menu = false;
            }
        });
    }

    private void renderCityTakeoverOptions(MyDraw d, final City c) {
        int x = this.scrollX + c.x - 100;
        int y = this.scrollY + c.y - 16 - 20 - 5;
        int h = 27 * TakeoverMethod.values().length - 3 + 12;
        d.drawShadowedPanel(x, y - h, 212, h);
        y = y - h + 6;
        x += 6;
        for (final TakeoverMethod tom : TakeoverMethod.values()) {
            d.button(x, y, 200, tom.getName(), new Runnable(){

                @Override
                public void run() {
                    c.takeoverMethod = tom;
                    c.takeoverNeeded = false;
                }
            });
            d.tooltip(x, y, 200.0, 24.0, tom.getTooltip());
            y += 27;
        }
    }

    private void renderCityMoveMenu(final City c, MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int x = this.scrollX + c.x - 16;
        int y = this.scrollY + c.y + 25;
        int width = 200;
        if (this.selectedFleet.location != c && !this.fleetSelection.isEmpty() && this.canTravelTo(c)) {
            d.rect(MyDraw.WIN_SHADOW, x - 1, y - 1, width + 2, 26.0);
            boolean invade = this.w.map.owner(c) != this.w.map.owner(this.selectedFleet);
            d.button(x, y, width, invade ? Lang._t("Invade", new Object[0]) : Lang._t("Move", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.travelTo(c);
                }
            });
            d.hook(x, y, width, 24.0, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

                public void run(Input in, Pt p, Hook.Type type) {
                    if (StrategicScreen.this.selectedFleet == null || ((StrategicScreen)StrategicScreen.this).selectedFleet.location == null) {
                        return;
                    }
                    StrategicScreen.this.highlitTravelConnection = c;
                    StrategicScreen.this.highlitTravelConnectionTime = 0;
                }
            });
        }
    }

    private void renderCityMenu(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        final City c = this.menuCity;
        final StrategicScreen ss = this;
        int x = this.scrollX + c.x - 16;
        int y = this.scrollY + c.y + 25;
        int width = 200;
        int nButtons = 0;
        final Spy spy = this.w.player.getSpyFor(c);
        nButtons = this.w.player.cities.contains(c) ? (c.constructing == null ? 5 : 2) : (spy == null ? 1 : 2);
        d.drawShadowedPanel(x, y, width + 12, nButtons * 27 - 3 + 12);
        x += 6;
        y += 6;
        if (this.w.player.cities.contains(c)) {
            if (c.constructing == null) {
                d.button(x, y, width, Lang._t("Create_ship", new Object[0]), "C", new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.createShip(ShipType.AIRSHIP);
                    }
                }, c.canBuild());
                d.button(x, y += 27, width, Lang._t("Build_ship", new Object[0]), "B", new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.buildSavedShip(ShipType.AIRSHIP);
                    }
                }, c.canBuild());
                d.button(x, y += 27, width, Lang._t("Create_landship", new Object[0]), "A", new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.createShip(ShipType.LANDSHIP);
                    }
                }, c.canBuild());
                d.button(x, y += 27, width, Lang._t("Build_landship", new Object[0]), "L", new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.buildSavedShip(ShipType.LANDSHIP);
                    }
                }, c.canBuild());
            } else {
                d.button(x, y, width, Lang._t("Cancel_ship", new Object[0]), "C", new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.cancelShip();
                    }
                }, c.canBuild());
            }
            d.button(x, y += 27, width, Lang._t("Defenses", new Object[0]), "D", new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.defenses();
                }
            }, c.canBuild());
        } else if (spy == null && !this.debug) {
            d.button(x, y, width, Lang._t("Send_Spy_Sx", 100), "S", new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.w.player.spies.add(new Spy(c));
                    StrategicScreen.this.w.player.money -= 100;
                    StrategicScreen.this.menuCity = null;
                }
            }, this.w.player.money >= 100);
        } else {
            if (spy != null) {
                d.button(x, y, width, Lang._t("Recall_Spy", new Object[0]), "S", new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.w.player.spies.remove(spy);
                        StrategicScreen.this.menuCity = null;
                    }
                });
                y += 27;
            }
            d.button(x, y, width, Lang._t("View_City", new Object[0]), "V", new Runnable(){

                @Override
                public void run() {
                    UniScreen us = new UniScreen(StrategicScreen.this.g, new EspionageIntent(ss));
                    us.wm = StrategicScreen.this.w.map;
                    us.city = StrategicScreen.this.menuCity;
                    StrategicScreen.this.g.s = us;
                    StrategicScreen.this.menuCity = null;
                }
            });
        }
    }

    private void buildSavedShip(ShipType st) {
        ShipHelperWidget shw = ShipHelperWidget.get(new File(AGame.getGameDirectory(), st.dirName), this.w.player.arms, this.w.player.bonuses(), this.w.player.money);
        FileScreen fs = new FileScreen(ShipEditorUtils.shipsList(st, shw), new BuildShipMission(this.g, this, st), shw, new PriceInlineInfo(shw, null));
        fs.enabledFilter = new AffordableFilter(this.w.player.money, this.w.player.bonuses(), shw, null);
        this.g.s = fs;
    }

    public void build(Airship a) {
        a.constructionBonuses = this.w.player.bonuses();
        a.currentBonuses = this.w.player.bonuses();
        this.menuCity.constructionCost = a.getCost();
        this.menuCity.constructing = a;
        this.menuCity.constructionProgress = 0;
        this.w.player.money -= a.getCost();
        this.menuCity = null;
    }

    public void rebuild(City c, Airship original, Airship a) {
        int cost;
        a.constructionBonuses = this.w.player.bonuses();
        a.currentBonuses = this.w.player.bonuses();
        this.w.player.remove(original, this.w.map);
        c.constructionCost = cost = a.getRefitCost(original);
        c.constructing = a;
        c.constructionProgress = 0;
        this.w.player.money -= cost;
    }

    private void createShip(ShipType st) {
        UniScreen us = new UniScreen(this.g, new DesignFromStrategicIntent(this));
        us.standaloneEditShip = new Airship(st);
        us.standaloneEditShip.constructionBonuses = this.w.player.bonuses();
        us.standaloneEditShip.currentBonuses = this.w.player.bonuses();
        this.g.s = us;
    }

    private void cancelShip() {
        this.menuCity.constructing = null;
        this.menuCity.constructionProgress = 0;
    }

    private void defenses() {
        UniScreen us = new UniScreen(this.g, new DefencesIntent(this));
        us.city = this.menuCity;
        us.wm = this.w.map;
        this.g.s = us;
    }

    private boolean hasSpy(City c) {
        for (Spy s : this.w.player.spies) {
            if (s.location != c) continue;
            return s.infiltrationTimeout <= 0;
        }
        return false;
    }

    private void highlightRoadLine(MyDraw d, Road road, int scrollX, int scrollY) {
        for (int[] p : road.path) {
            d.rect(DARKER_INK, p[0] - 1 + scrollX, p[1] - 1 + scrollY, 4.0, 4.0);
        }
    }

    private void highlightItinerary(MyDraw d, Fleet.Itinerary it, int scrollX, int scrollY) {
        for (Fleet.Segment s : it.segments) {
            for (int i = s.startIndex; i != s.endIndex; i += s.direction) {
                int[] p = s.road.path.get(i);
                d.rect(DARKER_INK, p[0] - 1 + scrollX, p[1] - 1 + scrollY, 4.0, 4.0);
            }
        }
    }

    @Override
    public void render(final MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        for (int y = this.scrollY % 256 - 256; y < sm.height; y += 256) {
            for (int x = this.scrollX % 256 - 256; x < sm.width; x += 256) {
                TexGen.darkWoodGrain().draw((float)x, (float)y);
            }
        }
        for (Backdrop bd : this.backdrops) {
            d.blit(bd.type.img, bd.x + this.scrollX, bd.y + this.scrollY, bd.rot);
        }
        d.hook(0.0, 0.0, sm.width, sm.height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

            public void run(Input in, Pt p, Hook.Type type) {
                StrategicScreen.this.menuCity = null;
                StrategicScreen.this.selectedFleet = null;
            }
        });
        if (this.mapTiles == null || this.w.map.dirty) {
            this.renderMapTiles();
            this.w.map.dirty = false;
        }
        d.rect(MAP_SHADOW, this.scrollX - 2, this.scrollY - 2, this.mapTiles[0].length * 256 + 4, this.mapTiles.length * 256 + 4);
        for (int y = 0; y < this.mapTiles.length; ++y) {
            for (int x = 0; x < this.mapTiles[0].length; ++x) {
                this.mapTiles[y][x].draw((float)(this.scrollX + x * 256), (float)(this.scrollY + y * 256));
            }
        }
        int i = 0;
        for (WorldMap.TerrainFeature f : this.w.map.features) {
            switch (f.type) {
                case MOUNTAIN: {
                    Img img = this.mountains[i++ % this.mountains.length];
                    if (img.machineImgCache != null) {
                        ((Image)img.machineImgCache).setFilter(9728);
                    }
                    d.blit(img, INK, this.scrollX + f.x - 16, this.scrollY + f.y - 20, 32.0, 32.0);
                    break;
                }
                case FOREST: {
                    Img img = this.trees[i++ % this.trees.length];
                    if (img.machineImgCache != null) {
                        ((Image)img.machineImgCache).setFilter(9728);
                    }
                    d.blit(img, INK, this.scrollX + f.x - 16, this.scrollY + f.y - 20, 32.0, 32.0);
                    break;
                }
                case SWAMP: {
                    Img img = this.swamps[i++ % this.swamps.length];
                    if (img.machineImgCache != null) {
                        ((Image)img.machineImgCache).setFilter(9728);
                    }
                    d.blit(img, INK, this.scrollX + f.x, this.scrollY + f.y, 32.0, 32.0);
                    break;
                }
                case SEA_CREATURES: {
                    Img img = this.sea_creatures_bg[i % this.sea_creatures.length];
                    if (img.machineImgCache != null) {
                        ((Image)img.machineImgCache).setFilter(9728);
                    }
                    d.blit(img, PARCHMENT, this.scrollX + f.x, this.scrollY + f.y, 32.0, 32.0);
                    img = this.sea_creatures[i++ % this.sea_creatures.length];
                    if (img.machineImgCache != null) {
                        ((Image)img.machineImgCache).setFilter(9728);
                    }
                    d.blit(img, INK, this.scrollX + f.x, this.scrollY + f.y, 32.0, 32.0);
                }
            }
        }
        if (this.highlitTravelConnection != null && this.selectedFleet != null && this.selectedFleet.location != null) {
            Road road;
            Road road2 = road = Fleet.canFly(this.fleetSelection) ? null : this.w.map.getConnection(this.selectedFleet.location, this.highlitTravelConnection);
            if (road != null) {
                this.highlightRoadLine(d, road, this.scrollX, this.scrollY);
            } else {
                d.dottedLine(DARKER_INK, 2, 7, this.scrollX + this.highlitTravelConnection.x, this.scrollY + this.highlitTravelConnection.y, this.selectedFleet.location.x + this.scrollX, this.selectedFleet.location.y + this.scrollY);
            }
        }
        for (Empire em : this.w.map.empires) {
            for (final City c : em.cities) {
                Img img = this.cities_bg[c.appearance];
                if (img.machineImgCache != null) {
                    ((Image)img.machineImgCache).setFilter(9728);
                }
                d.blit(img, c == this.hoverCity ? INK : PARCHMENT, this.scrollX + c.x - 16, this.scrollY + c.y - 16, 32.0, 32.0);
                img = this.cities[c.appearance];
                if (img.machineImgCache != null) {
                    ((Image)img.machineImgCache).setFilter(9728);
                }
                d.blit(img, em == this.w.player ? DARK_GREEN_INK : DARK_RED_INK, this.scrollX + c.x - 16, this.scrollY + c.y - 16, 32.0, 32.0);
                d.heavilyBorderedText(c.name.toUpperCase(), AGame.BIG_FOUNT, AGame.BIG_FOUNT_OUTLINE, em == this.w.player ? DARK_GREEN_INK : DARK_RED_INK, PARCHMENT, this.scrollX + c.x + 20, this.scrollY + c.y - 8, 1000);
                em.arms.layout.drawShield(em.arms, d, this.scrollX + c.x - 18, this.scrollY + c.y - 16 - 41, 1.0, INK);
                d.hook(this.scrollX + c.x - 18, this.scrollY + c.y - 16 - 41, 36.0, 73.0, new Hook(new Hook.Type[]{Hook.Type.HOVER, Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        StrategicScreen.this.nextHoverCity = c;
                        if (type == Hook.Type.MOUSE_1_CLICKED) {
                            d.state.hasClicked();
                            StrategicScreen.this.selectedFleet = null;
                            StrategicScreen.this.menuCity = c;
                        }
                    }
                });
                d.hook(this.scrollX + c.x - 16, this.scrollY + c.y - 16, 32.0, 32.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_2_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        d.state.hasClicked();
                        if (StrategicScreen.this.selectedFleet != null && !StrategicScreen.this.fleetSelection.isEmpty() && ((StrategicScreen)StrategicScreen.this).selectedFleet.location != c && StrategicScreen.this.canTravelTo(c)) {
                            StrategicScreen.this.travelTo(c);
                        }
                    }
                });
                int x = this.scrollX + c.x + 20;
                int y = this.scrollY + c.y + 12;
                int maxW = this.w.map.water[0].length - c.x - 30;
                if (this.w.player.cities.contains(c) || this.hasSpy(c) || this.debug) {
                    if (this.hasSpy(c)) {
                        d.heavilyBorderedText(Lang._t("Spy_Active", new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, RED_INK, PARCHMENT, x, y, maxW);
                        y += 13;
                    }
                    if (c.takeoverMethod != null) {
                        d.rect(RED_INK, x, y, 100.0, 6.0);
                        d.rect(PARCHMENT, x + 1, y + 1, 98.0, 4.0);
                        d.rect(RED_INK, x + 2, y + 2, 96 * c.takeoverAmount / c.takeoverMethod.takeoverTime, 2.0);
                        d.heavilyBorderedText(c.takeoverMethod.getName(), AGame.FOUNT, AGame.FOUNT_OUTLINE, RED_INK, PARCHMENT, x, y += 8, maxW);
                        y += 13;
                    } else if (c.constructing != null) {
                        d.rect(DARKER_INK, x, y, 100.0, 6.0);
                        d.rect(PARCHMENT, x + 1, y + 1, 98.0, 4.0);
                        d.rect(DARKER_INK, x + 2, y + 2, 96 * c.constructionProgress / c.constructionTimeCost(), 2.0);
                        d.heavilyBorderedText(Lang._t("Constructing_x", c.constructing.name), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y += 8, maxW);
                        y += 13;
                    }
                    d.heavilyBorderedText(Lang._t("x_Income", c.adjustedIncome()), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y, maxW);
                    d.heavilyBorderedText(Lang._t(City.SHIPYARD_SIZES[c.shipyardLevel], new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y += 13, maxW);
                    y += 13;
                    if (c.bonus != null && c.bonus != Bonus.NO_BONUS) {
                        d.heavilyBorderedText(c.bonus.getName() + (c.bonus.getName().equals(c.bonus.getDesc()) ? "" : ": " + c.bonus.getDesc()), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y, maxW);
                        y += 13;
                    }
                    d.heavilyBorderedText(Lang._t("Secret_Police_", new Object[0]) + this.w.map.owner((City)c).policeLevel.getName(), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y, maxW);
                    y += 13;
                    if (c.alertAmount > 0) {
                        int alertAmt = Math.min(30000, c.alertAmount);
                        d.rect(RED_INK, x, y, 100.0, 6.0);
                        d.rect(PARCHMENT, x + 1, y + 1, 98.0, 4.0);
                        d.rect(RED_INK, x + 2, y + 2, 96 * alertAmt / 30000, 2.0);
                        d.heavilyBorderedText(Lang._t("High_Alert_", new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, RED_INK, PARCHMENT, x, y += 8, maxW);
                        y += 13;
                    }
                    if (!this.debug) continue;
                    d.heavilyBorderedText("SpyActions: " + em.spyActionsDone, AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y, maxW);
                    d.heavilyBorderedText("$" + em.money + " d" + em.incomeBalance(), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y += 13, maxW);
                    y += 13;
                    if (c.constructionTarget == null) continue;
                    d.heavilyBorderedText("Target: " + c.constructionTarget.name + " $" + c.constructionTarget.getCost(), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, x, y, maxW);
                    continue;
                }
                Spy spy = this.w.player.getSpyFor(c);
                if (spy == null) continue;
                d.rect(RED_INK, x, y, 100.0, 6.0);
                d.rect(PARCHMENT, x + 1, y + 1, 98.0, 4.0);
                d.rect(RED_INK, x + 2, y + 2, 96 * (10000 - spy.infiltrationTimeout) / 10000, 2.0);
                d.heavilyBorderedText(Lang._t("Infiltrating_City", new Object[0]), AGame.FOUNT, AGame.FOUNT_OUTLINE, RED_INK, PARCHMENT, x, y += 8, maxW);
                y += 13;
            }
        }
        for (int passes = 0; passes < 2; ++passes) {
            for (Empire e : this.w.map.empires) {
                if (e == this.w.player != (passes == 1)) continue;
                for (final Fleet fl : e.fleets) {
                    int tw;
                    int x = this.scrollX + (int)fl.displayX() - 16;
                    int y = this.scrollY + (int)fl.displayY() - 16;
                    if (fl.inTransit() && (fl == this.selectedFleet || fl == this.hoverFleet)) {
                        if (fl.interceptPoint != null) {
                            d.dottedLine(DARKER_INK, 2, 7, (double)this.scrollX + fl.interceptPoint.x, (double)this.scrollY + fl.interceptPoint.y, x + 16, y + 16);
                            if (fl.interceptTarget.interceptPoint != null) {
                                d.dottedLine(DARKER_INK, 2, 7, (double)this.scrollX + fl.interceptTarget.interceptPoint.x, (double)this.scrollY + fl.interceptTarget.interceptPoint.y, this.scrollX + (int)fl.interceptTarget.displayX(), this.scrollY + (int)fl.interceptTarget.displayY());
                            } else {
                                d.dottedLine(DARKER_INK, 2, 7, this.scrollX + fl.interceptTarget.destination.x, this.scrollY + fl.interceptTarget.destination.y, this.scrollX + (int)fl.interceptTarget.displayX(), this.scrollY + (int)fl.interceptTarget.displayY());
                            }
                        } else if (fl.interceptItinerary != null) {
                            this.highlightItinerary(d, fl.interceptItinerary, this.scrollX, this.scrollY);
                        } else if (fl.usingRoad != null) {
                            this.highlightRoadLine(d, fl.usingRoad, this.scrollX, this.scrollY);
                        } else {
                            d.dottedLine(DARKER_INK, 2, 7, this.scrollX + fl.destination.x, this.scrollY + fl.destination.y, x + 16, y + 16);
                        }
                    }
                    Appearance fleetApp = this.airfleet;
                    Appearance fleetAppOutline = this.airfleetOutline;
                    if (!fl.canFly()) {
                        if (fl.usingRoad != null && fl.usingRoad.seaRoute) {
                            if (fl.groundOnly()) {
                                fleetApp = this.convoy;
                                fleetAppOutline = this.convoyOutline;
                            } else {
                                fleetApp = this.escortedConvoy;
                                fleetAppOutline = this.escortedConvoyOutline;
                            }
                        } else if (fl.groundOnly()) {
                            fleetApp = this.landfleet;
                            fleetAppOutline = this.landfleetOutline;
                        } else {
                            fleetApp = this.mixedfleet;
                            fleetAppOutline = this.mixedfleetOutline;
                        }
                    }
                    fleetApp.draw(d, x, y + 8, this.time, fl == this.selectedFleet || fl == this.hoverFleet ? e.getMainTincture().tint.mix(0.7, INK) : PARCHMENT, false);
                    fleetAppOutline.draw(d, x, y + 8, this.time, fl == this.selectedFleet || fl == this.hoverFleet ? PARCHMENT : e.getMainTincture().tint.mix(0.7, INK), false);
                    d.rect(INK, x + 7, y - 15, 18.0, 18.0);
                    e.arms.draw(d, x + 8, y - 14, 16);
                    d.rect(PARCHMENT_OVER, x + 7, y - 15, 18.0, 18.0);
                    if (fl.fleeDestinationNeeded) {
                        tw = x - 5 - (int)d.textSize((String)Lang._t((String)"Select_destination_to_fly_to", (Object[])new Object[0]).toUpperCase(), (Fount)AGame.FOUNT).x;
                        d.heavilyBorderedText(Lang._t("Select_destination_to_fly_to", new Object[0]).toUpperCase(), AGame.FOUNT, AGame.FOUNT_OUTLINE, Clr.RED, PARCHMENT, tw, y + 18, 10000);
                    }
                    if (this.selectedFleet != null && e != this.w.player && this.selectedFleet.canIntercept(fl, this.fleetSelection, this.w.map)) {
                        tw = x - 5 - (int)d.textSize((String)Lang._t((String)"Click_to_intercept", (Object[])new Object[0]).toUpperCase(), (Fount)AGame.FOUNT).x;
                        d.heavilyBorderedText(Lang._t("Click_to_intercept", new Object[0]).toUpperCase(), AGame.FOUNT, AGame.FOUNT_OUTLINE, DARKER_INK, PARCHMENT, tw, y + 18, 10000);
                        d.hook(tw, y + 18, tw, AGame.FOUNT_OUTLINE.height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                            public void run(Input in, Pt p, Hook.Type type) {
                                StrategicScreen.this.doIntercept(fl);
                            }
                        });
                        d.hook(x, y, 32.0, 32.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                            public void run(Input in, Pt p, Hook.Type type) {
                                StrategicScreen.this.doIntercept(fl);
                            }
                        });
                    }
                    if (e == this.w.player) {
                        d.hook(x, y - 15, 32.0, 55.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                            public void run(Input in, Pt p, Hook.Type type) {
                                if (d.state.canClick()) {
                                    StrategicScreen.this.menuCity = null;
                                    StrategicScreen.this.selectedFleet = fl;
                                    StrategicScreen.this.fleetSelection = new ArrayList<Airship>(fl.actives);
                                    StrategicScreen.this.fleetSelection.addAll(fl.reserve);
                                    ((StrategicScreen)StrategicScreen.this).fleetScrollBar.offset = 0;
                                    d.state.hasClicked();
                                }
                            }
                        });
                    }
                    d.hook(x, y - 15, 32.0, 55.0, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

                        public void run(Input in, Pt p, Hook.Type type) {
                            StrategicScreen.this.nextHoverFleet = fl;
                        }
                    });
                }
            }
        }
        for (Empire em : this.w.map.empires) {
            for (final City c : em.cities) {
                if (this.w.player.cities.contains(c) && c.takeoverNeeded) {
                    this.renderCityTakeoverOptions(d, c);
                }
                if (this.selectedFleet == null || this.fleetSelection.isEmpty()) continue;
                this.renderCityMoveMenu(c, d, sm, hs, cursor);
            }
        }
        for (Empire em : this.w.map.empires) {
            for (final City c : em.cities) {
                for (City.Message msg : c.messages) {
                    Img icon = null;
                    switch (msg.type) {
                        case COMBAT: {
                            icon = this.fight;
                            break;
                        }
                        case LOST_SHIP: {
                            icon = this.shipLoss;
                            break;
                        }
                        case REVOLT: {
                            icon = this.fight;
                        }
                    }
                    d.borderedBlit(icon, Clr.RED, Clr.WHITE, this.scrollX + c.x - 16, this.scrollY + c.y - msg.offset / 2 - 16);
                    d.heavilyBorderedText(msg.text, AGame.FOUNT, AGame.FOUNT_OUTLINE, Clr.RED, Clr.WHITE, this.scrollX + c.x + 20 - 16, this.scrollY + c.y - msg.offset / 2 - 16 + 2, 1000);
                }
            }
        }
        d.rect(MyDraw.WIN_SHADOW, 0.0, 2.0, 2.0, 42.0);
        d.rect(MyDraw.WIN_SHADOW, 109.0, 2.0, sm.width - 109, 42.0);
        d.rect(MyDraw.WIN_SHADOW, 2.0, 2.0, 110.0, 110.0);
        d.drawTopBar(sm);
        d.drawPanel(3, 3, 108, 108);
        CoatOfArms coa = this.w.player.arms;
        if (coa == null) {
            d.rect(Clr.DARK_GREY, 9.0, 9.0, 96.0, 96.0);
        } else {
            coa.draw(d, 9.0, 9.0, 96);
        }
        int x = 123;
        StringBuilder moneyInfo = new StringBuilder();
        moneyInfo.append(this.w.player.money < 0 ? "[ff9999]$" : "$").append(this.w.player.money).append("[]");
        int inc = this.w.player.incomeBalance();
        if (inc > 0) {
            moneyInfo.append(" +").append(inc);
        } else if (inc < 0) {
            moneyInfo.append(" [ff9999]").append(inc);
        } else {
            moneyInfo.append(" 0");
        }
        d.text(moneyInfo.toString(), AGame.BIG_FOUNT, x, 12.0);
        if (this.debug) {
            d.hook(45.0, 5.0, 50.0, 20.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    StrategicScreen.this.w.player.money += 1000;
                }
            });
        }
        d.button(x += 100, 11, 150, Lang._t("Empire_Details", new Object[0]), "E", new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.showEmpireDetails = true;
            }
        });
        if (this.selectedFleet != null) {
            this.renderFleetList(d, sm, hs, cursor);
        }
        if (this.menuCity != null) {
            this.renderCityMenu(d, sm, hs, cursor);
        }
        x = sm.width - 40 - 10;
        d.button(x, 11, 40, "?", new Runnable(){

            @Override
            public void run() {
                StrategicScreen.this.g.showHelp("strategic", null);
            }
        });
        d.toggle(x -= 112, 11, 100, Lang._t("Menu", new Object[0]), "M", new InputRunnable(){

            @Override
            public void run(Input in) {
                StrategicScreen.this.menu = true;
            }
        }, this.menu, !this.menu);
        x -= 12;
        for (i = CampaignWorld.Speed.values().length - 1; i >= 0; --i) {
            final CampaignWorld.Speed sp = CampaignWorld.Speed.values()[i];
            d.iconToggle(x -= 27, 11, sp.icon, null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    if (sp != CampaignWorld.Speed.STOP) {
                        StrategicScreen.this.lastSpeed = StrategicScreen.this.w.speed;
                    }
                    StrategicScreen.this.w.speed = sp;
                }
            }, this.w.speed == sp, !this.menu);
        }
        if (!this.w.player.messages.isEmpty()) {
            d.getHooks().list.clear();
            Empire.Message msg = this.w.player.messages.get(this.w.player.messages.size() - 1);
            String text = msg.text;
            if (msg.type == Empire.MessageType.SPY_ACTION && this.w.player.policeLevel != SecretPoliceLevel.SEVERE) {
                text = text + "\n\n" + Lang._t("secret_police_hint", new Object[0]);
            }
            d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, text, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.w.player.messages.remove(StrategicScreen.this.w.player.messages.size() - 1);
                }
            });
        }
        if (this.showEmpireDetails) {
            int width = 546;
            int height = 353;
            x = sm.width / 2 - width / 2;
            int y = sm.height / 2 - height / 2;
            d.drawShadowedWindow(x, y, width, height);
            d.drawPanel((x += 12) + ((width -= 24) / 2 - 66), y += 12, 132, 132);
            this.w.player.arms.draw(d, x + (width / 2 - 64), y += 2, 128);
            Pt ts = d.textSize(Lang._t("The_Empire_of_x", this.w.player.name), AGame.BIG_FOUNT);
            d.text(Lang._t("The_Empire_of_x", this.w.player.name), AGame.BIG_FOUNT, x + (int)((double)(width / 2) - ts.x / 2.0), y += 140);
            d.text(StrategicScreen.lineItem(Lang._t("Cities", new Object[0]), this.w.player.totalIncome(), 24), AGame.FOUNT, x, y += 40);
            d.text(StrategicScreen.lineItem(Lang._t("Defences_Maintenance", new Object[0]), -this.w.player.totalDefencesCost(), 24), AGame.FOUNT, x, y += 20);
            d.text(StrategicScreen.lineItem(Lang._t("Fleet_Maintenance", new Object[0]), -this.w.player.totalFleetCosts(), 24), AGame.FOUNT, x, y += 20);
            d.text(StrategicScreen.lineItem(Lang._t("Spy_Network", new Object[0]), -this.w.player.totalSpiesCost(), 24), AGame.FOUNT, x, y += 20);
            d.text(StrategicScreen.lineItem(Lang._t("Secret_Police", new Object[0]), -this.w.player.totalPoliceCosts(), 24), AGame.FOUNT, x, y += 20);
            int x2 = x + 192;
            int y2 = y - 5;
            for (final SecretPoliceLevel spl : SecretPoliceLevel.values()) {
                d.toggle(x2, y2, 80, spl.getName(), null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        StrategicScreen.this.w.player.policeLevel = spl;
                    }
                }, spl == this.w.player.policeLevel, true);
                d.tooltip(x2, y2, 50.0, 20.0, spl.getDesc());
                x2 += 83;
            }
            d.text(StrategicScreen.lineItem(Lang._t("TOTAL", new Object[0]), this.w.player.incomeBalance(), 24), AGame.FOUNT, x, y += 20);
            d.button(x + width - 55, y += 20, 50, Lang._t("OK", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.showEmpireDetails = false;
                }
            });
        }
        if (this.menu) {
            this.renderMenu(d, sm, hs, cursor);
        }
        if (this.w.victory()) {
            d.getHooks().list.clear();
            d.rect(AirshipGame.ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
            int width = 320;
            int height = 320;
            x = sm.width / 2 - width / 2;
            int textY = Math.max(60, sm.height / 2 - 300);
            int y = textY - 60 + 140;
            this.victoryUnderlay.draw((Draw)d, (double)x, (double)y, (double)width, height, 0, CoatOfArms.Tincture.OR.tint, false);
            this.w.player.arms.draw(d, x + width / 4, y + height / 4 + 50, width / 2);
            Pt sz = d.textSize(Lang._t("VICTORY", new Object[0]), AGame.HUGE_FOUNT);
            d.borderedText(Lang._t("VICTORY", new Object[0]), AGame.HUGE_FOUNT, CoatOfArms.Tincture.OR.tint, Clr.BLACK, (int)((double)(sm.width / 2) - sz.x / 2.0), textY);
        } else if (this.w.defeat()) {
            d.getHooks().list.clear();
            d.rect(AirshipGame.ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
            int width = 320;
            int height = 320;
            x = sm.width / 2 - width / 2;
            int textY = Math.max(60, sm.height / 2 - 300);
            int y = textY - 20;
            this.w.player.arms.draw(d, x + width / 4, y + height / 4 + 50, width / 2);
            d.rect(ROT, x + width / 4, y + height / 4 + 50, width / 2, height / 2);
            this.defeatOverlay.draw((Draw)d, (double)x, (double)y, (double)width, height, 0, INK, false);
            Pt sz = d.textSize(Lang._t("DEFEAT", new Object[0]), AGame.HUGE_FOUNT);
            d.borderedText(Lang._t("DEFEAT", new Object[0]), AGame.HUGE_FOUNT, PARCHMENT, Clr.BLACK, (int)((double)(sm.width / 2) - sz.x / 2.0), textY);
        } else if (this.combatOutcome != null) {
            d.getHooks().list.clear();
            d.rect(AirshipGame.ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
            Pt sz = d.textSize(this.combatOutcome.getName(), AGame.HUGE_FOUNT);
            d.borderedText(this.combatOutcome.getName(), AGame.HUGE_FOUNT, PARCHMENT, Clr.BLACK, (int)((double)(sm.width / 2) - sz.x / 2.0), Math.max(60, sm.height / 2 - 100));
        } else if (this.askForScrap != null) {
            d.getHooks().list.clear();
            int width = 300;
            d.confirmDialog(sm.width / 2 - width / 2, sm.height / 2 - 150, width, Lang._t("Scrap_x_for_y_gold", this.askForScrap.name, this.askForScrap.getCost() / 8), new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.doScrap();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    StrategicScreen.this.askForScrap = null;
                }
            });
        }
    }

    private static String lineItem(String name, int value, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        String v = "" + value;
        while (sb.length() + v.length() < width) {
            sb.append(" ");
        }
        return sb.append(v).toString();
    }

    public static FileScreen.Backend savesList() {
        File f = new File(AGame.getGameDirectory(), "saves");
        f.mkdirs();
        return new JSONFileBackend(f);
    }

    public void save() {
        this.g.s = new FileScreen(StrategicScreen.savesList(), new SaveGameMission(this.g, this), null, new DateInfo(new File(AGame.getGameDirectory(), "saves")));
    }

    public void open(boolean returnToMainMenu) {
        this.g.s = new FileScreen(StrategicScreen.savesList(), new OpenGameMission(this.g, this, returnToMainMenu), null, new DateInfo(new File(AGame.getGameDirectory(), "saves")));
    }

    @Override
    public ArrayList<String> music() {
        return AGame.STRATEGIC_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return true;
    }

    private static class SaveGameMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final StrategicScreen ss;

        public SaveGameMission(AirshipGame g, StrategicScreen ss) {
            this.g = g;
            this.ss = ss;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.SAVE;
        }

        @Override
        public String text() {
            return Lang._t("Save_game_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Save", new Object[0]);
        }

        @Override
        public String initialInput() {
            return this.ss.w.player.name.toUpperCase();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileSelected(String name) {
            this.g.s = this.ss;
            File f = new File(new File(AGame.getGameDirectory(), "saves"), name + ".json");
            BufferedWriter w = null;
            try {
                w = new BufferedWriter(new FileWriter(f));
                w.write(this.ss.w.toJSON().toString(4));
                this.ss.menu = false;
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_save_game", new Object[0]), e, null, false);
            }
            finally {
                try {
                    w.close();
                }
                catch (Exception e) {}
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.ss;
        }
    }

    public static class OpenGameMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final StrategicScreen ss;
        private boolean returnToMainMenu;

        public OpenGameMission(AirshipGame g, StrategicScreen ss, boolean returnToMainMenu) {
            this.g = g;
            this.ss = ss;
            this.returnToMainMenu = returnToMainMenu;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.OPEN;
        }

        @Override
        public String text() {
            return Lang._t("Open_save_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Open", new Object[0]);
        }

        @Override
        public String initialInput() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileSelected(String name) {
            this.g.s = this.ss;
            BufferedReader r = null;
            try {
                r = new BufferedReader(new FileReader(new File(new File(AGame.getGameDirectory(), "saves"), name + ".json")));
                JSONObject o = new JSONObject(new JSONTokener(r));
                int version = o.optInt("version", 0);
                if (version < 7000) {
                    this.g.showError(Lang._t("Save_out_of_date", new Object[0]));
                    if (this.returnToMainMenu) {
                        this.g.s = new MainMenu(this.g);
                    }
                    return;
                }
                this.ss.w = new CampaignWorld(o, this.g);
                this.ss.updateBackgrounds();
                this.ss.menu = false;
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_game", new Object[0]), e, null, true);
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.returnToMainMenu ? new MainMenu(this.g) : this.ss;
        }
    }

    private static class BuildShipMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final StrategicScreen ss;
        private final ShipType st;

        public BuildShipMission(AirshipGame g, StrategicScreen ss, ShipType st) {
            this.g = g;
            this.ss = ss;
            this.st = st;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.OPEN;
        }

        @Override
        public String text() {
            return Lang._t("Select_ship_design_to_build", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Build", new Object[0]);
        }

        @Override
        public String initialInput() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileSelected(String name) {
            this.g.s = this.ss;
            BufferedReader r = null;
            try {
                r = new BufferedReader(new FileReader(new File(new File(AGame.getGameDirectory(), this.st.dirName), name + ".json")));
                Airship a = new Airship(new JSONObject(new JSONTokener(r)));
                a.setFlipped(true);
                this.ss.build(a);
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_ship_or_building", new Object[0]), e, null, false);
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.ss;
        }
    }

    public class FleetElementAdapter
    implements ScrollBar.ScrollElementAdapter<Airship> {
        @Override
        public int getHeight(Airship t, MyDraw d, int availableWidth) {
            boolean canRebuild;
            boolean bl = canRebuild = ((StrategicScreen)StrategicScreen.this).selectedFleet.location != null && ((StrategicScreen)StrategicScreen.this).selectedFleet.location.canBuild() && StrategicScreen.this.w.player.cities.contains(((StrategicScreen)StrategicScreen.this).selectedFleet.location);
            if (canRebuild) {
                return 190 + AGame.FOUNT.lineHeight + 12;
            }
            return 133 + AGame.FOUNT.lineHeight + 12;
        }

        @Override
        public void draw(final Airship ship, MyDraw d, int x, int y, int width) {
            boolean canRebuild = ((StrategicScreen)StrategicScreen.this).selectedFleet.location != null && ((StrategicScreen)StrategicScreen.this).selectedFleet.location.canBuild() && StrategicScreen.this.w.player.cities.contains(((StrategicScreen)StrategicScreen.this).selectedFleet.location);
            d.drawPanel(x, y, 130, 130);
            d.rect(StrategicScreen.this.fleetSelection.contains(ship) ? MyDraw.PROGRESS_BAR_INSIDE : MyDraw.TOGGLE_OFF_INSIDE, x + 2, y + 2, 126.0, 126.0);
            double scale = Math.min(100.0 / (double)ship.getWidth() / 16.0, 100.0 / (double)ship.getHeight() / 16.0);
            d.shift(x + 15, y + 15);
            d.scale(scale, scale);
            ship.draw(d, 100.0 / scale / 2.0 - (double)(ship.getWidth() * 16 / 2), 100.0 / scale / 2.0 - (double)(ship.getHeight() * 16 / 2), 0, true, false, true, StrategicScreen.this.w.player.arms, true, null, 1.0f, 1.0f, Clr.WHITE);
            d.resetTransforms();
            d.hook(x, y, 130.0, 130.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    if (StrategicScreen.this.fleetSelection.contains(ship)) {
                        StrategicScreen.this.fleetSelection.remove(ship);
                    } else {
                        StrategicScreen.this.fleetSelection.add(ship);
                    }
                }
            });
            d.text(ship.name, AGame.FOUNT, x, y += 133);
            y += AGame.FOUNT.lineHeight;
            if (canRebuild) {
                d.button(x, y, 130, Lang._t("Refit", new Object[0]), null, new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.refitShip(((StrategicScreen)StrategicScreen.this).selectedFleet.location, ship);
                    }
                }, ((StrategicScreen)StrategicScreen.this).selectedFleet.location.constructing == null);
                d.button(x, y += 27, 130, Lang._t("Scrap_Sx", ship.getCost() / 8), null, new Runnable(){

                    @Override
                    public void run() {
                        StrategicScreen.this.askForScrap = ship;
                    }
                });
            }
        }
    }

    private static class Backdrop {
        BackdropType type;
        int x;
        int y;
        double rot;

        public Backdrop(BackdropType type, int x, int y, double rot) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.rot = rot;
        }
    }

    private static class BackdropType {
        public final Img img;
        public final boolean shadow;

        public BackdropType(Img img, boolean shadow) {
            this.img = img;
            this.shadow = shadow;
        }
    }
}

