/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.catengine.util.Pt;
import java.util.Iterator;

public strictfp class TacticalAI {
    public static final int GRID_STEP = 20;
    public static final int INSET = 8;
    public static final int GRID_H_SIZE = 160;
    public static final int MAX_GRID_V_SIZE = 80;
    public static final int GRID_X_ANCHOR = -1600;
    public static final double NO = -1000000.0;
    public final int gridVSize;
    public final int gridYAnchor;
    public final double[][][] grid;
    public final Airship ship;
    public final Combat c;
    public final Combat.Side mySide;
    public final Combat.Side enemySide;
    int yIndex = -2;
    int ticksUntilCommand = 0;
    int phaseTick = 0;
    int sideTickCounter = 0;
    public static boolean fixed = false;
    public static boolean lfs = true;
    public static final int BOARD_X_DIST_MAX = 60;
    public static final int TOO_HIGH = 80;
    public static final int TOO_LOW = -60;

    public TacticalAI(Airship ship, Combat c, Combat.Side mySide, Combat.Side enemySide) {
        this.gridVSize = !ship.type.mobile ? 0 : (ship.type.onGround ? 1 : Math.min(80, Math.max(0, ship.serviceCeiling()) / 20 + 2));
        this.gridYAnchor = 512 - this.gridVSize * 20;
        this.grid = new double[this.gridVSize][160][2];
        this.ship = ship;
        this.c = c;
        this.mySide = mySide;
        this.enemySide = enemySide;
    }

    public void sideTick() {
        if (this.sideTickCounter-- > 0) {
            return;
        }
        Iterator<Airship> it = this.mySide.reserve.iterator();
        block0: while (it.hasNext()) {
            double proposedY;
            int proposedX;
            Airship res = it.next();
            int n = proposedX = this.c.sides.indexOf(this.mySide) == 0 ? -1599 : 1600 - res.getWidth() * 16 - 1;
            if (res.type.onGround) {
                proposedY = this.c.landFormations.get(0).getVerticalPosition(res, proposedX, false);
                if (!PlaceShipTool.canPlace(res, proposedX, proposedY, this.c, true)) continue;
                res.x = proposedX;
                res.y = proposedY;
                res.ai = new TacticalAI(res, this.c, this.mySide, this.enemySide);
                this.mySide.ships.add(res);
                it.remove();
                continue;
            }
            for (proposedY = (double)(512 - res.serviceCeiling()); proposedY < 512.0; proposedY += 16.0) {
                if (!PlaceShipTool.canPlace(res, proposedX, proposedY, this.c, false)) continue;
                res.x = proposedX;
                res.y = proposedY;
                res.ai = new TacticalAI(res, this.c, this.mySide, this.enemySide);
                this.mySide.ships.add(res);
                it.remove();
                continue block0;
            }
        }
        this.sideTickCounter = 20;
    }

    public void tick() {
        if (this.ship == this.mySide.ships.get(0)) {
            this.sideTick();
        }
        if (!this.ship.type.mobile) {
            return;
        }
        if (this.yIndex == -2) {
            this.yIndex = -1;
            this.ticksUntilCommand = this.mySide.ships.indexOf(this.ship) * 3 + 1;
            return;
        }
        if (this.yIndex == -1) {
            this.calculate();
            this.yIndex = 0;
        } else if (this.phaseTick++ % this.mySide.ships.size() == 0) {
            this.calculateRow(this.yIndex, this.wantsToRam(), this.wantsToBoard());
            this.yIndex = (this.yIndex + 1) % this.grid.length;
        }
        if (this.ticksUntilCommand <= 0) {
            this.checkSurrender();
            this.move();
        } else {
            --this.ticksUntilCommand;
        }
    }

    private void checkSurrender() {
        int ourStrength = 0;
        int ssz = this.mySide.ships.size();
        for (int si = 0; si < ssz; ++si) {
            Airship s = this.mySide.ships.get(si);
            if (!s.canShoot()) continue;
            ourStrength += s.getCost();
        }
        int enemyStrength = 0;
        ssz = this.enemySide.ships.size();
        for (int si = 0; si < ssz; ++si) {
            Airship s = this.enemySide.ships.get(si);
            if (!s.canShoot()) continue;
            enemyStrength += s.getCost();
        }
        if (enemyStrength > ourStrength * 8) {
            if (this.c.isMultiplayer()) {
                this.c.giveCommand(Client.msg("surrender").put("id", this.c.getIDForSide(this.mySide)));
            } else {
                this.mySide.surrendered = true;
            }
        }
    }

    private void move() {
        if (!this.ship.readyForCommand()) {
            return;
        }
        Airship boardable = this.getBoardable();
        if (boardable != null && this.ship.board == null) {
            this.c.giveCommand(Client.msg("board").put("id", this.c.getShipID(this.ship)).put("target", this.c.getShipID(boardable)));
        } else if (this.wantsToRam() && this.canRam()) {
            this.c.giveCommand(Client.msg("ram").put("id", this.c.getShipID(this.ship)).put("x", Math.min(1600.0 - this.ship.getBBWidth(), Math.max(-1600.0, this.ship.x + (double)(this.ship.flipped ? -1500 : 1500)))).put("y", this.ship.y).put("flipTo", this.ship.flipped));
            this.ticksUntilCommand = 400;
        } else {
            MoveTo mt = this.choose();
            if (mt != null) {
                this.c.giveCommand(Client.msg("moveTo").put("id", this.c.getShipID(this.ship)).put("x", mt.getMoveToPt().x).put("y", mt.getMoveToPt().y).put("flipTo", mt.flipped));
                this.ticksUntilCommand = this.gridVSize * 3 + 1;
            }
        }
    }

    public Airship getBoardable() {
        if (!this.ship.hasCrewType(CrewType.MARINE) && !this.ship.hasCrewType(CrewType.GRENADIER)) {
            return null;
        }
        int ssz = this.enemySide.ships.size();
        for (int si = 0; si < ssz; ++si) {
            boolean yep;
            Airship s = this.enemySide.ships.get(si);
            boolean bl = yep = s.x - (this.ship.x + this.ship.getBBWidth()) <= 60.0 && this.ship.x - (s.x + s.getBBWidth()) <= 60.0 && s.y - (this.ship.y + this.ship.getBBHeight()) <= 80.0 && this.ship.y - (s.y + s.getBBHeight()) <= -60.0;
            if (!yep) continue;
            return s;
        }
        return null;
    }

    public double getWorldYFromGridY(int gridX, int gridY) {
        if (this.ship.type.onGround) {
            return (double)this.c.landFormations.get(0).getVerticalPosition(this.ship, -1600 + gridX * 20, true) - this.ship.getCachedGroundOffset();
        }
        return this.gridYAnchor + gridY * 20;
    }

    public void calculate() {
        boolean wantsToRam = this.wantsToRam();
        boolean wantsToBoard = this.wantsToBoard();
        for (int gridY = 0; gridY < this.grid.length; ++gridY) {
            this.calculateRow(gridY, wantsToRam, wantsToBoard);
        }
    }

    private void calculateRow(int gridY, boolean wantsToRam, boolean wantsToBoard) {
        int asc = this.ship.availableServiceCeiling();
        for (int gridX = 0; gridX < this.grid[0].length; ++gridX) {
            double result;
            int x = -1600 + gridX * 20;
            int y = (int)this.getWorldYFromGridY(gridX, gridY);
            this.grid[gridY][gridX][0] = result = this.calculate(x, y, false, asc, wantsToRam, wantsToBoard);
            this.grid[gridY][gridX][1] = result = this.calculate(x, y, true, asc, wantsToRam, wantsToBoard);
        }
    }

    public MoveTo choose() {
        double best = -1000000.0;
        int bestY = 0;
        int bestX = 0;
        boolean bestFlipped = false;
        for (int gridY = 0; gridY < this.grid.length; ++gridY) {
            for (int gridX = 0; gridX < this.grid[0].length; ++gridX) {
                double q = this.grid[gridY][gridX][0] + (!this.ship.flipped ? 0.001 : 0.0);
                if (q > best) {
                    bestX = gridX;
                    bestY = gridY;
                    bestFlipped = false;
                    best = q;
                }
                if (!((q = this.grid[gridY][gridX][1] + (this.ship.flipped ? 0.001 : 0.0)) > best)) continue;
                bestX = gridX;
                bestY = gridY;
                bestFlipped = true;
                best = q;
            }
        }
        if (best > -1000000.0 && best > this.calculate(this.ship.x, this.ship.y, this.ship.flipped, this.ship.availableServiceCeiling(), this.wantsToRam(), this.wantsToBoard())) {
            return new MoveTo(bestX, bestY, bestFlipped);
        }
        return null;
    }

    private double awayFromCurrentPosition(double x, boolean pointingLeft, double optimalDistance, double value) {
        double distance = this.ship.flipped ? x - this.ship.x : this.ship.x - x;
        double distanceFromOptimalDistance = Math.abs(distance - optimalDistance);
        return value + 10.0 * optimalDistance - 10.0 * distanceFromOptimalDistance + (double)(pointingLeft == this.ship.flipped ? 10 : 0);
    }

    private double calculate(double x, double y, boolean pointingLeft, int asc, boolean wantsToRam, boolean wantsToBoard) {
        if (this.ship.type.onGround && this.ship.moveTo != null && Math.abs(this.ship.moveTo.x - this.ship.x) > 50.0 && this.ship.msSinceLastXMove > 500) {
            return this.awayFromCurrentPosition(x, pointingLeft, 100.0, this.calculateNormally(x, y, pointingLeft, asc, wantsToBoard));
        }
        return wantsToRam ? this.calculateRamSpot(x, y, pointingLeft, asc, wantsToBoard) : this.calculateNormally(x, y, pointingLeft, asc, wantsToBoard);
    }

    private boolean wantsToRam() {
        return !this.ship.isArmed() || this.ship.hasRam();
    }

    private boolean wantsToBoard() {
        return this.ship.hasCrewType(CrewType.MARINE) || this.ship.hasCrewType(CrewType.GRENADIER);
    }

    private boolean canRam() {
        FindClosestResult fcr = new FindClosestResult();
        this.findClosestRock(fcr, this.ship.x, this.ship.y, this.ship.flipped);
        if (fcr.invalidMove) {
            return false;
        }
        this.findRammableShip(fcr, this.ship.x, this.ship.y, this.ship.flipped);
        if (fcr.invalidMove) {
            return false;
        }
        return fcr.dist > 100.0 && fcr.dist < 1000.0 && this.enemySide.ships.contains(fcr.xClosest);
    }

    private void findClosestRock(FindClosestResult fcr, double x, double y, boolean pointingLeft) {
        int start;
        double shipW = this.ship.getBBWidth();
        double shipH = this.ship.getBBHeight();
        double lowX = Math.min(this.ship.x, x) - 1.0;
        double highX = Math.max(this.ship.x + shipW, x + shipW) + 1.0;
        double mvW = highX - lowX;
        double lowY = Math.min(this.ship.y, y) - 1.0;
        double highY = Math.max(this.ship.y + shipH, y + shipH) + 1.0;
        double mvH = highY - lowY;
        int lfsz = this.c.landFormations.size();
        for (int lfi = start = this.ship.type.onGround ? 1 : 0; lfi < lfsz; ++lfi) {
            int widen;
            LandFormation lf = this.c.landFormations.get(lfi);
            if (y + shipH > lf.y && y < lf.y + lf.getBBHeight()) {
                if (pointingLeft) {
                    if (lf.x < x) {
                        double d = x - lf.x - lf.getBBWidth();
                        if (fcr.xClosest == null || d < fcr.dist) {
                            fcr.xClosest = lf;
                            fcr.dist = d;
                        }
                    }
                } else if (lf.x > x) {
                    double d = lf.x - x - this.ship.getBBWidth();
                    if (fcr.xClosest == null || d < fcr.dist) {
                        fcr.xClosest = lf;
                        fcr.dist = d;
                    }
                }
            }
            if (Rect2D.intersects(this.ship.x - 2.0, this.ship.y - 2.0, shipW + 4.0, shipH + 4.0, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) continue;
            int n = widen = Rect2D.intersects(this.ship.x - 20.0, this.ship.y - 20.0, shipW + 40.0, shipH + 40.0, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight()) ? 0 : 5;
            if (!Rect2D.intersects(lowX - (double)widen, lowY - (double)widen, mvW + (double)(widen * 2), mvH + (double)(widen * 2), lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) continue;
            fcr.invalidMove = true;
            return;
        }
    }

    private void findClosestShip(FindClosestResult fcr, double x, double y, boolean pointingLeft, double areaY, double areaH) {
        double shipW = this.ship.getBBWidth();
        double shipH = this.ship.getBBHeight();
        double lowX = Math.min(this.ship.x, x) - 1.0;
        double highX = Math.max(this.ship.x + shipW, x + shipW) + 1.0;
        double mvW = highX - lowX;
        double lowY = this.ship.type.onGround ? y - 1.0 : Math.min(this.ship.y, y) - 1.0;
        double highY = this.ship.type.onGround ? y + shipH + 1.0 : Math.max(this.ship.y + shipH, y + shipH) + 1.0;
        double mvH = highY - lowY;
        int ssz = this.c.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side s = this.c.sides.get(si);
            int osz = s.ships.size();
            for (int oi = 0; oi < osz; ++oi) {
                int widen;
                Airship other = s.ships.get(oi);
                if (other == this.ship) continue;
                if (areaY > other.y && areaY + areaH < other.y + other.getBBHeight()) {
                    if (pointingLeft) {
                        if (other.x < x) {
                            double d = x - other.x - other.getBBWidth();
                            if (fcr.xClosest == null || d < fcr.dist) {
                                fcr.xClosest = other;
                                fcr.dist = d;
                            }
                        }
                    } else if (other.x > x) {
                        double d = other.x - x - this.ship.getBBWidth();
                        if (fcr.xClosest == null || d < fcr.dist) {
                            fcr.xClosest = other;
                            fcr.dist = d;
                        }
                    }
                }
                if (Rect2D.intersects(this.ship.x - 2.0, this.ship.y - 2.0, shipW + 4.0, shipH + 4.0, other.x, other.y, other.getBBWidth(), other.getBBHeight())) continue;
                int n = widen = Rect2D.intersects(this.ship.x - 20.0, this.ship.y - 20.0, shipW + 40.0, shipH + 40.0, other.x, other.y, other.getBBWidth(), other.getBBHeight()) ? 0 : 5;
                if (!Rect2D.intersects(lowX - (double)widen, lowY - (double)widen, mvW + (double)(widen * 2), mvH + (double)(widen * 2), other.x, other.y, other.getBBWidth(), other.getBBHeight())) continue;
                fcr.invalidMove = true;
                return;
            }
        }
    }

    private void findRammableShip(FindClosestResult fcr, double x, double y, boolean pointingLeft) {
        if (!this.ship.type.onGround && this.ship.hasRam()) {
            int msz = this.ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = this.ship.modules.get(mi);
                if (m.type != ModuleType.RAM && m.type != ModuleType.GRAND_RAM) continue;
                double my = y + (double)(m.y * 16) + (double)(m.type.getH() * 16);
                double mh = y + (double)(m.y * 16);
                this.findClosestShip(fcr, x, y, pointingLeft, my, mh);
                if (!fcr.invalidMove) continue;
                return;
            }
        } else {
            this.findClosestShip(fcr, x, y, pointingLeft, y, this.ship.getBBHeight());
        }
    }

    private double calculateRamSpot(double x, double y, boolean pointingLeft, int asc, boolean wantsToBoard) {
        if (y < (double)(512 - asc) && !this.ship.type.onGround) {
            return -1000000.0;
        }
        FindClosestResult fcr = new FindClosestResult();
        this.findClosestRock(fcr, x, y, pointingLeft);
        if (fcr.invalidMove) {
            return -1000000.0;
        }
        this.findRammableShip(fcr, x, y, pointingLeft);
        if (fcr.invalidMove) {
            return -1000000.0;
        }
        if (this.enemySide.ships.contains(fcr.xClosest)) {
            int ramDist = this.ship.type.onGround ? 200 : 800;
            return (double)ramDist - Math.abs(fcr.dist - (double)ramDist);
        }
        return this.calculateNormally(x, y, pointingLeft, asc, wantsToBoard);
    }

    private double calculateNormally(double x, double y, boolean flipped, int asc, boolean wantsToBoard) {
        Airship e;
        if (!this.ship.type.onGround && y < (double)(512 - asc)) {
            return -1000000.0;
        }
        double shipW = this.ship.getBBWidth();
        double shipH = this.ship.getBBHeight();
        double boardMult = 1.0;
        double belowMult = 1.0;
        double freeXMult = 1.0;
        double freeYMult = 1.0;
        double lowX = Math.min(this.ship.x, x) - 1.0;
        double highX = Math.max(this.ship.x + shipW, x + shipW) + 1.0;
        double mvW = highX - lowX;
        double lowY = Math.min(this.ship.y, y) - 1.0;
        double highY = Math.max(this.ship.y + shipH, y + shipH) + 1.0;
        double mvH = highY - lowY;
        if (lfs) {
            int start;
            int lfsz = this.c.landFormations.size();
            for (int lfi = start = this.ship.type.onGround ? 1 : 0; lfi < lfsz; ++lfi) {
                int widen;
                LandFormation lf = this.c.landFormations.get(lfi);
                if (Rect2D.intersects(this.ship.x - 2.0, this.ship.y - 2.0, shipW + 4.0, shipH + 4.0, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) continue;
                int n = widen = Rect2D.intersects(this.ship.x - 20.0, this.ship.y - 20.0, shipW + 40.0, shipH + 40.0, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight()) ? 0 : 5;
                if (Rect2D.intersects(lowX - (double)widen, lowY - (double)widen, mvW + (double)(widen * 2), mvH + (double)(widen * 2), lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) {
                    return -1000000.0;
                }
                if (y < lf.y + lf.getBBHeight() + 12.0 && lf.y < y + shipH + 12.0) {
                    freeXMult = 0.8;
                }
                if (!(x < lf.x + lf.getBBWidth() + 3.0) || !(lf.x < x + shipW + 3.0)) continue;
                freeYMult = 0.8;
            }
        }
        highY += this.ship.getCachedGroundOffset();
        double shipHForPreIntersect = shipH + this.ship.getCachedGroundOffset();
        int ssz = this.c.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side s = this.c.sides.get(si);
            int osz = s.ships.size();
            for (int oi = 0; oi < osz; ++oi) {
                Airship other = s.ships.get(oi);
                if (other == this.ship) continue;
                boolean wouldBeMovingAwayFromOther = Math.signum(x - other.x) == Math.signum(this.ship.x - other.x);
                double otherW = other.getBBWidth();
                double otherH = other.getBBHeight();
                boolean considerMove = s == this.mySide && other.aiTmpCanMove && other.aiTmpAvailableLift > 0;
                double otherLowX = considerMove ? Math.min(other.x, other.moveTo.x) : other.x;
                double otherLowY = considerMove ? Math.min(other.y, other.moveTo.y) : other.y;
                double otherHighX = considerMove ? Math.max(other.x + otherW, other.moveTo.x + otherW) : other.x + otherW;
                double otherHighY = considerMove ? Math.max(other.y + otherH, other.moveTo.y + otherH) : other.y + otherH;
                otherW = otherHighX - otherLowX;
                otherH = (otherHighY += other.getCachedGroundOffset()) - otherLowY;
                double otherBBHeightForPreIntersect = other.getBBHeight() + other.getCachedGroundOffset();
                if (!wouldBeMovingAwayFromOther || !Rect2D.intersects(this.ship.x - 2.0, this.ship.y - 2.0, shipW + 4.0, shipHForPreIntersect + 4.0, other.x, other.y, other.getBBWidth(), otherBBHeightForPreIntersect)) {
                    int widen;
                    int n = widen = Rect2D.intersects(this.ship.x - 20.0, this.ship.y - 20.0, shipW + 40.0, shipH + 40.0, other.x, other.y, other.getBBWidth(), other.getBBHeight()) ? 0 : 5;
                    if (Rect2D.intersects(lowX - (double)widen, lowY - (double)widen, mvW + (double)(widen * 2), mvH + (double)(widen * 2), otherLowX, otherLowY, otherW, otherH)) {
                        return -1000000.0;
                    }
                }
                if (Rect2D.intersects(x, y, shipW, shipH, otherLowX, otherLowY, otherW, 10000.0)) {
                    belowMult = 0.9;
                }
                if (y < otherHighY + 5.0 && otherLowY < y + shipH + 5.0) {
                    freeXMult = 0.8;
                }
                if (x < otherHighX && otherLowX < x + shipW) {
                    freeYMult = 0.8;
                }
                if (!wantsToBoard || !(other.x - (x + shipW) <= 60.0) || !(x - (other.x + otherW) <= 60.0) || !(other.y - (y + shipH) <= 80.0) || !(y - (other.y + otherH) <= -60.0)) continue;
                boardMult = 10.0;
            }
        }
        int esz = this.enemySide.ships.size();
        double optimumRangeMult = 1.0;
        if (this.ship.type == ShipType.LANDSHIP) {
            double div = 1.0;
            ssz = this.mySide.ships.size();
            for (int si = 0; si < ssz; ++si) {
                if (this.mySide.ships.get((int)si).type != ShipType.LANDSHIP) continue;
                div += 1.0;
            }
            optimumRangeMult = 2.0 / div;
        }
        double shootQuality = 0.1;
        int msz = this.ship.modules.size();
        block4: for (int mi = 0; mi < msz; ++mi) {
            Module m = this.ship.modules.get(mi);
            if (!m.type.isWeapon() || !m.canRun()) continue;
            for (int ei = 0; ei < esz; ++ei) {
                e = this.enemySide.ships.get(ei);
                if (!m.canHit(e, x, y, e.x, e.y, flipped, 8)) continue;
                double q = 1.0;
                int emsz = e.modules.size();
                for (int emi = 0; emi < emsz; ++emi) {
                    Module em = e.modules.get(emi);
                    if (!em.type.isWeapon() || em.hp <= 0) continue;
                    q += em.type.DPS();
                }
                if (y + this.ship.getBBHeight() < e.y) {
                    q *= 1.5;
                } else if (y < e.y) {
                    q *= 1.2;
                }
                double manhattanDist = Math.min(Math.abs(x - e.x - e.getBBWidth()), Math.abs(e.x - x - shipW)) + Math.min(Math.abs(y - e.y - e.getBBHeight()), Math.abs(e.y - y - shipH));
                shootQuality += (q *= Math.max(0.01, Math.min(1.0, (double)m.type.getOptimumRange() * optimumRangeMult / manhattanDist)));
                continue block4;
            }
        }
        double damageQuality = 1.0;
        for (int ei = 0; ei < esz; ++ei) {
            e = this.enemySide.ships.get(ei);
            int emsz = e.modules.size();
            double manhattanDist = Math.min(Math.abs(x - e.x - e.getBBWidth()), Math.abs(e.x - x - shipW)) + Math.min(Math.abs(y - e.y - e.getBBHeight()), Math.abs(e.y - y - shipH));
            for (int emi = 0; emi < emsz; ++emi) {
                Module m = e.modules.get(emi);
                if (!m.type.isWeapon() || m.hp <= 0 || !m.canHit(this.ship, e.x, e.y, x, y, e.flipped, -8)) continue;
                damageQuality += Math.min(1.0, (double)m.type.getOptimumRange() / manhattanDist) * m.type.DPS();
            }
        }
        return shootQuality / damageQuality * belowMult * freeXMult * freeYMult * boardMult;
    }

    strictfp static class FindClosestResult {
        boolean invalidMove = false;
        Body xClosest;
        double dist = 0.0;

        FindClosestResult() {
        }
    }

    public strictfp final class MoveTo {
        public final int gridX;
        public final int gridY;
        public final boolean flipped;

        public MoveTo(int gridX, int gridY, boolean flipped) {
            this.gridX = gridX;
            this.gridY = gridY;
            this.flipped = flipped;
        }

        public Pt getMoveToPt() {
            return new Pt((double)(-1600 + this.gridX * 20), TacticalAI.this.getWorldYFromGridY(this.gridX, this.gridY));
        }
    }
}

