/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Cursor;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class TargetCommandTool
implements UniScreen.Tool {
    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        double y;
        double x = us.screenToWorldX(cursor.x);
        Airship hs = TargetCommandTool.hoverShip(us, x, y = us.screenToWorldY(cursor.y));
        if (hs != null) {
            d.state.setCursor(Cursor.FULL_TARGET, Clr.RED, null);
            d.scale(us.zoom, us.zoom);
            d.shift(us.adjScrollX, us.adjScrollY);
            SelectionVisualLayer.drawGridBodyOutline(d, us, hs, SelectionVisualLayer.TARGET, SelectionVisualLayer.TARGET2);
            d.resetTransforms();
        } else {
            d.state.setCursor(Cursor.EMPTY_TARGET, Clr.RED, null);
        }
    }

    public static Airship hoverShip(UniScreen us, double x, double y) {
        Combat.Side enemy = us.combat.otherSide(us.mySide);
        for (Airship as : enemy.ships) {
            if (!Rect2D.contains(as.x, as.y, as.getBBWidth(), as.getBBHeight(), x, y)) continue;
            return as;
        }
        return null;
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        double y;
        double x = us.screenToWorldX(click.x);
        Airship hs = TargetCommandTool.hoverShip(us, x, y = us.screenToWorldY(click.y));
        if (hs != null) {
            us.combat.giveCommand(Client.msg("fireAt").put("id", us.combat.getShipID(us.selectedShip)).put("target", us.combat.getShipID(hs)));
            us.tool = UniScreen.NAVIGATE;
        }
        return true;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (in.keyPressed("ESCAPE")) {
            us.tool = UniScreen.NAVIGATE;
        }
    }
}

