/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.Perlin;
import com.zarkonnen.catengine.util.Clr;
import java.util.Random;
import org.newdawn.slick.Image;
import org.newdawn.slick.ImageBuffer;

public final class TexGen {
    public static final Clr WOOD_GRAIN = CoatEditor.BG.mix(0.1, Clr.BLACK);
    public static final Clr DARK_WOOD_GRAIN = WOOD_GRAIN.mix(0.35, Clr.BLACK);
    public static final Clr DARK_WOOD_GRAIN_B = CoatEditor.BG.mix(0.35, Clr.BLACK);
    private static Image woodGrain;
    private static Image darkWoodGrain;

    private TexGen() {
    }

    public static Image woodGrain() {
        if (woodGrain == null) {
            TexGen.renderWoodGrain();
        }
        return woodGrain;
    }

    private static void renderWoodGrain() {
        Perlin p = new Perlin(new Random(888L));
        ImageBuffer ib = new ImageBuffer(256, 256);
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256; ++x) {
                double nv = p.pnoise((double)x * 0.015, (double)y * 0.6, (double)(x + y / 8) * 0.1);
                Clr c = nv > 0.2 ? WOOD_GRAIN : CoatEditor.BG;
                ib.setRGBA(x, y, c.r, c.g, c.b, 255);
            }
        }
        woodGrain = ib.getImage();
    }

    public static Image darkWoodGrain() {
        if (darkWoodGrain == null) {
            TexGen.renderDarkWoodGrain();
        }
        return darkWoodGrain;
    }

    private static void renderDarkWoodGrain() {
        Perlin p = new Perlin(new Random(888L));
        ImageBuffer ib = new ImageBuffer(256, 256);
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256; ++x) {
                double nv = p.pnoise((double)x * 0.015, (double)y * 0.6, (double)(x + y / 8) * 0.1);
                Clr c = nv > 0.2 ? DARK_WOOD_GRAIN : DARK_WOOD_GRAIN_B;
                ib.setRGBA(x, y, c.r, c.g, c.b, 255);
            }
        }
        darkWoodGrain = ib.getImage();
    }
}

