/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class TextField {
    public String help = "";
    public String text = "";
    public boolean focus = true;
    public boolean password = false;
    private char lastChar = '\u0000';
    private int timeSinceReset = 0;
    private int msSinceKeyPress = 0;
    public String filter = " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?<>,.;:\"'@\u00a3$%^&*()[]{}|\\~/\u00b1\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00c9\u00ca\u00c8\u00e9\u00ea\u00e8\u00eb\u00c7\u00e7\u00c0\u00e0\u00e2\u00fb";
    public boolean uppercase;
    public boolean showValid = true;
    public boolean pasteButton = false;
    private final Img CLIPBOARD = new Img("spritesheet", 208, 416, 16, 16, false);
    private static final Clr INVALID = new Clr(80, 20, 20);

    public TextField(boolean password, String filter) {
        this.password = password;
        this.filter = filter;
    }

    public TextField(boolean password) {
        this.password = password;
    }

    public TextField() {
    }

    public void reset() {
        this.timeSinceReset = 0;
    }

    public char filter(char c) {
        if (c <= '\u0000' || c == '\t') {
            return '\u0000';
        }
        if (this.filter != null && !this.filter.contains(Character.toString(c))) {
            return '\u0000';
        }
        if (this.uppercase) {
            return Character.toUpperCase(c);
        }
        return c;
    }

    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        this.timeSinceReset += ms;
        this.msSinceKeyPress += ms;
        char lastInput = this.filter(in.lastInput());
        if (this.timeSinceReset > 100 && this.focus) {
            if ("BACK".equals(in.lastKeyPressed())) {
                if (!this.text.isEmpty() && this.msSinceKeyPress >= 125) {
                    this.text = this.text.substring(0, this.text.length() - 1);
                    this.msSinceKeyPress = 0;
                }
            } else if (lastInput > '\u0000' && (lastInput != this.lastChar || this.msSinceKeyPress >= 250)) {
                this.text = this.text + Character.toString(lastInput);
                this.msSinceKeyPress = 0;
            }
        }
        this.lastChar = lastInput;
    }

    public String displayText() {
        if (this.text.length() < 2) {
            return this.text;
        }
        if (this.password) {
            return this.text.substring(0, this.text.length() - 1).replaceAll(".", "*") + this.text.substring(this.text.length() - 1);
        }
        return this.text;
    }

    public void render(int x, int y, int w, MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawPanel(x, y, w, 24);
        d.rect(this.showValid ? Clr.DARK_GREY : INVALID, x + 2, y + 2, w - 4, 20.0);
        if (this.text.isEmpty()) {
            d.text("[GREY]" + this.help, AGame.FOUNT, x + 8, y + 6);
        }
        String inTxt = this.focus ? (this.timeSinceReset / 700 % 2 == 0 ? this.displayText() : this.displayText() + "|") : this.displayText();
        d.text(inTxt, AGame.FOUNT, x + 4, y + 6, w, 20, false);
        if (this.pasteButton && AGame.getClipboardString() != null) {
            d.blit(this.CLIPBOARD, Clr.LIGHT_GREY, x + w - 19, y + 4);
            d.hook(x + w - 19, y + 4, 16.0, 16.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    TextField.this.text = TextField.this.text + AGame.getClipboardString();
                }
            });
            d.tooltip(x + w - 19, y + 4, 16.0, 16.0, Lang._t("Paste", new Object[0]));
        }
    }

    public void render(int x, int y, int w, int h, MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawPanel(x, y, w, h);
        d.rect(this.showValid ? Clr.DARK_GREY : INVALID, x + 2, y + 2, w - 4, h - 4);
        if (this.text.isEmpty()) {
            d.text("[GREY]" + this.help, AGame.FOUNT, x + 8, y + 6);
        }
        String inTxt = this.focus ? (this.timeSinceReset / 700 % 2 == 0 ? this.displayText() : this.displayText() + "|") : this.displayText();
        d.text(inTxt, AGame.FOUNT, x + 4, y + 4, w, h - 4, false);
    }
}

