/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourPlate;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Decal;
import com.zarkonnen.airships.Fragment;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.catengine.util.Utils;
import java.util.List;
import org.json.JSONObject;

public strictfp class Tile
implements JSONAble {
    public static final double MIN_CREW_HARM_P = 1.5;
    public static final double PEN_TO_HARM = 0.1;
    public static final double BLAST_TO_HARM = 0.2;
    public static final double CREW_TO_HARM = 0.5;
    public int pathCostTmp;
    public int x;
    public int y;
    public ArmourPlate armour;
    public Module module;
    public boolean canOccupy;
    public boolean[][] adjacent = new boolean[3][3];
    public transient Airship ship;

    public boolean enterable() {
        return this.canOccupy && (this.armour.hp <= 0 || this.armour.type == ArmourType.NONE || this.module.type.isHatch());
    }

    public void setShip(Airship ship) {
        this.ship = ship;
        this.armour.ship = ship;
    }

    public Tile(Airship ship, Module module, int x, int y) {
        this.ship = ship;
        this.module = module;
        this.x = x;
        this.y = y;
        boolean hasWin = false;
        for (Utils.Pair<Integer, Integer> win : module.type.getWindows()) {
            if ((Integer)win.a != x - module.x || (Integer)win.b != y - module.y) continue;
            hasWin = true;
            break;
        }
        for (Utils.Pair<Integer, Integer> occ : module.type.getCanOccupy()) {
            if ((Integer)occ.a != x - module.x || (Integer)occ.b != y - module.y) continue;
            this.canOccupy = true;
            break;
        }
        this.armour = new ArmourPlate(hasWin, ship);
    }

    private Decal checkDecalDestruction() {
        for (Decal d : this.ship.decals) {
            if (!d.enabled || d.x > this.x || d.y > this.y || d.x + d.type.w <= this.x || d.y + d.type.h <= this.y) continue;
            d.enabled = false;
            return d;
        }
        return null;
    }

    public void hit(Shot shot, Combat c) {
        Crewman op;
        Decal dest;
        int pen = shot.getPenDmg();
        int blast = shot.getBlastDmg();
        int vsCrew = shot.getCrewDmg();
        int damageDone = 0;
        if (this.armour.hp > 0) {
            if (this.armour.hp > (pen = Math.max(0, pen - this.armour.type.getPenDmgAbsorb(this.ship.constructionBonuses)))) {
                damageDone += pen;
                this.armour.hp -= pen;
                pen = 0;
                blast = Math.max(0, blast - this.armour.type.getBlastDmgAbsorb(this.ship.constructionBonuses));
            } else {
                damageDone += this.armour.hp;
                pen -= this.armour.hp;
                this.armour.hp = 0;
            }
            if (this.armour.hp > blast) {
                damageDone += blast;
                this.armour.hp -= blast;
                blast = 0;
            } else {
                damageDone += this.armour.hp;
                blast -= this.armour.hp;
                this.armour.hp = 0;
            }
        }
        if ((double)this.armour.hp < (double)this.armour.getMaxHP() * 0.4 && (dest = this.checkDecalDestruction()) != null) {
            for (int dx = dest.x; dx < dest.x + dest.type.w; ++dx) {
                for (int dy = dest.y; dy < dest.y + dest.type.h; ++dy) {
                    for (int i = 0; i < 2; ++i) {
                        c.particles.add(new Particle(Particle.Type.FRAGMENT, this.ship.getX() + this.ship.gridXToWorldX(dx, 1) * 16 + 8, this.ship.getY() + dy * 16 + 8));
                    }
                }
            }
        }
        if (pen + blast + vsCrew == 0) {
            return;
        }
        int prevHP = this.module.hp;
        this.module.hp -= pen + blast;
        damageDone += pen + blast;
        boolean cheer = this.module.hp <= 0 && prevHP > 0;
        int adjFireHP = this.module.type.getFireHP() * this.module.maxHP / this.module.type.getHp();
        if (this.module.hp > 0 && this.module.hp < adjFireHP && (double)c.r.nextInt(adjFireHP) * 1.5 > (double)this.module.hp) {
            this.module.fire = Math.max(this.module.fire, 5);
            cheer = true;
        }
        if (cheer && shot.weapon != null && (op = shot.weapon.findOperator()) != null) {
            op.shout("directHit");
        }
        double harmPotential = 1.5 + (double)pen * 0.1 + (double)blast * 0.2 + (double)vsCrew * 0.5;
        for (int boarders = 0; boarders < 2; ++boarders) {
            if (boarders == 0 && !shot.harmsCrew() || boarders == 1 && !shot.harmsBoarders()) continue;
            int csz = (boarders == 1 ? this.ship.boarders : this.ship.crew).size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = (boarders == 1 ? this.ship.boarders : this.ship.crew).get(ci);
                if (cm.currentTile != this) continue;
                int harm = (int)Math.floor(c.r.nextDouble() * harmPotential);
                boolean alive = cm.alive();
                cm.hp = Math.max(0, cm.hp - harm);
                int cx = this.ship.getX() + this.ship.gridXToWorldX(this.x, 1) * 16 + 8;
                int cy = this.ship.getY() + this.y * 16 + 8;
                if (alive && !cm.alive()) {
                    c.play("death" + AGame.ANIM_R.nextInt(5), cx, cy, 1.0);
                }
                if (cm.alive() && harm > 0) {
                    cm.shout("hit");
                }
                int parts = Math.min(10, harm * 4);
                for (int i = 0; i < parts; ++i) {
                    c.particles.add(new Particle(Particle.Type.BLOOD_SPRAY, cx, cy));
                }
            }
        }
        int parts = 1 + damageDone / 6 + AGame.ANIM_R.nextInt(2);
        List<ModuleType.FragmentImg> frags = this.armour.getFragments();
        if (!frags.isEmpty()) {
            ModuleType.FragmentImg fragI = frags.get(AGame.ANIM_R.nextInt(frags.size()));
            for (int i = 0; i < parts; ++i) {
                c.fragments.add(new Fragment(fragI.img, this.ship.getX() + this.ship.gridXToWorldX(this.x, 1) * 16 + fragI.dx, this.ship.getY() + this.y * 16 + fragI.dy, AGame.ANIM_R.nextDouble() * 0.4 - 0.2, AGame.ANIM_R.nextDouble() * 0.4 - 0.2, 0.0, AGame.ANIM_R.nextDouble() * 0.02 - 0.01, 200 + AGame.ANIM_R.nextInt(500)));
            }
        }
    }

    public int getMoveDelay() {
        return this.module.type.getMoveDelay();
    }

    public void tick(Combat c, int ms, Airship ship) {
        if (this.module.fire > 0) {
            int i;
            double fireParticlesSpawn = (double)(this.module.fire * ms) * AGame.ANIM_R.nextDouble() * 0.004;
            double smokeParticlesSpawn = (double)(this.module.fire * ms) * AGame.ANIM_R.nextDouble() * 5.0E-4;
            int fireParticlesSpawned = Math.min(1, (int)Math.floor(fireParticlesSpawn) + (AGame.ANIM_R.nextDouble() < fireParticlesSpawn % 1.0 ? 1 : 0));
            int smokeParticlesSpawned = Math.min(1, (int)Math.floor(smokeParticlesSpawn) + (AGame.ANIM_R.nextDouble() < smokeParticlesSpawn % 1.0 ? 1 : 0));
            for (i = 0; i < fireParticlesSpawned; ++i) {
                c.particles.add(new Particle(Particle.Type.FIRE, ship.getX() + ship.gridXToWorldX(this.x, 1) * 16 + 8, ship.getY() + this.y * 16 + 8));
            }
            for (i = 0; i < smokeParticlesSpawned; ++i) {
                c.particles.add(new Particle(Particle.Type.FIRE_SMOKE, ship.getX() + ship.gridXToWorldX(this.x, 1) * 16 + 8, ship.getY() + this.y * 16 + 8));
            }
        }
    }

    public Tile(JSONObject o, Airship ship) {
        this.x = o.getInt("x");
        this.y = o.getInt("y");
        this.armour = new ArmourPlate(o.getJSONObject("armour"), ship);
        this.module = ship.modules.get(o.getInt("module"));
        for (Utils.Pair<Integer, Integer> occ : this.module.type.getCanOccupy()) {
            if ((Integer)occ.a != this.x - this.module.x || (Integer)occ.b != this.y - this.module.y) continue;
            this.canOccupy = true;
            break;
        }
        this.ship = ship;
    }

    @Override
    public JSONObject toJSON() {
        return new JSONObject().put("x", this.x).put("y", this.y).put("armour", this.armour.toJSON()).put("module", this.module.ship.modules.indexOf(this.module));
    }
}

