/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.CloudsVisualLayer;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.catengine.util.Clr;
import java.util.Random;
import org.newdawn.slick.Color;

public enum TimeOfDay {
    DAY(new Color[]{new Color(180, 180, 90), new Color(60, 60, 30), Color.black, Color.black}, 0.6f, 0.7f, 0.5, new Clr[]{Clr.fromHex((String)"88b1d6").mix(0.4, Clr.LIGHT_GREY), Clr.fromHex((String)"7fb1e8").mix(0.4, Clr.LIGHT_GREY), Clr.fromHex((String)"6aabed").mix(0.4, Clr.LIGHT_GREY), Clr.fromHex((String)"5ea3e9").mix(0.4, Clr.LIGHT_GREY), Clr.fromHex((String)"4b91df").mix(0.4, Clr.LIGHT_GREY)}, 150, WeatherEffect.NONE, CloudsVisualLayer.SMALL_CLOUDS, false),
    NIGHT(new Color[]{new Color(30, 30, 39), new Color(10, 10, 13), Color.black, Color.black}, 2.0f, 0.13f, 1.3, new Clr[]{Clr.fromHex((String)"070607").mix(0.5, Clr.fromHex((String)"23243f")), Clr.fromHex((String)"070607").mix(0.25, Clr.fromHex((String)"23243f")), Clr.fromHex((String)"070607").mix(0.125, Clr.fromHex((String)"23243f")), Clr.fromHex((String)"070607").mix(0.07, Clr.fromHex((String)"23243f")), Clr.fromHex((String)"070607")}, 20, WeatherEffect.NIGHT, CloudsVisualLayer.SMALL_CLOUDS, false),
    DAWN(new Color[]{Color.black, new Color(30, 15, 5), new Color(120, 40, 20), Color.black}, 1.4f, 0.3f, 0.6, new Clr[]{Clr.fromHex((String)"d9915a"), Clr.fromHex((String)"cfac89"), Clr.fromHex((String)"9f9899"), Clr.fromHex((String)"9f9899").mix(0.5, Clr.fromHex((String)"4f5d7b")), Clr.fromHex((String)"4f5d7b")}, 20, WeatherEffect.DAWN, CloudsVisualLayer.SMALL_CLOUDS, false),
    DUSK(new Color[]{new Color(120, 40, 20), new Color(30, 15, 5), Color.black, Color.black}, 1.4f, 0.3f, 0.6, new Clr[]{Clr.fromHex((String)"d9915a"), Clr.fromHex((String)"cfac89"), Clr.fromHex((String)"9f9899"), Clr.fromHex((String)"9f9899").mix(0.5, Clr.fromHex((String)"4f5d7b")), Clr.fromHex((String)"4f5d7b")}, 20, WeatherEffect.DUSK, CloudsVisualLayer.BIG_CLOUDS, true),
    SNOW(new Color[]{new Color(80, 80, 100), new Color(80, 80, 100), new Color(40, 40, 50), Color.black}, 0.9f, 0.75f, 0.6, new Clr[]{Clr.fromHex((String)"95a0b6"), Clr.fromHex((String)"95a0b6").mix(0.5, Clr.fromHex((String)"aeb4ca")), Clr.fromHex((String)"aeb4ca"), Clr.fromHex((String)"aeb4ca").mix(0.5, Clr.fromHex((String)"c0c6dc")), Clr.fromHex((String)"c0c6dc")}, 100, WeatherEffect.SNOW, CloudsVisualLayer.SMALL_CLOUDS, false),
    RAIN(new Color[]{new Color(10, 10, 10), new Color(50, 50, 50), new Color(20, 20, 20), Color.black}, 0.8f, 0.5f, 0.9, new Clr[]{Clr.fromHex((String)"675b42"), Clr.fromHex((String)"524e3c"), Clr.fromHex((String)"43463a"), Clr.fromHex((String)"505d5a"), Clr.fromHex((String)"636f68")}, 20, WeatherEffect.RAIN, CloudsVisualLayer.BIG_CLOUDS, true),
    FOG(new Color[]{new Color(10, 10, 10), new Color(50, 50, 50), new Color(20, 20, 20), Color.black}, 1.0f, 0.75f, 1.3, new Clr[]{Clr.fromHex((String)"88b1d6").mix(0.7, Clr.GREY), Clr.fromHex((String)"7fb1e8").mix(0.7, Clr.GREY), Clr.fromHex((String)"6aabed").mix(0.7, Clr.GREY), Clr.fromHex((String)"5ea3e9").mix(0.7, Clr.GREY), Clr.fromHex((String)"4b91df").mix(0.7, Clr.GREY)}, 20, WeatherEffect.FOG, CloudsVisualLayer.SMALL_CLOUDS, true),
    STORM(new Color[]{new Color(10, 10, 10), new Color(50, 50, 50), new Color(20, 20, 20), Color.black}, 1.0f, 0.5f, 1.3, new Clr[]{Clr.fromHex((String)"675b42"), Clr.fromHex((String)"524e3c"), Clr.fromHex((String)"43463a"), Clr.fromHex((String)"505d5a"), Clr.fromHex((String)"636f68")}, 20, WeatherEffect.STORM, CloudsVisualLayer.BIG_CLOUDS, true);

    public final Color[] light;
    public final float ambient;
    public final float lightStrength;
    public final double haloStrength;
    public final Clr[] skyColors;
    public final int skyColorBandHeight;
    public final WeatherEffect effect;
    public final Clr ambientTint;
    public final Color ropeColor;
    public final Clr deepSoilTint;
    public final Appearance[] clouds;
    public final boolean cloudBottomsAligned;
    public static final TimeOfDay[] TOURNAMENT;

    private TimeOfDay(Color[] light, float lightStrength, float ambient, double haloStrength, Clr[] skyColors, int skyColorBandHeight, WeatherEffect effect, Appearance[] clouds, boolean cloudBottomsAligned) {
        this.light = light;
        this.ambient = ambient;
        this.lightStrength = lightStrength;
        this.haloStrength = haloStrength;
        this.skyColorBandHeight = skyColorBandHeight;
        this.skyColors = skyColors;
        this.effect = effect;
        this.ambientTint = new Clr(0, 0, 0, (int)(255.0f - 255.0f * ambient));
        Clr ROPE_COLOR = Clr.fromHex((String)"d9cbb1");
        this.ropeColor = new Color((int)((double)ROPE_COLOR.r * (0.5 + (double)ambient)), (int)((double)ROPE_COLOR.g * (0.5 + (double)ambient)), (int)((double)ROPE_COLOR.b * (0.5 + (double)ambient)));
        float a2 = 0.1f + ambient;
        this.deepSoilTint = new Clr((int)(87.3 * (double)a2), (int)(56.7 * (double)a2), (int)(40.5 * (double)a2));
        this.clouds = clouds;
        this.cloudBottomsAligned = cloudBottomsAligned;
    }

    public static TimeOfDay getRandom(Random r) {
        return TimeOfDay.values()[r.nextInt(TimeOfDay.values().length)];
    }

    public static TimeOfDay getRandomForTournament(Random r) {
        return TOURNAMENT[r.nextInt(TOURNAMENT.length)];
    }

    static {
        TOURNAMENT = new TimeOfDay[]{DAY, NIGHT, RAIN, FOG, STORM};
    }
}

