/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Foot;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.WheelBody;

public class TroopPhysics {
    public static final double COLLISION_SPEED_SQ_TO_DAMAGE = 3.0;

    public static void tick(int ms, Combat c) {
        int ssz = c.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side side = c.sides.get(si);
            int tsz = side.troops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                double ropeLength;
                double hookY;
                double hookX;
                double distSq;
                Crewman t = side.troops.get(ti);
                t.x += (t.dx + t.mvDx) * (double)ms;
                t.y += (t.dy + t.mvDy) * (double)ms;
                boolean wasAlive = t.alive();
                t.attachedTo = null;
                int bsz = c.physics.bodies.size();
                for (int bi = 0; bi < bsz; ++bi) {
                    Body b = c.physics.bodies.get(bi);
                    if (b == t.ignoring || !Rect2D.intersects(t.x, t.y, t.getBBWidth(), t.getBBHeight(), b.x, b.y, b.getBBWidth(), b.getBBHeight()) || !b.collidesWith(t)) continue;
                    double collisionSpeedSquared = (t.dx - b.xSpeed) * (t.dx - b.xSpeed) + (t.dy - b.ySpeed) * (t.dy - b.ySpeed);
                    int dmg = (int)Math.floor(collisionSpeedSquared * 3.0);
                    if (b instanceof Foot && !side.ships.contains(((Foot)b).ship)) {
                        dmg = 10;
                    }
                    if (b instanceof WheelBody && !side.ships.contains(((WheelBody)b).ship)) {
                        dmg = 10;
                    }
                    t.hp -= dmg;
                    int parts = Math.min(10, dmg * 4);
                    for (int i = 0; i < parts; ++i) {
                        c.particles.add(new Particle(Particle.Type.BLOOD_SPRAY, t.x + 2.0, t.y + 6.0));
                    }
                    if (!t.alive() && wasAlive) {
                        c.play("death" + AGame.ANIM_R.nextInt(5), (int)t.x, (int)t.y, 1.0);
                    }
                    wasAlive = t.alive();
                    if (b instanceof WheelBody || b instanceof Foot) continue;
                    t.attachedTo = b;
                    if (b instanceof GridBody) {
                        GridBody gb = (GridBody)b;
                        double yBoundary = gb.yBoundaryAt(t.x + t.getBBWidth() / 2.0);
                        if (b.isImmobile() && b instanceof LandFormation && gb.solidAt((int)Math.floor((t.x + t.getBBWidth() / 2.0 - b.x) / 16.0), (int)Math.floor((t.y + t.getBBHeight() / 2.0 - b.y) / 16.0))) {
                            t.y = Math.min(t.y, yBoundary - t.getBBHeight() + 0.5);
                        }
                        t.standing = t.y <= yBoundary - t.getBBHeight() + 3.0 && t.y > yBoundary - t.getBBHeight() - 1.0;
                    }
                    t.dx = b.xSpeed;
                    t.dy = b.ySpeed;
                }
                if (t.attachedTo == null) {
                    t.dy += c.physics.gravity * (double)ms;
                }
                if (!t.hookLaunched || t.hookedGR == null || !((distSq = (t.x - (hookX = t.hookTarget.x + t.hookTargetBody.x + (double)(t.hookedGR.gridX * 16))) * (t.x - hookX) + (t.y - (hookY = t.hookTarget.y + t.hookTargetBody.y + (double)(t.hookedGR.gridY * 16))) * (t.y - hookY)) > (ropeLength = t.hookProgress) * ropeLength)) continue;
                double dist = Math.sqrt(distSq);
                double ropeUnitX = (t.x - hookX) / dist;
                double ropeUnitY = (t.y - hookY) / dist;
                t.x = hookX + ropeUnitX * ropeLength;
                t.y = hookY + ropeUnitY * ropeLength;
                t.dx -= t.dx * ropeUnitX * ropeUnitX / 8.0;
                t.dy -= t.dy * ropeUnitY * ropeUnitY / 8.0;
            }
        }
    }
}

