/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import org.newdawn.slick.Graphics;

public class TroopsVisualLayer
implements UniScreen.VisualLayer {
    public static final Img HOOK = new Img("spritesheet", 112, 304, 8, 7, false);

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.combat == null) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        int ssz = us.combat.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side side = us.combat.sides.get(si);
            int tsz = side.troops.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Crewman t = side.troops.get(ti);
                if (t.attachedTo == us.selectedShip && us.selectedShip != null || t.attachedTo == us.selectedLF && us.selectedLF != null) {
                    double border = 2.0 / us.zoom;
                    d.rect(SelectionVisualLayer.SELECT2, t.x - border, t.y - border, t.getBBWidth() + border * 2.0, border);
                    d.rect(SelectionVisualLayer.SELECT2, t.x - border, t.y + t.getBBHeight(), t.getBBWidth() + border * 2.0, border);
                    d.rect(SelectionVisualLayer.SELECT2, t.x - border, t.y - border, border, t.getBBHeight() + border * 2.0);
                    d.rect(SelectionVisualLayer.SELECT2, t.x + t.getBBWidth(), t.y - border, border, t.getBBHeight() + border * 2.0);
                    d.rect(SelectionVisualLayer.SELECT, t.x - (border /= 2.0), t.y - border, t.getBBWidth() + border * 2.0, border);
                    d.rect(SelectionVisualLayer.SELECT, t.x - border, t.y + t.getBBHeight(), t.getBBWidth() + border * 2.0, border);
                    d.rect(SelectionVisualLayer.SELECT, t.x - border, t.y - border, border, t.getBBHeight() + border * 2.0);
                    d.rect(SelectionVisualLayer.SELECT, t.x + t.getBBWidth(), t.y - border, border, t.getBBHeight() + border * 2.0);
                }
                t.anim.draw(d, t.x, t.y, false, us.lightingMap, tod.lightStrength, tod.ambient, tod.ambientTint);
                if (!t.hookLaunched) continue;
                double sX = t.hookSource.x;
                double sY = t.hookSource.y;
                double tX = t.hookTarget.x;
                double tY = t.hookTarget.y;
                double hX = sX + (tX - sX) * t.hookProgress / t.hookDist;
                double hY = sY + (tY - sY) * t.hookProgress / t.hookDist;
                if (t.hookedGR != null) {
                    sX = t.x;
                    sY = t.y;
                    hX = tX += t.hookTargetBody.x + (double)(t.hookedGR.gridX * 16);
                    hY = tY += t.hookTargetBody.y + (double)(t.hookedGR.gridY * 16);
                }
                d.blit(HOOK, hX - (double)(TroopsVisualLayer.HOOK.srcWidth / 2), hY - (double)(TroopsVisualLayer.HOOK.srcHeight / 2), Math.atan2(tY - sY, tX - sX));
                Graphics g = (Graphics)d.frame().nativeRenderer();
                g.setColor(tod.ropeColor);
                g.drawLine((float)(t.x + 2.0), (float)(t.y + 6.0), (float)hX, (float)hY);
            }
        }
    }
}

