/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.ConfirmDialog;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class UnderConstructionChrome
implements UniScreen.InfoPanel {
    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, final UniScreen us) {
        if (us.hideUI) {
            return;
        }
        if (us.city == null || us.city.constructing == null) {
            return;
        }
        if (!(us.intent instanceof DefencesIntent)) {
            return;
        }
        final Airship ship = us.city.constructing;
        if (us.tool instanceof PlaceShipTool && ((PlaceShipTool)us.tool).shipToPlace == ship) {
            return;
        }
        int x = (int)((double)(ship.getX() + us.adjScrollX) * us.zoom);
        int y = (int)((double)(ship.getY() + us.adjScrollY) * us.zoom);
        int w = (int)(ship.getBBWidth() * us.zoom) + 2;
        int h = (int)(ship.getBBHeight() * us.zoom);
        int completionPercent = 100 * us.city.constructionProgress / us.city.constructionTimeCost();
        d.progressBar(x, y + h + 3, w, (double)completionPercent * 0.01);
        d.text(completionPercent + "%", AGame.FOUNT, x, y + h + 24 + 6);
        d.button(x, y - 24 - 3, 60, Lang._t("Move", new Object[0]), new Runnable(){

            @Override
            public void run() {
                us.tool = new PlaceShipTool(ship, true, null, 1, true);
            }
        });
        d.button(x + 3 + 60, y - 24 - 3, 60, Lang._t("Cancel", new Object[0]), new Runnable(){

            @Override
            public void run() {
                us.confirmDialog = new ConfirmCancelConstructionDialog(us.city);
            }
        });
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }

    public static class ConfirmCancelConstructionDialog
    implements ConfirmDialog {
        public City c;

        public ConfirmCancelConstructionDialog(City c) {
            this.c = c;
        }

        public int refund() {
            return this.c.constructing.getCost() - this.c.constructionProgress / 50 + this.c.constructionProgress / 50 / 8;
        }

        @Override
        public String text() {
            return Lang._t("Cancel_construction_of_x_for_y_gold", this.c.constructing.name, this.refund());
        }

        @Override
        public String okText() {
            return Lang._t("OK", new Object[0]);
        }

        @Override
        public String cancelText() {
            return Lang._t("Cancel", new Object[0]);
        }

        @Override
        public void ok(UniScreen us) {
            us.wm.owner((City)this.c).money += this.refund();
            this.c.constructing = null;
            this.c.constructionProgress = 0;
            us.confirmDialog = null;
        }

        @Override
        public void cancel(UniScreen us) {
            us.confirmDialog = null;
        }
    }
}

