/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AIDebugLayer;
import com.zarkonnen.airships.AddConstructionButton;
import com.zarkonnen.airships.AddMultiplayerConstructionButton;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.AreaLayer;
import com.zarkonnen.airships.BackdropVisualLayer;
import com.zarkonnen.airships.BirdsVisualLayer;
import com.zarkonnen.airships.BoardingStatusChrome;
import com.zarkonnen.airships.BuildFromDesignButton;
import com.zarkonnen.airships.CameraControls;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CityNameOverlay;
import com.zarkonnen.airships.CitySpyButton;
import com.zarkonnen.airships.ClickToSelectShipChrome;
import com.zarkonnen.airships.CloudsVisualLayer;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.CombatReserveButton;
import com.zarkonnen.airships.CombatSetupHelpPanel;
import com.zarkonnen.airships.CombatSoundEffects;
import com.zarkonnen.airships.CombatSpeed;
import com.zarkonnen.airships.CombatSpeedButton;
import com.zarkonnen.airships.CommandButtonsPanel;
import com.zarkonnen.airships.ConfirmDialog;
import com.zarkonnen.airships.ConnectorsOverlay;
import com.zarkonnen.airships.DamageToolToggle;
import com.zarkonnen.airships.DefenceReserveButton;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.DisconnectionOverlay;
import com.zarkonnen.airships.DoBuildFromDefencesButton;
import com.zarkonnen.airships.DoBuildFromStrategicButton;
import com.zarkonnen.airships.DoRefitFromDefencesButton;
import com.zarkonnen.airships.DoRefitFromStrategicButton;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.EditorAttractBGLayer;
import com.zarkonnen.airships.EditorAttractIntent;
import com.zarkonnen.airships.EspionageIntent;
import com.zarkonnen.airships.FireArcs;
import com.zarkonnen.airships.FleeButton;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.FleetCostPanel;
import com.zarkonnen.airships.FlipPlaceShipButton;
import com.zarkonnen.airships.FlipShipButton;
import com.zarkonnen.airships.FloatieVisualLayer;
import com.zarkonnen.airships.FollowActionButton;
import com.zarkonnen.airships.FragmentVisualLayer;
import com.zarkonnen.airships.HelpButton;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.LandFormationVisualLayer;
import com.zarkonnen.airships.LandscapeEditorPanel;
import com.zarkonnen.airships.LandscapeEditorToggle;
import com.zarkonnen.airships.LeaveMPSetupButton;
import com.zarkonnen.airships.LeaveShipEditorButton;
import com.zarkonnen.airships.LeaveToMainMenuButton;
import com.zarkonnen.airships.LeaveToStrategicScreenButton;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.LightMapLayer;
import com.zarkonnen.airships.LobbyChat;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MessageDialog;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleProfilePanel;
import com.zarkonnen.airships.MoveShipButton;
import com.zarkonnen.airships.MoveTargetVisualLayer;
import com.zarkonnen.airships.MultiplayerChat;
import com.zarkonnen.airships.MultiplayerSurrenderButton;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.OpenDesignButton;
import com.zarkonnen.airships.ParticleVisualLayer;
import com.zarkonnen.airships.ReadyButton;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RemoveShipButton;
import com.zarkonnen.airships.RenameShipChrome;
import com.zarkonnen.airships.ReservePanel;
import com.zarkonnen.airships.ReservePanelToggle;
import com.zarkonnen.airships.SaveDesignButton;
import com.zarkonnen.airships.ScrapShipButton;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.SetupExplanationFloat;
import com.zarkonnen.airships.ShipLayers;
import com.zarkonnen.airships.ShipSpyButton;
import com.zarkonnen.airships.ShipTooltipChrome;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.ShipWarningsChrome;
import com.zarkonnen.airships.ShotVisualLayer;
import com.zarkonnen.airships.ShoutOverlay;
import com.zarkonnen.airships.SkyVisualLayer;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.StartCombatButton;
import com.zarkonnen.airships.StartDesignFromDefencesButton;
import com.zarkonnen.airships.StartRefitFromDefencesButton;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.ToggleAIControlButton;
import com.zarkonnen.airships.ToggleShowOutsideButton;
import com.zarkonnen.airships.TroopsVisualLayer;
import com.zarkonnen.airships.UnderConstructionChrome;
import com.zarkonnen.airships.UnderConstructionLayer;
import com.zarkonnen.airships.UpperWeatherVisualLayer;
import com.zarkonnen.airships.VictoryOrDefeatOverlay;
import com.zarkonnen.airships.WeatherStatusOverlay;
import com.zarkonnen.airships.WeatherVisualLayer;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class UniScreen
implements Screen {
    public static final Img LEFT_ARROW = new Img("spritesheet", 224, 512, 16, 16, false);
    public static final Img RIGHT_ARROW = new Img("spritesheet", 112, 512, 16, 16, false);
    public static final Tool NAVIGATE = new Tool(){

        @Override
        public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        }

        @Override
        public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
            return false;
        }

        @Override
        public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
            return false;
        }

        @Override
        public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
            return false;
        }

        @Override
        public void tick(Input in, int ms, UniScreen us) {
        }
    };
    public WorldMap wm;
    public City city;
    public Combat combat;
    public Combat.Side mySide;
    public ArrayList<Airship> setupFleet;
    public LandFormation setupGround;
    public ArrayList<LandFormation> setupFloaters;
    public CombatBackgroundFlavor setupBG;
    public TimeOfDay setupTime;
    public Airship standaloneEditShip;
    public Image[] lightingMap;
    public AirshipGame g;
    public boolean hideUI = false;
    public Airship followShip;
    public boolean attractMode;
    public boolean overrideCamera;
    public int attractTime;
    public int followIndex = 0;
    public int topBarScroll = 0;
    public int scrollRange = 0;
    public ArrayList<VisualLayer> lowerVisualLayers = new ArrayList();
    public ArrayList<VisualLayer> upperVisualLayers = new ArrayList();
    public ArrayList<Button> buttons = new ArrayList();
    public ArrayList<InfoPanel> infoPanels = new ArrayList();
    public ArrayList<InfoPanel> floats = new ArrayList();
    public Tool tool = NAVIGATE;
    public Intent intent;
    public ArrayList<ShipOverlay> shipOverlays = new ArrayList();
    public ArrayList<ShipButton> shipButtons = new ArrayList();
    public ArrayList<ShipChrome> shipChromes = new ArrayList();
    public ArrayList<InfoPanel> overlays = new ArrayList();
    public ConfirmDialog confirmDialog;
    public int scrollX;
    public int scrollY;
    public int adjScrollX;
    public int adjScrollY;
    public int sscrollX;
    public int sscrollY;
    public double zoom = 1.0;
    public int time = 0;
    public Airship selectedShip;
    public LandFormation selectedLF;
    public TimeOfDay bakedTOD;
    public boolean allOutside = false;

    public TimeOfDay getTimeOfDay() {
        if (this.combat != null) {
            return this.combat.timeOfDay;
        }
        if (this.setupTime != null) {
            return this.setupTime;
        }
        return TimeOfDay.DAY;
    }

    public boolean textInputOccurring() {
        int ipl = this.infoPanels.size();
        for (int ipi = 0; ipi < ipl; ++ipi) {
            if (!this.infoPanels.get(ipi).chatEnabled(this)) continue;
            return true;
        }
        int ol = this.overlays.size();
        for (int oi = 0; oi < ol; ++oi) {
            if (!this.overlays.get(oi).chatEnabled(this)) continue;
            return true;
        }
        int scl = this.shipChromes.size();
        for (int sci = 0; sci < scl; ++sci) {
            if (!this.shipChromes.get(sci).textInputOccurring(this)) continue;
            return true;
        }
        return false;
    }

    public UniScreen(AirshipGame g, Intent intent) {
        this.g = g;
        this.intent = intent;
        this.lowerVisualLayers.add(new LightMapLayer());
        this.lowerVisualLayers.add(new SkyVisualLayer());
        this.lowerVisualLayers.add(new CloudsVisualLayer());
        this.lowerVisualLayers.add(new SelectionVisualLayer());
        this.lowerVisualLayers.add(new BackdropVisualLayer());
        this.lowerVisualLayers.add(new FloatieVisualLayer());
        this.lowerVisualLayers.add(new BirdsVisualLayer());
        this.lowerVisualLayers.add(new AreaLayer());
        this.lowerVisualLayers.add(new WeatherVisualLayer());
        this.lowerVisualLayers.add(new LandFormationVisualLayer());
        this.lowerVisualLayers.add(new MoveTargetVisualLayer());
        this.lowerVisualLayers.add(new EditorAttractBGLayer());
        this.upperVisualLayers.add(new FragmentVisualLayer());
        this.upperVisualLayers.add(new TroopsVisualLayer());
        this.upperVisualLayers.add(new UnderConstructionLayer());
        this.upperVisualLayers.add(new ShotVisualLayer());
        this.upperVisualLayers.add(new ParticleVisualLayer());
        this.upperVisualLayers.add(new UpperWeatherVisualLayer());
        this.upperVisualLayers.add(new AIDebugLayer());
        this.shipOverlays.add(new DisconnectionOverlay());
        this.shipOverlays.add(new ConnectorsOverlay());
        this.shipChromes.add(new FireArcs());
        this.shipChromes.add(new BoardingStatusChrome());
        this.shipChromes.add(new ClickToSelectShipChrome());
        this.shipChromes.add(new ShipWarningsChrome());
        this.shipChromes.add(new RenameShipChrome());
        this.shipChromes.add(new ShipTooltipChrome());
        this.shipButtons.add(new MoveShipButton());
        this.shipButtons.add(new RemoveShipButton());
        this.shipButtons.add(new ScrapShipButton());
        this.shipButtons.add(new StartRefitFromDefencesButton());
        this.shipButtons.add(new DefenceReserveButton());
        this.shipButtons.add(new CombatReserveButton());
        for (Spy.ShipSpyAction shipSpyAction : Spy.ShipSpyAction.values()) {
            this.shipButtons.add(new ShipSpyButton(shipSpyAction));
        }
        this.buttons.add(new HelpButton());
        this.buttons.add(new ReadyButton());
        this.buttons.add(new StartCombatButton());
        this.buttons.add(new DoRefitFromStrategicButton());
        this.buttons.add(new DoBuildFromStrategicButton());
        this.buttons.add(new FleeButton());
        this.buttons.add(new LeaveToStrategicScreenButton());
        this.buttons.add(new DamageToolToggle());
        for (Enum enum_ : ShipType.values()) {
            this.buttons.add(new BuildFromDesignButton((ShipType)enum_));
        }
        for (Enum enum_ : ShipType.values()) {
            this.buttons.add(new StartDesignFromDefencesButton((ShipType)enum_));
        }
        this.buttons.add(new LeaveMPSetupButton());
        this.buttons.add(new FlipPlaceShipButton());
        for (Enum enum_ : ShipType.values()) {
            this.buttons.add(new AddMultiplayerConstructionButton((ShipType)enum_));
        }
        this.buttons.add(new LeaveToMainMenuButton());
        this.buttons.add(new LeaveShipEditorButton());
        this.buttons.add(new DoBuildFromDefencesButton());
        this.buttons.add(new DoRefitFromDefencesButton());
        for (Enum enum_ : ShipType.values()) {
            this.buttons.add(new AddConstructionButton((ShipType)enum_, 1));
        }
        for (Enum enum_ : ShipType.values()) {
            this.buttons.add(new AddConstructionButton((ShipType)enum_, 0));
        }
        this.buttons.add(new SaveDesignButton());
        this.buttons.add(new OpenDesignButton());
        this.buttons.add(new FlipShipButton());
        this.buttons.add(new FollowActionButton());
        this.buttons.add(new ZoomToFitButton());
        this.buttons.add(new ToggleShowOutsideButton());
        this.buttons.add(new ToggleAIControlButton());
        this.buttons.add(new MultiplayerSurrenderButton());
        this.buttons.add(new ReservePanelToggle());
        this.buttons.add(new LandscapeEditorToggle());
        for (Enum enum_ : Spy.CitySpyAction.values()) {
            this.buttons.add(new CitySpyButton((Spy.CitySpyAction)enum_));
        }
        for (int i = CombatSpeed.values().length - 1; i >= 0; --i) {
            this.buttons.add(new CombatSpeedButton(CombatSpeed.values()[i]));
        }
        this.infoPanels.add(new ShoutOverlay());
        this.infoPanels.add(new WeatherStatusOverlay());
        this.infoPanels.add(new UnderConstructionChrome());
        this.infoPanels.add(new LobbyChat());
        this.infoPanels.add(new EditInfoPanel());
        this.infoPanels.add(new EditPalettePanel());
        this.infoPanels.add(new ReservePanel());
        this.infoPanels.add(new LandscapeEditorPanel());
        this.infoPanels.add(new ModuleProfilePanel());
        this.infoPanels.add(new CameraControls());
        this.infoPanels.add(new CommandButtonsPanel());
        this.infoPanels.add(new MultiplayerChat());
        this.overlays.add(new CityNameOverlay());
        this.overlays.add(new VictoryOrDefeatOverlay());
        this.overlays.add(new CombatSoundEffects());
        this.floats.add(new SetupExplanationFloat());
        this.floats.add(new CombatSetupHelpPanel());
        this.floats.add(new FleetCostPanel());
    }

    public <T extends InfoPanel> T panel(Class<T> c) {
        int ipl = this.infoPanels.size();
        for (int ipi = 0; ipi < ipl; ++ipi) {
            InfoPanel ip = this.infoPanels.get(ipi);
            if (!c.isInstance(ip)) continue;
            return (T)ip;
        }
        return null;
    }

    public <T extends Button> T button(Class<T> c) {
        int bl = this.buttons.size();
        for (int bi = 0; bi < bl; ++bi) {
            Button b = this.buttons.get(bi);
            if (!c.isInstance(b)) continue;
            return (T)b;
        }
        return null;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        int vli;
        MainMenu mm;
        ScreenMode sm = in.mode();
        if (this.time == 0 && this.zoom == 1.0) {
            this.zoom = (double)sm.width / 800.0;
        }
        this.time += ms;
        this.intent.tick(in, ms, this);
        if (this.attractMode && (this.combat.isFinished() || this.combat.isBoring() || this.combat.time > 120000 || this.g.mouseMoved)) {
            mm = new MainMenu(this.g);
            mm.idleTime = this.g.mouseMoved ? 0 : 15000;
            this.g.s = mm;
        }
        if (this.intent instanceof EditorAttractIntent && this.g.mouseMoved) {
            mm = new MainMenu(this.g);
            mm.idleTime = this.g.mouseMoved ? 0 : 15000;
            this.g.s = mm;
        }
        if (this.attractMode) {
            this.attractTime += ms;
            if (this.followShip != null && !this.combat.sides.get((int)0).ships.contains(this.followShip) && !this.combat.sides.get((int)1).ships.contains(this.followShip)) {
                this.attractTime = 10000;
            }
            if (this.attractTime >= 8000) {
                this.attractTime = 0;
                if (AGame.ANIM_R.nextBoolean()) {
                    this.button(FollowActionButton.class).follow = true;
                    this.followShip = null;
                } else {
                    Combat.Side s = this.combat.sides.get(0);
                    int fi = this.followIndex;
                    if (s.ships.size() <= fi) {
                        fi -= s.ships.size();
                        s = this.combat.sides.get(1);
                    }
                    if (s.ships.size() <= fi) {
                        s = this.combat.sides.get(0);
                        this.followIndex = 0;
                        fi = 0;
                    }
                    if (!s.ships.isEmpty()) {
                        this.button(FollowActionButton.class).follow = false;
                        this.followShip = s.ships.get(this.followIndex++ % s.ships.size());
                        this.zoom = AGame.ANIM_R.nextInt(2) + 2;
                    }
                }
            }
        }
        if (!this.overrideCamera) {
            boolean arrowKeysInUse = false;
            for (InfoPanel ip : this.infoPanels) {
                arrowKeysInUse = arrowKeysInUse || ip.arrowKeysInUse(this);
            }
            for (InfoPanel ip : this.floats) {
                arrowKeysInUse = arrowKeysInUse || ip.arrowKeysInUse(this);
            }
            for (InfoPanel ip : this.overlays) {
                arrowKeysInUse = arrowKeysInUse || ip.arrowKeysInUse(this);
            }
            if (!arrowKeysInUse) {
                if (this.followShip != null) {
                    if (in.keyDown("UP")) {
                        this.sscrollY = (int)((double)this.sscrollY + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown("DOWN")) {
                        this.sscrollY = (int)((double)this.sscrollY - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown("LEFT")) {
                        this.sscrollX = (int)((double)this.sscrollX + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown("RIGHT")) {
                        this.sscrollX = (int)((double)this.sscrollX - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    this.scrollX = (int)(-(this.followShip.x + this.followShip.getBBWidth() / 2.0)) + this.sscrollX;
                    this.scrollY = (int)(-(this.followShip.y + this.followShip.getBBHeight() / 2.0)) + this.sscrollY;
                } else {
                    if (in.keyDown("UP") || cursor.y < 2.0) {
                        this.scrollY = (int)((double)this.scrollY + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown("DOWN") || cursor.y > (double)(in.mode().height - 2)) {
                        this.scrollY = (int)((double)this.scrollY - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown("LEFT") || cursor.x < 2.0) {
                        this.scrollX = (int)((double)this.scrollX + ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                    if (in.keyDown("RIGHT") || cursor.x > (double)(in.mode().width - 2)) {
                        this.scrollX = (int)((double)this.scrollX - ((double)AirshipGame.scrollSpeed / this.zoom + 1.0));
                    }
                }
            }
            if (in.keyDown("ADD")) {
                this.zoom *= 1.03;
            }
            if (in.keyDown("SUBTRACT")) {
                this.zoom /= 1.03;
            }
        }
        if (this.confirmDialog != null) {
            if (in.keyPressed("ESCAPE")) {
                this.confirmDialog.cancel(this);
            } else if (in.keyPressed("ENTER")) {
                this.confirmDialog.ok(this);
            }
            return;
        }
        int vll = this.lowerVisualLayers.size();
        for (vli = 0; vli < vll; ++vli) {
            this.lowerVisualLayers.get(vli).tick(in, ms, this);
        }
        vll = this.upperVisualLayers.size();
        for (vli = 0; vli < vll; ++vli) {
            this.upperVisualLayers.get(vli).tick(in, ms, this);
        }
        int ipl = this.infoPanels.size();
        for (int ipi = 0; ipi < ipl; ++ipi) {
            this.infoPanels.get(ipi).tick(in, ms, this);
        }
        if (in.scrollAmount() != 0 && cursor == null || cursor.y > 43.0) {
            boolean captured = false;
            for (int ipi = 0; ipi < ipl; ++ipi) {
                if (!this.infoPanels.get(ipi).doScroll(this, in.scrollAmount(), cursor, sm)) continue;
                captured = true;
                break;
            }
            if (!captured && !this.overrideCamera) {
                this.zoom *= Math.pow(1.0003, in.scrollAmount());
            }
        }
        if (in.scrollAmount() != 0 && cursor.y <= 43.0) {
            this.topBarScroll += in.scrollAmount() / 2;
            this.topBarScroll = Math.min(this.scrollRange, Math.max(0, this.topBarScroll));
        }
        if (!this.overrideCamera) {
            if (this.zoom > 16.1) {
                this.zoom = 16.1;
            }
            if (this.zoom < 0.49 * (double)sm.width / 1024.0) {
                this.zoom = 0.49 * (double)sm.width / 1024.0;
            }
        }
        this.adjScrollX = this.scrollX + (int)((double)(sm.width / 2) / this.zoom);
        this.adjScrollY = this.scrollY + (int)((double)(sm.height / 2) / this.zoom);
        if (!this.overrideCamera) {
            while (this.screenToWorldX(0.0) <= -1600.0) {
                --this.scrollX;
                this.adjScrollX = this.scrollX + (int)((double)(sm.width / 2) / this.zoom);
            }
            while (this.screenToWorldX(sm.width) >= 1600.0) {
                ++this.scrollX;
                this.adjScrollX = this.scrollX + (int)((double)(sm.width / 2) / this.zoom);
            }
            while (this.screenToWorldY(0.0) <= -1988.0) {
                --this.scrollY;
                this.adjScrollY = this.scrollY + (int)((double)(sm.height / 2) / this.zoom);
            }
            while (this.screenToWorldY(sm.height) >= 1012.0) {
                ++this.scrollY;
                this.adjScrollY = this.scrollY + (int)((double)(sm.height / 2) / this.zoom);
            }
        }
        this.tool.tick(in, ms, this);
        Pt mouseDown = in.mouseDown();
        if (mouseDown != null && mouseDown.y > 43.0) {
            this.tool.mouseDown(in, mouseDown, sm, this);
        }
        if (click != null && click.y > 43.0 && drawState.canClick()) {
            if (in.clickButton() == 2) {
                if (this.tool.rightClick(in, click, sm, this)) {
                    drawState.hasClicked();
                }
            } else if (this.tool.click(in, click, sm, this)) {
                drawState.hasClicked();
            }
        }
        int sbl = this.shipButtons.size();
        for (int sbi = 0; sbi < sbl; ++sbi) {
            this.shipButtons.get(sbi).tick(in, ms, this);
        }
        int scl = this.shipChromes.size();
        for (int sci = 0; sci < scl; ++sci) {
            this.shipChromes.get(sci).tick(in, ms, this);
        }
        int bl = this.buttons.size();
        for (int bi = 0; bi < bl; ++bi) {
            Button b = this.buttons.get(bi);
            if (!b.visible(this)) continue;
            b.tick(in, this);
        }
        int oll = this.overlays.size();
        for (int oli = 0; oli < oll; ++oli) {
            this.overlays.get(oli).tick(in, ms, this);
        }
        int fll = this.floats.size();
        for (int fli = 0; fli < fll; ++fli) {
            this.floats.get(fli).tick(in, ms, this);
        }
        if (!this.textInputOccurring()) {
            for (int bi = 0; bi < bl; ++bi) {
                Button b = this.buttons.get(bi);
                if (!b.visible(this) || b.hotkey(this) == null || !b.enabled(this) || !in.keyPressed(b.hotkey(this))) continue;
                b.click(in, this);
                break;
            }
        }
    }

    public double screenToWorldX(double x) {
        return x / this.zoom - (double)this.adjScrollX;
    }

    public double screenToWorldY(double y) {
        return y / this.zoom - (double)this.adjScrollY;
    }

    public double worldToScreenX(double x) {
        return (x + (double)this.adjScrollX) * this.zoom;
    }

    public double worldToScreenY(double y) {
        return (y + (double)this.adjScrollY) * this.zoom;
    }

    private void drawShipChrome(MyDraw d, Airship ship, Combat.Side side, ShipChrome sc, Pt cursor, ScreenMode sm) {
        int x = (int)((double)(ship.getX() + this.adjScrollX) * this.zoom);
        int y = (int)((double)(ship.getY() + this.adjScrollY) * this.zoom);
        int w = (int)(ship.getBBWidth() * this.zoom);
        int h = (int)(ship.getBBHeight() * this.zoom);
        sc.draw(d, cursor, ship, side, x, y, w, h, sm, this);
    }

    private void drawShipButton(MyDraw d, final Airship ship, final ShipButton sb, final Combat.Side side, int[] offsets) {
        if (this.hideUI) {
            return;
        }
        if (!sb.acceptsTool(this.tool)) {
            return;
        }
        if (!sb.visible(ship, side, this)) {
            return;
        }
        int x = (int)((double)(ship.getX() + this.adjScrollX) * this.zoom);
        int y = (int)((double)(ship.getY() + this.adjScrollY) * this.zoom);
        int w = (int)(ship.getBBWidth() * this.zoom);
        String text = sb.text(ship, side, this);
        int bw = (int)d.textSize((String)text, (Fount)AGame.BIG_FOUNT).x + 20;
        if (offsets[0] > 0 && offsets[0] + bw > w) {
            offsets[0] = 0;
            offsets[1] = offsets[1] - 27;
        }
        final UniScreen us = this;
        d.button(x + offsets[0], y - 24 - 3 + offsets[1], bw, sb.text(ship, side, this), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                sb.click(in, ship, side, us);
            }
        }, sb.enabled(ship, side, us));
        offsets[0] = offsets[0] + (bw + 3);
    }

    public static boolean isShipInCropRect(Airship ship, double cropX, double cropY, double cropW, double cropH) {
        double sx = ship.x;
        double sy = ship.y;
        double sRight = ship.x + ship.getBBWidth();
        double sBottom = ship.y + ship.getBBHeight();
        int msz = ship.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = ship.modules.get(mi);
            double mx = ship.x + (double)(ship.gridXToWorldX(m.x, m.type.getW()) * 16);
            double my = ship.y + (double)(m.y * 16) + (double)(m.type.getH() * 16);
            int ll = m.legs.size();
            for (int li = 0; li < ll; ++li) {
                Leg l = m.legs.get(li);
                if (l.spec.upperLeg == null) continue;
                double legW = l.spec.upperLeg.srcHeight;
                double hipX = ship.flipped ? mx + ((double)m.type.getW() - l.spec.xOffset) * 16.0 : mx + l.spec.xOffset * 16.0;
                double hipY = my + l.spec.yOffset * 16.0;
                double kneeX = hipX + Math.cos(l.upperRotation) * l.spec.limbLength;
                double kneeY = hipY + Math.sin(l.lowerRotation) * l.spec.limbLength;
                sx = Math.min(kneeX - legW / 2.0, sx);
                sRight = Math.max(kneeX + legW / 2.0, sRight);
                sy = Math.min(kneeY - legW / 2.0, sy);
                sBottom = Math.max(kneeY + legW / 2.0, sBottom);
                double footX = kneeX + Math.cos(l.lowerRotation) * l.spec.limbLength;
                double footY = kneeY + Math.sin(l.lowerRotation) * l.spec.limbLength;
                sx = Math.min(footX - legW / 2.0, sx);
                sRight = Math.max(footX + legW / 2.0, sRight);
                sy = Math.min(footY - legW / 2.0, sy);
                sBottom = Math.max(footY + l.spec.footHeight + legW / 2.0, sBottom);
            }
        }
        return Rect2D.intersects(cropX, cropY, cropW, cropH, sx, sy, sRight - sx, sBottom - sy);
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        Airship ship;
        int ai;
        if (this.lightingMap == null && Appearance.useLighting && !Appearance.useSimpleGraphics) {
            try {
                this.lightingMap = new Image[4];
                for (int i = 0; i < 4; ++i) {
                    this.lightingMap[i] = new Image(sm.width / 4, sm.height / 4);
                }
            }
            catch (SlickException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.lightingMap != null && (!Appearance.useLighting || Appearance.useSimpleGraphics)) {
            this.lightingMap = null;
        }
        if (this.hideUI) {
            d.state.setCursor(null, Clr.WHITE, null);
        } else {
            d.state.resetCursor();
        }
        d.rect(this.getTimeOfDay().skyColors[4], 0.0, 0.0, sm.width, sm.height);
        d.scale(this.zoom, this.zoom);
        d.shift(this.adjScrollX, this.adjScrollY);
        double cropX = this.screenToWorldX(0.0);
        double cropY = this.screenToWorldY(0.0);
        double cropW = this.screenToWorldX(sm.width) - cropX;
        double cropH = this.screenToWorldY(sm.height) - cropY;
        int vll = this.lowerVisualLayers.size();
        for (int vli = 0; vli < vll; ++vli) {
            this.lowerVisualLayers.get(vli).draw(d, this, cropX, cropY, cropW, cropH);
        }
        TimeOfDay tod = this.getTimeOfDay();
        for (ShipLayer shipLayer : ShipLayers.ALL) {
            if (!shipLayer.doDraw(this.zoom)) continue;
            shipLayer.lockShader(d, this.zoom, this.lightingMap, tod.lightStrength, tod.ambient);
            if (this.combat != null) {
                int sl = this.combat.sides.size();
                for (int si = 0; si < sl; ++si) {
                    Combat.Side side = this.combat.sides.get(si);
                    int al = side.ships.size();
                    for (ai = 0; ai < al; ++ai) {
                        boolean inside;
                        ship = side.ships.get(ai);
                        if (!UniScreen.isShipInCropRect(ship, cropX, cropY, cropW, cropH)) continue;
                        boolean bl = side == this.mySide ? ship.commandPointsGenerated() > 0 : (inside = !ship.boarders.isEmpty());
                        if (this.allOutside) {
                            inside = false;
                        }
                        shipLayer.draw(ship, d, !inside, this.zoom, ship.getX(), ship.getY(), this.time, true, this.intent.showDecals(), side.arms, this.zoom >= 1.0, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientTint);
                    }
                }
            } else if (this.city != null) {
                CoatOfArms ownerCOA = this.wm.owner((City)this.city).arms;
                Fleet garrison = this.wm.getGarrison(this.city);
                for (Airship ship2 : this.city.getDefences()) {
                    if (!UniScreen.isShipInCropRect(ship2, cropX, cropY, cropW, cropH)) continue;
                    shipLayer.draw(ship2, d, this.intent.showOutside(), this.zoom, ship2.getX(), ship2.getY(), this.time, true, this.intent.showDecals(), ownerCOA, this.zoom >= 1.0, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientTint);
                }
                if (garrison != null) {
                    int al = garrison.actives.size();
                    for (int ai2 = 0; ai2 < al; ++ai2) {
                        Airship ship3 = garrison.actives.get(ai2);
                        if (!UniScreen.isShipInCropRect(ship3, cropX, cropY, cropW, cropH)) continue;
                        shipLayer.draw(ship3, d, this.intent.showOutside(), this.zoom, ship3.getX(), ship3.getY(), this.time, true, this.intent.showDecals(), ownerCOA, this.zoom >= 1.0, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientTint);
                    }
                }
            } else if (this.setupFleet != null) {
                CoatOfArms coa = this.g.getBestCOA();
                int al = this.setupFleet.size();
                for (int ai3 = 0; ai3 < al; ++ai3) {
                    Airship ship4 = this.setupFleet.get(ai3);
                    if (!UniScreen.isShipInCropRect(ship4, cropX, cropY, cropW, cropH)) continue;
                    shipLayer.draw(ship4, d, this.intent.showOutside(), this.zoom, ship4.getX(), ship4.getY(), this.time, true, this.intent.showDecals(), coa, this.zoom > 0.75, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientTint);
                }
            } else if (this.standaloneEditShip != null) {
                CoatOfArms coa = this.intent instanceof EditShipIntent ? ((EditShipIntent)this.intent).getArms(this) : (this.intent instanceof EditorAttractIntent ? ((EditorAttractIntent)this.intent).coa : this.g.getBestCOA());
                shipLayer.draw(this.standaloneEditShip, d, this.intent.showOutside(), this.zoom, this.standaloneEditShip.getX(), this.standaloneEditShip.getY(), this.time, true, this.intent.showDecals(), coa, this.zoom >= 1.0, this.lightingMap, tod.lightStrength, tod.ambient, tod.ambientTint);
            }
            shipLayer.unlockShader(this.lightingMap, this.zoom);
        }
        for (ShipOverlay so : this.shipOverlays) {
            if (this.combat != null) {
                int sl = this.combat.sides.size();
                for (int si = 0; si < sl; ++si) {
                    Combat.Side side = this.combat.sides.get(si);
                    int al = side.ships.size();
                    for (ai = 0; ai < al; ++ai) {
                        ship = side.ships.get(ai);
                        if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship.x, ship.y, ship.getBBWidth(), ship.getBBHeight())) continue;
                        so.draw(d, ship, this);
                    }
                }
                continue;
            }
            if (this.city != null) {
                Fleet garrison = this.wm.getGarrison(this.city);
                for (Airship ship5 : this.city.getDefences()) {
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship5.x, ship5.y, ship5.getBBWidth(), ship5.getBBHeight())) continue;
                    so.draw(d, ship5, this);
                }
                if (garrison == null) continue;
                int al = garrison.actives.size();
                for (int ai4 = 0; ai4 < al; ++ai4) {
                    Airship ship6 = garrison.actives.get(ai4);
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship6.x, ship6.y, ship6.getBBWidth(), ship6.getBBHeight())) continue;
                    so.draw(d, ship6, this);
                }
                continue;
            }
            if (this.setupFleet != null) {
                int al = this.setupFleet.size();
                for (int ai5 = 0; ai5 < al; ++ai5) {
                    Airship ship7 = this.setupFleet.get(ai5);
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship7.x, ship7.y, ship7.getBBWidth(), ship7.getBBHeight())) continue;
                    so.draw(d, ship7, this);
                }
                continue;
            }
            if (this.standaloneEditShip == null) continue;
            so.draw(d, this.standaloneEditShip, this);
        }
        vll = this.upperVisualLayers.size();
        for (int vli = 0; vli < vll; ++vli) {
            this.upperVisualLayers.get(vli).draw(d, this, cropX, cropY, cropW, cropH);
        }
        d.resetTransforms();
        int[] offsets = new int[]{0, 0};
        if (this.combat != null) {
            int sl = this.combat.sides.size();
            for (int si = 0; si < sl; ++si) {
                Combat.Side side = this.combat.sides.get(si);
                int al = side.ships.size();
                for (int ai6 = 0; ai6 < al; ++ai6) {
                    Airship ship8 = side.ships.get(ai6);
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship8.x, ship8.y, ship8.getBBWidth(), ship8.getBBHeight())) continue;
                    offsets[0] = 0;
                    offsets[1] = 0;
                    int sbl = this.shipButtons.size();
                    for (int sbi = 0; sbi < sbl; ++sbi) {
                        this.drawShipButton(d, ship8, this.shipButtons.get(sbi), side, offsets);
                    }
                }
            }
        } else if (this.city != null) {
            Fleet garrison = this.wm.getGarrison(this.city);
            for (Airship ship9 : this.city.getDefences()) {
                if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship9.x, ship9.y, ship9.getBBWidth(), ship9.getBBHeight())) continue;
                offsets[0] = 0;
                offsets[1] = 0;
                int sbl = this.shipButtons.size();
                for (int sbi = 0; sbi < sbl; ++sbi) {
                    this.drawShipButton(d, ship9, this.shipButtons.get(sbi), null, offsets);
                }
            }
            if (garrison != null) {
                int al = garrison.actives.size();
                for (int ai7 = 0; ai7 < al; ++ai7) {
                    Airship ship10 = garrison.actives.get(ai7);
                    if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship10.x, ship10.y, ship10.getBBWidth(), ship10.getBBHeight())) continue;
                    offsets[0] = 0;
                    offsets[1] = 0;
                    int sbl = this.shipButtons.size();
                    for (int sbi = 0; sbi < sbl; ++sbi) {
                        this.drawShipButton(d, ship10, this.shipButtons.get(sbi), null, offsets);
                    }
                }
            }
        } else if (this.setupFleet != null) {
            int al = this.setupFleet.size();
            for (int ai8 = 0; ai8 < al; ++ai8) {
                Airship ship11 = this.setupFleet.get(ai8);
                if (!Rect2D.intersects(cropX, cropY, cropW, cropH, ship11.x, ship11.y, ship11.getBBWidth(), ship11.getBBHeight())) continue;
                offsets[0] = 0;
                offsets[1] = 0;
                int sbl = this.shipButtons.size();
                for (int sbi = 0; sbi < sbl; ++sbi) {
                    this.drawShipButton(d, ship11, this.shipButtons.get(sbi), null, offsets);
                }
            }
        } else if (this.standaloneEditShip != null) {
            offsets[0] = 0;
            offsets[1] = 0;
            int sbl = this.shipButtons.size();
            for (int sbi = 0; sbi < sbl; ++sbi) {
                this.drawShipButton(d, this.standaloneEditShip, this.shipButtons.get(sbi), null, offsets);
            }
        }
        int scl = this.shipChromes.size();
        for (int sci = 0; sci < scl; ++sci) {
            ShipChrome sc = this.shipChromes.get(sci);
            if (this.combat != null) {
                int sl = this.combat.sides.size();
                for (int si = 0; si < sl; ++si) {
                    Combat.Side side = this.combat.sides.get(si);
                    int al = side.ships.size();
                    for (int ai9 = 0; ai9 < al; ++ai9) {
                        Airship ship12 = side.ships.get(ai9);
                        this.drawShipChrome(d, ship12, side, sc, cursor, sm);
                    }
                }
                continue;
            }
            if (this.city != null) {
                Fleet garrison = this.wm.getGarrison(this.city);
                for (Airship ship13 : this.city.getDefences()) {
                    this.drawShipChrome(d, ship13, null, sc, cursor, sm);
                }
                if (garrison == null) continue;
                int al = garrison.actives.size();
                for (int ai10 = 0; ai10 < al; ++ai10) {
                    Airship ship14 = garrison.actives.get(ai10);
                    this.drawShipChrome(d, ship14, null, sc, cursor, sm);
                }
                continue;
            }
            if (this.setupFleet != null) {
                int al = this.setupFleet.size();
                for (int ai11 = 0; ai11 < al; ++ai11) {
                    Airship ship15 = this.setupFleet.get(ai11);
                    this.drawShipChrome(d, ship15, null, sc, cursor, sm);
                }
                continue;
            }
            if (this.standaloneEditShip == null) continue;
            this.drawShipChrome(d, this.standaloneEditShip, null, sc, cursor, sm);
        }
        this.tool.draw(d, cursor, sm, this);
        int ipl = this.infoPanels.size();
        for (int ipi = 0; ipi < ipl; ++ipi) {
            this.infoPanels.get(ipi).draw(d, cursor, sm, this);
        }
        final UniScreen us = this;
        if (!this.hideUI) {
            d.drawTopBar(sm);
            boolean chat = this.textInputOccurring();
            int bsz = this.buttons.size();
            int totalButtonWidth = 0;
            for (int bi = 0; bi < bsz; ++bi) {
                Button b = this.buttons.get(bi);
                if (!b.visible(this)) continue;
                Img icon = b.icon(this);
                totalButtonWidth = icon != null ? (totalButtonWidth += 24) : (totalButtonWidth += (int)d.textSize((String)b.text((UniScreen)this), (Fount)AGame.BIG_FOUNT).x + (b.isToggle() ? 60 : 40));
                totalButtonWidth += 3;
            }
            int x = (totalButtonWidth -= 3) > sm.width - 6 - 48 ? sm.width - 10 - 3 - 24 + this.topBarScroll : sm.width - 10 + this.topBarScroll;
            for (int bi = 0; bi < bsz; ++bi) {
                final Button b = this.buttons.get(bi);
                if (!b.visible(this)) continue;
                Img icon = b.icon(this);
                if (icon != null) {
                    x -= 24;
                    if (b.isToggle()) {
                        d.iconToggle(x, 11, icon, new InputRunnable(){

                            @Override
                            public void run(Input in) {
                                b.click(in, us);
                            }
                        }, b.selected(this), b.enabled(this));
                    } else {
                        d.iconButton(x, 11, icon, new InputRunnable(){

                            @Override
                            public void run(Input in) {
                                b.click(in, us);
                            }
                        }, b.enabled(this));
                    }
                    x -= 3;
                    continue;
                }
                String text = b.text(this);
                int bw = (int)d.textSize((String)text, (Fount)AGame.BIG_FOUNT).x + (b.isToggle() ? 60 : 40);
                x -= bw;
                if (b.isToggle()) {
                    d.toggle(x, 11, bw, text, chat ? null : b.hotkey(this), new InputRunnable(){

                        @Override
                        public void run(Input in) {
                            b.click(in, us);
                        }
                    }, b.selected(this), b.enabled(this));
                } else if (b.gold(us)) {
                    d.goldbutton(x, 11, bw, text, chat ? null : b.hotkey(this), new InputRunnable(){

                        @Override
                        public void run(Input in) {
                            b.click(in, us);
                        }
                    }, b.enabled(this));
                } else {
                    d.button(x, 11, bw, text, chat ? null : b.hotkey(this), new InputRunnable(){

                        @Override
                        public void run(Input in) {
                            b.click(in, us);
                        }
                    }, b.enabled(this));
                }
                x -= 3;
            }
            if (totalButtonWidth > sm.width - 20) {
                d.hook(sm.width - 10 - 24 - 3, 10.0, 37.0, 26.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN, Hook.Type.HOVER}){

                    public void run(Input in, Pt p, Hook.Type type) {
                    }
                });
                d.state.removeIntersectingGlowRects(sm.width - 10 - 24 - 3, 10, 37, 26);
                d.drawWoodGrain(sm.width - 10 - 24 - 3, 10, 37, 26);
                d.repeatingIconButton(sm.width - 10 - 24, 11, RIGHT_ARROW, new Runnable(){

                    @Override
                    public void run() {
                        UniScreen.this.topBarScroll -= 5;
                    }
                }, this.topBarScroll > 0);
                d.hook(0.0, 10.0, 37.0, 26.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED, Hook.Type.MOUSE_1_DOWN, Hook.Type.HOVER}){

                    public void run(Input in, Pt p, Hook.Type type) {
                    }
                });
                d.drawWoodGrain(0, 10, 37, 26);
                d.repeatingIconButton(10, 11, LEFT_ARROW, new Runnable(){

                    @Override
                    public void run() {
                        UniScreen.this.topBarScroll += 5;
                    }
                }, x < 37);
                this.scrollRange = Math.max(0, this.topBarScroll - x + 10 + 24 + 3);
                if (x > this.scrollRange) {
                    this.topBarScroll = this.scrollRange;
                }
            }
        }
        int os = this.overlays.size();
        for (int oi = 0; oi < os; ++oi) {
            this.overlays.get(oi).draw(d, cursor, sm, this);
        }
        int fll = this.floats.size();
        for (int fli = 0; fli < fll; ++fli) {
            this.floats.get(fli).draw(d, cursor, sm, this);
        }
        if (this.attractMode || this.intent instanceof EditorAttractIntent) {
            hs.list.clear();
            d.getHooks().list.clear();
            d.hook(0.0, 0.0, sm.width, sm.height, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    UniScreen.this.g.s = new MainMenu(UniScreen.this.g);
                }
            });
        }
        if (this.confirmDialog != null) {
            hs.list.clear();
            d.getHooks().list.clear();
            d.rect(AirshipGame.ERR_BG_TINT, 0.0, 0.0, sm.width, sm.height);
            if (this.confirmDialog instanceof MessageDialog) {
                try {
                    d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, this.confirmDialog.text(), new Runnable(){

                        @Override
                        public void run() {
                            UniScreen.this.confirmDialog.ok(us);
                        }
                    });
                }
                catch (Exception e) {
                    this.g.reportError("{0} problem with " + this.confirmDialog.text(), e, null, false, true);
                }
            } else {
                d.confirmDialog(sm.width / 2 - 200, sm.height / 2 - 150, 400, this.confirmDialog.text(), this.confirmDialog.okText(), this.confirmDialog.cancelText(), new Runnable(){

                    @Override
                    public void run() {
                        UniScreen.this.confirmDialog.ok(us);
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        UniScreen.this.confirmDialog.cancel(us);
                    }
                });
            }
        }
    }

    @Override
    public ArrayList<String> music() {
        if (this.intent instanceof EditShipIntent) {
            return AGame.EDITOR_MUSIC;
        }
        if (this.intent instanceof DefencesIntent || this.intent instanceof EspionageIntent) {
            return AGame.CITY_MUSIC;
        }
        if (this.combat != null && this.combat.time > 0) {
            return AGame.COMBAT_MUSIC;
        }
        return AGame.STRATEGIC_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return this.getTimeOfDay().name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    public static interface ShipLayer {
        public boolean doDraw(double var1);

        public void lockShader(MyDraw var1, double var2, Image[] var4, float var5, float var6);

        public void draw(Airship var1, MyDraw var2, boolean var3, double var4, double var6, double var8, int var10, boolean var11, boolean var12, CoatOfArms var13, boolean var14, Image[] var15, float var16, float var17, Clr var18);

        public void unlockShader(Image[] var1, double var2);
    }

    public static interface Intent {
        public void tick(Input var1, int var2, UniScreen var3);

        public boolean showOutside();

        public boolean showDecals();

        public boolean drawAsBlueprint();
    }

    public static interface ShipChrome {
        public void draw(MyDraw var1, Pt var2, Airship var3, Combat.Side var4, int var5, int var6, int var7, int var8, ScreenMode var9, UniScreen var10);

        public void tick(Input var1, int var2, UniScreen var3);

        public boolean textInputOccurring(UniScreen var1);
    }

    public static interface ShipOverlay {
        public void draw(MyDraw var1, Airship var2, UniScreen var3);
    }

    public static interface Tool {
        public void draw(MyDraw var1, Pt var2, ScreenMode var3, UniScreen var4);

        public boolean click(Input var1, Pt var2, ScreenMode var3, UniScreen var4);

        public boolean rightClick(Input var1, Pt var2, ScreenMode var3, UniScreen var4);

        public boolean mouseDown(Input var1, Pt var2, ScreenMode var3, UniScreen var4);

        public void tick(Input var1, int var2, UniScreen var3);
    }

    public static interface InfoPanel {
        public void draw(MyDraw var1, Pt var2, ScreenMode var3, UniScreen var4);

        public void tick(Input var1, int var2, UniScreen var3);

        public boolean chatEnabled(UniScreen var1);

        public boolean doScroll(UniScreen var1, int var2, Pt var3, ScreenMode var4);

        public boolean arrowKeysInUse(UniScreen var1);
    }

    public static abstract class ShipButton {
        public abstract boolean visible(Airship var1, Combat.Side var2, UniScreen var3);

        public boolean enabled(Airship ship, Combat.Side side, UniScreen us) {
            return true;
        }

        public boolean acceptsTool(Tool t) {
            return t == NAVIGATE;
        }

        public abstract String text(Airship var1, Combat.Side var2, UniScreen var3);

        public abstract void click(Input var1, Airship var2, Combat.Side var3, UniScreen var4);

        public void tick(Input in, int ms, UniScreen us) {
        }
    }

    public static abstract class Button {
        public abstract boolean visible(UniScreen var1);

        public boolean enabled(UniScreen us) {
            return true;
        }

        public boolean isToggle() {
            return false;
        }

        public boolean selected(UniScreen us) {
            return false;
        }

        public abstract String text(UniScreen var1);

        public Img icon(UniScreen us) {
            return null;
        }

        public abstract void click(Input var1, UniScreen var2);

        public void tick(Input in, UniScreen us) {
        }

        public String hotkey(UniScreen us) {
            return null;
        }

        public boolean gold(UniScreen us) {
            return false;
        }
    }

    public static interface VisualLayer {
        public void tick(Input var1, int var2, UniScreen var3);

        public void draw(MyDraw var1, UniScreen var2, double var3, double var5, double var7, double var9);
    }
}

