/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CampaignCombatSetupIntent;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatIntent;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public class VictoryOrDefeatOverlay
implements UniScreen.InfoPanel {
    public Combat cachedC;
    public ArrayList<ArrayList<String>> lines = new ArrayList();
    private static final int ROW_L = 20;

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, final UniScreen us) {
        if (us.hideUI) {
            return;
        }
        if (us.combat != null && us.combat.isFinished()) {
            Pt dims;
            int y = 50;
            if (us.combat.won(us.mySide)) {
                dims = d.textSize(Lang._t("VICTORY", new Object[0]), AGame.HUGE_FOUNT);
                d.borderedText(Lang._t("VICTORY", new Object[0]), AGame.HUGE_FOUNT, Clr.BLACK, Clr.WHITE, (int)((double)(sm.width / 2) - dims.x / 2.0), y);
            } else if (us.combat.won(us.combat.otherSide(us.mySide))) {
                dims = d.textSize(Lang._t("DEFEAT", new Object[0]), AGame.HUGE_FOUNT);
                d.borderedText(Lang._t("DEFEAT", new Object[0]), AGame.HUGE_FOUNT, Clr.BLACK, Clr.WHITE, (int)((double)(sm.width / 2) - dims.x / 2.0), y);
            } else {
                dims = d.textSize(Lang._t("DRAW", new Object[0]), AGame.HUGE_FOUNT);
                d.borderedText(Lang._t("DRAW", new Object[0]), AGame.HUGE_FOUNT, Clr.BLACK, Clr.WHITE, (int)((double)(sm.width / 2) - dims.x / 2.0), y);
            }
            d.button(sm.width / 2 - 50, y += AGame.HUGE_FOUNT.height, 100, Lang._t("OK", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    VictoryOrDefeatOverlay.this.ok(us);
                }
            });
            this.genLines(us.combat);
            int w = 80 * AGame.FOUNT.displayWidth + 24;
            int x = sm.width / 2 - w / 2;
            int nLines = Math.min(Math.max(this.lines.get(0).size(), this.lines.get(1).size()), (sm.height - (y += 36) - 20) / 20);
            int h = nLines * AGame.FOUNT.lineHeight + 24;
            d.drawWindow(x, y, w, h);
            x += 12;
            y += 12;
            w -= 24;
            for (int i = 0; i < Math.max(this.lines.get(0).size(), this.lines.get(1).size()); ++i) {
                if (i < this.lines.get(0).size()) {
                    d.text(this.lines.get(0).get(i), AGame.FOUNT, x, y + i * AGame.FOUNT.lineHeight);
                }
                if (i >= this.lines.get(1).size()) continue;
                d.text(this.lines.get(1).get(i), AGame.FOUNT, x + w / 2, y + i * AGame.FOUNT.lineHeight);
            }
        }
    }

    private void ok(UniScreen us) {
        if (us.intent instanceof CombatIntent) {
            ((CombatIntent)us.intent).leave(us);
        }
        if (us.intent instanceof CampaignCombatSetupIntent) {
            ((CampaignCombatSetupIntent)us.intent).leave(us);
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (in.keyPressed("ENTER") && us.combat != null && us.combat.isFinished()) {
            this.ok(us);
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    private String pad(String s, int n) {
        while (s.length() < n) {
            s = s + " ";
        }
        return s;
    }

    private void genLines(Combat c) {
        if (c == this.cachedC) {
            return;
        }
        this.cachedC = c;
        for (int i = 0; i < 2; ++i) {
            ArrayList<String> ls = new ArrayList<String>();
            this.lines.add(ls);
            Combat.Side s = c.sides.get(i);
            Combat.Side otherS = c.sides.get(i == 0 ? 1 : 0);
            ls.add(s.name.toUpperCase());
            ls.add("");
            for (Airship ship : s.originalComposition) {
                if (!s.ships.contains(ship) && !s.reserve.contains(ship)) {
                    if (otherS.ships.contains(ship) || otherS.reserve.contains(ship)) {
                        ls.add(this.pad(ship.name, 20) + "[ff9999]" + Lang._t("CAPTURED", new Object[0]) + "[]");
                        continue;
                    }
                    ls.add(this.pad(ship.name, 20) + "[ff9999]" + Lang._t("DESTROYED", new Object[0]) + "[]");
                    continue;
                }
                String err = ship.uselessReason();
                if (err == null) {
                    err = ship.harmlessReason();
                    if (err == null) {
                        if (s.surrendered) {
                            ls.add(this.pad(ship.name, 20) + "[99ff99]" + Lang._t("SURRENDERED", new Object[0]) + "[]");
                            continue;
                        }
                        ls.add(this.pad(ship.name, 20) + "[99ff99]" + Lang._t("SURVIVED", new Object[0]) + "[]");
                        continue;
                    }
                    ls.add(this.pad(ship.name, 20) + err.toUpperCase());
                    continue;
                }
                ls.add(this.pad(ship.name, 20) + "[ff9999]" + err.toUpperCase());
            }
        }
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

