/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Pt;

public class WeaponAppearance {
    public Appearance back;
    public Img shot;
    public Img barrel;
    public Img flippedbarrel;
    public Pt barrelOffset;
    public Pt flippedBarrelOffset;
    public double recoil;
    public Particle.Emitter shotEmitter;
    public ShotExhaustEmitter exhaust;

    public WeaponAppearance shot(Img shot) {
        this.shot = shot;
        return this;
    }

    public WeaponAppearance exhaust(ShotExhaustEmitter exhaust) {
        this.exhaust = exhaust;
        return this;
    }

    public WeaponAppearance back(Appearance back) {
        this.back = back;
        return this;
    }

    public WeaponAppearance back(Img shot) {
        this.shot = shot;
        return this;
    }

    public WeaponAppearance barrel(Img barrel, Pt barrelOffset, int w) {
        this.barrel = barrel;
        this.barrelOffset = barrelOffset;
        this.flippedbarrel = barrel.flip();
        this.flippedBarrelOffset = new Pt((double)(w * 16) - barrelOffset.x - (double)barrel.srcWidth, barrelOffset.y);
        return this;
    }

    public WeaponAppearance recoil(double recoil) {
        this.recoil = recoil;
        return this;
    }

    public WeaponAppearance shotEmitter(Particle.Emitter shotEmitter) {
        this.shotEmitter = shotEmitter;
        return this;
    }

    public WeaponAppearance flipped(int w) {
        WeaponAppearance wa2 = new WeaponAppearance();
        wa2.back = this.back;
        if (this.barrel != null) {
            wa2.barrel = this.flippedbarrel;
            wa2.flippedbarrel = this.barrel;
            wa2.barrelOffset = this.flippedBarrelOffset;
            wa2.flippedBarrelOffset = this.barrelOffset;
        }
        wa2.recoil = this.recoil;
        wa2.shot = this.shot;
        wa2.shotEmitter = this.shotEmitter;
        wa2.exhaust = this.exhaust;
        return wa2;
    }

    public static class ShotExhaustEmitter {
        public final Particle.Type type;
        public final double p;
        public final double backOffset;
        public final double angleRange;
        public final double randomOffset;
        public final double speedMin;
        public final double speedMax;

        public ShotExhaustEmitter(Particle.Type type, double p, double backOffset, double angleRange, double randomOffset, double speedMin, double speedMax) {
            this.type = type;
            this.p = p;
            this.backOffset = backOffset;
            this.angleRange = angleRange;
            this.randomOffset = randomOffset;
            this.speedMin = speedMin;
            this.speedMax = speedMax;
        }

        public Particle emit(double shotX, double shotY, double shotAngle, int ms) {
            if (AGame.ANIM_R.nextDouble() > (double)ms * this.p) {
                return null;
            }
            double xOffset = Math.cos(shotAngle) * -this.backOffset + (AGame.ANIM_R.nextDouble() - 0.5) * this.randomOffset;
            double yOffset = Math.sin(shotAngle) * -this.backOffset + (AGame.ANIM_R.nextDouble() - 0.5) * this.randomOffset;
            double angle = shotAngle + (AGame.ANIM_R.nextDouble() - 0.5) * this.angleRange;
            double speed = this.speedMin + AGame.ANIM_R.nextDouble() * (this.speedMax - this.speedMin);
            double dx = Math.cos(angle) * -speed;
            double dy = Math.sin(angle) * -speed;
            return new Particle(this.type, shotX + xOffset, shotY + yOffset, dx, dy);
        }
    }
}

