/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import java.util.ArrayList;

public class WeatherVisualLayer
implements UniScreen.VisualLayer {
    public ArrayList<Drop> drops = new ArrayList();
    public static final int N_SNOW = 1000;
    public static final int N_RAIN = 120;
    public static final int N_DUST = 30;
    public static final Clr RAIN_C = new Clr(191, 191, 191, 128);
    public static final Clr DUST_C = new Clr(51, 26, 8, 128);

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        TimeOfDay tod = us.getTimeOfDay();
        switch (tod.effect) {
            case SNOW: {
                int i;
                if (this.drops.isEmpty()) {
                    this.drops.ensureCapacity(1000);
                    for (i = 0; i < 1000; ++i) {
                        this.drops.add(new Drop(AGame.ANIM_R.nextInt(3200) - 1600, AGame.ANIM_R.nextInt(2500) + 512 - 2500, 0.0, 0.01 + AGame.ANIM_R.nextDouble() * 0.02));
                    }
                }
                for (i = 0; i < 1000; ++i) {
                    Drop d = this.drops.get(i);
                    d.y += d.dy * (double)ms;
                    if (us.combat != null && us.combat.physics != null) {
                        int bsz = us.combat.physics.bodies.size();
                        for (int bi = 0; bi < bsz; ++bi) {
                            Body b = us.combat.physics.bodies.get(bi);
                            if (b == us.combat.landFormations.get(0) || !b.canParticleStick(d.x, d.y)) continue;
                            Particle snowP = new Particle(Particle.Type.GROUND_SNOW, d.x - b.x, d.y - b.y, 0.0, 0.0);
                            b.stuckParticles.add(snowP);
                            d.y = -1988.0;
                            d.x = AGame.ANIM_R.nextInt(3200) - 1600;
                            break;
                        }
                    }
                    if (!(d.y > 512.0)) continue;
                    d.y = -1988.0;
                }
                break;
            }
            case RAIN: 
            case STORM: {
                int i;
                if (this.drops.isEmpty()) {
                    this.drops.ensureCapacity(120);
                    for (i = 0; i < 120; ++i) {
                        this.drops.add(new Drop(AGame.ANIM_R.nextInt(3200) - 1600, AGame.ANIM_R.nextInt(2660) + 512 - 2500, 0.0, 1.0 + AGame.ANIM_R.nextDouble() * 0.2, 20 + AGame.ANIM_R.nextInt(10)));
                    }
                }
                for (i = 0; i < 120; ++i) {
                    Drop d = this.drops.get(i);
                    d.y += d.dy * (double)ms;
                    if (!(d.y + (double)d.size > 672.0)) continue;
                    d.y = -1988.0;
                    d.x = AGame.ANIM_R.nextInt(3200) - 1600;
                }
                if (us.combat == null || AGame.ANIM_R.nextInt(1000) != 0) break;
                us.combat.play("thunder" + AGame.ANIM_R.nextInt(4), -1488, AGame.ANIM_R.nextInt(3200) - 1600, 1.0 + AGame.ANIM_R.nextDouble() * 2.0);
            }
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        TimeOfDay tod = us.getTimeOfDay();
        switch (tod.effect) {
            case SNOW: {
                double sz = Math.max(2.0, 1.5 / us.zoom);
                if (this.drops.isEmpty()) break;
                for (int i = 0; i < 1000; ++i) {
                    Drop drop = this.drops.get(i);
                    if (!Rect2D.contains(cropX, cropY, cropW, cropH, drop.x, drop.y)) continue;
                    d.rect(Clr.WHITE, drop.x - sz / 2.0, drop.y - sz / 2.0, sz, sz);
                }
                break;
            }
            case RAIN: 
            case STORM: {
                double sz = 1.1 / us.zoom;
                if (this.drops.isEmpty()) break;
                for (int i = 0; i < 120; ++i) {
                    Drop drop = this.drops.get(i);
                    if (!Rect2D.contains(cropX, cropY, cropW, cropH, drop.x, drop.y)) continue;
                    d.rect(RAIN_C, drop.x, drop.y, sz, drop.size);
                }
                break;
            }
        }
    }

    public class Drop {
        public double x;
        public double y;
        public double dx;
        public double dy;
        public int size;

        public Drop(double x, double y, double dx, double dy) {
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
        }

        public Drop(double x, double y, double dx, double dy, int size) {
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
            this.size = size;
        }
    }
}

