/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.IntegrationBackend;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.newdawn.slick.opengl.PNGImageData;

public class WebIntegrationBackend
implements IntegrationBackend {
    public final String baseURL;
    public final String mediaURL;
    public final String forumsURL;
    public final String calendarURL;
    public String multiplayerServer;

    public WebIntegrationBackend(String baseURL, String mediaURL, String forumsURL, String calendarURL) {
        this.baseURL = baseURL;
        this.mediaURL = mediaURL;
        this.forumsURL = forumsURL;
        this.calendarURL = calendarURL;
        this.rpc(new JSONRequest("setting/gameserver", new String[0]){

            @Override
            public void respond(JSONObject o) {
                if (o.getBoolean("success")) {
                    WebIntegrationBackend.this.multiplayerServer = o.getString("value");
                }
            }
        });
    }

    @Override
    public String getMultiplayerServer() {
        return this.multiplayerServer;
    }

    private void rpc(final JSONRequest req) {
        final String urlSpec = this.baseURL + req.urlSpec;
        Thread th = new Thread(){

            @Override
            public void run() {
                try {
                    req.respond(WebIntegrationBackend.rpc(urlSpec, req.postVars));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    req.respond(new JSONObject().put("success", false).put("error", "Network error: " + e.getMessage()));
                }
            }
        };
        th.setDaemon(true);
        th.start();
    }

    private static JSONObject rpc(String urlSpec, String ... postVars) {
        try {
            StringBuilder query = new StringBuilder();
            for (int i = 0; i < postVars.length; i += 2) {
                if (i != 0) {
                    query.append("&");
                }
                query.append(postVars[i]).append("=").append(URLEncoder.encode(postVars[i + 1], "UTF-8"));
            }
            URL url = new URL(urlSpec);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-length", String.valueOf(query.length()));
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            DataOutputStream output = new DataOutputStream(conn.getOutputStream());
            output.writeBytes(query.toString());
            output.flush();
            output.close();
            if (conn.getResponseCode() == 500) {
                String l;
                InputStream es = conn.getErrorStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(es));
                while ((l = br.readLine()) != null) {
                    System.out.println(l);
                }
                br.close();
                return new JSONObject().put("success", false).put("error", "Server Error");
            }
            InputStream is = conn.getInputStream();
            JSONObject o = new JSONObject(new JSONTokener(is));
            is.close();
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONObject().put("success", false).put("error", e.getClass().getSimpleName().replace("Exception", "") + ": " + e.getMessage());
        }
    }

    @Override
    public void checkForNews(final IntegrationBackend.Receiver<IntegrationBackend.NewsCallback> rec) {
        this.rpc(new JSONRequest("news", new String[0]){

            @Override
            public void respond(JSONObject o) {
                if (o.getBoolean("success")) {
                    if (o.getBoolean("news")) {
                        rec.receive(new IntegrationBackend.NewsCallback(o.getString("title"), o.getString("text"), o.getString("link")));
                    } else {
                        rec.receive(new IntegrationBackend.NewsCallback());
                    }
                } else {
                    rec.receive(new IntegrationBackend.NewsCallback(o.getString("error")));
                }
            }
        });
    }

    @Override
    public void register(final String username, final String password, String email, final IntegrationBackend.Receiver<IntegrationBackend.RegisterCallback> rec) {
        this.rpc(new JSONRequest("register", new String[]{"username", username, "email", email, "password", password}){

            @Override
            public void respond(JSONObject o) {
                if (o.getBoolean("success")) {
                    rec.receive(new IntegrationBackend.RegisterCallback(username, password));
                } else {
                    rec.receive(new IntegrationBackend.RegisterCallback(o.getString("error")));
                }
            }
        });
    }

    @Override
    public void authenticate(final String username, final String password, final IntegrationBackend.Receiver<IntegrationBackend.AuthCallback> rec) {
        this.rpc(new JSONRequest("authenticate", new String[]{"username", username, "password", password}){

            @Override
            public void respond(JSONObject o) {
                if (o.getBoolean("success")) {
                    JSONObject ui = o.getJSONObject("userInfo");
                    CoatOfArms coa = null;
                    if (ui.has("coatOfArms")) {
                        coa = new CoatOfArms(ui.getJSONObject("coatOfArms"));
                    }
                    String specialCharge = ui.optString("specialCharge", null);
                    ArrayList<String> features = new ArrayList<String>();
                    if (ui.has("features")) {
                        JSONArray fs = ui.getJSONArray("features");
                        for (int i = 0; i < fs.length(); ++i) {
                            features.add(fs.getString(i));
                        }
                    }
                    rec.receive(new IntegrationBackend.AuthCallback(username, password, coa, specialCharge, features));
                } else {
                    rec.receive(new IntegrationBackend.AuthCallback(o.getString("error")));
                }
            }
        });
    }

    @Override
    public void addCode(String username, String password, String code, final IntegrationBackend.Receiver<IntegrationBackend.AddCodeCallback> rec) {
        this.rpc(new JSONRequest("add_code", new String[]{"username", username, "password", password, "code", code}){

            @Override
            public void respond(JSONObject o) {
                if (o.getBoolean("success")) {
                    rec.receive(new IntegrationBackend.AddCodeCallback());
                } else {
                    rec.receive(new IntegrationBackend.AddCodeCallback(o.getString("error")));
                }
            }
        });
    }

    @Override
    public void setArms(String username, String password, CoatOfArms arms, final IntegrationBackend.Receiver<IntegrationBackend.SetArmsCallback> rec) {
        this.rpc(new JSONRequest("set_coat_of_arms", new String[]{"username", username, "password", password, "coa", arms.toJSON().toString()}){

            @Override
            public void respond(JSONObject o) {
                if (o.getBoolean("success")) {
                    rec.receive(new IntegrationBackend.SetArmsCallback());
                } else {
                    rec.receive(new IntegrationBackend.SetArmsCallback(o.getString("error")));
                }
            }
        });
    }

    @Override
    public void getCharge(final String chargeName, final IntegrationBackend.Receiver<IntegrationBackend.GetChargeCallback> rec) {
        String cn = null;
        try {
            cn = URLEncoder.encode(chargeName, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            rec.receive(new IntegrationBackend.GetChargeCallback("Encoding error."));
        }
        this.rpc(new JSONRequest("charge/" + cn, new String[0]){

            @Override
            public void respond(JSONObject o) {
                if (!o.getBoolean("success")) {
                    rec.receive(new IntegrationBackend.GetChargeCallback(o.getString("error")));
                    return;
                }
                try {
                    String chargeImageURLSpec = o.getString("url");
                    URL chargeImageURL = new URL(WebIntegrationBackend.this.mediaURL + chargeImageURLSpec);
                    InputStream is = chargeImageURL.openStream();
                    PNGImageData pid = new PNGImageData();
                    pid.loadImage(is);
                    is.close();
                    rec.receive(new IntegrationBackend.GetChargeCallback(chargeName, pid));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    rec.receive(new IntegrationBackend.GetChargeCallback("Unable to download charge image: " + e.getMessage()));
                }
            }
        });
    }

    @Override
    public void checkArmsAvailable(CoatOfArms arms, final IntegrationBackend.Receiver<IntegrationBackend.CheckArmsAvailableCallback> rec) {
        this.rpc(new JSONRequest("check_arms_available", new String[]{"coa", arms.toJSON().toString()}){

            @Override
            public void respond(JSONObject o) {
                if (o.getBoolean("success")) {
                    rec.receive(new IntegrationBackend.CheckArmsAvailableCallback(o.getBoolean("available")));
                } else {
                    System.out.println(o.getString("error"));
                    rec.receive(new IntegrationBackend.CheckArmsAvailableCallback(o.getString("error")));
                }
            }
        });
    }

    @Override
    public void gotoForums(String username, String password) {
        try {
            Desktop.getDesktop().browse(new URI(this.forumsURL + username + "/" + password));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void gotoCalendar(String username, String password) {
        try {
            Desktop.getDesktop().browse(new URI(this.calendarURL + username + "/" + password));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendFeedback(String username, String text, final IntegrationBackend.Receiver<IntegrationBackend.FeedbackCallback> rec) {
        this.rpc(new JSONRequest("feedback", new String[]{"username", username, "text", text}){

            @Override
            public void respond(JSONObject o) {
                if (o.getBoolean("success")) {
                    rec.receive(new IntegrationBackend.FeedbackCallback());
                } else {
                    rec.receive(new IntegrationBackend.FeedbackCallback(o.getString("error")));
                }
            }
        });
    }

    @Override
    public void steamGetInfo(String steamID, final IntegrationBackend.Receiver<IntegrationBackend.SteamGetInfoCallback> rec) {
        this.rpc(new JSONRequest("steam/get_info", new String[]{"userID", steamID}){

            @Override
            public void respond(JSONObject o) {
                if (o.getBoolean("success")) {
                    rec.receive(new IntegrationBackend.SteamGetInfoCallback(o.has("coatOfArms") ? new CoatOfArms(o.getJSONObject("coatOfArms")) : null, o.optString("specialCharge", null), o.getBoolean("unlinked")));
                } else {
                    rec.receive(new IntegrationBackend.SteamGetInfoCallback(o.getString("error")));
                }
            }
        });
    }

    @Override
    public void steamSetArms(String steamID, CoatOfArms coa, final IntegrationBackend.Receiver<IntegrationBackend.SteamSetArmsCallback> rec) {
        this.rpc(new JSONRequest("steam/set_coat_of_arms", new String[]{"userID", steamID, "coa", coa.toJSON().toString()}){

            @Override
            public void respond(JSONObject o) {
                rec.receive(new IntegrationBackend.SteamSetArmsCallback(o.getBoolean("success"), o.optString("error", null)));
            }
        });
    }

    @Override
    public void steamLinkUser(String steamID, String authTicket, String username, String password, final IntegrationBackend.Receiver<IntegrationBackend.SteamLinkUserCallback> rec) {
        this.rpc(new JSONRequest("steam/link_user", new String[]{"userID", steamID, "authTicket", authTicket, "username", username, "password", password}){

            @Override
            public void respond(JSONObject o) {
                rec.receive(new IntegrationBackend.SteamLinkUserCallback(o.getBoolean("success"), o.optString("error", null)));
            }
        });
    }

    private abstract class JSONRequest {
        public final String urlSpec;
        public final String[] postVars;

        public JSONRequest(String urlSpec, String ... postVars) {
            this.urlSpec = urlSpec;
            this.postVars = postVars;
        }

        public abstract void respond(JSONObject var1);
    }
}

