/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Spring;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.WheelBody;
import com.zarkonnen.catengine.Img;

public strictfp class Wheel {
    public final Spec spec;
    public double yOffset;
    public double phase;
    public boolean onGround;
    public Airship myShip;
    public WheelBody body;
    public static final double SINCOS45 = 0.707;

    public Wheel(Spec spec, Airship ship) {
        this.spec = spec;
        this.myShip = ship;
        this.body = new WheelBody(ship, this, 0.0, 0.0, spec.radius);
    }

    public static double lengthTo3Probe(LandFormation lf, double x, double y, double r) {
        return Math.min(Spring.lengthTo(lf, x, y), Math.min(Spring.lengthTo(lf, x + r * 0.707, y) + r * 0.29300000000000004, Spring.lengthTo(lf, x - r * 0.707, y) + r * 0.29300000000000004));
    }

    public double lengthTo3Probe(Airship ship, double x, double y, double r) {
        return Math.min(Spring.lengthTo(ship, x, y), Math.min(Spring.lengthTo(ship, x + r * 0.707, y) + r * 0.29300000000000004, Spring.lengthTo(ship, x - r * 0.707, y) + r * 0.29300000000000004));
    }

    public void setBodyPosition(double mx, double my) {
        this.body.x = mx + this.spec.xOffset * 16.0 - this.spec.radius;
        this.body.y = my + this.yOffset - this.spec.radius;
        this.body.xSpeed = 0.0;
        this.body.ySpeed = this.myShip.ySpeed;
        this.body.xForce = 0.0;
        this.body.yForce = 0.0;
    }

    public void calcYOffset(double x, double y, UniScreen us) {
        double newOffset;
        double l = this.spec.maxYOffset + this.spec.radius + 1.0E-6;
        x += this.spec.xOffset * 16.0;
        if (us.combat != null) {
            for (LandFormation lf : us.combat.landFormations) {
                l = Math.min(l, Wheel.lengthTo3Probe(lf, x, y, this.spec.radius));
            }
            for (Combat.Side s : us.combat.sides) {
                for (Airship ship : s.ships) {
                    if (ship == this.myShip) continue;
                    l = Math.min(l, this.lengthTo3Probe(ship, x, y, this.spec.radius));
                }
            }
        } else if (us.city != null) {
            l = Math.min(l, Spring.lengthTo(us.city.ground, x, y));
            for (LandFormation lf : us.city.floaters) {
                l = Math.min(l, Wheel.lengthTo3Probe(lf, x, y, this.spec.radius));
            }
            Fleet garrison = us.wm.getGarrison(us.city);
            for (Airship ship : garrison.actives) {
                if (ship == this.myShip) continue;
                l = Math.min(l, this.lengthTo3Probe(ship, x, y, this.spec.radius));
            }
        } else if (us.setupGround != null) {
            l = Math.min(l, Spring.lengthTo(us.setupGround, x, y));
            for (LandFormation lf : us.setupFloaters) {
                l = Math.min(l, Wheel.lengthTo3Probe(lf, x, y, this.spec.radius));
            }
            for (Airship ship : us.setupFleet) {
                if (ship == this.myShip) continue;
                l = Math.min(l, this.lengthTo3Probe(ship, x, y, this.spec.radius));
            }
        }
        this.yOffset = Math.abs(this.yOffset - (newOffset = Math.min(this.spec.maxYOffset, l - this.spec.radius))) <= this.spec.radius / 10.0 ? newOffset : (newOffset > this.yOffset ? (this.yOffset += this.spec.radius / 10.0) : (this.yOffset -= this.spec.radius / 10.0));
        this.onGround = this.yOffset < this.spec.maxYOffset;
    }

    public void calcYOffset(double x, double y, Combat c) {
        double l = this.spec.maxYOffset + this.spec.radius + 1.0E-6;
        x += this.spec.xOffset * 16.0;
        for (LandFormation lf : c.landFormations) {
            l = Math.min(l, Wheel.lengthTo3Probe(lf, x, y, this.spec.radius));
        }
        double newOffset = Math.min(this.spec.maxYOffset, l - this.spec.radius);
        this.yOffset = Math.abs(this.yOffset - newOffset) <= this.spec.radius / 10.0 ? newOffset : (newOffset > this.yOffset ? (this.yOffset += this.spec.radius / 10.0) : (this.yOffset -= this.spec.radius / 10.0));
        this.onGround = this.yOffset < this.spec.maxYOffset;
    }

    public strictfp static class Spec {
        public final double xOffset;
        public final double maxYOffset;
        public final double radius;
        public final Img wheel;
        public final Img lowerLink;
        public final Img upperLink;
        public final double segmentStride;

        public Spec(double xOffset, double maxYOffset, double radius, Img wheel, Img lowerLink, Img upperLink, double segmentStride) {
            this.xOffset = xOffset;
            this.maxYOffset = maxYOffset;
            this.radius = radius;
            this.wheel = wheel;
            this.lowerLink = lowerLink;
            this.upperLink = upperLink;
            this.segmentStride = segmentStride;
        }
    }
}

