/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.Wheel;

public strictfp class WheelBody
extends Body {
    public Wheel wheel;
    public Airship ship;
    public double r;
    public boolean removeMe;

    public WheelBody(Airship ship, Wheel wheel, double x, double y, double r) {
        this.ship = ship;
        this.wheel = wheel;
        this.x = x;
        this.y = y;
        this.r = r;
    }

    @Override
    public int getCollisionMass() {
        return this.ship.getCollisionMass() / 100;
    }

    @Override
    public int getMass() {
        return this.ship.getMass() / 100;
    }

    @Override
    public boolean isImmobile() {
        return false;
    }

    @Override
    public boolean removeMe() {
        return this.removeMe;
    }

    @Override
    public double elasticity() {
        return this.ship.elasticity();
    }

    @Override
    public double horizontalAirFriction() {
        return 0.0;
    }

    @Override
    public double verticalAirFriction() {
        return 0.0;
    }

    public boolean intersectsWithRect(double rX, double rY, double rW, double rH) {
        double centerX = this.x + this.r;
        double centerY = this.y + this.r;
        if ((rX - centerX) * (rX - centerX) + (rY - centerY) * (rY - centerY) <= this.r * this.r) {
            return true;
        }
        if ((rX + rW - centerX) * (rX + rW - centerX) + (rY - centerY) * (rY - centerY) <= this.r * this.r) {
            return true;
        }
        if ((rX + rW - centerX) * (rX + rW - centerX) + (rY + rH - centerY) * (rY + rH - centerY) <= this.r * this.r) {
            return true;
        }
        return (rX - centerX) * (rX - centerX) + (rY + rH - centerY) * (rY + rH - centerY) <= this.r * this.r;
    }

    @Override
    public boolean collidesWith(PhysicsRect b2) {
        if (b2 == this.ship) {
            return false;
        }
        if (b2 instanceof Airship) {
            return ((Airship)b2).collidesWith(this);
        }
        if (b2 instanceof LandFormation) {
            return ((LandFormation)b2).collidesWith(this);
        }
        return this.intersectsWithRect(b2.x, b2.y, b2.getBBWidth(), b2.getBBHeight());
    }

    @Override
    public void doCollision(Body b2, double hitEnergy, Combat combat, boolean atSpeed) {
    }

    @Override
    public double getBBWidth() {
        return this.r * 2.0;
    }

    @Override
    public double getBBHeight() {
        return this.r * 2.0;
    }

    @Override
    public boolean canParticleStick(double px, double py) {
        return false;
    }

    @Override
    public boolean isAtSpeed() {
        return true;
    }
}

