/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public class WorldGenScreen
implements Screen {
    public CampaignWorld w;
    public AirshipGame g;
    public boolean drawn = false;
    public String playerName;
    public CoatOfArms coa;

    public WorldGenScreen(CampaignWorld w, AirshipGame g, String playerName, CoatOfArms coa) {
        this.w = w;
        this.g = g;
        this.playerName = playerName;
        this.coa = coa;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        this.w.map.setupPlayerName = this.playerName;
        if (this.drawn && this.w.map.doSetup()) {
            this.w.setupPlayer(this.playerName, this.coa);
            this.g.s = new StrategicScreen(this.g, this.w);
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(AGame.CAST_IRON, sm);
        d.text("[f5edb5]" + this.w.map.getSetupStageDesc(), AGame.BIG_FOUNT, (int)((double)(sm.width / 2) - d.textSize((String)this.w.map.getSetupStageDesc(), (Fount)AGame.BIG_FOUNT).x / 2.0), sm.height / 3);
        d.progressBar(sm.width / 2 - 100, sm.height / 3 + AGame.BIG_FOUNT.height + 12, 200, (double)this.w.map.getSetupProgress() * 1.0 / (double)this.w.map.getSetupLength());
        this.drawn = true;
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

