/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.ConstructionAffinity;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Perlin;
import com.zarkonnen.airships.Road;
import com.zarkonnen.airships.SecretPoliceLevel;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.StrategicAI;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public class WorldMap
implements JSONAble {
    public static final double BUILDING_MULT = 0.6;
    public static final int MIN_DIST = 200;
    public ArrayList<Empire> empires = new ArrayList();
    public transient double[][] height;
    public boolean[][] water;
    public transient double[][] resistance;
    public transient double[][][] cityDist;
    public transient ArrayList<NavNode> navNodes = new ArrayList();
    public int[][] cityOwnership;
    public transient boolean[][] border;
    public transient int[][] borderingCityID;
    public transient boolean[][] roadMap;
    public transient boolean[][] seaRouteBorder;
    public transient ArrayList<City[]> cityPairs;
    public ArrayList<Road> roads = new ArrayList();
    public ArrayList<TerrainFeature> features = new ArrayList();
    public boolean villainDesignated;
    public int age;
    public final AirshipGame g;
    private boolean reportedNullDefender = false;
    private CoatOfArms playerCOA;
    public transient boolean dirty = false;
    public transient String setupPlayerName;
    public transient ArrayList<String> setupCityNames;
    private transient Random r;
    private transient Size size;
    private transient int stageIndex = 0;
    private transient ArrayList<Bonus> bs;
    private transient int offset;
    private transient City playerStart;
    private final SetupStage[] setupStages = new SetupStage[]{new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Generating_landscape", new Object[0]);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void run(int index, WorldMap wm) {
            int i;
            int y;
            int x;
            WorldMap.this.height = WorldMap.this.genGrid(WorldMap.this.r, WorldMap.this.size);
            Perlin perlin = new Perlin(WorldMap.this.r);
            WorldMap.this.resistance = new double[((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            WorldMap.this.cityDist = new double[((WorldMap)WorldMap.this).size.empires][((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            for (int y2 = 0; y2 < ((WorldMap)WorldMap.this).size.gridSize; ++y2) {
                for (x = 0; x < ((WorldMap)WorldMap.this).size.gridSize; ++x) {
                    if (WorldMap.this.water[y2][x]) {
                        WorldMap.this.resistance[y2][x] = 10000.0;
                        continue;
                    }
                    WorldMap.this.resistance[y2][x] = perlin.pnoise((double)x * 0.03 + 988.0, (double)y2 * 0.023 - 2.0, -908.3) * 2.0 + perlin.pnoise((double)x * 0.09 + 2399.0, (double)y2 * 0.123 + 2.0, -33.3) + 3.0;
                    int waterCount = 0;
                    for (int dy = -7; dy < 14; ++dy) {
                        for (int dx = -7; dx < 14; ++dx) {
                            int yy = y2 + dy;
                            int xx = x + dx;
                            if (yy < 0 || yy >= WorldMap.this.water.length || xx < 0 || xx >= WorldMap.this.water[0].length || !WorldMap.this.water[yy][xx]) continue;
                            ++waterCount;
                        }
                    }
                    WorldMap.this.resistance[y2][x] = Math.max(0.2, WorldMap.this.resistance[y2][x] - (double)waterCount * 0.04);
                    int borderDist = Math.max(0, 10 - x) + Math.max(0, x - ((WorldMap)WorldMap.this).size.gridSize + 10) + Math.max(0, 10 - y2) + Math.max(0, y2 - ((WorldMap)WorldMap.this).size.gridSize + 10);
                    double[] dArray = WorldMap.this.resistance[y2];
                    int n = x;
                    dArray[n] = dArray[n] + (double)borderDist * 0.3;
                }
            }
            for (int n = 0; n < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 3000; ++n) {
                x = WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize);
                y = WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize);
                WorldMap.this.blitBlob(WorldMap.this.resistance, x, y, 20 + WorldMap.this.r.nextInt(20), 5);
            }
            block5: for (i = 0; i < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 3000; ++i) {
                x = 20 + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - 40);
                y = 20 + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - 40);
                if (!(WorldMap.this.height[y][x] > 1.25)) continue;
                for (TerrainFeature f : WorldMap.this.features) {
                    if ((f.x - x) * (f.x - x) + (f.y - y) * (f.y - y) >= 400) continue;
                    continue block5;
                }
                WorldMap.this.features.add(new TerrainFeature(TerrainFeatureType.MOUNTAIN, x, y));
                WorldMap.this.blitBlob(WorldMap.this.resistance, x, y, 40, 6);
            }
            block7: for (i = 0; i < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 100; ++i) {
                x = 20 + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - 40);
                y = 20 + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - 40);
                if (WorldMap.this.water[y][x] || !(perlin.pnoise((double)x * 0.01 - 88.0, (double)y * 0.01 + 9018.0, 555.0) > 0.25)) continue;
                for (TerrainFeature f : WorldMap.this.features) {
                    if ((f.x - x) * (f.x - x) + (f.y - y) * (f.y - y) >= 400) continue;
                    continue block7;
                }
                WorldMap.this.features.add(new TerrainFeature(TerrainFeatureType.FOREST, x, y));
                WorldMap.this.blitBlob(WorldMap.this.resistance, x, y, 30, 3);
            }
            block9: for (i = 0; i < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 100; ++i) {
                x = 10 + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - 40);
                y = 10 + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - 40);
                if (WorldMap.this.water[y][x] || WorldMap.this.water[y + 16][x + 16] || !(perlin.pnoise((double)y * 0.03 - 557.0, (double)x * 0.005 + 888.0, 222.0) > 0.3)) continue;
                for (TerrainFeature f : WorldMap.this.features) {
                    if ((f.x - x) * (f.x - x) + (f.y - y) * (f.y - y) >= 400) continue;
                    continue block9;
                }
                WorldMap.this.features.add(new TerrainFeature(TerrainFeatureType.SWAMP, x, y));
                WorldMap.this.blitBlob(WorldMap.this.resistance, x, y, 30, 3);
            }
            block11: for (i = 0; i < ((WorldMap)WorldMap.this).size.gridSize * ((WorldMap)WorldMap.this).size.gridSize / 100000; ++i) {
                x = 50 + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - 100);
                y = 50 + WorldMap.this.r.nextInt(((WorldMap)WorldMap.this).size.gridSize - 100);
                if (!WorldMap.this.water[y][x] || !WorldMap.this.water[y + 16][x + 16]) continue;
                for (TerrainFeature f : WorldMap.this.features) {
                    if ((f.x - x) * (f.x - x) + (f.y - y) * (f.y - y) >= 400) continue;
                    continue block11;
                }
                WorldMap.this.features.add(new TerrainFeature(TerrainFeatureType.SEA_CREATURES, x, y));
            }
            WorldMap.this.bs = Bonus.cityBonuses();
            Collections.shuffle(WorldMap.this.bs, WorldMap.this.r);
            WorldMap.this.offset = WorldMap.this.r.nextInt(City.NAMES.length);
            WorldMap.this.playerStart = null;
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Placing_city_x_y", index + 1, ((WorldMap)WorldMap.this).size.empires);
        }

        @Override
        public int getSize() {
            return ((WorldMap)WorldMap.this).size.empires;
        }

        @Override
        public void run(int index, WorldMap wm) {
            Utils.Pair p = WorldMap.this.findCityLocation(WorldMap.this.r);
            if (p == null) {
                WorldMap.this.stageIndex = 0;
                WorldMap.this.empires.clear();
                WorldMap.this.features.clear();
                return;
            }
            if (WorldMap.this.setupCityNames == null) {
                WorldMap.this.setupCityNames = new ArrayList<String>(Arrays.asList(City.NAMES));
                WorldMap.this.setupCityNames.remove(WorldMap.this.setupPlayerName);
                Collections.shuffle(WorldMap.this.setupCityNames, WorldMap.this.r);
            }
            Empire emp = new Empire(WorldMap.this.empires.isEmpty() ? WorldMap.this.setupPlayerName : WorldMap.this.setupCityNames.get((index + WorldMap.this.offset) % WorldMap.this.setupCityNames.size()), WorldMap.this.empires.isEmpty() ? WorldMap.this.playerCOA : CoatOfArms.getRandom(WorldMap.this.r), Bonus.NO_BONUS, 500, Empire.Personality.CONQUEROR, 0.5 + WorldMap.this.r.nextDouble(), TakeoverMethod.values()[WorldMap.this.r.nextInt(TakeoverMethod.values().length)]);
            City city = new City(WorldMap.this.empires.size(), (Integer)p.a, (Integer)p.b, emp.name, index >= WorldMap.this.bs.size() ? Bonus.NO_BONUS : (Bonus)((Object)WorldMap.this.bs.get(index)), 1, 1);
            city.originalEmpire = emp;
            city.income = WorldMap.this.income(WorldMap.this.playerStart, city, WorldMap.this.r);
            city.shipyardLevel = WorldMap.this.shipyardLevel(WorldMap.this.playerStart, city);
            city.generateLand(WorldMap.this.r);
            if (WorldMap.this.playerStart == null) {
                WorldMap.this.playerStart = city;
            } else {
                emp.money = WorldMap.this.money(WorldMap.this.playerStart, city, WorldMap.this.r);
                emp.policeLevel = SecretPoliceLevel.values()[WorldMap.this.r.nextInt(SecretPoliceLevel.values().length)];
            }
            emp.cities.add(city);
            WorldMap.this.empires.add(emp);
            if (index == 0) {
                emp.money += 400;
                city.bonus = Bonus.NO_BONUS;
                StrategicAI.setup(wm, emp, WorldMap.this.r, false, false);
                emp.money += 400;
            } else if (!ConstructionAffinity.GIVE_NONE_TO_THESE.contains((Object)city.bonus)) {
                emp.constructionAffinity = ConstructionAffinity.values()[WorldMap.this.r.nextInt(ConstructionAffinity.values().length)];
            }
            StrategicAI.setup(wm, emp, WorldMap.this.r, index == 0, true);
            if (index == 0) {
                emp.money += 100;
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Claiming_land_x_y", index + 1, ((WorldMap)WorldMap.this).size.empires);
        }

        @Override
        public int getSize() {
            return ((WorldMap)WorldMap.this).size.empires;
        }

        @Override
        public void run(int index, WorldMap wm) {
            WorldMap.this.calcCityDistances(index, null);
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Drawing_borders", new Object[0]);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void run(int index, WorldMap wm) {
            int x;
            WorldMap.this.cityOwnership = new int[((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            WorldMap.this.border = new boolean[((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            WorldMap.this.borderingCityID = new int[((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            WorldMap.this.roadMap = new boolean[((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            WorldMap.this.seaRouteBorder = new boolean[((WorldMap)WorldMap.this).size.gridSize][((WorldMap)WorldMap.this).size.gridSize];
            for (int y = 0; y < ((WorldMap)WorldMap.this).size.gridSize; ++y) {
                for (x = 0; x < ((WorldMap)WorldMap.this).size.gridSize; ++x) {
                    double maxInfluence = -1.0;
                    WorldMap.this.cityOwnership[y][x] = -1;
                    for (int ei = 0; ei < WorldMap.this.empires.size(); ++ei) {
                        double influence;
                        City c = WorldMap.this.empires.get((int)ei).cities.get(0);
                        if (!(WorldMap.this.cityDist[ei][y][x] < Double.MAX_VALUE) || !((influence = (double)Math.min(40, c.income) / (1.0 + WorldMap.this.cityDist[ei][y][x])) > maxInfluence)) continue;
                        WorldMap.this.cityOwnership[y][x] = ei;
                        maxInfluence = influence;
                    }
                }
            }
            HashMap borderings = WorldMap.this.determineBorders(true);
            for (x = 0; x < 100; ++x) {
                for (Empire e1 : borderings.keySet()) {
                    if (e1 == WorldMap.this.empires.get(0)) continue;
                    for (Empire e2 : (ArrayList)borderings.get(e1)) {
                        if (e1.getMainTincture() != e2.getMainTincture()) continue;
                        e1.arms = CoatOfArms.getRandom(WorldMap.this.r);
                    }
                }
            }
            WorldMap.this.cityPairs = new ArrayList();
            for (Empire e : borderings.keySet()) {
                City c1 = e.cities.get(0);
                for (Empire e2 : (ArrayList)borderings.get(e)) {
                    City c2 = e2.cities.get(0);
                    if (c2.id <= c1.id) continue;
                    WorldMap.this.cityPairs.add(new City[]{c1, c2});
                }
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Building_road_x_y", index + 1, this.getSize());
        }

        @Override
        public int getSize() {
            return WorldMap.this.cityPairs == null ? ((WorldMap)WorldMap.this).size.empires * 3 : WorldMap.this.cityPairs.size();
        }

        @Override
        public void run(int index, WorldMap wm) {
            int bestDy;
            int bestDx;
            int roadY;
            if (index == 0) {
                for (int y = 0; y < ((WorldMap)WorldMap.this).size.gridSize; ++y) {
                    for (int x = 0; x < ((WorldMap)WorldMap.this).size.gridSize; ++x) {
                        if (WorldMap.this.water[y][x]) continue;
                        int waterCount = 0;
                        for (int dy = -7; dy < 14; ++dy) {
                            for (int dx = -7; dx < 14; ++dx) {
                                int yy = y + dy;
                                int xx = x + dx;
                                if (yy < 0 || yy >= WorldMap.this.water.length || xx < 0 || xx >= WorldMap.this.water[0].length || !WorldMap.this.water[yy][xx]) continue;
                                ++waterCount;
                            }
                        }
                        double[] dArray = WorldMap.this.resistance[y];
                        int n = x;
                        dArray[n] = dArray[n] + (double)waterCount * 0.09;
                    }
                }
            }
            City[] cs = WorldMap.this.cityPairs.get(index);
            City c1 = cs[0];
            City c2 = cs[1];
            Road road = new Road(c1, c2);
            int roadX = c1.x;
            WorldMap.this.calcCityDistances(c2.id, new int[]{c1.id, c2.id});
            double[][] dist = WorldMap.this.cityDist[c2.id];
            if (dist[roadY][roadX] == Double.MAX_VALUE) {
                System.out.println("Cities too far apart.");
                return;
            }
            for (roadY = c1.y; roadX != c2.x || roadY != c2.y; roadX += bestDx, roadY += bestDy) {
                road.path.add(new int[]{roadX, roadY});
                bestDy = 0;
                bestDx = 0;
                double lowestDist = dist[roadY][roadX];
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dx = -1; dx < 2; ++dx) {
                        int xx = roadX + dx;
                        int yy = roadY + dy;
                        if (yy < 0 || yy >= dist.length || xx < 0 || xx >= dist[0].length || !(dist[yy][xx] < lowestDist)) continue;
                        bestDy = dy;
                        bestDx = dx;
                        lowestDist = dist[yy][xx];
                    }
                }
                if (bestDy != 0 || bestDx != 0) continue;
                throw new RuntimeException("Stuck in local minimum but not at destination.");
            }
            if (roadX == c2.x && roadY == c2.y) {
                for (int[] p : road.path) {
                    WorldMap.this.resistance[p[1]][p[0]] = Math.max(0.5, WorldMap.this.resistance[p[1]][p[0]] * 0.35);
                    for (int dy = 0; dy < 2; ++dy) {
                        for (int dx = 0; dx < 2; ++dx) {
                            int xx = p[0] + dx;
                            int yy = p[1] + dy;
                            if (yy < 0 || yy >= ((WorldMap)WorldMap.this).size.gridSize || xx < 0 || xx >= ((WorldMap)WorldMap.this).size.gridSize) continue;
                            WorldMap.this.roadMap[yy][xx] = true;
                        }
                    }
                }
                WorldMap.this.roads.add(road);
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Mapping_oceans", new Object[0]);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void run(int index, WorldMap wm) {
            int xx;
            int yy;
            int dx;
            int dy;
            for (int y = 0; y < ((WorldMap)WorldMap.this).size.gridSize; ++y) {
                for (int x = 0; x < ((WorldMap)WorldMap.this).size.gridSize; ++x) {
                    if (WorldMap.this.water[y][x]) {
                        WorldMap.this.resistance[y][x] = 1.0;
                        int landCount = 0;
                        for (dy = -7; dy < 14; ++dy) {
                            for (dx = -7; dx < 14; ++dx) {
                                yy = y + dy;
                                xx = x + dx;
                                if (yy < 0 || yy >= WorldMap.this.water.length || xx < 0 || xx >= WorldMap.this.water[0].length || WorldMap.this.water[yy][xx]) continue;
                                ++landCount;
                            }
                        }
                        double[] dArray = WorldMap.this.resistance[y];
                        int n = x;
                        dArray[n] = dArray[n] + (double)landCount * 0.07;
                        continue;
                    }
                    WorldMap.this.resistance[y][x] = 10000.0;
                }
            }
            block4: for (Empire e : WorldMap.this.empires) {
                City c = e.cities.get(0);
                c.probablyCoastal = false;
                for (dy = -30; dy < 31; ++dy) {
                    for (dx = -30; dx < 31; ++dx) {
                        yy = c.y + dy;
                        xx = c.x + dx;
                        if (yy < 0 || yy >= WorldMap.this.water.length || xx < 0 || xx >= WorldMap.this.water[0].length || !WorldMap.this.water[yy][xx]) continue;
                        c.probablyCoastal = true;
                        WorldMap.this.suppressBlob(WorldMap.this.resistance, c.x, c.y, 40, 1.0);
                        c.navNode = new NavNode(c.x, c.y);
                        WorldMap.this.navNodes.add(c.navNode);
                        double offset = WorldMap.this.r.nextDouble() * Math.PI;
                        for (int n = 0; n < 14; ++n) {
                            for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / (5.0 + (double)n * 0.7)) {
                                double a = angle + offset;
                                double dist = 30 + n * 40;
                                int npX = c.x + (int)(Math.cos(a) * dist);
                                int npY = c.y + (int)(Math.sin(a) * dist);
                                if (npX < 0 || npX >= ((WorldMap)WorldMap.this).size.gridSize || npY < 0 || npY >= ((WorldMap)WorldMap.this).size.gridSize || (n == 0 ? !WorldMap.this.water[npY][npX] : WorldMap.this.resistance[npY][npX] > 3.0)) continue;
                                WorldMap.this.navNodes.add(new NavNode(npX, npY));
                            }
                        }
                        continue block4;
                    }
                }
            }
            for (NavNode nn1 : WorldMap.this.navNodes) {
                block10: for (NavNode nn2 : WorldMap.this.navNodes) {
                    double d;
                    if (nn1 == nn2 || (d = Math.sqrt((nn1.x - nn2.x) * (nn1.x - nn2.x) + (nn1.y - nn2.y) * (nn1.y - nn2.y))) > 100.0) continue;
                    int along = 0;
                    while ((double)along < d) {
                        int alY = (int)((double)nn1.y + (double)((nn2.y - nn1.y) * along) / d);
                        int alX = (int)((double)nn1.x + (double)((nn2.x - nn1.x) * along) / d);
                        if (WorldMap.this.resistance[alY][alX] > 3.0) continue block10;
                        ++along;
                    }
                    nn1.adjacent.add(nn2);
                }
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Charting_sea_routes", index + 1, this.getSize());
        }

        @Override
        public int getSize() {
            int ncc = this.numCoastalCities();
            return ncc * ncc;
        }

        private int numCoastalCities() {
            return this.coastalCities().size();
        }

        private ArrayList<City> coastalCities() {
            ArrayList<City> cs = new ArrayList<City>();
            for (Empire e : WorldMap.this.empires) {
                if (!e.cities.get((int)0).probablyCoastal) continue;
                cs.add(e.cities.get(0));
            }
            return cs;
        }

        @Override
        public void run(int index, WorldMap wm) {
            City c2;
            ArrayList<City> cities = this.coastalCities();
            if (cities.isEmpty()) {
                return;
            }
            City c1 = cities.get(index / cities.size());
            if (c1 == (c2 = cities.get(index % cities.size()))) {
                return;
            }
            if (WorldMap.this.connected(c1, c2)) {
                return;
            }
            Road road = new Road(c1, c2);
            road.seaRoute = true;
            for (NavNode nn : WorldMap.this.navNodes) {
                nn.dist = Double.MAX_VALUE;
            }
            c2.navNode.dist = 0.0;
            boolean progress = true;
            boolean found = false;
            while (progress) {
                progress = false;
                for (NavNode nn : WorldMap.this.navNodes) {
                    for (NavNode nn2 : nn.adjacent) {
                        double d = Math.sqrt((nn.x - nn2.x) * (nn.x - nn2.x) + (nn.y - nn2.y) * (nn.y - nn2.y));
                        if (!(nn2.dist > nn.dist + (d /= (double)nn2.uses + 0.1))) continue;
                        nn2.dist = nn.dist + d;
                        progress = true;
                        if (nn2 != c1.navNode) continue;
                        found = true;
                    }
                }
            }
            if (found) {
                int yy;
                ArrayList<NavNode> nodePath = new ArrayList<NavNode>();
                NavNode current = c1.navNode;
                while (current != c2.navNode) {
                    nodePath.add(current);
                    if (nodePath.size() > 50) {
                        return;
                    }
                    ++current.uses;
                    NavNode next = null;
                    double closest = 0.0;
                    for (NavNode adj : current.adjacent) {
                        if (next != null && !(closest > adj.dist)) continue;
                        next = adj;
                        closest = adj.dist;
                    }
                    current = next;
                }
                nodePath.add(c2.navNode);
                for (int i = 0; i < nodePath.size() - 1; ++i) {
                    NavNode nn1 = (NavNode)nodePath.get(i);
                    NavNode nn2 = (NavNode)nodePath.get(i + 1);
                    double d = Math.sqrt((nn1.x - nn2.x) * (nn1.x - nn2.x) + (nn1.y - nn2.y) * (nn1.y - nn2.y));
                    int along = 0;
                    while ((double)along < d) {
                        int alX = (int)((double)nn1.x + (double)((nn2.x - nn1.x) * along) / d);
                        int alY = (int)((double)nn1.y + (double)((nn2.y - nn1.y) * along) / d);
                        road.path.add(new int[]{alX, alY});
                        ++along;
                    }
                }
                for (int[] p : road.path) {
                    WorldMap.this.resistance[p[1]][p[0]] = Math.max(0.05, WorldMap.this.resistance[p[1]][p[0]] * 0.35);
                    for (int dy = -2; dy < 4; ++dy) {
                        for (int dx = -2; dx < 4; ++dx) {
                            int xx = p[0] + dx;
                            yy = p[1] + dy;
                            if (yy < 0 || yy >= ((WorldMap)WorldMap.this).size.gridSize || xx < 0 || xx >= ((WorldMap)WorldMap.this).size.gridSize) continue;
                            WorldMap.this.seaRouteBorder[yy][xx] = true;
                        }
                    }
                }
                for (int[] p : road.path) {
                    for (int dy = 0; dy < 2; ++dy) {
                        for (int dx = 0; dx < 2; ++dx) {
                            int xx = p[0] + dx;
                            yy = p[1] + dy;
                            if (yy < 0 || yy >= ((WorldMap)WorldMap.this).size.gridSize || xx < 0 || xx >= ((WorldMap)WorldMap.this).size.gridSize) continue;
                            WorldMap.this.seaRouteBorder[yy][xx] = false;
                            WorldMap.this.roadMap[yy][xx] = true;
                        }
                    }
                }
                WorldMap.this.roads.add(road);
            }
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Roads_", new Object[0]);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void run(int index, WorldMap wm) {
            wm.findRoadOverlaps();
        }
    }, new SetupStage(){

        @Override
        public String getDesc(int index) {
            return Lang._t("Done", new Object[0]);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void run(int index, WorldMap wm) {
        }
    }};

    public void tick(int ms) {
        for (Empire e : this.empires) {
            e.tick(ms, this);
        }
        this.age += ms;
        this.designateVillain();
    }

    public void resolveUncontestedSeaIntercepts(Empire e) {
        for (Fleet f : e.fleets) {
            if (f.interceptTarget == null || f.fleeDestinationNeeded || !(f.progress >= f.transitDistance()) || f.interceptTarget.usingRoad == null || !f.interceptTarget.usingRoad.seaRoute || !f.interceptTarget.groundOnly()) continue;
            this.owner((Fleet)f.interceptTarget).fleets.remove(f.interceptTarget);
            f.interceptTarget.broadcastDestroyed(this);
            f.stopAndAskForHelp();
            e.messages.add(new Empire.Message(Empire.MessageType.ENEMY_LANDSHIPS_CAUGHT, null, Lang._t("enemy_landships_caught", this.owner(f.interceptTarget))));
        }
    }

    public void quickResolveCombats(Empire exceptFor, Random r) {
        for (Empire attacker : new ArrayList<Empire>(this.empires)) {
            if (attacker == exceptFor) continue;
            for (Fleet fleet : new ArrayList<Fleet>(attacker.fleets)) {
                if (fleet.location == null) continue;
                Empire defender = this.owner(fleet.location);
                if (defender == null) {
                    if (this.reportedNullDefender) continue;
                    try {
                        this.g.reportError("Null defender", null, "Fleet owner: " + attacker.name + "\nFleet location: " + fleet.location.name + "\nIn cities? " + this.cities().contains(fleet.location), false, true);
                    }
                    catch (Exception e) {
                        this.g.reportError("Null defender plus", e, null, false, true);
                    }
                    this.reportedNullDefender = true;
                    continue;
                }
                if (defender == attacker || defender == exceptFor) continue;
                this.quickResolveCombat(attacker, fleet, defender, fleet.location, r);
            }
        }
        for (Empire e : new ArrayList<Empire>(this.empires)) {
            if (!e.cities.isEmpty()) continue;
            this.removeEmpire(e);
        }
    }

    static int cost(ArrayList<Airship> l) {
        int c = 0;
        for (Airship s : l) {
            if (!s.isArmed()) continue;
            c += s.getCost();
        }
        return c;
    }

    public void quickResolveCombat(Empire attacker, Fleet attackingFleet, Empire defender, City defendingCity, Random r) {
        Fleet defendingFleet = new Fleet(defendingCity);
        for (Fleet fl : defender.fleets) {
            if (fl.location != defendingCity) continue;
            defendingFleet = fl;
            break;
        }
        while (WorldMap.cost(attackingFleet.actives) > (WorldMap.cost(defendingFleet.actives) + WorldMap.cost(defendingCity.getDefences())) / 4 && WorldMap.cost(defendingFleet.actives) + WorldMap.cost(defendingCity.getDefences()) > WorldMap.cost(attackingFleet.actives) / 4) {
            int attackerCost = 0;
            for (Airship s : attackingFleet.actives) {
                attackerCost += s.getCost();
            }
            int defenderCost = 0;
            for (Airship s : defendingFleet.actives) {
                defenderCost += s.getCost();
            }
            for (Airship b : defendingCity.getDefences()) {
                defenderCost = (int)((double)defenderCost + (double)b.getCost() * 0.6);
            }
            int attackerValue = attackerCost * attackerCost;
            int defenderValue = defenderCost * defenderCost;
            int roll = r.nextInt(attackerValue + defenderValue);
            if (roll < attackerValue) {
                int remove = r.nextInt(defendingFleet.actives.size() + defendingCity.getDefences().size());
                if (remove < defendingFleet.actives.size()) {
                    defendingFleet.actives.remove(remove);
                    continue;
                }
                defendingCity.removeDefence(defendingCity.getDefences().get(remove - defendingFleet.actives.size()));
                continue;
            }
            attackingFleet.actives.remove(r.nextInt(attackingFleet.actives.size()));
        }
        if (WorldMap.cost(attackingFleet.actives) <= (WorldMap.cost(defendingFleet.actives) + WorldMap.cost(defendingCity.getDefences())) / 4) {
            if (attackingFleet.actives.isEmpty() && attackingFleet.reserve.isEmpty()) {
                attacker.fleets.remove(attackingFleet);
                attackingFleet.broadcastDestroyed(this);
            } else {
                attackingFleet.fleeDestinationNeeded = true;
            }
            defendingCity.addMessage(City.MessageType.COMBAT, Lang._t("x_repels_y", defendingCity.name, attacker.name));
        } else {
            if (defendingFleet.actives.isEmpty() && defendingFleet.reserve.isEmpty()) {
                defender.fleets.remove(defendingFleet);
                defendingFleet.broadcastDestroyed(this);
            }
            defender.cities.remove(defendingCity);
            defendingCity.takeoverNeeded = defendingCity.originalEmpire != attacker;
            defendingCity.takeoverMethod = null;
            defendingCity.takeoverAmount = 0;
            attacker.cities.add(defendingCity);
            defendingCity.addMessage(City.MessageType.COMBAT, Lang._t("x_conquers_y", attacker.name, defendingCity.name));
            this.dirty = true;
        }
        defendingCity.constructionTarget = null;
    }

    public CampaignWorld.CombatInfo getCombatFor(Empire e, AirshipGame g) {
        for (Fleet f : e.fleets) {
            if (f.location != null && !f.fleeDestinationNeeded && !e.cities.contains(f.location)) {
                return this.makeCombat(e, f, this.owner(f.location), f.location, false, g);
            }
            if (f.interceptTarget == null || f.fleeDestinationNeeded || !(f.progress >= f.transitDistance())) continue;
            return this.makeCombat(e, f, this.owner(f.interceptTarget), f.interceptTarget, this.reportedNullDefender, g);
        }
        for (Empire attacker : this.empires) {
            if (attacker == e) continue;
            for (Fleet f : attacker.fleets) {
                if (f.location == null || f.fleeDestinationNeeded || !e.cities.contains(f.location)) continue;
                return this.makeCombat(attacker, f, e, f.location, true, g);
            }
        }
        return null;
    }

    public ArrayList<City> cities() {
        ArrayList<City> cs = new ArrayList<City>();
        for (Empire e : this.empires) {
            cs.addAll(e.cities);
        }
        return cs;
    }

    public Empire owner(City c) {
        for (Empire e : this.empires) {
            if (!e.cities.contains(c)) continue;
            return e;
        }
        return null;
    }

    public Empire owner(Fleet f) {
        for (Empire e : this.empires) {
            if (!e.fleets.contains(f)) continue;
            return e;
        }
        return null;
    }

    public Empire owner(Spy spy) {
        for (Empire e : this.empires) {
            if (!e.spies.contains(spy)) continue;
            return e;
        }
        return null;
    }

    private CampaignWorld.CombatInfo makeCombat(Empire attacker, Fleet attackingFleet, Empire defender, City defendingCity, boolean playerDefending, AirshipGame g) {
        int count;
        Combat c = new Combat(g, TimeOfDay.getRandom(AGame.ANIM_R));
        c.backgroundFlavor = this.getBackground((int)attackingFleet.realX(), (int)attackingFleet.realY());
        c.sides.get((int)0).arms = attacker.arms;
        c.sides.get((int)0).name = attacker.name;
        c.sides.get((int)0).bonuses = attacker.bonuses();
        c.sides.get((int)0).ships.addAll(attackingFleet.actives);
        c.sides.get((int)0).reserve.addAll(attackingFleet.reserve);
        c.sides.get((int)1).arms = defender.arms;
        c.sides.get((int)1).name = defender.name;
        c.sides.get((int)1).bonuses = defender.bonuses();
        c.sides.get((int)1).ships.addAll(defendingCity.getDefences());
        Fleet defendingFleet = this.getGarrison(defendingCity);
        if (defendingFleet != null) {
            c.sides.get((int)1).ships.addAll(defendingFleet.actives);
            c.sides.get((int)1).reserve.addAll(defendingFleet.reserve);
            ArrayList<Airship> l = new ArrayList<Airship>(defendingFleet.actives);
            l.retainAll(defendingFleet.reserve);
            if (!l.isEmpty()) {
                System.out.println("ACTIVE-RESERVE OVERLAP");
            }
        }
        for (Airship as : c.sides.get((int)1).ships) {
            System.out.println(as.name);
        }
        Combat.Side side = c.sides.get(1);
        for (Airship ship : side.ships) {
            count = 0;
            for (Airship ship2 : side.ships) {
                if (ship != ship2) continue;
                ++count;
            }
            for (Airship ship2 : side.reserve) {
                if (ship != ship2) continue;
                ++count;
            }
            if (count == 1) continue;
            System.out.println("Miscount in combat setup: " + count);
        }
        for (Airship ship : side.reserve) {
            count = 0;
            for (Airship ship2 : side.ships) {
                if (ship != ship2) continue;
                ++count;
            }
            for (Airship ship2 : side.reserve) {
                if (ship != ship2) continue;
                ++count;
            }
            if (count == 1) continue;
            System.out.println("Miscount in combat setup: " + count);
        }
        for (Airship ship : c.sides.get((int)0).ships) {
            ship.currentBonuses = attacker.bonuses();
        }
        for (Airship ship : c.sides.get((int)1).ships) {
            ship.currentBonuses = defender.bonuses();
        }
        c.landFormations.add(defendingCity.ground);
        for (LandFormation lf : defendingCity.floaters) {
            c.landFormations.add(lf);
        }
        c.sides.get(0).layoutShips(c, false);
        c.sides.get(1).layoutShips(c, true);
        return new CampaignWorld.CombatInfo(c, attackingFleet, defendingFleet, defendingCity, playerDefending ? 1 : 0, false);
    }

    private CampaignWorld.CombatInfo makeCombat(Empire attacker, Fleet attackingFleet, Empire defender, Fleet defendingFleet, boolean playerDefending, AirshipGame g) {
        Combat c = new Combat(g, TimeOfDay.getRandom(AGame.ANIM_R));
        c.backgroundFlavor = this.getBackground((int)attackingFleet.realX(), (int)attackingFleet.realY());
        c.sides.get((int)0).arms = attacker.arms;
        c.sides.get((int)0).name = attacker.name;
        c.sides.get((int)0).bonuses = attacker.bonuses();
        c.sides.get((int)0).ships.addAll(attackingFleet.actives);
        c.sides.get((int)0).reserve.addAll(attackingFleet.reserve);
        c.sides.get((int)1).arms = defender.arms;
        c.sides.get((int)1).name = defender.name;
        c.sides.get((int)1).bonuses = defender.bonuses();
        if (defendingFleet.usingRoad != null && defendingFleet.usingRoad.seaRoute) {
            for (Airship ship : defendingFleet.actives) {
                if (ship.type.onGround) continue;
                c.sides.get((int)1).ships.add(ship);
            }
            for (Airship ship : defendingFleet.reserve) {
                if (ship.type.onGround) continue;
                c.sides.get((int)1).reserve.add(ship);
            }
        } else {
            c.sides.get((int)1).ships.addAll(defendingFleet.actives);
            c.sides.get((int)1).reserve.addAll(defendingFleet.reserve);
        }
        for (Airship ship : c.sides.get((int)0).ships) {
            ship.currentBonuses = attacker.bonuses();
        }
        for (Airship ship : c.sides.get((int)1).ships) {
            ship.currentBonuses = defender.bonuses();
        }
        Utils.Pair<LandFormation, List<LandFormation>> p = LandFormation.generate(AGame.ANIM_R);
        c.landFormations.add((LandFormation)p.a);
        c.landFormations.addAll((Collection)p.b);
        c.sides.get(0).layoutShips(c, false);
        c.sides.get(1).layoutShips(c, true);
        return new CampaignWorld.CombatInfo(c, attackingFleet, defendingFleet, null, playerDefending ? 1 : 0, false);
    }

    public CombatBackgroundFlavor getBackground(int x, int y) {
        CombatBackgroundFlavor cbf = CombatBackgroundFlavor.PLAINS;
        int closest = 6400;
        for (TerrainFeature tf : this.features) {
            int distSq = (tf.x - x) * (tf.x - x) + (tf.y - y) * (tf.y - y);
            if (distSq >= 4900 || distSq >= closest) continue;
            closest = distSq;
            switch (tf.type) {
                case MOUNTAIN: {
                    cbf = CombatBackgroundFlavor.MOUNTAIN;
                    break;
                }
                case FOREST: {
                    cbf = CombatBackgroundFlavor.FOREST;
                    break;
                }
                case SWAMP: {
                    cbf = CombatBackgroundFlavor.SWAMPS;
                }
            }
        }
        if (cbf == CombatBackgroundFlavor.PLAINS) {
            block6: for (int dy = -20; dy < 20; ++dy) {
                for (int dx = -20; dx < 20; ++dx) {
                    int ny = y + dy;
                    int nx = x + dx;
                    if (ny < 0 || nx < 0 || ny >= this.water.length || nx >= this.water[0].length || !this.water[ny][nx]) continue;
                    cbf = CombatBackgroundFlavor.SEA;
                    break block6;
                }
            }
        }
        return cbf;
    }

    public void removeEmpire(Empire loser) {
        this.empires.remove(loser);
        for (Empire e : this.empires) {
            for (City c : e.cities) {
                if (c.originalEmpire != loser) continue;
                c.originalEmpire = null;
            }
        }
    }

    public Fleet getGarrison(City city) {
        Empire o = this.owner(city);
        for (Fleet f : o.fleets) {
            if (f.location != city) continue;
            return f;
        }
        return null;
    }

    public String getSetupStageDesc() {
        int index = this.stageIndex;
        for (SetupStage ss : this.setupStages) {
            if (index < ss.getSize()) {
                return ss.getDesc(index);
            }
            index -= ss.getSize();
        }
        return "...";
    }

    public int getSetupProgress() {
        return this.stageIndex;
    }

    public int getSetupLength() {
        int n = 0;
        for (SetupStage stage : this.setupStages) {
            n += stage.getSize();
        }
        return n;
    }

    private void blitBlob(double[][] resistance, int x, int y, int r, int amt) {
        for (int dy = -r; dy <= r * 2; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= resistance.length) continue;
            for (int dx = -r; dx <= r * 2; ++dx) {
                double d;
                int xx = x + dx;
                if (xx < 0 || xx >= resistance[0].length || !((d = Math.sqrt((x - xx) * (x - xx) + (y - yy) * (y - yy))) < (double)r)) continue;
                double a = (double)amt * ((double)r - d) / (double)r / 2.0 + (double)(amt / 2);
                double[] dArray = resistance[yy];
                int n = xx;
                dArray[n] = dArray[n] + a;
            }
        }
    }

    private void suppressBlob(double[][] resistance, int x, int y, int r, double max) {
        for (int dy = -r; dy <= r * 2; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= resistance.length) continue;
            for (int dx = -r; dx <= r * 2; ++dx) {
                double d;
                int xx = x + dx;
                if (xx < 0 || xx >= resistance[0].length || !((d = Math.sqrt((x - xx) * (x - xx) + (y - yy) * (y - yy))) < (double)r)) continue;
                resistance[yy][xx] = Math.min(resistance[yy][xx], max);
            }
        }
    }

    public boolean connected(City c1, City c2) {
        return this.getConnection(c1, c2) != null;
    }

    public boolean connectedByLand(City c1, City c2) {
        Road road = this.getConnection(c1, c2);
        return road != null && !road.seaRoute;
    }

    public Road getConnection(City c1, City c2) {
        for (Road road : this.roads) {
            if ((road.src != c1 || road.dst != c2) && (road.src != c2 || road.dst != c1)) continue;
            return road;
        }
        return null;
    }

    private void calcCityDistances(int empireIndex, int[] allowedTerritories) {
        Empire e = this.empires.get(empireIndex);
        City c = e.cities.get(0);
        double[][] dist = this.cityDist[empireIndex];
        for (int y = 0; y < dist.length; ++y) {
            for (int x = 0; x < dist[y].length; ++x) {
                dist[y][x] = Double.MAX_VALUE;
            }
        }
        boolean[][] inQ = new boolean[this.size.gridSize][this.size.gridSize];
        LinkedList<int[]> q = new LinkedList<int[]>();
        dist[c.y][c.x] = 0.0;
        q.add(new int[]{c.x, c.y});
        inQ[c.y][c.x] = true;
        while (!q.isEmpty()) {
            int[] pt = (int[])q.pollFirst();
            int x = pt[0];
            int y = pt[1];
            inQ[y][x] = false;
            for (int dy = -1; dy < 2; ++dy) {
                for (int dx = -1; dx < 2; ++dx) {
                    double newDist;
                    int xx = x + dx;
                    int yy = y + dy;
                    if (yy < 0 || yy >= dist.length || xx < 0 || xx >= dist[0].length || this.resistance[yy][xx] >= 10000.0) continue;
                    if (allowedTerritories != null) {
                        boolean allowed = false;
                        for (int ti = 0; ti < allowedTerritories.length; ++ti) {
                            if (this.cityOwnership[yy][xx] != allowedTerritories[ti]) continue;
                            allowed = true;
                            break;
                        }
                        if (!allowed) continue;
                    }
                    if (!((newDist = (dx == 0 || dy == 0 ? 1.0 : 1.4) * this.resistance[yy][xx] + dist[y][x]) < dist[yy][xx])) continue;
                    int n = allowedTerritories == null ? 2000 : 3000;
                    if (!(newDist < (double)n)) continue;
                    dist[yy][xx] = newDist;
                    if (inQ[yy][xx]) continue;
                    inQ[yy][xx] = true;
                    q.add(new int[]{xx, yy});
                }
            }
        }
    }

    private void findRoadOverlaps() {
        for (Road road : this.roads) {
            road.overlaps.clear();
            for (int[] pt : road.path) {
                HashMap<Road, Integer> m = new HashMap<Road, Integer>();
                road.overlaps.add(m);
                block2: for (Road r2 : this.roads) {
                    for (int pi = 0; pi < r2.path.size(); ++pi) {
                        int[] pt2 = r2.path.get(pi);
                        if (pt[0] != pt2[0] || pt[1] != pt2[1]) continue;
                        m.put(r2, pi);
                        continue block2;
                    }
                }
            }
            if (road.overlaps.size() == road.path.size()) continue;
            System.out.println("len mismatch!");
        }
    }

    public boolean doSetup() {
        int index = this.stageIndex;
        for (SetupStage ss : this.setupStages) {
            if (index < ss.getSize()) {
                ss.run(index, this);
                ++this.stageIndex;
                return false;
            }
            index -= ss.getSize();
        }
        return true;
    }

    private HashMap<Empire, ArrayList<Empire>> determineBorders(boolean getBorderings) {
        HashMap<Empire, ArrayList<Empire>> borderings = new HashMap<Empire, ArrayList<Empire>>();
        for (int y = 0; y < this.cityOwnership.length; ++y) {
            for (int x = 0; x < this.cityOwnership[0].length; ++x) {
                int owner = this.cityOwnership[y][x];
                if (owner == -1) continue;
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dx = -1; dx < 2; ++dx) {
                        int otherOwner;
                        int xx = x + dx;
                        int yy = y + dy;
                        if (yy < 0 || yy >= this.cityOwnership.length || xx < 0 || xx >= this.cityOwnership[0].length || (otherOwner = this.cityOwnership[yy][xx]) == -1 || otherOwner == owner) continue;
                        this.border[y][x] = true;
                        this.borderingCityID[y][x] = otherOwner;
                        if (!getBorderings) continue;
                        Empire e1 = this.empires.get(owner);
                        Empire e2 = this.empires.get(otherOwner);
                        if (!borderings.containsKey(e1)) {
                            borderings.put(e1, new ArrayList());
                        }
                        if (borderings.get(e1).contains(e2)) continue;
                        borderings.get(e1).add(e2);
                    }
                }
            }
        }
        return borderings;
    }

    public WorldMap(long seed, Size size, AirshipGame g, CoatOfArms playerCOA) {
        this.g = g;
        this.r = new Random(seed);
        this.size = size;
        this.playerCOA = playerCOA;
    }

    private int money(City playerStart, City city, Random r) {
        int dist = (int)Math.pow((city.x - playerStart.x) * (city.x - playerStart.x) + (city.y - playerStart.y) * (city.y - playerStart.y), 0.5);
        return 100 + dist / 3 + r.nextInt(700);
    }

    private int income(City playerStart, City city, Random r) {
        if (playerStart == null) {
            return 70;
        }
        int dist = (int)Math.pow((city.x - playerStart.x) * (city.x - playerStart.x) + (city.y - playerStart.y) * (city.y - playerStart.y), 0.5);
        return 30 + dist / 60 + r.nextInt(20);
    }

    private int shipyardLevel(City playerStart, City city) {
        if (playerStart == null) {
            return 2;
        }
        int dist = (int)Math.sqrt((city.x - playerStart.x) * (city.x - playerStart.x) + (city.y - playerStart.y) * (city.y - playerStart.y));
        return Math.min(1 + dist / 150, City.SHIPYARD_SIZES.length - 1);
    }

    private double[][] genGrid(Random r, Size size) {
        Perlin p = new Perlin(r);
        this.water = new boolean[size.gridSize][size.gridSize];
        double[][] height = new double[size.gridSize][size.gridSize];
        for (int y = 0; y < size.gridSize; ++y) {
            for (int x = 0; x < size.gridSize; ++x) {
                height[y][x] = 1.0 - (p.pnoise((double)x * 0.01 * 256.0 / (double)size.gridSize, (double)y * 0.01 * 256.0 / (double)size.gridSize, 0.0) + p.pnoise((double)(x - y) * 0.01 * 256.0 / (double)size.gridSize, (double)x * 0.02 * 256.0 / (double)size.gridSize, (double)y * 0.02 * 256.0 / (double)size.gridSize) + (double)(x + y) * 0.0015 * 256.0 / (double)size.gridSize + p.pnoise((double)x * 0.02 + 908.0, (double)y * 0.02 + 9018.0, 2.2E-4 * (double)y) * 0.2);
                this.water[y][x] = height[y][x] < 0.6;
            }
        }
        return height;
    }

    private Utils.Pair<Integer, Integer> findCityLocation(Random r) {
        Utils.Pair p;
        int iters = 0;
        block0: while (true) {
            if (iters++ >= 10000) {
                return null;
            }
            p = new Utils.Pair((Object)(50 + r.nextInt(this.water[0].length - 250)), (Object)(50 + r.nextInt(this.water.length - 100)));
            if (this.water[(Integer)p.b][(Integer)p.a]) continue;
            block1: for (int dy = -40; dy < 41; ++dy) {
                for (int dx = -40; dx < 41; ++dx) {
                    int xx = (Integer)p.a + dx;
                    int yy = (Integer)p.b + dy;
                    if (xx < 40 || xx >= this.size.gridSize - 40 || yy < 40 || yy >= this.size.gridSize - 40 || this.water[yy][xx]) continue;
                    for (int dy2 = -1; dy2 < 2; ++dy2) {
                        for (int dx2 = -1; dx2 < 2; ++dx2) {
                            int xxx = xx + dx2;
                            int yyy = yy + dy2;
                            if (xxx < 0 || xxx >= this.size.gridSize || yyy < 0 || yyy >= this.size.gridSize || !this.water[yyy][xxx]) continue;
                            p = new Utils.Pair((Object)xx, (Object)yy);
                            break block1;
                        }
                    }
                }
            }
            for (TerrainFeature f : this.features) {
                if ((f.x - (Integer)p.a) * (f.x - (Integer)p.a) + (f.y - (Integer)p.b) * (f.y - (Integer)p.b) >= 900) continue;
                continue block0;
            }
            for (Empire em : this.empires) {
                for (City c : em.cities) {
                    if ((c.x - (Integer)p.a) * (c.x - (Integer)p.a) + (c.y - (Integer)p.b) * (c.y - (Integer)p.b) >= 40000) continue;
                    continue block0;
                }
            }
            break;
        }
        return p;
    }

    public WorldMap(JSONObject o, AirshipGame g) {
        int i;
        this.g = g;
        JSONArray a = o.getJSONArray("empires");
        for (i = 0; i < a.length(); ++i) {
            this.empires.add(new Empire(a.getJSONObject(i)));
        }
        for (i = 0; i < a.length(); ++i) {
            this.empires.get(i).finish(a.getJSONObject(i), this);
        }
        a = o.getJSONArray("terrainFeatures");
        for (i = 0; i < a.length(); ++i) {
            JSONObject f = a.getJSONObject(i);
            this.features.add(new TerrainFeature(TerrainFeatureType.valueOf(f.getString("type")), f.getInt("x"), f.getInt("y")));
        }
        this.water = this.fromBitString(o.getJSONObject("water"));
        a = o.getJSONArray("roads");
        for (i = 0; i < a.length(); ++i) {
            this.roads.add(new Road(a.getJSONObject(i), this));
        }
        a = o.getJSONArray("empires");
        for (i = 0; i < a.length(); ++i) {
            this.empires.get(i).finishFleets(a.getJSONObject(i), this);
        }
        this.cityOwnership = this.fromIntString(o.getJSONObject("cityOwnership"));
        this.age = o.optInt("age", 0);
        this.villainDesignated = o.optBoolean("villainDesignated", false);
        this.border = new boolean[this.cityOwnership.length][this.cityOwnership[0].length];
        this.borderingCityID = new int[this.cityOwnership.length][this.cityOwnership[0].length];
        this.roadMap = new boolean[this.cityOwnership.length][this.cityOwnership[0].length];
        this.seaRouteBorder = new boolean[this.cityOwnership.length][this.cityOwnership[0].length];
        this.determineBorders(false);
        for (Road road : this.roads) {
            int yy;
            int xx;
            int dx;
            int dy;
            if (road.seaRoute) {
                for (int[] p : road.path) {
                    for (dy = -2; dy < 4; ++dy) {
                        for (dx = -2; dx < 4; ++dx) {
                            xx = p[0] + dx;
                            yy = p[1] + dy;
                            if (yy < 0 || yy >= this.roadMap.length || xx < 0 || xx >= this.roadMap[0].length) continue;
                            this.seaRouteBorder[yy][xx] = true;
                        }
                    }
                }
            }
            for (int[] p : road.path) {
                for (dy = 0; dy < 2; ++dy) {
                    for (dx = 0; dx < 2; ++dx) {
                        xx = p[0] + dx;
                        yy = p[1] + dy;
                        if (yy < 0 || yy >= this.roadMap.length || xx < 0 || xx >= this.roadMap[0].length) continue;
                        this.seaRouteBorder[yy][xx] = false;
                        this.roadMap[yy][xx] = true;
                    }
                }
            }
        }
        this.findRoadOverlaps();
    }

    private boolean[][] fromBitString(JSONObject o) {
        int yl = o.getInt("yl");
        int xl = o.getInt("xl");
        String raw = o.getString("data");
        boolean[][] data = new boolean[yl][xl];
        for (int y = 0; y < data.length; ++y) {
            for (int x = 0; x < data[0].length; ++x) {
                data[y][x] = raw.charAt(y * xl + x) == '1';
            }
        }
        return data;
    }

    private JSONObject toBitString(boolean[][] data) {
        JSONObject o = new JSONObject();
        o.put("yl", data.length);
        o.put("xl", data[0].length);
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < data.length; ++y) {
            for (int x = 0; x < data[0].length; ++x) {
                sb.append(data[y][x] ? "1" : "0");
            }
        }
        o.put("data", sb.toString());
        return o;
    }

    private JSONObject toIntString(int[][] data) {
        JSONObject o = new JSONObject();
        o.put("yl", data.length);
        o.put("xl", data[0].length);
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < data.length; ++y) {
            for (int x = 0; x < data[0].length; ++x) {
                sb.append(data[y][x]).append(" ");
            }
        }
        o.put("data", sb.toString());
        return o;
    }

    private int[][] fromIntString(JSONObject o) {
        int h = o.getInt("yl");
        int w = o.getInt("xl");
        int[][] d = new int[h][w];
        String[] raw = o.getString("data").split(" ");
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                d[y][x] = Integer.parseInt(raw[y * w + x]);
            }
        }
        return d;
    }

    public void designateVillain() {
        if (!this.villainDesignated && this.age > 90000) {
            for (Empire e : this.empires) {
                if (this.empires.indexOf(e) == 0 || e.cities.size() <= 1) continue;
                return;
            }
            Empire villain = this.empires.get(this.empires.size() - 1);
            villain.cities.get((int)0).income += 30;
            villain.money += 2000;
            villain.aggressiveness += 0.5;
            this.villainDesignated = true;
            System.out.println("Designated villain: " + villain.name);
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        JSONArray a = new JSONArray();
        o.put("empires", a);
        for (Empire e : this.empires) {
            a.put(e.toJSON(this));
        }
        a = new JSONArray();
        o.put("terrainFeatures", a);
        for (TerrainFeature tf : this.features) {
            a.put(new JSONObject().put("type", tf.type.name()).put("x", tf.x).put("y", tf.y));
        }
        o.put("water", this.toBitString(this.water));
        a = new JSONArray();
        o.put("roads", a);
        for (Road road : this.roads) {
            a.put(road.toJSON(this));
        }
        o.put("cityOwnership", this.toIntString(this.cityOwnership));
        o.put("age", this.age);
        o.put("villainDesignated", this.villainDesignated);
        return o;
    }

    public static final class NavNode {
        public int x;
        public int y;
        public final ArrayList<NavNode> adjacent = new ArrayList();
        public transient double dist;
        public int uses;

        public NavNode(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    private static interface SetupStage {
        public String getDesc(int var1);

        public int getSize();

        public void run(int var1, WorldMap var2);
    }

    public static enum Size {
        SMALL(768, 5),
        MEDIUM(1024, 9),
        LARGE(1536, 18);

        public final int gridSize;
        public final int empires;

        private Size(int gridSize, int empires) {
            this.gridSize = gridSize;
            this.empires = empires;
        }

        public String getName() {
            return Lang._t("mapsize_" + this.name(), new Object[0]);
        }
    }

    public static class TerrainFeature {
        TerrainFeatureType type;
        public int x;
        public int y;

        public TerrainFeature(TerrainFeatureType type, int x, int y) {
            this.type = type;
            this.x = x;
            this.y = y;
        }
    }

    public static enum TerrainFeatureType {
        MOUNTAIN,
        FOREST,
        SWAMP,
        SEA_CREATURES;

    }
}

