/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.ScreenMode;

public class ZoomToFitButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return true;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Zoom_to_fit", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        ZoomToFitButton.zoomToFit(in, us, 1.0);
    }

    public static void zoomOut(Input in, UniScreen us) {
        us.zoom = Math.min(2.941176470588235E-4 * (double)in.mode().width, 8.333333333333334E-4 * (double)in.mode().height);
        us.scrollX = 0;
        us.scrollY = 0;
    }

    public static void zoomToFit(Input in, UniScreen us, double mixFactor) {
        int left = 10000;
        int right = -10000;
        int top = 10000;
        int bottom = -10000;
        boolean hasShips = false;
        if (us.combat != null) {
            for (Combat.Side s : us.combat.sides) {
                for (Airship ship : s.ships) {
                    hasShips = true;
                    left = Math.min(ship.getX() - 100, left);
                    right = Math.max(ship.getX() + ship.getWidth() * 16 + 100, right);
                    top = Math.min(ship.getY() - 100, top);
                    bottom = Math.max(ship.getY() + ship.getHeight() * 16 + 100, bottom);
                }
            }
        } else if (us.city != null) {
            for (Airship ship : us.city.getDefences()) {
                hasShips = true;
                left = Math.min(ship.getX() - 100, left);
                right = Math.max(ship.getX() + ship.getWidth() * 16 + 100, right);
                top = Math.min(ship.getY() - 100, top);
                bottom = Math.max(ship.getY() + ship.getHeight() * 16 + 100, bottom);
            }
            Fleet fl = us.wm.getGarrison(us.city);
            if (fl != null) {
                for (Airship ship : fl.actives) {
                    hasShips = true;
                    left = Math.min(ship.getX() - 100, left);
                    right = Math.max(ship.getX() + ship.getWidth() * 16 + 100, right);
                    top = Math.min(ship.getY() - 100, top);
                    bottom = Math.max(ship.getY() + ship.getHeight() * 16 + 100, bottom);
                }
            }
        } else if (us.standaloneEditShip != null && !us.standaloneEditShip.modules.isEmpty()) {
            Airship ship = us.standaloneEditShip;
            hasShips = true;
            left = Math.min(ship.getX() - 100, left);
            right = Math.max(ship.getX() + ship.getWidth() * 16 + 100, right);
            top = Math.min(ship.getY() - 100, top);
            bottom = Math.max(ship.getY() + ship.getHeight() * 16 + 100, bottom);
        }
        if (!hasShips) {
            return;
        }
        ScreenMode sm = in.mode();
        left = Math.max(left, -1599);
        right = Math.min(right, 1599);
        bottom = Math.min(bottom, 832);
        int w = right - left;
        double wZoom = 1.0 / (double)w * (double)sm.width;
        int h = bottom - top;
        double hZoom = 1.0 / (double)h * (double)sm.height;
        double zoom = Math.min(wZoom, hZoom);
        double scrollX = -left - w / 2;
        double scrollY = -top - h / 2;
        us.zoom = us.zoom * (1.0 - mixFactor) + zoom * mixFactor;
        us.scrollX = (int)((double)us.scrollX * (1.0 - mixFactor) + scrollX * mixFactor);
        us.scrollY = (int)((double)us.scrollY * (1.0 - mixFactor) + scrollY * mixFactor);
    }

    public static void zoomToEditShip(Input in, UniScreen us) {
        if (!(us.intent instanceof EditShipIntent)) {
            return;
        }
        Airship ship = ((EditShipIntent)us.intent).getShip(us);
        int left = Math.min(ship.getX() - 100, 10000);
        int right = Math.max(ship.getX() + ship.getWidth() * 16 + 100, -10000);
        int top = Math.min(ship.getY() - 100, 10000);
        int bottom = Math.max(ship.getY() + ship.getHeight() * 16 + 100, -10000);
        ScreenMode sm = in.mode();
        int w = right - left;
        double wZoom = 1.0 / (double)w * (double)(sm.width - 320);
        int h = bottom - top;
        double hZoom = 1.0 / (double)h * (double)sm.height;
        us.zoom = Math.min(wZoom, hZoom);
        us.scrollX = -left - w / 2 + (int)(160.0 / us.zoom);
        us.scrollY = -top - h / 2;
    }

    @Override
    public String hotkey(UniScreen us) {
        return "Z";
    }
}

