/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import net.puppygames.steam.ISteamAPI;
import net.puppygames.steam.ISteamApps;
import net.puppygames.steam.ISteamFriends;
import net.puppygames.steam.ISteamMatchmaking;
import net.puppygames.steam.ISteamMatchmakingServers;
import net.puppygames.steam.ISteamNetworking;
import net.puppygames.steam.ISteamRemoteStorage;
import net.puppygames.steam.ISteamUser;
import net.puppygames.steam.ISteamUserStats;
import net.puppygames.steam.ISteamUtils;
import net.puppygames.steam.SteamException;

public class Steam {
    private static final boolean DEBUG = Boolean.getBoolean("net.puppygames.steam.Steam.DEBUG");
    private static final String IMPLEMENTATION = System.getProperty("net.puppygames.steam.implementation", "net.puppygames.steam.SteamAPI");
    private static ISteamAPI impl;

    static void log(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    public static void create() {
        if (impl != null) {
            Steam.log("Steampuppy already created");
            return;
        }
        try {
            impl = (ISteamAPI)Class.forName(IMPLEMENTATION).newInstance();
            impl.create();
        }
        catch (SteamException e) {
            impl = null;
            throw e;
        }
        catch (Exception e) {
            impl = null;
            throw new SteamException(e);
        }
    }

    public static boolean isCreated() {
        return impl != null;
    }

    public static void init(int appID) {
        if (!Steam.isCreated()) {
            Steam.create();
        }
        impl.init(appID);
    }

    public static int getAppID() {
        return impl.getAppID();
    }

    public static void shutdown() {
        if (impl == null) {
            Steam.log("Already shutdown");
            return;
        }
        impl.shutdown();
    }

    public static void destroy() {
        if (impl != null) {
            impl.shutdown();
        }
        impl = null;
    }

    public static void tick() {
        Steam.checkCreated();
        impl.tick();
    }

    private static void checkCreated() {
        if (impl == null) {
            throw new RuntimeException("Steam is not initialised");
        }
    }

    public static boolean isSteamRunning() {
        Steam.checkCreated();
        return impl.isSteamRunning();
    }

    public static ISteamUser getUser() {
        Steam.checkCreated();
        return impl.getUser();
    }

    public static ISteamFriends getFriends() {
        Steam.checkCreated();
        return impl.getFriends();
    }

    public static ISteamUtils getUtils() {
        Steam.checkCreated();
        return impl.getUtils();
    }

    public static ISteamMatchmaking getMatchmaking() {
        Steam.checkCreated();
        return impl.getMatchmaking();
    }

    public static ISteamUserStats getUserStats() {
        Steam.checkCreated();
        return impl.getUserStats();
    }

    public static ISteamApps getApps() {
        Steam.checkCreated();
        return impl.getApps();
    }

    public static ISteamNetworking getNetworking() {
        Steam.checkCreated();
        return impl.getNetworking();
    }

    public static ISteamMatchmakingServers getMatchmakingServers() {
        Steam.checkCreated();
        return impl.getMatchmakingServers();
    }

    public static ISteamRemoteStorage getRemoteStorage() {
        Steam.checkCreated();
        return impl.getRemoteStorage();
    }
}

