/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import net.puppygames.steam.FlagsEnum;
import net.puppygames.steam.IntEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Utils {
    private Utils() {
    }

    public static <T extends Enum<T>> T find(int n, T[] values) {
        T[] TArray = values;
        int n2 = values.length;
        int n3 = 0;
        while (n3 < n2) {
            T o = TArray[n3];
            if (((IntEnum)o).getValue() == n) {
                return o;
            }
            ++n3;
        }
        return null;
    }

    public static <T extends Enum<T>> EnumSet<T> fromFlags(int f, Class<T> clazz, T[] values) {
        EnumSet<T> ret = EnumSet.noneOf(clazz);
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if ((((FlagsEnum)t).getValue() & f) != 0) {
                ret.add(t);
            }
            ++n2;
        }
        return ret;
    }

    public static <T extends Enum<T>> int toIntFlags(EnumSet<T> flags) {
        int flags_ = 0;
        for (Enum f : flags) {
            flags_ |= ((FlagsEnum)((Object)f)).getValue();
        }
        return flags_;
    }

    public static Inet4Address toInetAddress(int ip) throws UnknownHostException {
        return (Inet4Address)InetAddress.getByAddress(new byte[]{(byte)(ip >> 24), (byte)(ip >> 16), (byte)(ip >> 8), (byte)ip});
    }

    public static int fromInetAddress(Inet4Address addr) {
        byte[] ip = addr.getAddress();
        return ip[0] << 24 | ip[1] << 16 | ip[2] << 8 | ip[3];
    }
}

