/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam.friends;

import net.puppygames.steam.GameID;
import net.puppygames.steam.SteamID;

public class FriendGameInfo {
    private final GameID gameID;
    private final int gameIP;
    private final char gamePort;
    private final char queryPort;
    private final SteamID steamIDLobby;

    private FriendGameInfo(long gameID, int gameIP, char gamePort, char queryPort, long steamIDLobby) {
        this.gameID = new GameID(gameID);
        this.gameIP = gameIP;
        this.gamePort = gamePort;
        this.queryPort = queryPort;
        this.steamIDLobby = new SteamID(steamIDLobby);
    }

    public GameID getGameID() {
        return this.gameID;
    }

    public int getGameIP() {
        return this.gameIP;
    }

    public char getGamePort() {
        return this.gamePort;
    }

    public char getQueryPort() {
        return this.queryPort;
    }

    public SteamID getSteamIDLobby() {
        return this.steamIDLobby;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gameID == null ? 0 : this.gameID.hashCode());
        result = 31 * result + this.gameIP;
        result = 31 * result + this.gamePort;
        result = 31 * result + this.queryPort;
        result = 31 * result + (this.steamIDLobby == null ? 0 : this.steamIDLobby.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FriendGameInfo other = (FriendGameInfo)obj;
        if (this.gameID == null ? other.gameID != null : !this.gameID.equals(other.gameID)) {
            return false;
        }
        if (this.gameIP != other.gameIP) {
            return false;
        }
        if (this.gamePort != other.gamePort) {
            return false;
        }
        if (this.queryPort != other.queryPort) {
            return false;
        }
        return !(this.steamIDLobby == null ? other.steamIDLobby != null : !this.steamIDLobby.equals(other.steamIDLobby));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FriendGameInfo [");
        if (this.gameID != null) {
            builder.append("gameID=");
            builder.append(this.gameID);
            builder.append(", ");
        }
        builder.append("gameIP=");
        builder.append(this.gameIP);
        builder.append(", gamePort=");
        builder.append(this.gamePort);
        builder.append(", queryPort=");
        builder.append(this.queryPort);
        builder.append(", ");
        if (this.steamIDLobby != null) {
            builder.append("steamIDLobby=");
            builder.append(this.steamIDLobby);
        }
        builder.append("]");
        return builder.toString();
    }
}

