/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam.remotestorage;

public class UGCDetails {
    private final long appID;
    private final String name;
    private final int fileSizeInBytes;
    private final long steamIDowner;

    public UGCDetails(long appID, String name, int fileSizeInBytes, long steamIDowner) {
        this.appID = appID;
        this.name = name;
        this.fileSizeInBytes = fileSizeInBytes;
        this.steamIDowner = steamIDowner;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.appID ^ this.appID >>> 32);
        result = 31 * result + this.fileSizeInBytes;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.steamIDowner ^ this.steamIDowner >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UGCDetails other = (UGCDetails)obj;
        if (this.appID != other.appID) {
            return false;
        }
        if (this.fileSizeInBytes != other.fileSizeInBytes) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.steamIDowner == other.steamIDowner;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UGCDetails [appID=");
        builder.append(this.appID);
        builder.append(", ");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        builder.append("fileSizeInBytes=");
        builder.append(this.fileSizeInBytes);
        builder.append(", steamIDowner=");
        builder.append(this.steamIDowner);
        builder.append("]");
        return builder.toString();
    }

    public long getAppID() {
        return this.appID;
    }

    public String getName() {
        return this.name;
    }

    public int getFileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public long getSteamIDowner() {
        return this.steamIDowner;
    }
}

