/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam.userstats;

import net.puppygames.steam.SteamID;
import net.puppygames.steam.UGCHandle;

public class LeaderboardEntry {
    private SteamID steamIDUser;
    private int globalRank;
    private int score;
    private int details;
    private UGCHandle ugc;

    private LeaderboardEntry(long steamIDUser, int globalRank, int score, int details, long UGC) {
        this.steamIDUser = new SteamID(steamIDUser);
        this.globalRank = globalRank;
        this.score = score;
        this.details = details;
        this.ugc = new UGCHandle(UGC);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LeaderBoardEntry [");
        if (this.steamIDUser != null) {
            builder.append("steamIDUser=");
            builder.append(this.steamIDUser);
            builder.append(", ");
        }
        builder.append("globalRank=");
        builder.append(this.globalRank);
        builder.append(", score=");
        builder.append(this.score);
        builder.append(", details=");
        builder.append(this.details);
        builder.append(", ");
        if (this.ugc != null) {
            builder.append("ugc=");
            builder.append(this.ugc);
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.details;
        result = 31 * result + this.globalRank;
        result = 31 * result + this.score;
        result = 31 * result + (this.steamIDUser == null ? 0 : this.steamIDUser.hashCode());
        result = 31 * result + (this.ugc == null ? 0 : this.ugc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeaderboardEntry other = (LeaderboardEntry)obj;
        if (this.details != other.details) {
            return false;
        }
        if (this.globalRank != other.globalRank) {
            return false;
        }
        if (this.score != other.score) {
            return false;
        }
        if (this.steamIDUser == null ? other.steamIDUser != null : !this.steamIDUser.equals(other.steamIDUser)) {
            return false;
        }
        return !(this.ugc == null ? other.ugc != null : !this.ugc.equals(other.ugc));
    }

    public SteamID getSteamIDUser() {
        return this.steamIDUser;
    }

    public int getGlobalRank() {
        return this.globalRank;
    }

    public int getScore() {
        return this.score;
    }

    public int getDetails() {
        return this.details;
    }

    public UGCHandle getUGC() {
        return this.ugc;
    }
}

